---
generated_at: 2026-01-30 16:45:00
metrics:
  claims_total: 100
  claims_with_evidence: 100
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：libraries-Microsoft.Extensions.Http 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコードなどの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：100 / 100、根拠なし：0
- 優先レビュー（高）
  1. **なし**：全てのテストケースに根拠あり

## 2) 参照した情報（Evidence一覧）

### Core Classes
- E-01: `src/libraries/Microsoft.Extensions.Http/src/DefaultHttpClientFactory.cs`
- E-02: `src/libraries/Microsoft.Extensions.Http/src/DefaultHttpMessageHandlerBuilder.cs`
- E-03: `src/libraries/Microsoft.Extensions.Http/src/HttpMessageHandlerBuilder.cs`
- E-04: `src/libraries/Microsoft.Extensions.Http/src/HttpClientFactoryOptions.cs`
- E-05: `src/libraries/Microsoft.Extensions.Http/src/ActiveHandlerTrackingEntry.cs`
- E-06: `src/libraries/Microsoft.Extensions.Http/src/ExpiredHandlerTrackingEntry.cs`
- E-07: `src/libraries/Microsoft.Extensions.Http/src/LifetimeTrackingHttpMessageHandler.cs`
- E-08: `src/libraries/Microsoft.Extensions.Http/src/DefaultTypedHttpClientFactory.cs`

### Extensions
- E-09: `src/libraries/Microsoft.Extensions.Http/src/HttpClientFactoryExtensions.cs`
- E-10: `src/libraries/Microsoft.Extensions.Http/src/HttpMessageHandlerFactoryExtensions.cs`

### DependencyInjection
- E-11: `src/libraries/Microsoft.Extensions.Http/src/DependencyInjection/HttpClientFactoryServiceCollectionExtensions.cs`
- E-12: `src/libraries/Microsoft.Extensions.Http/src/DependencyInjection/HttpClientBuilderExtensions.cs`
- E-13: `src/libraries/Microsoft.Extensions.Http/src/DependencyInjection/IHttpClientBuilder.cs`
- E-14: `src/libraries/Microsoft.Extensions.Http/src/DependencyInjection/DefaultHttpClientBuilder.cs`
- E-15: `src/libraries/Microsoft.Extensions.Http/src/DependencyInjection/HttpClientMappingRegistry.cs`

### Logging
- E-16: `src/libraries/Microsoft.Extensions.Http/src/Logging/LoggingHttpMessageHandler.cs`
- E-17: `src/libraries/Microsoft.Extensions.Http/src/Logging/LoggingScopeHttpMessageHandler.cs`
- E-18: `src/libraries/Microsoft.Extensions.Http/src/Logging/HttpHeadersLogValue.cs`
- E-19: `src/libraries/Microsoft.Extensions.Http/src/Logging/LogHelper.cs`
- E-20: `src/libraries/Microsoft.Extensions.Http/src/Logging/HttpClientLoggerHandler.cs`
- E-21: `src/libraries/Microsoft.Extensions.Http/src/Logging/LoggingHttpMessageHandlerBuilderFilter.cs`

### Infrastructure
- E-22: `src/libraries/Microsoft.Extensions.Http/src/ValueStopwatch.cs`
- E-23: `src/libraries/Microsoft.Extensions.Http/src/MetricsFactoryHttpMessageHandlerFilter.cs`

### Interfaces
- E-24: `src/libraries/Microsoft.Extensions.Http/src/IHttpClientFactory.cs`
- E-25: `src/libraries/Microsoft.Extensions.Http/src/IHttpMessageHandlerFactory.cs`
- E-26: `src/libraries/Microsoft.Extensions.Http/src/ITypedHttpClientFactory.cs`
- E-27: `src/libraries/Microsoft.Extensions.Http/src/IHttpMessageHandlerBuilderFilter.cs`

## 3) Claims と根拠の対応（レビューの主戦場）

### DefaultHttpClientFactory (UT-HTTP-001 - UT-HTTP-012)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | CreateClientがHttpClientを生成する | E-01 L103-117 | ○ |
| C-02 | HttpClientActionsが順次実行される | E-01 L111-114 | ○ |
| C-03 | nameがnullでArgumentNullExceptionがスローされる | E-01 L105 | ○ |
| C-04 | CreateHandlerがハンドラを生成する | E-01 L119-128 | ○ |
| C-05 | ハンドラがキャッシュされる | E-01 L123 _activeHandlers | ○ |
| C-06 | CreateHandler(null)でArgumentNullException | E-01 L121 | ○ |
| C-07 | SuppressHandlerScope=falseでスコープ作成 | E-01 L137-141 | ○ |
| C-08 | SuppressHandlerScope=trueでスコープ未作成 | E-01 L137 | ○ |
| C-09 | フィルターが逆順で適用される | E-01 L151-154 | ○ |
| C-10 | ExpiryTimer_Tickでハンドラが移動 | E-01 L193-215 | ○ |
| C-11 | CanDispose=trueで破棄される | E-01 L281-293 | ○ |
| C-12 | CanDispose=falseでキューに戻る | E-01 L294-298 | ○ |

### DefaultHttpMessageHandlerBuilder (UT-HTTP-013 - UT-HTTP-018)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-13 | Buildでパイプラインが構築される | E-02 L44-53 | ○ |
| C-14 | PrimaryHandler=nullでInvalidOperationException | E-02 L46-49 | ○ |
| C-15 | Nameの設定・取得 | E-02 L24-31 | ○ |
| C-16 | Name=nullでArgumentNullException | E-02 L29 | ○ |
| C-17 | PrimaryHandler未設定でデフォルト生成 | E-02 L34-84 | ○ |
| C-18 | AdditionalHandlersが空リストを返す | E-02 L40 | ○ |

### HttpMessageHandlerBuilder (UT-HTTP-019 - UT-HTTP-023)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-19 | CreateHandlerPipelineでチェーン | E-03 L81-119 | ○ |
| C-20 | primaryHandler=nullでArgumentNullException | E-03 L83 | ○ |
| C-21 | additionalHandlers=nullでArgumentNullException | E-03 L84 | ○ |
| C-22 | additionalHandlersにnullでInvalidOperationException | E-03 L95-98 | ○ |
| C-23 | InnerHandler!=nullでInvalidOperationException | E-03 L103-112 | ○ |

### HttpClientFactoryOptions (UT-HTTP-024 - UT-HTTP-028)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-24 | HandlerLifetimeデフォルト値2分 | E-04 L23 | ○ |
| C-25 | InfiniteTimeSpan設定可能 | E-04 L64 | ○ |
| C-26 | 最小値未満でArgumentException | E-04 L64-66 | ○ |
| C-27 | ShouldRedactHeaderValueデフォルトでtrue | E-04 L76, E-19 L33 | ○ |
| C-28 | SuppressHandlerScopeデフォルトfalse | E-04 L103 | ○ |

### ActiveHandlerTrackingEntry (UT-HTTP-029 - UT-HTTP-031)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-29 | StartExpiryTimerでタイマー開始 | E-05 L44-74 | ○ |
| C-30 | InfiniteTimeSpanでタイマー未開始 | E-05 L46-48 | ○ |
| C-31 | 重複呼び出しで1回のみ初期化 | E-05 L51-53 | ○ |

### ExpiredHandlerTrackingEntry (UT-HTTP-032 - UT-HTTP-033)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-32 | GC後にCanDispose=true | E-06 L26 | ○ |
| C-33 | 生存中はCanDispose=false | E-06 L26 | ○ |

### LifetimeTrackingHttpMessageHandler (UT-HTTP-034)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-34 | Disposeが何も行わない | E-07 L18-21 | ○ |

### DefaultTypedHttpClientFactory (UT-HTTP-035 - UT-HTTP-037)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-35 | CreateClientでTClient生成 | E-08 L26-31 | ○ |
| C-36 | httpClient=nullでArgumentNullException | E-08 L28 | ○ |
| C-37 | Activatorがキャッシュされる | E-08 L54-58 | ○ |

### Extension Methods (UT-HTTP-038 - UT-HTTP-041)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-38 | HttpClientFactoryExtensions.CreateClient | E-09 L18-23 | ○ |
| C-39 | factory=nullでArgumentNullException | E-09 L20 | ○ |
| C-40 | HttpMessageHandlerFactoryExtensions.CreateHandler | E-10 L18-23 | ○ |
| C-41 | factory=nullでArgumentNullException | E-10 L20 | ○ |

### HttpClientFactoryServiceCollectionExtensions (UT-HTTP-042 - UT-HTTP-047)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-42 | AddHttpClientでサービス登録 | E-11 L26-72 | ○ |
| C-43 | 名前付きクライアント登録 | E-11 L108-116 | ○ |
| C-44 | services=nullでArgumentNullException | E-11 L28 | ○ |
| C-45 | name=nullでArgumentNullException | E-11 L111 | ○ |
| C-46 | AddHttpClient<TClient>で型付き登録 | E-11 L200-212 | ○ |
| C-47 | ConfigureHttpClientDefaultsでデフォルト設定 | E-11 L80-90 | ○ |

### HttpClientBuilderExtensions (UT-HTTP-048 - UT-HTTP-064)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-48 | ConfigureHttpClientでアクション追加 | E-12 L28-36 | ○ |
| C-49 | builder=nullでArgumentNullException | E-12 L30 | ○ |
| C-50 | configureClient=nullでArgumentNullException | E-12 L31 | ○ |
| C-51 | AddHttpMessageHandlerでハンドラ追加 | E-12 L74-85 | ○ |
| C-52 | AddHttpMessageHandler<THandler>でDI連携 | E-12 L130-141 | ○ |
| C-53 | ConfigurePrimaryHttpMessageHandler設定 | E-12 L154-165 | ○ |
| C-54 | ConfigurePrimaryHttpMessageHandler<THandler>でDI連携 | E-12 L212-223 | ○ |
| C-55 | AddTypedClient<TClient>で型付きクライアント | E-12 L360-367 | ○ |
| C-56 | AddTypedClient<TClient,TImplementation>分離 | E-12 L422-430 | ○ |
| C-57 | SetHandlerLifetimeで設定 | E-12 L616-627 | ○ |
| C-58 | 最小値未満でArgumentException | E-12 L620-623 | ○ |
| C-59 | RedactLoggedHeaders(Func)で設定 | E-12 L558-569 | ○ |
| C-60 | RedactLoggedHeaders(IEnumerable)で設定 | E-12 L577-590 | ○ |
| C-61 | AddAsKeyedでKeyed service登録 | E-12 L687-715 | ○ |
| C-62 | RemoveAsKeyedで登録削除 | E-12 L729-752 | ○ |
| C-63 | ConfigureAdditionalHttpMessageHandlers | E-12 L636-647 | ○ |
| C-64 | UseSocketsHttpHandler設定 | E-12 L286-304 | ○ |

### Logging Classes (UT-HTTP-065 - UT-HTTP-081)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-65 | LoggingHttpMessageHandler.SendAsyncでログ出力 | E-16 L49-82 | ○ |
| C-66 | HttpRequestExceptionで失敗ログ | E-16 L76-80 | ○ |
| C-67 | request=nullでArgumentNullException | E-16 L51 | ○ |
| C-68 | LoggingScopeHttpMessageHandler.SendAsyncでスコープ付きログ | E-17 L48-83 | ○ |
| C-69 | request=nullでArgumentNullException | E-17 L50 | ○ |
| C-70 | HttpHeadersLogValue.ToStringでRequestヘッダーフォーマット | E-18 L86-127 | ○ |
| C-71 | Responseヘッダーフォーマット | E-18 L91 | ○ |
| C-72 | リダクト対象ヘッダー値が*に置換 | E-18 L99-103 | ○ |
| C-73 | インデクサでヘッダーアクセス | E-18 L61-71 | ○ |
| C-74 | 範囲外でIndexOutOfRangeException | E-18 L65-68 | ○ |
| C-75 | Countでヘッダー数取得 | E-18 L74 | ○ |
| C-76 | HttpClientLoggerHandler.SendAsyncでロガー呼び出し | E-20 L25-62 | ○ |
| C-77 | IHttpClientAsyncLoggerで非同期呼び出し | E-20 L32-47 | ○ |
| C-78 | 例外時LogRequestFailed呼び出し | E-20 L49-60 | ○ |
| C-79 | LoggingHttpMessageHandlerBuilderFilter.Configureでハンドラ追加 | E-21 L31-60 | ○ |
| C-80 | SuppressDefaultLogging=trueでハンドラ未追加 | E-21 L41-44 | ○ |
| C-81 | next=nullでArgumentNullException | E-21 L33 | ○ |

### MetricsFactoryHttpMessageHandlerFilter (UT-HTTP-082 - UT-HTTP-084)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-82 | HttpClientHandlerにMeterFactory設定 | E-23 L31-35 | ○ |
| C-83 | SocketsHttpHandlerにMeterFactory設定 | E-23 L36-40 | ○ |
| C-84 | 既存MeterFactoryを維持 | E-23 L34, L39 (??=) | ○ |

### ValueStopwatch (UT-HTTP-085 - UT-HTTP-089)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-85 | StartNewでタイムスタンプ記録 | E-22 L22 | ○ |
| C-86 | GetElapsedTimeで経過時間取得 | E-22 L24-37 | ○ |
| C-87 | 未初期化でInvalidOperationException | E-22 L28-30 | ○ |
| C-88 | 開始後IsActive=true | E-22 L15 | ○ |
| C-89 | default値でIsActive=false | E-22 L15 | ○ |

### DefaultHttpClientBuilder (UT-HTTP-090 - UT-HTTP-091)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-90 | Nameプロパティ取得 | E-14 L21 | ○ |
| C-91 | Servicesプロパティ取得 | E-14 L23 | ○ |

### HttpClientMappingRegistry (UT-HTTP-092 - UT-HTTP-093)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-92 | NamedClientRegistrations追跡 | E-15 L16 | ○ |
| C-93 | KeyedLifetimeMap追跡 | E-15 L18 | ○ |

### LogHelper (UT-HTTP-094 - UT-HTTP-097)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-94 | ShouldRedactHeaderValueデフォルトtrue | E-19 L33 | ○ |
| C-95 | LogRequestStartでログ出力 | E-19 L68-85 | ○ |
| C-96 | LogRequestEndでレスポンスログ | E-19 L87-100 | ○ |
| C-97 | BeginRequestPipelineScopeでスコープ開始 | E-19 L105-109 | ○ |

### Constructor Validation (UT-HTTP-098 - UT-HTTP-100)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-98 | services=nullでArgumentNullException | E-01 L68 | ○ |
| C-99 | scopeFactory=nullでArgumentNullException | E-01 L69 | ○ |
| C-100 | optionsMonitor=nullでArgumentNullException | E-01 L70 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし - 全てのテストケースに対してソースコードからの根拠が確認できました

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: 全てのテストケースがソースコードに基づいて生成されており、根拠が明確

### 注意すべき点
1. **ハンドラライフサイクル管理** (UT-HTTP-010 - UT-HTTP-012): タイマーベースのクリーンアップ処理は並行性の問題が発生しやすい
2. **WeakReferenceによるGC連携** (UT-HTTP-032 - UT-HTTP-033): GCのタイミングに依存するため、テスト結果が不安定になる可能性
3. **Keyed Service登録** (UT-HTTP-061 - UT-HTTP-062): .NET 8以降の機能であり、対象フレームワークバージョンに依存

## 6) レビュアーチェックリスト（最小）
- [ ] 高優先度テストケース（UT-HTTP-001 - UT-HTTP-006, UT-HTTP-013 - UT-HTTP-014, UT-HTTP-019 - UT-HTTP-023）の網羅性を確認
- [ ] ArgumentNullExceptionテストケースがソースコードのThrowIfNull呼び出しと一致しているか確認
- [ ] HandlerLifetimeの最小値バリデーション（1秒）がテストケースに反映されているか確認
- [ ] ロギング機能のテストケースがTrace/Informationレベルの両方をカバーしているか確認
- [ ] Keyed Service関連のテストケースが.NET 8以降の機能であることを考慮しているか確認
