---
generated_at: 2026-01-30 12:30:00
metrics:
  claims_total: 132
  claims_with_evidence: 132
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：libraries-Microsoft.Extensions.Logging.Abstractions 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：132 / 132、根拠なし：0
- 優先レビュー（高）
  1. **LoggerMessage.Defineのパラメータ数検証**：複雑なフォーマット文字列解析ロジック
  2. **FormattedLogValuesのキャッシュ動作**：性能最適化に関わる重要な機能
  3. **LoggerExternalScopeProviderの非同期動作**：AsyncLocalの動作確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `src/libraries/Microsoft.Extensions.Logging.Abstractions/src/EventId.cs`
- E-02: `src/libraries/Microsoft.Extensions.Logging.Abstractions/src/LogEntry.cs`
- E-03: `src/libraries/Microsoft.Extensions.Logging.Abstractions/src/NullLogger.cs`
- E-04: `src/libraries/Microsoft.Extensions.Logging.Abstractions/src/NullLoggerT.cs`
- E-05: `src/libraries/Microsoft.Extensions.Logging.Abstractions/src/NullLoggerFactory.cs`
- E-06: `src/libraries/Microsoft.Extensions.Logging.Abstractions/src/NullLoggerProvider.cs`
- E-07: `src/libraries/Microsoft.Extensions.Logging.Abstractions/src/LoggerExtensions.cs`
- E-08: `src/libraries/Microsoft.Extensions.Logging.Abstractions/src/LoggerMessage.cs`
- E-09: `src/libraries/Microsoft.Extensions.Logging.Abstractions/src/LogValuesFormatter.cs`
- E-10: `src/libraries/Microsoft.Extensions.Logging.Abstractions/src/FormattedLogValues.cs`
- E-11: `src/libraries/Microsoft.Extensions.Logging.Abstractions/src/LoggerExternalScopeProvider.cs`
- E-12: `src/libraries/Microsoft.Extensions.Logging.Abstractions/src/LoggerFactoryExtensions.cs`
- E-13: `src/libraries/Microsoft.Extensions.Logging.Abstractions/src/LoggerT.cs`
- E-14: `src/libraries/Microsoft.Extensions.Logging.Abstractions/src/LogDefineOptions.cs`
- E-15: `src/libraries/Microsoft.Extensions.Logging.Abstractions/src/LoggerMessageAttribute.cs`
- E-16: `src/libraries/Microsoft.Extensions.Logging.Abstractions/src/ProviderAliasAttribute.cs`
- E-17: `src/libraries/Microsoft.Extensions.Logging.Abstractions/src/BufferedLogRecord.cs`
- E-18: `src/libraries/Microsoft.Extensions.Logging.Abstractions/src/IBufferedLogger.cs`
- E-19: `src/libraries/Microsoft.Extensions.Logging.Abstractions/src/LogLevel.cs`
- E-20: `src/libraries/Microsoft.Extensions.Logging.Abstractions/src/ILogger.cs`
- E-21: `src/libraries/Microsoft.Extensions.Logging.Abstractions/src/ILoggerFactory.cs`
- E-22: `src/libraries/Microsoft.Extensions.Logging.Abstractions/src/ILoggerProvider.cs`
- E-23: `src/libraries/Microsoft.Extensions.Logging.Abstractions/src/ILoggerT.cs`
- E-24: `src/libraries/Microsoft.Extensions.Logging.Abstractions/src/IExternalScopeProvider.cs`
- E-25: `src/libraries/Microsoft.Extensions.Logging.Abstractions/src/ILoggingBuilder.cs`
- E-26: `src/libraries/Microsoft.Extensions.Logging.Abstractions/src/ISupportExternalScope.cs`

## 3) Claims と根拠の対応（レビューの主戦場）

### EventId (UT-LOG-001 - UT-LOG-013)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | EventIdコンストラクタでId, Nameが初期化される | E-01 (L50-54) | ○ |
| C-02 | name引数はオプショナルでデフォルトnull | E-01 (L50) | ○ |
| C-03 | implicit operatorでintからEventIdに変換 | E-01 (L18-21) | ○ |
| C-04 | operator ==でIdのみを比較 | E-01 (L29-32, L77-80) | ○ |
| C-05 | operator !=で不等価判定 | E-01 (L40-43) | ○ |
| C-06 | Equals(EventId)でIdのみを比較 | E-01 (L77-80) | ○ |
| C-07 | Equals(object)でnull時false | E-01 (L83-91) | ○ |
| C-08 | GetHashCodeがIdを返す | E-01 (L94-97) | ○ |
| C-09 | ToStringがNameまたはIdを返す | E-01 (L67-70) | ○ |

### LogEntry<TState> (UT-LOG-014 - UT-LOG-020)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-10 | LogEntryコンストラクタで全プロパティ初期化 | E-02 (L22-30) | ○ |
| C-11 | 各プロパティ（LogLevel, Category, EventId, State, Exception, Formatter）が取得可能 | E-02 (L35, 40, 45, 50, 55, 60) | ○ |

### NullLogger / NullLogger<T> (UT-LOG-021 - UT-LOG-030)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-12 | NullLogger.Instanceがシングルトン | E-03 (L16) | ○ |
| C-13 | NullLogger.IsEnabledが常にfalse | E-03 (L32-35) | ○ |
| C-14 | NullLogger.Logが何もしない | E-03 (L38-40) | ○ |
| C-15 | NullLogger.BeginScopeがNullScope.Instanceを返す | E-03 (L26-29) | ○ |
| C-16 | NullLogger<T>.Instanceが静的フィールド | E-04 (L17) | ○ |
| C-17 | NullLogger<T>.IsEnabledが常にfalse | E-04 (L39-42) | ○ |
| C-18 | NullLogger<T>.Logが何もしない | E-04 (L29-36) | ○ |

### NullLoggerFactory / NullLoggerProvider (UT-LOG-031 - UT-LOG-037)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-19 | NullLoggerFactory.InstanceがReadOnlyフィールド | E-05 (L20) | ○ |
| C-20 | NullLoggerFactory.CreateLoggerがNullLogger.Instanceを返す | E-05 (L26-29) | ○ |
| C-21 | NullLoggerFactory.AddProviderが何もしない | E-05 (L35-37) | ○ |
| C-22 | NullLoggerProvider.Instanceがシングルトン | E-06 (L14) | ○ |
| C-23 | NullLoggerProvider.CreateLoggerがNullLogger.Instanceを返す | E-06 (L21-24) | ○ |

### LoggerExtensions (UT-LOG-038 - UT-LOG-050)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-24 | LogDebugがLogLevel.Debugで呼び出す | E-07 (L30-33, L47-50, L64-67, L80-83) | ○ |
| C-25 | LogTraceがLogLevel.Traceで呼び出す | E-07 (L100-103, L117-120, L134-137, L150-153) | ○ |
| C-26 | LogInformationがLogLevel.Informationで呼び出す | E-07 (L170-173, L187-190, L204-207, L220-223) | ○ |
| C-27 | LogWarningがLogLevel.Warningで呼び出す | E-07 (L240-243, L257-260, L274-277, L290-293) | ○ |
| C-28 | LogErrorがLogLevel.Errorで呼び出す | E-07 (L310-313, L327-330, L344-347, L360-363) | ○ |
| C-29 | LogCriticalがLogLevel.Criticalで呼び出す | E-07 (L380-383, L397-400, L414-417, L430-433) | ○ |
| C-30 | Log拡張メソッドでArgumentNullException.ThrowIfNull | E-07 (L484) | ○ |
| C-31 | BeginScope拡張メソッドでArgumentNullException.ThrowIfNull | E-07 (L508) | ○ |

### LoggerMessage (UT-LOG-051 - UT-LOG-060)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-32 | DefineScopeがFunc<ILogger, IDisposable?>を返す | E-08 (L21-28) | ○ |
| C-33 | DefineScope<T1>...DefineScope<T1-T6>が対応する型のFuncを返す | E-08 (L36-121) | ○ |
| C-34 | Define系メソッドがIsEnabledチェック付きAction返却 | E-08 (L141-162) | ○ |
| C-35 | LogDefineOptions.SkipEnabledCheck=trueでチェックスキップ | E-08 (L150-153) | ○ |
| C-36 | パラメータ数不一致でArgumentException | E-08 (L452-464) | ○ |

### LogValuesFormatter (UT-LOG-061 - UT-LOG-070)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-37 | コンストラクタで名前付きパラメータ解析 | E-09 (L30-83) | ○ |
| C-38 | エスケープ波括弧処理 | E-09 (L88-134) | ○ |
| C-39 | ArgumentNullException.ThrowIfNull(format) | E-09 (L32) | ○ |
| C-40 | Format(object[])でフォーマット | E-09 (L136-161) | ○ |
| C-41 | null値が"(null)"に変換 | E-09 (L18, L254-259) | ○ |
| C-42 | IEnumerableがカンマ区切りに変換 | E-09 (L262-281) | ○ |
| C-43 | GetValueでIndexOutOfRangeException | E-09 (L221-234) | ○ |
| C-44 | GetValuesで全値+OriginalFormat返却 | E-09 (L236-246) | ○ |

### FormattedLogValues (UT-LOG-071 - UT-LOG-081)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-45 | コンストラクタでフォーマッター初期化 | E-10 (L33-61) | ○ |
| C-46 | nullフォーマットで"[null]"使用 | E-10 (L20, L58) | ○ |
| C-47 | CountがValueNames.Count + 1または1 | E-10 (L81-92) | ○ |
| C-48 | インデクサでKeyValuePair返却 | E-10 (L63-79) | ○ |
| C-49 | ToStringでフォーマット済み文字列返却 | E-10 (L102-110) | ○ |
| C-50 | MaxCachedFormatters = 1024 | E-10 (L19) | ○ |
| C-51 | キャッシュ超過時は追加せず検索のみ | E-10 (L37-43) | ○ |

### LoggerExternalScopeProvider (UT-LOG-082 - UT-LOG-089)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-52 | コンストラクタで初期化 | E-11 (L19-20) | ○ |
| C-53 | PushがIDisposable(Scope)返却 | E-11 (L38-45) | ○ |
| C-54 | ForEachScopeが親から子の順で呼び出し | E-11 (L23-35) | ○ |
| C-55 | Scope.Disposeで親スコープに戻る | E-11 (L68-75) | ○ |
| C-56 | 二重Dispose安全（_isDisposedフラグ） | E-11 (L50, L68-75) | ○ |
| C-57 | AsyncLocalで非同期スコープ分離 | E-11 (L14) | ○ |

### LoggerFactoryExtensions (UT-LOG-090 - UT-LOG-094)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-58 | CreateLogger<T>がLogger<T>返却 | E-12 (L20-25) | ○ |
| C-59 | CreateLogger<T>でArgumentNullException | E-12 (L22) | ○ |
| C-60 | CreateLogger(Type)で型名カテゴリ | E-12 (L32-38) | ○ |
| C-61 | CreateLogger(Type)でfactory/type null検証 | E-12 (L34-35) | ○ |

### Logger<T> (UT-LOG-095 - UT-LOG-101)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-62 | コンストラクタでILoggerFactory.CreateLogger呼び出し | E-13 (L25-30) | ○ |
| C-63 | factoryがnullでArgumentNullException | E-13 (L27) | ○ |
| C-64 | Log/IsEnabled/BeginScopeが内部ILoggerに委譲 | E-13 (L33-48) | ○ |
| C-65 | GetCategoryNameがTypeNameHelper使用 | E-13 (L50) | ○ |

### LogDefineOptions (UT-LOG-102 - UT-LOG-103)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-66 | SkipEnabledCheckプロパティ | E-14 (L16) | ○ |

### LoggerMessageAttribute (UT-LOG-104 - UT-LOG-113)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-67 | 各コンストラクタオーバーロード | E-15 (L38, L47-52, L60-64, L71-74, L81-84) | ○ |
| C-68 | EventIdデフォルト-1 | E-15 (L89) | ○ |
| C-69 | Levelデフォルト=None | E-15 (L102) | ○ |
| C-70 | Messageデフォルト="" | E-15 (L107) | ○ |
| C-71 | SkipEnabledCheckプロパティ | E-15 (L112) | ○ |

### ProviderAliasAttribute (UT-LOG-114 - UT-LOG-115)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-72 | コンストラクタでAlias設定 | E-16 (L24-27) | ○ |
| C-73 | Aliasプロパティgetonly | E-16 (L32) | ○ |

### BufferedLogRecord (UT-LOG-116 - UT-LOG-125)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-74 | Timestamp, LogLevel, EventIdが抽象プロパティ | E-17 (L23, L28, L33) | ○ |
| C-75 | Exception等が仮想プロパティでデフォルトnull | E-17 (L38, L43, L48, L53, L58, L63) | ○ |
| C-76 | Attributesがデフォルト空配列 | E-17 (L68) | ○ |

### LogLevel (UT-LOG-126 - UT-LOG-132)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-77 | Trace=0, Debug=1, Information=2, Warning=3, Error=4, Critical=5, None=6 | E-19 (L15, L21, L26, L32, L38, L44, L49) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし。全てのテストケースはソースコードを直接参照して作成されている。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全てのテストケースがソースコードから直接導出されている

## 6) レビュアーチェックリスト（最小）
- [ ] EventIdの等価性比較がIdのみで行われることを確認
- [ ] NullLogger系クラスがシングルトンパターンを正しく実装していることを確認
- [ ] LoggerExtensionsのnull引数チェックが適切に行われることを確認
- [ ] LoggerMessage.Defineのパラメータ数検証ロジックが正しいことを確認
- [ ] FormattedLogValuesのキャッシュ上限（1024）動作を確認
- [ ] LoggerExternalScopeProviderのAsyncLocal動作を非同期テストで確認
- [ ] Logger<T>が正しくILoggerに委譲することを確認
- [ ] 全てのテストケースが指定されたテストID命名規則（UT-LOG-XXX）に従っていることを確認
