---
generated_at: 2026-01-30 10:30:00
metrics:
  claims_total: 109
  claims_with_evidence: 109
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：libraries-Microsoft.Extensions.Logging.Console 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各テストケースに対して、ソースコード内のメソッド・クラス・ロジックが根拠（Evidence）として存在するか
2. **根拠との整合性**：テストケースの内容がソースコードの実装と矛盾していないか
3. **網羅性**：対象モジュールの主要なクラス・メソッドをカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：109 / 109、根拠なし：0
- 優先レビュー（高）
  1. **ConsoleLoggerProcessor キュー制御テスト (UT-LOG-028, 029)**：マルチスレッド環境でのテストが必要
  2. **AnsiParser 色コードパーステスト (UT-LOG-037-042)**：様々なエスケープシーケンスパターンのカバレッジ確認
  3. **JsonConsoleFormatter JSONシリアライズ (UT-LOG-066, 067)**：様々なデータ型の網羅確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/libraries/Microsoft.Extensions.Logging.Console/src/ConsoleLogger.cs`
- E-02: `src/libraries/Microsoft.Extensions.Logging.Console/src/ConsoleLoggerProvider.cs`
- E-03: `src/libraries/Microsoft.Extensions.Logging.Console/src/ConsoleLoggerProcessor.cs`
- E-04: `src/libraries/Microsoft.Extensions.Logging.Console/src/AnsiParser.cs`
- E-05: `src/libraries/Microsoft.Extensions.Logging.Console/src/ConsoleFormatter.cs`
- E-06: `src/libraries/Microsoft.Extensions.Logging.Console/src/SimpleConsoleFormatter.cs`
- E-07: `src/libraries/Microsoft.Extensions.Logging.Console/src/JsonConsoleFormatter.cs`
- E-08: `src/libraries/Microsoft.Extensions.Logging.Console/src/SystemdConsoleFormatter.cs`
- E-09: `src/libraries/Microsoft.Extensions.Logging.Console/src/ConsoleLoggerOptions.cs`
- E-10: `src/libraries/Microsoft.Extensions.Logging.Console/src/ConsoleLoggerExtensions.cs`
- E-11: `src/libraries/Microsoft.Extensions.Logging.Console/src/AnsiLogConsole.cs`
- E-12: `src/libraries/Microsoft.Extensions.Logging.Console/src/AnsiParsingLogConsole.cs`
- E-13: `src/libraries/Microsoft.Extensions.Logging.Console/src/TextWriterExtensions.cs`
- E-14: `src/libraries/Microsoft.Extensions.Logging.Console/src/FormatterOptionsMonitor.cs`
- E-15: `src/libraries/Microsoft.Extensions.Logging.Console/src/ConsoleFormatterOptions.cs`
- E-16: `src/libraries/Microsoft.Extensions.Logging.Console/src/SimpleConsoleFormatterOptions.cs`
- E-17: `src/libraries/Microsoft.Extensions.Logging.Console/src/JsonConsoleFormatterOptions.cs`
- E-18: `src/libraries/Microsoft.Extensions.Logging.Console/src/LogMessageEntry.cs`
- E-19: `src/libraries/Microsoft.Extensions.Logging.Console/src/ConsoleFormatterNames.cs`
- E-20: `src/libraries/Microsoft.Extensions.Logging.Console/src/LoggerColorBehavior.cs`
- E-21: `src/libraries/Microsoft.Extensions.Logging.Console/src/ConsoleLoggerQueueFullMode.cs`

## 3) Claims と根拠の対応（レビューの主戦場）

### ConsoleLogger クラス (UT-LOG-001 - UT-LOG-011)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Log メソッドで有効なログレベルでログが出力される | E-01 (46-71行目) | ○ |
| C-02 | LogLevel.None の場合 IsEnabled が false を返す | E-01 (103-106行目) | ○ |
| C-03 | formatter が null の場合 ArgumentNullException がスローされる | E-01 (53行目) | ○ |
| C-04 | StringBuilder の容量が 1024 を超えた場合リセットされる | E-01 (66-69行目) | ○ |
| C-05 | LogToStandardErrorThreshold 以上で stderr に出力 | E-01 (70行目) | ○ |
| C-06 | LogRecords で BufferedLogRecord が処理される | E-01 (74-100行目) | ○ |
| C-07 | LogRecords で records が null の場合例外 | E-01 (76行目) | ○ |
| C-08 | IsEnabled で LogLevel.None 以外は true | E-01 (103-106行目) | ○ |
| C-09 | BeginScope で ScopeProvider.Push が呼ばれる | E-01 (109行目) | ○ |

### ConsoleLoggerProvider クラス (UT-LOG-012 - UT-LOG-019)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-10 | IOptionsMonitor のみでインスタンス生成可能 | E-02 (33-34行目) | ○ |
| C-11 | formatters が null の場合デフォルトフォーマッター設定 | E-02 (100-122行目) | ○ |
| C-12 | CreateLogger で名前付き Logger が生成される | E-02 (153-174行目) | ○ |
| C-13 | 同名の Logger がキャッシュされる | E-02 (171-173行目) | ○ |
| C-14 | SetScopeProvider で全 Logger に反映 | E-02 (211-219行目) | ○ |
| C-15 | Dispose でリソースが解放される | E-02 (204-208行目) | ○ |
| C-16 | ReloadLoggerOptions で全 Logger が更新される | E-02 (125-150行目) | ○ |

### ConsoleLoggerProcessor クラス (UT-LOG-020 - UT-LOG-035)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-17 | コンストラクタで出力スレッドが開始される | E-03 (63-77行目) | ○ |
| C-18 | MaxQueueLength に 0 以下設定で例外 | E-03 (26-29行目) | ○ |
| C-19 | FullMode に無効な値設定で例外 | E-03 (44-47行目) | ○ |
| C-20 | EnqueueMessage でキューに追加される | E-03 (79-86行目) | ○ |
| C-21 | キュー満杯で Wait モード時にブロック | E-03 (114-123行目) | ○ |
| C-22 | キュー満杯で DropWrite モード時にドロップ | E-03 (116-119行目) | ○ |
| C-23 | ドロップ警告がキューに追加される | E-03 (130-138行目) | ○ |
| C-24 | TryDequeue でメッセージが取得できる | E-03 (159-183行目) | ○ |
| C-25 | WriteMessage で Console/ErrorConsole に振り分け | E-03 (89-100行目) | ○ |
| C-26 | Dispose でスレッドが Join される | E-03 (185-194行目) | ○ |

### AnsiParser クラス (UT-LOG-036 - UT-LOG-044)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-27 | コンストラクタで null チェック | E-04 (14-16行目) | ○ |
| C-28 | Parse でエスケープコードなしメッセージが処理される | E-04 (45-125行目) | ○ |
| C-29 | 前景色エスケープコードが解析される | E-04 (172-186行目) | ○ |
| C-30 | 背景色エスケープコードが解析される | E-04 (189-203行目) | ○ |
| C-31 | Bright フラグが解析される | E-04 (72-73行目) | ○ |
| C-32 | GetForegroundColorEscapeCode で各色のコード返却 | E-04 (133-154行目) | ○ |
| C-33 | GetBackgroundColorEscapeCode で各色のコード返却 | E-04 (156-170行目) | ○ |

### ConsoleFormatter 抽象クラス (UT-LOG-045 - UT-LOG-046)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-34 | コンストラクタで name が null の場合例外 | E-05 (21行目) | ○ |
| C-35 | Name プロパティが正しく設定される | E-05 (23行目) | ○ |

### SimpleConsoleFormatter クラス (UT-LOG-047 - UT-LOG-057)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-36 | Write で基本フォーマットが出力される | E-06 (47-130行目) | ○ |
| C-37 | TimestampFormat 設定時にタイムスタンプ出力 | E-06 (75-83行目) | ○ |
| C-38 | UseUtcTimestamp で UTC 時刻使用 | E-06 (156-161行目) | ○ |
| C-39 | IncludeScopes でスコープ情報出力 | E-06 (201-226行目) | ○ |
| C-40 | SingleLine で改行置換 | E-06 (132-154行目) | ○ |
| C-41 | ColorBehavior で色制御 | E-06 (177-199行目) | ○ |
| C-42 | 各 LogLevel に対応する色設定 | E-06 (189-198行目) | ○ |
| C-43 | 例外情報が出力される | E-06 (121-125行目) | ○ |
| C-44 | Dispose で token が解放される | E-06 (40-43行目) | ○ |

### JsonConsoleFormatter クラス (UT-LOG-058 - UT-LOG-068)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-45 | Write で JSON 形式出力 | E-07 (29-54行目) | ○ |
| C-46 | EventId が JSON に含まれる | E-07 (71行目) | ○ |
| C-47 | LogLevel が JSON に含まれる | E-07 (72行目) | ○ |
| C-48 | Category が JSON に含まれる | E-07 (73行目) | ○ |
| C-49 | Exception が JSON に含まれる | E-07 (76-79行目) | ○ |
| C-50 | State が JSON に含まれる | E-07 (81-99行目) | ○ |
| C-51 | Scopes が JSON に含まれる | E-07 (146-170行目) | ○ |
| C-52 | JsonWriterOptions が適用される | E-07 (63行目) | ○ |
| C-53 | 各プリミティブ型が正しくシリアライズされる | E-07 (172-227行目) | ○ |
| C-54 | Dispose で token が解放される | E-07 (239-242行目) | ○ |

### SystemdConsoleFormatter クラス (UT-LOG-069 - UT-LOG-074)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-55 | Write で systemd 形式出力 | E-08 (37-56行目) | ○ |
| C-56 | 各 LogLevel に syslog severity マッピング | E-08 (120-133行目) | ○ |
| C-57 | 改行がスペースに置換される | E-08 (106-110行目) | ○ |
| C-58 | カテゴリと EventId が出力される | E-08 (79-82行目) | ○ |
| C-59 | スコープ情報が => で区切られる | E-08 (135-145行目) | ○ |
| C-60 | Dispose で token が解放される | E-08 (30-33行目) | ○ |

### AnsiLogConsole クラス (UT-LOG-075 - UT-LOG-077)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-61 | stdErr=false で Console.Out 使用 | E-11 (15-18行目) | ○ |
| C-62 | stdErr=true で Console.Error 使用 | E-11 (15-18行目) | ○ |
| C-63 | Write でメッセージが出力される | E-11 (20-23行目) | ○ |

### AnsiParsingLogConsole クラス (UT-LOG-078 - UT-LOG-081)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-64 | AnsiParser が初期化される | E-12 (19-23行目) | ○ |
| C-65 | Write で Parser を通じて出力される | E-12 (25-28行目) | ○ |
| C-66 | 色が設定・リセットされる | E-12 (30-73行目) | ○ |

### TextWriterExtensions クラス (UT-LOG-082 - UT-LOG-084)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-67 | WriteColoredMessage で色付きメッセージ出力 | E-13 (11-31行目) | ○ |
| C-68 | 色が null の場合エスケープコードなし | E-13 (14-27行目) | ○ |

### FormatterOptionsMonitor クラス (UT-LOG-085 - UT-LOG-087)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-69 | Get でオプションが返却される | E-14 (21行目) | ○ |
| C-70 | CurrentValue で現在値が返却される | E-14 (28行目) | ○ |
| C-71 | OnChange で null が返却される | E-14 (23-26行目) | ○ |

### ConsoleLoggerOptions クラス (UT-LOG-088 - UT-LOG-092)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-72 | Format に無効な値設定で例外 | E-09 (36-40行目) | ○ |
| C-73 | QueueFullMode に無効な値設定で例外 | E-09 (97-100行目) | ○ |
| C-74 | MaxQueueLength に 0 以下設定で例外 | E-09 (119-122行目) | ○ |
| C-75 | MaxQueueLength デフォルト値 2500 | E-09 (105-106行目) | ○ |
| C-76 | LogToStandardErrorThreshold デフォルト値 None | E-09 (65行目) | ○ |

### ConsoleLoggerExtensions クラス (UT-LOG-093 - UT-LOG-099)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-77 | AddConsole で Provider 登録 | E-10 (29-43行目) | ○ |
| C-78 | AddConsole で configure 適用 | E-10 (50-58行目) | ○ |
| C-79 | configure が null で例外 | E-10 (52行目) | ○ |
| C-80 | AddSimpleConsole で FormatterName=simple | E-10 (64-65行目) | ○ |
| C-81 | AddJsonConsole で FormatterName=json | E-10 (81-82行目) | ○ |
| C-82 | AddSystemdConsole で FormatterName=systemd | E-10 (108-109行目) | ○ |
| C-83 | AddConsoleFormatter でカスタムフォーマッター登録 | E-10 (131-136行目) | ○ |

### その他の構造体・定数 (UT-LOG-100 - UT-LOG-109)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-84 | LogMessageEntry のコンストラクタ | E-18 (8-12行目) | ○ |
| C-85 | ConsoleFormatterOptions のデフォルト値 | E-15 (13-42行目) | ○ |
| C-86 | SimpleConsoleFormatterOptions のデフォルト値 | E-16 (11-29行目) | ○ |
| C-87 | JsonConsoleFormatterOptions のデフォルト値 | E-17 (12-22行目) | ○ |
| C-88 | ConsoleFormatterNames の定数値 | E-19 (10-24行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし：全てのテストケースがソースコードに基づいて生成されています

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 全てのテストケースがソースコードの実装に基づいており、根拠が明確です

### 追加レビュー推奨項目
1. **マルチスレッドテスト**: ConsoleLoggerProcessor のキュー制御はマルチスレッド環境でのテストが重要（UT-LOG-028, 029）
2. **プラットフォーム固有テスト**: DoesConsoleSupportAnsi() はプラットフォームによって異なる動作をするため、プラットフォーム固有のテストが必要
3. **パフォーマンステスト**: 高負荷時のキュー動作（DropWrite モード）のパフォーマンス検証

## 6) レビュアーチェックリスト（最小）
- [ ] 全テストケースがソースコードの実装に対応しているか確認
- [ ] 境界値テスト（MaxQueueLength=0, 1, MaxValue）のカバレッジが十分か確認
- [ ] 異常系テスト（null入力、無効な列挙値）のカバレッジが十分か確認
- [ ] マルチスレッド環境でのテストシナリオが適切か確認
- [ ] 各フォーマッター（Simple, Json, Systemd）の出力形式テストが網羅されているか確認
- [ ] IDisposable 実装のリソース解放テストが含まれているか確認
- [ ] プラットフォーム固有の動作（ANSI サポート判定）のテスト方針を検討
