---
generated_at: 2026-01-30 12:00:00
metrics:
  claims_total: 71
  claims_with_evidence: 71
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：libraries-Microsoft.Extensions.Logging.EventLog 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：71 / 71、根拠なし：0
- 優先レビュー（高）
  1. **WindowsEventLogのSecurityException処理（UT-ELG-056〜058）**：実際のWindows環境でのテスト実行が必要
  2. **メッセージ分割ロジック（UT-ELG-019〜023）**：境界値テストの実装時にMaxMessageSize=31839の確認が必要
  3. **Obsoleteメソッドのテスト（UT-ELG-069〜071）**：コンパイルエラーとなるため実行不可、属性確認のみ

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/libraries/Microsoft.Extensions.Logging.EventLog/src/EventLogLogger.cs`
- E-02: `src/libraries/Microsoft.Extensions.Logging.EventLog/src/EventLogLoggerProvider.cs`
- E-03: `src/libraries/Microsoft.Extensions.Logging.EventLog/src/EventLogSettings.cs`
- E-04: `src/libraries/Microsoft.Extensions.Logging.EventLog/src/IEventLog.cs`
- E-05: `src/libraries/Microsoft.Extensions.Logging.EventLog/src/WindowsEventLog.cs`
- E-06: `src/libraries/Microsoft.Extensions.Logging.EventLog/src/EventLoggerFactoryExtensions.cs`

## 3) Claims と根拠の対応（レビューの主戦場）

### EventLogLogger クラス（UT-ELG-001〜029）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | EventLogLoggerコンストラクタでnameのnullチェックが行われる | E-01 (L32: `ArgumentNullException.ThrowIfNull(name)`) | ○ |
| C-02 | EventLogLoggerコンストラクタでsettingsのnullチェックが行われる | E-01 (L33: `ArgumentNullException.ThrowIfNull(settings)`) | ○ |
| C-03 | externalScopeProviderはnull許容である | E-01 (L18, L30: `IExternalScopeProvider?`) | ○ |
| C-04 | EventLogプロパティはsettings.EventLogを返す | E-01 (L39, L54) | ○ |
| C-05 | BeginScopeはexternalScopeProvider?.Push(state)を返す | E-01 (L57-60) | ○ |
| C-06 | IsEnabledはLogLevel.Noneでfalseを返す | E-01 (L65: `logLevel != LogLevel.None`) | ○ |
| C-07 | IsEnabledはFilterがnullの場合LogLevel.None以外でtrueを返す | E-01 (L66: `_settings.Filter == null`) | ○ |
| C-08 | Logメソッドでformatterのnullチェックが行われる | E-01 (L82) | ○ |
| C-09 | formatterが空文字を返す場合は早期リターンする | E-01 (L86-89: `string.IsNullOrEmpty(message)`) | ○ |
| C-10 | 例外情報がメッセージに含まれる | E-01 (L117-120) | ○ |
| C-11 | スコープ情報がKeyValuePairの場合Key: Valueフォーマットで出力 | E-01 (L100-106) | ○ |
| C-12 | スコープ情報がオブジェクトの場合ToStringが出力 | E-01 (L107-110) | ○ |
| C-13 | メッセージがMaxMessageSize以下なら1回でWriteEntry | E-01 (L128-131) | ○ |
| C-14 | メッセージがMaxMessageSizeを超える場合は分割される | E-01 (L134-182) | ○ |
| C-15 | 先頭セグメントは"..."で終わる | E-01 (L143-146: `ContinuationString`) | ○ |
| C-16 | 中間セグメントは両端に"..."が付く | E-01 (L166-176) | ○ |
| C-17 | 末尾セグメントは"..."で始まる | E-01 (L155-159) | ○ |
| C-18 | GetEventLogEntryTypeのマッピングが正しい | E-01 (L185-201) | ○ |

### EventLogLoggerProvider クラス（UT-ELG-030〜037）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-19 | デフォルトコンストラクタはnullを渡す | E-02 (L21-24: `: this(settings: null)`) | ○ |
| C-20 | settingsがnullの場合new EventLogSettings()が使用される | E-02 (L32: `_settings = settings ?? new EventLogSettings()`) | ○ |
| C-21 | IOptions<EventLogSettings>コンストラクタはValue.を使用 | E-02 (L39-42: `options.Value`) | ○ |
| C-22 | CreateLoggerはEventLogLoggerを返す | E-02 (L45-48) | ○ |
| C-23 | DisposeはWindowsEventLogの場合DiagnosticsEventLogをDispose | E-02 (L51-57) | ○ |
| C-24 | SetScopeProviderは_scopeProviderを設定 | E-02 (L60-63) | ○ |

### EventLogSettings クラス（UT-ELG-038〜049）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-25 | LogName, SourceName, MachineName, Filterプロパティが存在 | E-03 (L16, L21, L26, L31) | ○ |
| C-26 | EventLogプロパティは未設定時にCreateDefaultEventLogを呼ぶ | E-03 (L33-39) | ○ |
| C-27 | LogNameがnull/空の場合"Application"がデフォルト | E-03 (L43) | ○ |
| C-28 | MachineNameがnull/空の場合"."がデフォルト | E-03 (L44) | ○ |
| C-29 | SourceNameがnull/空の場合".NET Runtime"とDefaultEventId=1000 | E-03 (L45-52) | ○ |
| C-30 | SourceNameが指定されている場合DefaultEventId=null | E-03 (L46, L54) | ○ |

### WindowsEventLog クラス（UT-ELG-050〜058）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-31 | コンストラクタでDiagnosticsEventLogを初期化 | E-05 (L24-27) | ○ |
| C-32 | MaxMessageSizeは31839を返す | E-05 (L18, L37: `MaximumMessageSize = 31839`) | ○ |
| C-33 | DefaultEventIdプロパティが存在 | E-05 (L39) | ○ |
| C-34 | WriteEntryは_enabled=trueの場合WriteEventを呼ぶ | E-05 (L43-48) | ○ |
| C-35 | SecurityException時に_enabled=falseになる | E-05 (L50-52) | ○ |
| C-36 | SecurityException時にバックアップログへ書き込み | E-05 (L54-60) | ○ |
| C-37 | バックアップログ書き込み失敗時は例外を抑制 | E-05 (L62-65) | ○ |

### IEventLog インターフェース（UT-ELG-059〜061）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-38 | DefaultEventId, MaxMessageSize, WriteEntryが定義 | E-04 (L10-14) | ○ |

### EventLoggerFactoryExtensions クラス（UT-ELG-062〜071）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-39 | AddEventLog(ILoggingBuilder)でbuilderのnullチェック | E-06 (L58) | ○ |
| C-40 | AddEventLog(ILoggingBuilder)でSingletonとして登録 | E-06 (L60) | ○ |
| C-41 | AddEventLog(ILoggingBuilder, EventLogSettings)で両引数のnullチェック | E-06 (L73-74) | ○ |
| C-42 | AddEventLog(ILoggingBuilder, Action)でconfigureのnullチェック | E-06 (L89) | ○ |
| C-43 | AddEventLog(ILoggingBuilder, Action)でAddEventLogとConfigureを呼ぶ | E-06 (L91-92) | ○ |
| C-44 | ILoggerFactory版のメソッドにObsolete属性が付与 | E-06 (L22-23, L38-39, L47-48) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし
  - 全てのテストケースはソースコードから直接導出されている

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 全テストケースがソースコードに基づいており、ロジックが明確
- **注意点**：
  - WindowsEventLogクラスは`[SupportedOSPlatform("windows")]`属性が付与されており、Windows環境でのみテスト実行可能
  - SecurityException関連のテスト（UT-ELG-056〜058）は実際の権限不足状況の再現が必要
  - Obsoleteメソッド（UT-ELG-069〜071）は`error: true`のため呼び出すとコンパイルエラーになる

## 6) レビュアーチェックリスト（最小）
- [ ] 各テストケースの入力値・期待結果がソースコードの実装と整合しているか
- [ ] メッセージ分割ロジック（MaxMessageSize=31839、ContinuationString="..."）の境界値が正しいか
- [ ] SecurityException処理のテストがモック可能な形で設計されているか
- [ ] Windows環境依存のテストが適切に条件分岐またはスキップされる設計か
- [ ] ProviderAlias属性（"EventLog"）に関するテストが必要か検討
- [ ] DIコンテナ（IOptions）経由のインスタンス生成テストが十分か
