---
generated_at: 2026-01-30 16:50:00
metrics:
  claims_total: 85
  claims_with_evidence: 85
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：libraries-Microsoft.Extensions.Logging.EventSource.csv

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：85 / 85、根拠なし：0
- 優先レビュー（高）
  1. **すべてのテストケースにソースコード根拠あり**
  2. 高優先度テストケース（認証・認可関連）は存在しないが、EventSource連携が重要
  3. LogLevel/FilterSpec処理は本ライブラリの中核機能

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/libraries/Microsoft.Extensions.Logging.EventSource/src/EventSourceLogger.cs`
- E-02: `src/libraries/Microsoft.Extensions.Logging.EventSource/src/EventSourceLoggerProvider.cs`
- E-03: `src/libraries/Microsoft.Extensions.Logging.EventSource/src/LoggingEventSource.cs`
- E-04: `src/libraries/Microsoft.Extensions.Logging.EventSource/src/ExceptionInfo.cs`
- E-05: `src/libraries/Microsoft.Extensions.Logging.EventSource/src/EventSourceLoggerFactoryExtensions.cs`
- E-06: `src/libraries/Microsoft.Extensions.Logging.EventSource/src/EventLogFiltersConfigureOptions.cs`
- E-07: `src/libraries/Microsoft.Extensions.Logging.EventSource/src/EventLogFiltersConfigureOptionsChangeSource.cs`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | EventSourceLogger.IsEnabled - LogLevel.Traceが有効判定されること | E-01 (Line 49-52) | ○ |
| C-02 | EventSourceLogger.IsEnabled - LogLevel.Noneは無効判定されること | E-01 (Line 49-52) | ○ |
| C-03 | EventSourceLogger.IsEnabled - 設定レベルより低いログレベルは無効判定されること | E-01 (Line 49-52) | ○ |
| C-04 | EventSourceLogger.IsEnabled - 設定レベルと同じログレベルは有効判定されること | E-01 (Line 49-52) | ○ |
| C-05 | EventSourceLogger.Log - FormattedMessageキーワード有効時にイベントが発行されること | E-01 (Line 62, 95-109) | ○ |
| C-06 | EventSourceLogger.Log - Messageキーワード有効時にイベントが発行されること | E-01 (Line 63, 112-128) | ○ |
| C-07 | EventSourceLogger.Log - JsonMessageキーワード有効時にJSON形式でイベントが発行されること | E-01 (Line 64, 131-161) | ○ |
| C-08 | EventSourceLogger.Log - 例外情報が正しくシリアライズされること | E-01 (Line 114, 136-144), E-04 | ○ |
| C-09 | EventSourceLogger.Log - Activity情報が正しく含まれること | E-01 (Line 75-92) | ○ |
| C-10 | EventSourceLogger.Log - IsEnabled=falseの場合はイベントが発行されないこと | E-01 (Line 57-60) | ○ |
| C-11 | EventSourceLogger.Log - EventSourceが無効の場合はイベントが発行されないこと | E-01 (Line 66-71) | ○ |
| C-12 | EventSourceLogger.BeginScope - スコープ開始時にActivityStartイベントが発行されること | E-01 (Line 181-186) | ○ |
| C-13 | EventSourceLogger.BeginScope - スコープ終了時にActivityStopイベントが発行されること | E-01 (Line 213-223) | ○ |
| C-14 | EventSourceLogger.BeginScope - JsonMessageキーワード有効時にJSON形式でスコープイベントが発行されること | E-01 (Line 174-178) | ○ |
| C-15 | EventSourceLogger.BeginScope - IsEnabled=falseの場合はNullScopeが返却されること | E-01 (Line 166-169, 189) | ○ |
| C-16 | EventSourceLogger.GetExceptionInfo - 例外からExceptionInfoが正しく生成されること | E-01 (Line 232-235), E-04 (Line 20-26) | ○ |
| C-17 | EventSourceLogger.GetExceptionInfo - nullの場合はExceptionInfo.Emptyが返却されること | E-01 (Line 234) | ○ |
| C-18 | EventSourceLogger.GetProperties - IReadOnlyList<KeyValuePair>から正しく変換されること | E-01 (Line 240-251) | ○ |
| C-19 | EventSourceLogger.GetProperties - 非IReadOnlyListの場合は空配列が返却されること | E-01 (Line 253) | ○ |
| C-20 | EventSourceLogger.ToJson - KeyValuePairリストがJSON文字列に変換されること | E-01 (Line 256-276) | ○ |
| C-21 | EventSourceLogger.ToJson - 空リストの場合は{}が返却されること | E-01 (Line 261, 266) | ○ |
| C-22 | EventSourceLoggerProvider.Constructor - EventSourceが正しく設定されること | E-02 (Line 27-33) | ○ |
| C-23 | EventSourceLoggerProvider.Constructor - eventSourceがnullの場合はArgumentNullExceptionがスローされること | E-02 (Line 29) | ○ |
| C-24 | EventSourceLoggerProvider.CreateLogger - EventSourceLoggerが生成されること | E-02 (Line 36-39) | ○ |
| C-25 | EventSourceLoggerProvider.CreateLogger - 複数のLoggerがリンクリストで管理されること | E-02 (Line 38), E-01 (Line 47) | ○ |
| C-26 | EventSourceLoggerProvider.Dispose - すべてのLoggerのLevelがNoneに設定されること | E-02 (Line 42-49) | ○ |
| C-27 | LoggingEventSource.Instance - シングルトンインスタンスが取得できること | E-03 (Line 118) | ○ |
| C-28 | LoggingEventSource.FormattedMessage - FormattedMessageイベントが正しく発行されること | E-03 (Line 140-184) | ○ |
| C-29 | LoggingEventSource.Message - Messageイベントが正しく発行されること | E-03 (Line 190-215) | ○ |
| C-30 | LoggingEventSource.MessageJson - MessageJsonイベントが正しく発行されること | E-03 (Line 255-307) | ○ |
| C-31 | LoggingEventSource.ActivityStart - ActivityStartイベントが正しく発行されること | E-03 (Line 220-230) | ○ |
| C-32 | LoggingEventSource.ActivityStop - ActivityStopイベントが正しく発行されること | E-03 (Line 232-253) | ○ |
| C-33 | LoggingEventSource.ActivityJsonStart - ActivityJsonStartイベントが正しく発行されること | E-03 (Line 309-333) | ○ |
| C-34 | LoggingEventSource.ActivityJsonStop - ActivityJsonStopイベントが正しく発行されること | E-03 (Line 335-356) | ○ |
| C-35 | LoggingEventSource.OnEventCommand - EventCommand.Enable時にフィルタが設定されること | E-03 (Line 359-374) | ○ |
| C-36 | LoggingEventSource.OnEventCommand - EventCommand.Disable時にフィルタがクリアされること | E-03 (Line 370-373) | ○ |
| C-37 | LoggingEventSource.OnEventCommand - FilterSpecsが未指定の場合はデフォルトレベルで全有効になること | E-03 (Line 363-366) | ○ |
| C-38 | LoggingEventSource.ParseFilterSpec - フィルタ仕様が正しくパースされること | E-03 (Line 414-468) | ○ |
| C-39 | LoggingEventSource.ParseFilterSpec - UseAppFiltersが指定された場合はデフォルト無効ルールが追加されないこと | E-03 (Line 430-434) | ○ |
| C-40 | LoggingEventSource.ParseFilterSpec - 空文字列の場合は全カテゴリがデフォルトレベルで有効になること | E-03 (Line 416-419) | ○ |
| C-41 | LoggingEventSource.ParseFilterSpec - nullの場合は全カテゴリがNoneで無効になること | E-03 (Line 421-425) | ○ |
| C-42 | LoggingEventSource.ParseFilterSpec - ワイルドカード(*)が正しく処理されること | E-03 (Line 451-454) | ○ |
| C-43 | LoggingEventSource.TryParseLevel - 文字列レベル名が正しくパースされること | E-03 (Line 477-522) | ○ |
| C-44 | LoggingEventSource.TryParseLevel - 数値レベルが正しくパースされること | E-03 (Line 510-518) | ○ |
| C-45 | LoggingEventSource.TryParseLevel - 空文字列の場合はデフォルトレベルが返却されること | E-03 (Line 481-486) | ○ |
| C-46 | LoggingEventSource.TryParseLevel - 無効な文字列の場合はfalseが返却されること | E-03 (Line 510-513) | ○ |
| C-47 | LoggingEventSource.TryParseLevel - 範囲外の数値の場合はfalseが返却されること | E-03 (Line 514-517) | ○ |
| C-48 | LoggingEventSource.GetDefaultLevel - EventLevel.VerboseでLogLevel.Debugが返却されること | E-03 (Line 529-532) | ○ |
| C-49 | LoggingEventSource.GetDefaultLevel - EventLevel.InformationalでLogLevel.Informationが返却されること | E-03 (Line 534-537) | ○ |
| C-50 | LoggingEventSource.GetDefaultLevel - EventLevel.WarningでLogLevel.Warningが返却されること | E-03 (Line 539-542) | ○ |
| C-51 | LoggingEventSource.GetDefaultLevel - EventLevel.ErrorでLogLevel.Errorが返却されること | E-03 (Line 544-547) | ○ |
| C-52 | LoggingEventSource.GetFilterRules - 設定されたフィルタルールが取得できること | E-03 (Line 553-556) | ○ |
| C-53 | LoggingEventSource.GetFilterChangeToken - 変更トークンが取得できること | E-03 (Line 388-393) | ○ |
| C-54 | LoggingEventSource.FireChangeToken - 変更トークンがキャンセルされること | E-03 (Line 395-400) | ○ |
| C-55 | ExceptionInfo.Constructor - 例外情報が正しく設定されること | E-04 (Line 20-26) | ○ |
| C-56 | ExceptionInfo.Empty - 空のExceptionInfoが取得できること | E-04 (Line 14) | ○ |
| C-57 | ExceptionInfo.TypeName - 例外の型名が取得できること | E-04 (Line 22, 28) | ○ |
| C-58 | ExceptionInfo.Message - 例外メッセージが取得できること | E-04 (Line 23, 29) | ○ |
| C-59 | ExceptionInfo.HResult - 例外のHResultが取得できること | E-04 (Line 24, 30) | ○ |
| C-60 | ExceptionInfo.VerboseMessage - 例外のToString()結果が取得できること | E-04 (Line 25, 31) | ○ |
| C-61 | EventSourceLoggerFactoryExtensions.AddEventSourceLogger(ILoggingBuilder) - EventSourceLoggerProviderがDIコンテナに登録されること | E-05 (Line 44) | ○ |
| C-62 | EventSourceLoggerFactoryExtensions.AddEventSourceLogger(ILoggingBuilder) - LoggingEventSource.InstanceがシングルトンとしてDI登録されること | E-05 (Line 43) | ○ |
| C-63 | EventSourceLoggerFactoryExtensions.AddEventSourceLogger(ILoggingBuilder) - EventLogFiltersConfigureOptionsが登録されること | E-05 (Line 45) | ○ |
| C-64 | EventSourceLoggerFactoryExtensions.AddEventSourceLogger(ILoggingBuilder) - EventLogFiltersConfigureOptionsChangeSourceが登録されること | E-05 (Line 46) | ○ |
| C-65 | EventSourceLoggerFactoryExtensions.AddEventSourceLogger(ILoggingBuilder) - builderがnullの場合はArgumentNullExceptionがスローされること | E-05 (Line 41) | ○ |
| C-66 | EventSourceLoggerFactoryExtensions.AddEventSourceLogger(ILoggerFactory) - factoryがnullの場合はArgumentNullExceptionがスローされること | E-05 (Line 27) | ○ |
| C-67 | EventLogFiltersConfigureOptions.Constructor - LoggingEventSourceが正しく設定されること | E-06 (Line 13-16) | ○ |
| C-68 | EventLogFiltersConfigureOptions.Configure - フィルタルールがLoggerFilterOptionsに追加されること | E-06 (Line 18-23) | ○ |
| C-69 | EventLogFiltersConfigureOptions.Configure - フィルタルールが空の場合は何も追加されないこと | E-06 (Line 20-22) | ○ |
| C-70 | EventLogFiltersConfigureOptionsChangeSource.Constructor - LoggingEventSourceが正しく設定されること | E-07 (Line 14-17) | ○ |
| C-71 | EventLogFiltersConfigureOptionsChangeSource.GetChangeToken - LoggingEventSourceのGetFilterChangeTokenが呼び出されること | E-07 (Line 19) | ○ |
| C-72 | EventLogFiltersConfigureOptionsChangeSource.Name - Nameプロパティがnullであること | E-07 (Line 21) | ○ |
| C-73 | EventSourceLogger.ActivityScope.Constructor - ActivityScopeが正しく初期化されること | E-01 (Line 204-211) | ○ |
| C-74 | EventSourceLogger.ActivityScope.Dispose - isJsonStop=falseの場合はActivityStopが呼び出されること | E-01 (Line 219-222) | ○ |
| C-75 | EventSourceLogger.ActivityScope.Dispose - isJsonStop=trueの場合はActivityJsonStopが呼び出されること | E-01 (Line 215-218) | ○ |
| C-76 | LoggingEventSource.Keywords.Meta - Keywords.Metaが1であること | E-03 (Line 100) | ○ |
| C-77 | LoggingEventSource.Keywords.Message - Keywords.Messageが2であること | E-03 (Line 104) | ○ |
| C-78 | LoggingEventSource.Keywords.FormattedMessage - Keywords.FormattedMessageが4であること | E-03 (Line 108) | ○ |
| C-79 | LoggingEventSource.Keywords.JsonMessage - Keywords.JsonMessageが8であること | E-03 (Line 112) | ○ |
| C-80 | EventSourceLogger.Log - EventNameがnullの場合は空文字列として処理されること | E-03 (Line 159-160, 212, 278-279) | ○ |
| C-81 | EventSourceLogger.Log - FormattedMessageがnullの場合は空文字列として処理されること | E-03 (Line 160-161, 279-280) | ○ |
| C-82 | EventSourceLogger.Log - Activityがnullの場合は空文字列のトレースIDが使用されること | E-01 (Line 87-92) | ○ |
| C-83 | EventSourceLogger.Log - ActivityがW3C形式でない場合は空文字列のトレースIDが使用されること | E-01 (Line 79, 87-92) | ○ |
| C-84 | EventSourceLogger.Log - ActivityTraceFlagsがNoneの場合は"0"が設定されること | E-01 (Line 83-85) | ○ |
| C-85 | EventSourceLogger.Log - ActivityTraceFlagsがRecordedの場合は"1"が設定されること | E-01 (Line 83-85) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。すべてのテストケースについてソースコードから根拠を確認できた。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべてのテストケースがソースコードに基づいており、追加の外部依存もない

## 6) レビュアーチェックリスト（最小）
- [ ] テストケースが実際のソースコード実装と整合しているか確認
- [ ] EventSource/ETW連携に関するテストケースが環境依存しないか確認
- [ ] LogLevelフィルタリングのテストケースが境界値を適切にカバーしているか確認
- [ ] ParseFilterSpecのテストケースがすべてのフィルタ構文パターンをカバーしているか確認
- [ ] Activity/分散トレーシング連携のテストケースがW3C仕様に準拠しているか確認
