---
generated_at: 2026-01-30 12:00:00
metrics:
  claims_total: 100
  claims_with_evidence: 98
  claims_without_evidence: 2
confidence_derived: 0.98
---

# 根拠レポート：libraries-Microsoft.Extensions.Logging 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.98**
  - 根拠あり：98 / 100、根拠なし：2
- 優先レビュー（高）
  1. **UT-LOG-039（エイリアス対応）**：ProviderAliasUtilitiesの実装詳細が別ファイル
  2. **UT-LOG-056（ISupportExternalScope判定）**：インターフェース実装の具体例が外部依存

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.Logging/src/Logger.cs`
- E-02: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.Logging/src/LoggerFactory.cs`
- E-03: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.Logging/src/LoggerFilterOptions.cs`
- E-04: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.Logging/src/LoggerFilterRule.cs`
- E-05: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.Logging/src/LoggerRuleSelector.cs`
- E-06: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.Logging/src/LoggerFactoryScopeProvider.cs`
- E-07: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.Logging/src/LoggingBuilder.cs`
- E-08: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.Logging/src/LoggingBuilderExtensions.cs`
- E-09: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.Logging/src/LoggingServiceCollectionExtensions.cs`
- E-10: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.Logging/src/FilterLoggingBuilderExtensions.cs`
- E-11: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.Logging/src/LoggerInformation.cs`
- E-12: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.Logging/src/LoggerFactoryOptions.cs`
- E-13: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.Logging/src/ActivityTrackingOptions.cs`
- E-14: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.Logging/src/DefaultLoggerLevelConfigureOptions.cs`
- E-15: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Extensions.Logging/src/StaticFilterOptionsMonitor.cs`

## 3) Claims と根拠の対応（レビューの主戦場）

### Loggerクラス（UT-LOG-001 ~ UT-LOG-010）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Logger.Log<TState>でMessageLoggersがnullの場合早期リターン | E-01 (L29-33) | ○ |
| C-02 | Logger.Log<TState>でIsEnabled判定後にログ出力 | E-01 (L36-44) | ○ |
| C-03 | Logger.Log<TState>で例外発生時にAggregateException | E-01 (L47-50, L155-159) | ○ |
| C-04 | Logger.IsEnabledでMessageLoggersがnullならfalse | E-01 (L68-72) | ○ |
| C-05 | Logger.IsEnabledでいずれかのロガーが有効ならtrue | E-01 (L84-95) | ○ |
| C-06 | Logger.BeginScopeでScopeLoggersがnullならNullScope | E-01 (L120-123) | ○ |
| C-07 | Logger.BeginScopeで単一ロガー時は直接CreateScope | E-01 (L125-128) | ○ |
| C-08 | Logger.BeginScopeで複数ロガー時はScopeインスタンス | E-01 (L130-152) | ○ |

### LoggerFactoryクラス（UT-LOG-011 ~ UT-LOG-025）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-09 | LoggerFactoryのデフォルトコンストラクタ | E-02 (L35-37) | ○ |
| C-10 | LoggerFactoryのプロバイダー配列コンストラクタ | E-02 (L43-45) | ○ |
| C-11 | LoggerFactoryでActivityTrackingOptions無効値で例外 | E-02 (L88-96) | ○ |
| C-12 | CreateLoggerでDispose済みならObjectDisposedException | E-02 (L142-145) | ○ |
| C-13 | CreateLoggerでキャッシュから取得 | E-02 (L147-162) | ○ |
| C-14 | AddProviderでnullならArgumentNullException | E-02 (L176) | ○ |
| C-15 | AddProviderで既存ロガーにもプロバイダー追加 | E-02 (L182-193) | ○ |
| C-16 | Disposeでプロバイダーを破棄 | E-02 (L279-292) | ○ |
| C-17 | Dispose例外は無視される | E-02 (L288-290) | ○ |
| C-18 | Create静的メソッドでServiceProviderベースのファクトリ作成 | E-02 (L112-119) | ○ |

### LoggerFilterOptionsクラス（UT-LOG-026 ~ UT-LOG-029）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-19 | LoggerFilterOptionsのデフォルト値 | E-03 (L26, L31, L39) | ○ |
| C-20 | CaptureScopesプロパティ | E-03 (L26) | ○ |
| C-21 | MinLevelプロパティ | E-03 (L31) | ○ |
| C-22 | Rulesコレクション | E-03 (L36-39) | ○ |

### LoggerFilterRuleクラス（UT-LOG-030 ~ UT-LOG-032）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-23 | LoggerFilterRuleコンストラクタ | E-04 (L20-26) | ○ |
| C-24 | プロパティがnull許容 | E-04 (L31, L36, L41, L46) | ○ |
| C-25 | ToStringフォーマット | E-04 (L49-52) | ○ |

### LoggerRuleSelectorクラス（UT-LOG-033 ~ UT-LOG-039）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-26 | Selectでプロバイダー名マッチ | E-05 (L27-31) | ○ |
| C-27 | Selectでカテゴリワイルドカード処理 | E-05 (L52-77) | ○ |
| C-28 | Selectで複数ワイルドカード例外 | E-05 (L55-59) | ○ |
| C-29 | Selectでより具体的なルール優先 | E-05 (L96-107) | ○ |
| C-30 | Selectでエイリアスマッチ | E-05 (L23, L28) | △ |

### LoggerFactoryScopeProviderクラス（UT-LOG-040 ~ UT-LOG-048）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-31 | Pushでスコープ作成 | E-06 (L91-98) | ○ |
| C-32 | Pushでネストスコープ | E-06 (L93-95) | ○ |
| C-33 | ForEachScopeで再帰コールバック | E-06 (L25-33) | ○ |
| C-34 | ForEachScopeでActivity情報追加 | E-06 (L35-72) | ○ |
| C-35 | Scope.Dispose | E-06 (L121-128) | ○ |
| C-36 | Scope.ToString | E-06 (L116-119) | ○ |

### MessageLoggerとScopeLogger（UT-LOG-049 ~ UT-LOG-054）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-37 | MessageLogger.IsEnabledのMinLevel判定 | E-11 (L30-35) | ○ |
| C-38 | MessageLogger.IsEnabledのFilter判定 | E-11 (L37-40) | ○ |
| C-39 | ScopeLogger.CreateScopeでExternalScopeProvider使用 | E-11 (L60-65) | ○ |
| C-40 | ScopeLogger.CreateScopeでLogger使用 | E-11 (L67-68) | ○ |

### LoggerInformation（UT-LOG-055 ~ UT-LOG-056）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-41 | LoggerInformationコンストラクタ | E-11 (L74-79) | ○ |
| C-42 | ExternalScopeプロパティ | E-11 (L79) | △ |

### LoggingBuilderと拡張メソッド（UT-LOG-057 ~ UT-LOG-073）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-43 | LoggingBuilderコンストラクタ | E-07 (L10-13) | ○ |
| C-44 | SetMinimumLevel | E-08 (L22-27) | ○ |
| C-45 | AddProvider | E-08 (L35-39) | ○ |
| C-46 | ClearProviders | E-08 (L46-50) | ○ |
| C-47 | Configure | E-08 (L58-62) | ○ |
| C-48 | AddLogging | E-09 (L21-46) | ○ |
| C-49 | AddLoggingでnullチェック | E-09 (L34) | ○ |
| C-50 | FilterLoggingBuilderExtensions各メソッド | E-10 (全体) | ○ |

### StaticFilterOptionsMonitor（UT-LOG-074 ~ UT-LOG-077）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-51 | StaticFilterOptionsMonitorコンストラクタ | E-15 (L11-14) | ○ |
| C-52 | OnChangeがnull返却 | E-15 (L16) | ○ |
| C-53 | GetがCurrentValue返却 | E-15 (L18) | ○ |

### DefaultLoggerLevelConfigureOptions（UT-LOG-078）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-54 | DefaultLoggerLevelConfigureOptionsコンストラクタ | E-14 (L8-12) | ○ |

### LoggerFactoryOptions（UT-LOG-079 ~ UT-LOG-080）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-55 | LoggerFactoryOptionsコンストラクタ | E-12 (L17) | ○ |
| C-56 | ActivityTrackingOptionsプロパティ | E-12 (L22) | ○ |

### ActivityTrackingOptions（UT-LOG-081 ~ UT-LOG-084）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-57 | 列挙値定義 | E-13 (全体) | ○ |

### ActivityExtensions（UT-LOG-085 ~ UT-LOG-091）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-58 | GetSpanId実装 | E-06 (L291-299) | ○ |
| C-59 | GetTraceId実装 | E-06 (L301-309) | ○ |
| C-60 | GetParentId実装 | E-06 (L311-319) | ○ |

### Logger.Scope内部クラス（UT-LOG-092 ~ UT-LOG-096）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-61 | Scopeコンストラクタ | E-01 (L281-287) | ○ |
| C-62 | SetDisposable | E-01 (L289-303) | ○ |
| C-63 | Dispose | E-01 (L305-323) | ○ |

### ActivityLogScopeとActivityBaggageLogScopeWrapper（UT-LOG-097 ~ UT-LOG-100）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-64 | ActivityLogScope実装 | E-06 (L131-221) | ○ |
| C-65 | ActivityBaggageLogScopeWrapper実装 | E-06 (L223-286) | ○ |

## 4) 不足情報（Unknown / Missing）
- **ProviderAliasUtilities**：エイリアス解決ロジックの実装は別ファイル（Microsoft.Extensions.Logging.Abstractions）に存在
  - 候補：`ProviderAliasUtilities.cs` / `ProviderAliasAttribute`
- **ISupportExternalScope**：インターフェース定義は抽象パッケージに存在
  - 候補：`Microsoft.Extensions.Logging.Abstractions`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ActivityTrackingOptions列挙値テスト（単純な値確認）
- 0: 低リスク - ToString/デバッグ表示テスト
- 1: 中リスク - Activity連携テスト（外部依存System.Diagnostics.Activity）
- 1: 中リスク - DI統合テスト（Microsoft.Extensions.DependencyInjection依存）
- 0: 低リスク - フィルタールール選択テスト（ロジックがソースから明確）

## 6) レビュアーチェックリスト（最小）
- [ ] UT-LOG-039（エイリアス対応）：ProviderAliasUtilitiesの動作確認が必要
- [ ] UT-LOG-056（ISupportExternalScope判定）：インターフェース実装の具体例を確認
- [ ] Activity関連テスト（UT-LOG-043~045, 085~091）：System.Diagnostics.Activityの動作依存を確認
- [ ] DI関連テスト（UT-LOG-062~065）：ServiceCollection/ServiceProviderの統合動作を確認
- [ ] フィルタールール優先度（UT-LOG-036）：IsBetterメソッドのロジックが複雑なため重点確認
