---
generated_at: 2026-01-30 17:00:00
metrics:
  claims_total: 40
  claims_with_evidence: 38
  claims_without_evidence: 2
confidence_derived: 0.95
---

# 根拠レポート：libraries-Microsoft.Extensions.Options.DataAnnotations.csv

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：38 / 40、根拠なし：2
- 優先レビュー（高）
  1. **UT-ODA-038（カスタムバリデーション属性）**：Validator.TryValidateObjectの一般的動作に基づく推測
  2. **UT-ODA-039（get-onlyプロパティ）**：GetMethod nullチェックロジックの詳細確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/libraries/Microsoft.Extensions.Options.DataAnnotations/src/DataAnnotationValidateOptions.cs` (行1-137)
- E-02: `src/libraries/Microsoft.Extensions.Options.DataAnnotations/src/OptionsBuilderDataAnnotationsExtensions.cs` (行1-28)
- E-03: DataAnnotationValidateOptions コンストラクタ (行28-31)
- E-04: Name プロパティ定義 (行36)
- E-05: Validate メソッド (行46-70)
- E-06: TryValidateOptions メソッド (行74-135)
- E-07: Name nullチェックロジック (行49-53)
- E-08: ArgumentNullException.ThrowIfNull (行56)
- E-09: Validator.TryValidateObject呼び出し (行85)
- E-10: ValidationResult処理 (行90-93)
- E-11: ValidateObjectMembersAttribute チェック (行111-118)
- E-12: ValidateEnumeratedItemsAttribute チェック (行119-131)
- E-13: 循環参照防止 HashSet (行78-81, 113-114, 122-123)
- E-14: インデクサ除外ロジック (行99-102)
- E-15: null プロパティスキップ (行106-109)
- E-16: ValidateDataAnnotations 拡張メソッド (行22-26)
- E-17: IValidateOptions<TOptions> 登録 (行24)
- E-18: OptionsBuilder 返却 (行25)
- E-19: OptionsBuilder.Name 使用 (行24)
- E-20: qualifiedName パス構築 (行117, 129)
- E-21: インデックス付きパス構築 (行129)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| UT-ODA-001 | コンストラクタでnameが正しく設定されること | E-03 | ○ |
| UT-ODA-002 | コンストラクタでnullが渡された場合もNameがnullに設定されること | E-03 | ○ |
| UT-ODA-003 | Nameプロパティが読み取り専用で取得できること | E-04 | ○ |
| UT-ODA-004 | Nameがnullの場合は全オプションを検証すること | E-07 | ○ |
| UT-ODA-005 | Nameと引数nameが一致する場合に検証が実行されること | E-07 | ○ |
| UT-ODA-006 | Nameと引数nameが異なる場合にスキップされること | E-07 | ○ |
| UT-ODA-007 | optionsがnullの場合にArgumentNullExceptionがスローされること | E-08 | ○ |
| UT-ODA-008 | DataAnnotation検証に成功した場合にSuccessが返されること | E-05, E-09 | ○ |
| UT-ODA-009 | [Required]属性のプロパティがnullの場合にFailが返されること | E-09, E-10 | ○ |
| UT-ODA-010 | [StringLength]属性の制限を超える場合にFailが返されること | E-09, E-10 | ○ |
| UT-ODA-011 | [Range]属性の範囲外の場合にFailが返されること | E-09, E-10 | ○ |
| UT-ODA-012 | 複数のバリデーションエラーがある場合に全てのエラーが報告されること | E-10 | ○ |
| UT-ODA-013 | [ValidateObjectMembers]属性付きネストオブジェクトが検証されること | E-11 | ○ |
| UT-ODA-014 | [ValidateObjectMembers]属性付きネストオブジェクトの検証が失敗すること | E-11, E-20 | ○ |
| UT-ODA-015 | [ValidateEnumeratedItems]属性付きコレクションの各要素が検証されること | E-12 | ○ |
| UT-ODA-016 | [ValidateEnumeratedItems]属性付きコレクション内の無効な要素が検出されること | E-12, E-21 | ○ |
| UT-ODA-017 | 循環参照がある場合でも無限ループにならないこと | E-13 | ○ |
| UT-ODA-018 | 空のコレクションに対して[ValidateEnumeratedItems]が適用された場合 | E-12 | ○ |
| UT-ODA-019 | nullプロパティは検証をスキップすること | E-15 | ○ |
| UT-ODA-020 | インデクサプロパティは検証対象外であること | E-14 | ○ |
| UT-ODA-021 | [EmailAddress]属性の無効なメールアドレス形式の場合にFailが返されること | E-09 | ○ |
| UT-ODA-022 | [RegularExpression]属性のパターン不一致の場合にFailが返されること | E-09 | ○ |
| UT-ODA-023 | エラーメッセージにメンバー名とエラー内容が含まれること | E-10 | ○ |
| UT-ODA-024 | 深くネストしたオブジェクトも再帰的に検証されること | E-06, E-11 | ○ |
| UT-ODA-025 | ネストパスがエラーメッセージに含まれること | E-20 | ○ |
| UT-ODA-026 | DIコンテナにDataAnnotationValidateOptionsが登録されること | E-16, E-17 | ○ |
| UT-ODA-027 | メソッドチェーンのためにOptionsBuilderが返されること | E-18 | ○ |
| UT-ODA-028 | OptionsBuilder.Nameが正しくDataAnnotationValidateOptionsに渡されること | E-19 | ○ |
| UT-ODA-029 | 複数回呼び出しても複数のバリデーターが登録されること | E-17 | ○ |
| UT-ODA-030 | [MinLength]属性の境界値（ちょうど最小長）で成功すること | E-09 | ○ |
| UT-ODA-031 | [MinLength]属性の境界値（最小長-1）で失敗すること | E-09 | ○ |
| UT-ODA-032 | [MaxLength]属性の境界値（ちょうど最大長）で成功すること | E-09 | ○ |
| UT-ODA-033 | [MaxLength]属性の境界値（最大長+1）で失敗すること | E-09 | ○ |
| UT-ODA-034 | [Compare]属性で2つのプロパティが一致する場合に成功すること | E-09 | ○ |
| UT-ODA-035 | [Compare]属性で2つのプロパティが不一致の場合に失敗すること | E-09 | ○ |
| UT-ODA-036 | 複合的なバリデーション属性がすべて成功する場合 | E-09 | ○ |
| UT-ODA-037 | [ValidateEnumeratedItems]属性付きコレクションのインデックスがエラーメッセージに含まれること | E-21 | ○ |
| UT-ODA-038 | カスタムバリデーション属性が動作すること | **根拠不足** | △ |
| UT-ODA-039 | プロパティにget-onlyアクセサのみの場合も検証されること | **根拠不足** | △ |
| UT-ODA-040 | IEnumerable実装型（配列）に対して[ValidateEnumeratedItems]が動作すること | E-12 | ○ |

## 4) 不足情報（Unknown / Missing）
- **UT-ODA-038**: カスタムバリデーション属性の動作は、System.ComponentModel.DataAnnotations.Validator.TryValidateObjectの一般的な動作に依存。このライブラリ内にはカスタム属性の明示的な処理コードはないが、標準のValidator APIがカスタム属性をサポートしているため動作が期待される。
  - 候補：System.ComponentModel.DataAnnotationsのドキュメント / Validatorクラスのソースコード / 既存テストコード
- **UT-ODA-039**: get-onlyプロパティの処理は、PropertyInfo.GetMethodがnullでないことをチェック（行99）しているが、get-onlyプロパティでパラメータがないケースの明示的なテストは確認できない。
  - 候補：GetPropertyメソッドのBindingFlags.Instance | BindingFlags.Publicの動作確認

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - DataAnnotationValidateOptionsクラスの基本機能（コンストラクタ、Name、Validate基本動作）
- **0: 低リスク** - OptionsBuilderDataAnnotationsExtensions拡張メソッド
- **1: 中リスク** - ネストオブジェクト検証とコレクション要素検証（ValidateObjectMembers/ValidateEnumeratedItems）
- **1: 中リスク** - 循環参照防止機構
- **1: 中リスク** - カスタムバリデーション属性のサポート（Validator APIへの依存）

## 6) レビュアーチェックリスト（最小）
- [ ] Validateメソッドの名前一致/不一致ロジック（UT-ODA-004〜006）が正しく実装されているか確認
- [ ] ArgumentNullException.ThrowIfNullの動作確認（UT-ODA-007）
- [ ] ValidateObjectMembersAttributeによるネスト検証の再帰動作確認（UT-ODA-013〜014, UT-ODA-024〜025）
- [ ] ValidateEnumeratedItemsAttributeによるコレクション要素検証の動作確認（UT-ODA-015〜016, UT-ODA-037）
- [ ] 循環参照防止のHashSet使用とReferenceEqualityComparer.Instanceの動作確認（UT-ODA-017）
- [ ] DIコンテナへの登録がSingletonとして行われていることの確認（UT-ODA-026）
- [ ] カスタムバリデーション属性のテストケース追加検討（UT-ODA-038）
- [ ] DataAnnotation属性の境界値テストの網羅性確認（UT-ODA-030〜033）
