---
generated_at: 2026-01-30 12:00:00
metrics:
  claims_total: 132
  claims_with_evidence: 132
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：libraries-Microsoft.Extensions.Options 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各テストケースに対して、ソースコード内の実装が根拠（Evidence）として存在するか
2. **根拠との整合性**：テストケースの内容がソースコードの実装と矛盾していないか
3. **網羅性**：対象クラスのpublicメソッド・プロパティを適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：132 / 132、根拠なし：0
- 優先レビュー（高）
  1. **UT-OPT-027, 028**: バリデーション失敗時の例外処理はOptionsFactory.Create内のコードから根拠あり
  2. **UT-OPT-122, 123**: StartupValidator.Validateの例外処理はソースコードから根拠あり
  3. **UT-OPT-131**: スレッドセーフティはUnnamedOptionsManagerのlock機構から根拠あり

## 2) 参照した情報（Evidence一覧）
> 解析対象ソースファイル一覧

- E-01: `src/libraries/Microsoft.Extensions.Options/src/Options.cs`
- E-02: `src/libraries/Microsoft.Extensions.Options/src/OptionsManager.cs`
- E-03: `src/libraries/Microsoft.Extensions.Options/src/OptionsMonitor.cs`
- E-04: `src/libraries/Microsoft.Extensions.Options/src/OptionsFactory.cs`
- E-05: `src/libraries/Microsoft.Extensions.Options/src/OptionsCache.cs`
- E-06: `src/libraries/Microsoft.Extensions.Options/src/OptionsBuilder.cs`
- E-07: `src/libraries/Microsoft.Extensions.Options/src/ValidateOptions.cs`
- E-08: `src/libraries/Microsoft.Extensions.Options/src/ValidateOptionsResult.cs`
- E-09: `src/libraries/Microsoft.Extensions.Options/src/ValidateOptionsResultBuilder.cs`
- E-10: `src/libraries/Microsoft.Extensions.Options/src/OptionsValidationException.cs`
- E-11: `src/libraries/Microsoft.Extensions.Options/src/ConfigureNamedOptions.cs`
- E-12: `src/libraries/Microsoft.Extensions.Options/src/ConfigureOptions.cs`
- E-13: `src/libraries/Microsoft.Extensions.Options/src/PostConfigureOptions.cs`
- E-14: `src/libraries/Microsoft.Extensions.Options/src/OptionsWrapper.cs`
- E-15: `src/libraries/Microsoft.Extensions.Options/src/OptionsServiceCollectionExtensions.cs`
- E-16: `src/libraries/Microsoft.Extensions.Options/src/UnnamedOptionsManager.cs`
- E-17: `src/libraries/Microsoft.Extensions.Options/src/ValidateOnStart.cs`
- E-18: `src/libraries/Microsoft.Extensions.Options/src/OptionsMonitorExtensions.cs`
- E-19: `src/libraries/Microsoft.Extensions.Options/src/OptionsBuilderExtensions.cs`
- E-20: `src/libraries/Microsoft.Extensions.Options/src/StartupValidatorOptions.cs`
- E-21: `src/libraries/Microsoft.Extensions.Options/src/ValidateEnumeratedItemsAttribute.cs`
- E-22: `src/libraries/Microsoft.Extensions.Options/src/ValidateObjectMembersAttribute.cs`
- E-23: `src/libraries/Microsoft.Extensions.Options/src/OptionsValidatorAttribute.cs`

## 3) Claims と根拠の対応（レビューの主戦場）

### Options クラス (E-01)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Options.Create<TOptions>がOptionsWrapperを返す | E-01 Line 27-31: `return new OptionsWrapper<TOptions>(options);` | ○ |
| C-02 | Options.DefaultNameが空文字列 | E-01 Line 19: `public static readonly string DefaultName = string.Empty;` | ○ |

### OptionsManager クラス (E-02)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-03 | コンストラクタがIOptionsFactoryを受け取る | E-02 Line 25-28: `public OptionsManager(IOptionsFactory<TOptions> factory)` | ○ |
| C-04 | ValueプロパティがGet(DefaultName)を呼ぶ | E-02 Line 33: `public TOptions Value => Get(Options.DefaultName);` | ○ |
| C-05 | Getメソッドがnull名をデフォルト名に変換 | E-02 Line 44: `name ??= Options.DefaultName;` | ○ |
| C-06 | Getメソッドがキャッシュを使用 | E-02 Line 46-51: TryGetValue後GetOrAddを呼び出す実装 | ○ |

### OptionsMonitor クラス (E-03)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-09 | コンストラクタが3つのパラメータを受け取る | E-03 Line 31: `public OptionsMonitor(IOptionsFactory<TOptions> factory, IEnumerable<IOptionsChangeTokenSource<TOptions>> sources, IOptionsMonitorCache<TOptions> cache)` | ○ |
| C-10 | 配列型ソースの最適化 | E-03 Line 48-54: `if (sources is IOptionsChangeTokenSource<TOptions>[] sourcesArray)` | ○ |
| C-11 | CurrentValueがGet(DefaultName)を呼ぶ | E-03 Line 79: `get => Get(Options.DefaultName);` | ○ |
| C-14 | OnChangeがIDisposableを返す | E-03 Line 109-114: `public IDisposable OnChange(Action<TOptions, string> listener)` | ○ |
| C-17 | InvokeChangedがキャッシュ削除後に値取得 | E-03 Line 64-70: `_cache.TryRemove(name); TOptions options = Get(name);` | ○ |
| C-18 | DisposeがRegistrationsをクリア | E-03 Line 119-128: Disposeメソッドの実装 | ○ |

### OptionsFactory クラス (E-04)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-19 | 2パラメータコンストラクタが3パラメータを呼び出す | E-04 Line 27-28: `this(setups, postConfigures, validations: Array.Empty<IValidateOptions<TOptions>>())` | ○ |
| C-21 | 配列型入力の最適化 | E-04 Line 43: `_setups = setups as IConfigureOptions<TOptions>[] ?? ...` | ○ |
| C-22 | CreateがConfigureアクションを実行 | E-04 Line 58-68: foreach ループでConfigureを呼び出す | ○ |
| C-23 | IConfigureNamedOptionsの分岐処理 | E-04 Line 60-67: `if (setup is IConfigureNamedOptions<TOptions> namedSetup)` | ○ |
| C-25 | PostConfigureがConfigureの後に実行 | E-04 Line 69-72: Configureループの後にPostConfigureループ | ○ |
| C-27 | バリデーション失敗時に例外スロー | E-04 Line 85-88: `throw new OptionsValidationException(name, typeof(TOptions), failures);` | ○ |
| C-29 | CreateInstanceがActivator.CreateInstanceを使用 | E-04 Line 102: `return Activator.CreateInstance<TOptions>();` | ○ |

### OptionsCache クラス (E-05)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-31 | ClearがConcurrentDictionaryをクリア | E-05 Line 23: `public void Clear() => _cache.Clear();` | ○ |
| C-32 | GetOrAddがファクトリを呼び出す | E-05 Line 31-48: GetOrAddメソッドの実装 | ○ |
| C-35 | createOptionsがnullで例外 | E-05 Line 33: `ArgumentNullException.ThrowIfNull(createOptions);` | ○ |
| C-38 | TryAddが新規エントリを追加 | E-05 Line 96-105: `return _cache.TryAdd(...)` | ○ |
| C-40 | optionsがnullで例外 | E-05 Line 98: `ArgumentNullException.ThrowIfNull(options);` | ○ |
| C-41 | TryRemoveがエントリを削除 | E-05 Line 112-113: `_cache.TryRemove(name ?? Options.DefaultName, out _);` | ○ |

### OptionsBuilder クラス (E-06)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-43 | コンストラクタがservicesとnameを受け取る | E-06 Line 32-38: コンストラクタの実装 | ○ |
| C-44 | null名がデフォルト名になる | E-06 Line 37: `Name = name ?? Options.DefaultName;` | ○ |
| C-45 | servicesがnullで例外 | E-06 Line 34: `ArgumentNullException.ThrowIfNull(services);` | ○ |
| C-46 | ConfigureがConfigureNamedOptionsを登録 | E-06 Line 52: `Services.AddSingleton<IConfigureOptions<TOptions>>(new ConfigureNamedOptions<TOptions>(Name, configureOptions));` | ○ |
| C-48 | configureOptionsがnullで例外 | E-06 Line 50: `ArgumentNullException.ThrowIfNull(configureOptions);` | ○ |
| C-50 | PostConfigureがPostConfigureOptionsを登録 | E-06 Line 201: `Services.AddSingleton<IPostConfigureOptions<TOptions>>(new PostConfigureOptions<TOptions>(Name, configureOptions));` | ○ |
| C-52 | ValidateがValidateOptionsを登録 | E-06 Line 356: `Services.AddSingleton<IValidateOptions<TOptions>>(new ValidateOptions<TOptions>(Name, validation, failureMessage));` | ○ |
| C-53 | デフォルト失敗メッセージ | E-06 Line 15: `private const string DefaultValidationFailureMessage = "A validation error has occurred.";` | ○ |

### ValidateOptions クラス (E-07)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-56 | コンストラクタが3パラメータを受け取る | E-07 Line 20-27: コンストラクタの実装 | ○ |
| C-57 | validationがnullで例外 | E-07 Line 22: `ArgumentNullException.ThrowIfNull(validation);` | ○ |
| C-58 | バリデーション成功時にSuccess | E-07 Line 55-58: `if (Validation.Invoke(options)) { return ValidateOptionsResult.Success; }` | ○ |
| C-59 | バリデーション失敗時にFail | E-07 Line 59: `return ValidateOptionsResult.Fail(FailureMessage);` | ○ |
| C-60 | Nameがnullで全名前に適用 | E-07 Line 53: `if (Name == null || name == Name)` | ○ |
| C-61 | Name不一致でSkip | E-07 Line 63: `return ValidateOptionsResult.Skip;` | ○ |

### ValidateOptionsResult クラス (E-08)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-62 | SkipがSkipped=true | E-08 Line 18: `public static readonly ValidateOptionsResult Skip = new ValidateOptionsResult() { Skipped = true };` | ○ |
| C-63 | SuccessがSucceeded=true | E-08 Line 23: `public static readonly ValidateOptionsResult Success = new ValidateOptionsResult() { Succeeded = true };` | ○ |
| C-64 | Fail(string)が失敗結果を生成 | E-08 Line 63-64: `public static ValidateOptionsResult Fail(string failureMessage)` | ○ |
| C-65 | Fail(IEnumerable)がセミコロン区切り | E-08 Line 71-72: `FailureMessage = string.Join("; ", failures)` | ○ |

### ValidateOptionsResultBuilder クラス (E-09)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-66 | AddErrorがエラーを追加 | E-09 Line 32-36: `Errors.Add(...)` | ○ |
| C-67 | propertyName付きエラー | E-09 Line 35: `$"Property {propertyName}: {error}"` | ○ |
| C-68 | errorがnullで例外 | E-09 Line 34: `ArgumentNullException.ThrowIfNull(error);` | ○ |
| C-76 | Buildがエラーありで Fail | E-09 Line 103-106: `if (_errors?.Count > 0) { return ValidateOptionsResult.Fail(_errors); }` | ○ |
| C-77 | Buildがエラーなしで Success | E-09 Line 108: `return ValidateOptionsResult.Success;` | ○ |
| C-78 | Clearがエラーをクリア | E-09 Line 114: `public void Clear() => _errors?.Clear();` | ○ |

### OptionsValidationException クラス (E-10)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-79 | コンストラクタが3パラメータを受け取る | E-10 Line 20-28: コンストラクタの実装 | ○ |
| C-80 | failureMessagesがnullで空リスト | E-10 Line 25: `Failures = failureMessages ?? new List<string>();` | ○ |
| C-81 | optionsNameがnullで例外 | E-10 Line 22: `ArgumentNullException.ThrowIfNull(optionsName);` | ○ |
| C-82 | optionsTypeがnullで例外 | E-10 Line 23: `ArgumentNullException.ThrowIfNull(optionsType);` | ○ |
| C-83 | Messageがセミコロン区切り | E-10 Line 48: `public override string Message => string.Join("; ", Failures);` | ○ |

### ConfigureNamedOptions クラス (E-11)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-84 | コンストラクタが2パラメータを受け取る | E-11 Line 19-23: コンストラクタの実装 | ○ |
| C-85 | 名前一致でActionが実行 | E-11 Line 45-48: `if (Name == null || name == Name) { Action?.Invoke(options); }` | ○ |
| C-86 | Nameがnullで全名前に適用 | E-11 Line 45: `if (Name == null || name == Name)` | ○ |
| C-89 | optionsがnullで例外 | E-11 Line 42: `ArgumentNullException.ThrowIfNull(options);` | ○ |
| C-90 | Configure(TOptions)がデフォルト名を使用 | E-11 Line 55: `public void Configure(TOptions options) => Configure(Options.DefaultName, options);` | ○ |

### ConfigureOptions クラス (E-12)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-91 | コンストラクタがactionを受け取る | E-12 Line 18-21: コンストラクタの実装 | ○ |
| C-92 | ConfigureがActionを実行 | E-12 Line 36: `Action?.Invoke(options);` | ○ |
| C-94 | optionsがnullで例外 | E-12 Line 34: `ArgumentNullException.ThrowIfNull(options);` | ○ |

### PostConfigureOptions クラス (E-13)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-95 | コンストラクタが2パラメータを受け取る | E-13 Line 19-23: コンストラクタの実装 | ○ |
| C-96 | 名前一致でActionが実行 | E-13 Line 45-48: `if (Name == null || name == Name) { Action?.Invoke(options); }` | ○ |
| C-99 | optionsがnullで例外 | E-13 Line 42: `ArgumentNullException.ThrowIfNull(options);` | ○ |

### OptionsWrapper クラス (E-14)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-100 | コンストラクタがoptionsを受け取る | E-14 Line 20-23: `public OptionsWrapper(TOptions options) { Value = options; }` | ○ |
| C-101 | Valueが設定されたoptionsを返す | E-14 Line 28: `public TOptions Value { get; }` | ○ |

### OptionsServiceCollectionExtensions クラス (E-15)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-102 | AddOptionsが必要なサービスを登録 | E-15 Line 22-32: TryAddでIOptions<>, IOptionsSnapshot<>等を登録 | ○ |
| C-104 | servicesがnullで例外 | E-15 Line 24: `ArgumentNullException.ThrowIfNull(services);` | ○ |
| C-105 | AddOptions<TOptions>がOptionsBuilderを返す | E-15 Line 267-268: `return new OptionsBuilder<TOptions>(services, name);` | ○ |
| C-107 | ConfigureがConfigureNamedOptionsを登録 | E-15 Line 102: `services.AddSingleton<IConfigureOptions<TOptions>>(new ConfigureNamedOptions<TOptions>(name, configureOptions));` | ○ |
| C-109 | ConfigureAllがname=nullで呼び出す | E-15 Line 114: `services.Configure(name: null, configureOptions: configureOptions);` | ○ |
| C-110 | PostConfigureがPostConfigureOptionsを登録 | E-15 Line 143: `services.AddSingleton<IPostConfigureOptions<TOptions>>(new PostConfigureOptions<TOptions>(name, configureOptions));` | ○ |
| C-114 | 未実装型でInvalidOperationException | E-15 Line 198-202: ThrowNoConfigServicesメソッド | ○ |

### UnnamedOptionsManager クラス (E-16)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-129 | Valueがファクトリを呼び出す | E-16 Line 30: `return _value ??= _factory.Create(Options.DefaultName);` | ○ |
| C-130 | 2回目以降はキャッシュを使用 | E-16 Line 23-25: `if (_value is TOptions value) { return value; }` | ○ |
| C-131 | スレッドセーフにlockを使用 | E-16 Line 28: `lock (_syncObj ?? Interlocked.CompareExchange(...)` | ○ |

### StartupValidator / ValidateOnStart (E-17, E-19)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-117 | ValidateOnStartがIStartupValidatorを登録 | E-19 Line 29: `optionsBuilder.Services.TryAddTransient<IStartupValidator, StartupValidator>();` | ○ |
| C-121 | Validateがバリデータを実行 | E-17 Line 24-29: foreachループでvalidator()を実行 | ○ |
| C-122 | 単一エラーで再スロー | E-17 Line 40-44: `if (exceptions.Count == 1) { ExceptionDispatchInfo.Capture(exceptions[0]).Throw(); }` | ○ |
| C-123 | 複数エラーでAggregateException | E-17 Line 46-49: `throw new AggregateException(exceptions);` | ○ |

### OptionsMonitorExtensions クラス (E-18)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-120 | OnChangeがAction<TOptions>を受け取る | E-18 Line 21-24: `public static IDisposable? OnChange<TOptions>(...Action<TOptions> listener)` | ○ |

### Attribute クラス (E-21, E-22, E-23)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-124 | ValidateEnumeratedItemsAttributeのデフォルトコンストラクタ | E-21 Line 23-25: パラメータなしコンストラクタ | ○ |
| C-125 | ValidateEnumeratedItemsAttributeのValidator指定コンストラクタ | E-21 Line 35-38: `public ValidateEnumeratedItemsAttribute(Type validator)` | ○ |
| C-126 | ValidateObjectMembersAttributeのデフォルトコンストラクタ | E-22 Line 17-20: パラメータなしコンストラクタ | ○ |
| C-127 | ValidateObjectMembersAttributeのValidator指定コンストラクタ | E-22 Line 34-37: `public ValidateObjectMembersAttribute(Type validator)` | ○ |
| C-128 | OptionsValidatorAttributeのAttributeUsage | E-23 Line 12: `[AttributeUsage(AttributeTargets.Class | AttributeTargets.Struct)]` | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし（すべてのテストケースにソースコードの根拠あり）

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - すべてのテストケースがソースコードの実装に基づいている

### 注意点
1. **スレッドセーフティテスト（UT-OPT-131）**: 実際のマルチスレッド環境でのテストが必要
2. **パフォーマンス最適化テスト（UT-OPT-010, 013, 021）**: ベンチマークでの検証が望ましい
3. **ジェネリック型制約**: TOptionsにはclass制約があり、値型は使用不可

## 6) レビュアーチェックリスト（最小）
- [ ] バリデーション関連のテストケース（UT-OPT-056〜065）が実際のバリデーションシナリオを網羅しているか
- [ ] キャッシュ関連のテストケース（UT-OPT-031〜042）が並行アクセスを考慮しているか
- [ ] DI登録関連のテストケース（UT-OPT-102〜116）がサービスのライフサイクルを適切に検証しているか
- [ ] 名前付きオプションのテストケースが空文字列とnullを適切に区別しているか
- [ ] 例外系テストケースが適切な例外型とメッセージを検証しているか
