---
generated_at: 2026-01-30 10:30:00
metrics:
  claims_total: 150
  claims_with_evidence: 150
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート: libraries-Microsoft.Extensions.Primitives 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：150 / 150、根拠なし：0
- 優先レビュー（高）
  1. **該当なし**：全テストケースがソースコードに基づいて生成されています

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/libraries/Microsoft.Extensions.Primitives/src/StringValues.cs`
- E-02: `src/libraries/Microsoft.Extensions.Primitives/src/StringSegment.cs`
- E-03: `src/libraries/Microsoft.Extensions.Primitives/src/IChangeToken.cs`
- E-04: `src/libraries/Microsoft.Extensions.Primitives/src/CancellationChangeToken.cs`
- E-05: `src/libraries/Microsoft.Extensions.Primitives/src/CompositeChangeToken.cs`
- E-06: `src/libraries/Microsoft.Extensions.Primitives/src/ChangeToken.cs`
- E-07: `src/libraries/Microsoft.Extensions.Primitives/src/StringTokenizer.cs`
- E-08: `src/libraries/Microsoft.Extensions.Primitives/src/StringSegmentComparer.cs`
- E-09: `src/libraries/Microsoft.Extensions.Primitives/src/InplaceStringBuilder.cs`
- E-10: `src/libraries/Microsoft.Extensions.Primitives/src/Extensions.cs`
- E-11: `src/libraries/Microsoft.Extensions.Primitives/src/ThrowHelper.cs`

## 3) Claims と根拠の対応（レビューの主戦場）

### StringValues クラス（UT-PRM-001 - UT-PRM-033）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | StringValues(string?)コンストラクタが単一文字列を受け取る | E-01 (L35-38) | ○ |
| C-02 | StringValues(string?[]?)コンストラクタが配列を受け取る | E-01 (L44-47) | ○ |
| C-03 | Countプロパティがnullで0、stringで1、配列で配列長を返す | E-01 (L91-112) | ○ |
| C-04 | インデクサが範囲外でIndexOutOfRangeExceptionをスロー | E-01 (L133-161) | ○ |
| C-05 | ToString()が複数値をカンマ区切りで結合する | E-01 (L167-267) | ○ |
| C-06 | ToArray()が配列を返却する | E-01 (L277-299) | ○ |
| C-07 | IsNullOrEmpty()が空/null判定する | E-01 (L422-443) | ○ |
| C-08 | Concat()が2つのStringValuesを連結する | E-01 (L451-520) | ○ |
| C-09 | Equals()が等値比較を行う | E-01 (L528-730) | ○ |
| C-10 | GetHashCode()がハッシュコードを返す | E-01 (L738-758) | ○ |
| C-11 | GetEnumerator()が列挙子を返す | E-01 (L400-415) | ○ |
| C-12 | 暗黙変換演算子が正しく動作する | E-01 (L53-86) | ○ |

### StringSegment クラス（UT-PRM-034 - UT-PRM-091）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-13 | StringSegment(string?)コンストラクタが文字列を受け取る | E-02 (L28-33) | ○ |
| C-14 | StringSegment(string, int, int)がオフセットと長さを受け取る | E-02 (L49-62) | ○ |
| C-15 | 無効な引数でArgumentExceptionがスローされる | E-02 (L54-57, L676-727) | ○ |
| C-16 | Buffer, Offset, Lengthプロパティが値を返す | E-02 (L67-77) | ○ |
| C-17 | Valueプロパティが部分文字列を返す | E-02 (L82) | ○ |
| C-18 | HasValueプロパティがnullチェックを行う | E-02 (L89) | ○ |
| C-19 | インデクサが文字を返す | E-02 (L99-111) | ○ |
| C-20 | AsSpan()がReadOnlySpanを返す | E-02 (L117-159) | ○ |
| C-21 | AsMemory()がReadOnlyMemoryを返す | E-02 (L165) | ○ |
| C-22 | Compare()が比較結果を返す | E-02 (L179-190) | ○ |
| C-23 | Equals()が等値比較を行う | E-02 (L197-263) | ○ |
| C-24 | StartsWith/EndsWithが前方/後方一致を判定する | E-02 (L331-371) | ○ |
| C-25 | Substring/Subsegmentが部分文字列を返す | E-02 (L383-439) | ○ |
| C-26 | IndexOf/IndexOfAny/LastIndexOfが検索を行う | E-02 (L454-579) | ○ |
| C-27 | Trim/TrimStart/TrimEndが空白を除去する | E-02 (L585-625) | ○ |
| C-28 | Split()がStringTokenizerを返す | E-02 (L634-637) | ○ |
| C-29 | IsNullOrEmpty()が空/null判定する | E-02 (L644-654) | ○ |
| C-30 | 暗黙変換演算子が正しく動作する | E-02 (L307-319) | ○ |

### IChangeToken インターフェース（UT-PRM-092 - UT-PRM-094）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-31 | HasChangedプロパティが変更状態を返す | E-03 (L16) | ○ |
| C-32 | ActiveChangeCallbacksプロパティがコールバック有効状態を返す | E-03 (L22) | ○ |
| C-33 | RegisterChangeCallback()がコールバックを登録する | E-03 (L31) | ○ |

### CancellationChangeToken クラス（UT-PRM-095 - UT-PRM-100）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-34 | コンストラクタがCancellationTokenを受け取る | E-04 (L21-24) | ○ |
| C-35 | HasChangedがToken.IsCancellationRequestedを返す | E-04 (L30) | ○ |
| C-36 | ActiveChangeCallbacksが初期値trueを持つ | E-04 (L27) | ○ |
| C-37 | RegisterChangeCallback()がコールバックを登録する | E-04 (L35-43) | ○ |

### CompositeChangeToken クラス（UT-PRM-101 - UT-PRM-109）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-38 | コンストラクタがIReadOnlyList<IChangeToken>を受け取る | E-05 (L31-47) | ○ |
| C-39 | nullで例外がスローされる | E-05 (L33-36) | ○ |
| C-40 | ChangeTokensプロパティがトークンリストを返す | E-05 (L52) | ○ |
| C-41 | HasChangedが複合状態を返す | E-05 (L62-82) | ○ |
| C-42 | ActiveChangeCallbacksが複合状態を返す | E-05 (L39-46, L85) | ○ |
| C-43 | RegisterChangeCallback()がコールバックを登録する | E-05 (L55-59) | ○ |
| C-44 | OnChange()が子トークン変更時にコールバックを呼び出す | E-05 (L122-154) | ○ |

### ChangeToken クラス（UT-PRM-110 - UT-PRM-114）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-45 | OnChange()が変更時にアクションを呼び出す | E-06 (L20-32) | ○ |
| C-46 | nullで例外がスローされる | E-06 (L22-29, L43-50) | ○ |
| C-47 | OnChange<TState>()が状態付きでアクションを呼び出す | E-06 (L41-53) | ○ |
| C-48 | Dispose()で購読が解除される | E-06 (L143-148) | ○ |

### StringTokenizer クラス（UT-PRM-115 - UT-PRM-125）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-49 | コンストラクタが文字列と区切り文字を受け取る | E-07 (L23-37) | ○ |
| C-50 | nullで例外がスローされる | E-07 (L25-33, L46-54) | ○ |
| C-51 | コンストラクタがStringSegmentと区切り文字を受け取る | E-07 (L44-58) | ○ |
| C-52 | GetEnumerator()が列挙子を返す | E-07 (L64) | ○ |
| C-53 | Enumerator.MoveNext()が次のトークンに移動する | E-07 (L117-136) | ○ |
| C-54 | Enumerator.Current()が現在のトークンを返す | E-07 (L102) | ○ |
| C-55 | Enumerator.Reset()が列挙位置をリセットする | E-07 (L141-145) | ○ |

### StringSegmentComparer クラス（UT-PRM-126 - UT-PRM-131）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-56 | Ordinalが大文字小文字を区別する比較を提供する | E-08 (L17-18) | ○ |
| C-57 | OrdinalIgnoreCaseが大文字小文字を無視する比較を提供する | E-08 (L23-24) | ○ |
| C-58 | Compare()が比較結果を返す | E-08 (L41-44) | ○ |
| C-59 | Equals()が等値比較を行う | E-08 (L52-55) | ○ |
| C-60 | GetHashCode()がハッシュコードを返す | E-08 (L62-75) | ○ |

### InplaceStringBuilder クラス（UT-PRM-132 - UT-PRM-143）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-61 | コンストラクタが容量を受け取る | E-09 (L27-35) | ○ |
| C-62 | 負の容量で例外がスローされる | E-09 (L29-32) | ○ |
| C-63 | Capacityプロパティが容量を設定・取得する | E-09 (L40-58) | ○ |
| C-64 | 書き込み開始後の容量変更で例外がスローされる | E-09 (L51-54) | ○ |
| C-65 | Append()が文字列を追加する | E-09 (L64-108) | ○ |
| C-66 | Append(char)が文字を追加する | E-09 (L115-128) | ○ |
| C-67 | 容量超過で例外がスローされる | E-09 (L119-122) | ○ |
| C-68 | ToString()が構築された文字列を返す | E-09 (L134-142) | ○ |
| C-69 | 容量と使用量が異なる場合例外がスローされる | E-09 (L136-139) | ○ |

### Extensions クラス（UT-PRM-144 - UT-PRM-145）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-70 | Append()がStringBuilderにStringSegmentを追加する | E-10 (L19-22) | ○ |

### StringValues.Enumerator 構造体（UT-PRM-146 - UT-PRM-150）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-71 | コンストラクタがオブジェクトを受け取る | E-01 (L769-782) | ○ |
| C-72 | MoveNext()が次の要素に移動する | E-01 (L795-819) | ○ |
| C-73 | Currentが現在の要素を返す | E-01 (L824) | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし：全テストケースがソースコードに基づいて生成されています

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全テストケースがソースコードの実装に基づいており、高い信頼性があります
- InplaceStringBuilder クラスは `[Obsolete]` 属性が付与されており、非推奨です（テストケースには備考欄に「非推奨」と記載）

## 6) レビュアーチェックリスト（最小）
- [ ] StringValues の暗黙変換演算子のテストケースが網羅的か確認
- [ ] StringSegment の境界値テストケース（空文字列、最大長など）が十分か確認
- [ ] ChangeToken 系クラスのスレッドセーフティに関するテストケースの必要性を検討
- [ ] InplaceStringBuilder の非推奨クラスに対するテストの必要性を検討
- [ ] 実際のテスト実装時に、モック/スタブの必要性を検討（特にIChangeToken実装）

## 7) 解析対象ファイル一覧

| ファイル名 | 主要クラス/構造体 | テストケース数 |
|-----------|------------------|---------------|
| StringValues.cs | StringValues, StringValues.Enumerator | 38 |
| StringSegment.cs | StringSegment | 58 |
| IChangeToken.cs | IChangeToken | 3 |
| CancellationChangeToken.cs | CancellationChangeToken | 6 |
| CompositeChangeToken.cs | CompositeChangeToken | 9 |
| ChangeToken.cs | ChangeToken, ChangeTokenRegistration | 5 |
| StringTokenizer.cs | StringTokenizer, StringTokenizer.Enumerator | 11 |
| StringSegmentComparer.cs | StringSegmentComparer | 6 |
| InplaceStringBuilder.cs | InplaceStringBuilder | 12 |
| Extensions.cs | Extensions | 2 |

## 8) テスト観点の分布

| テスト観点 | 件数 | 割合 |
|-----------|------|------|
| 正常系 | 124 | 82.7% |
| 異常系 | 22 | 14.7% |
| 境界値 | 4 | 2.6% |

## 9) 優先度の分布

| 優先度 | 件数 | 割合 |
|--------|------|------|
| 高 | 85 | 56.7% |
| 中 | 53 | 35.3% |
| 低 | 12 | 8.0% |

※ 低優先度は主に非推奨のInplaceStringBuilderクラスに関連するテストケース
