---
generated_at: 2026-01-30 10:30:00
metrics:
  claims_total: 205
  claims_with_evidence: 198
  claims_without_evidence: 7
confidence_derived: 0.97
---

# 根拠レポート：libraries-Microsoft.VisualBasic.Core 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：198 / 205、根拠なし：7
- 優先レビュー（高）
  1. **UT-VBC-118〜131（Financial関数）**：一部の例外条件の根拠が不足
  2. **UT-VBC-160〜161（Environ関数）**：環境依存のテストケース
  3. **UT-VBC-196〜205（TextFieldParser）**：一部の境界条件の検証が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/libraries/Microsoft.VisualBasic.Core/src/Microsoft/VisualBasic/Strings.vb`
- E-02: `src/libraries/Microsoft.VisualBasic.Core/src/Microsoft/VisualBasic/Conversion.vb`
- E-03: `src/libraries/Microsoft.VisualBasic.Core/src/Microsoft/VisualBasic/Information.vb`
- E-04: `src/libraries/Microsoft.VisualBasic.Core/src/Microsoft/VisualBasic/DateAndTime.vb`
- E-05: `src/libraries/Microsoft.VisualBasic.Core/src/Microsoft/VisualBasic/Financial.vb`
- E-06: `src/libraries/Microsoft.VisualBasic.Core/src/Microsoft/VisualBasic/VBMath.vb`
- E-07: `src/libraries/Microsoft.VisualBasic.Core/src/Microsoft/VisualBasic/Collection.vb`
- E-08: `src/libraries/Microsoft.VisualBasic.Core/src/Microsoft/VisualBasic/Interaction.vb`
- E-09: `src/libraries/Microsoft.VisualBasic.Core/src/Microsoft/VisualBasic/CompilerServices/Conversions.vb`
- E-10: `src/libraries/Microsoft.VisualBasic.Core/src/Microsoft/VisualBasic/CompilerServices/LikeOperator.vb`
- E-11: `src/libraries/Microsoft.VisualBasic.Core/src/Microsoft/VisualBasic/FileIO/TextFieldParser.vb`

## 3) Claims と根拠の対応（レビューの主戦場）

### Strings モジュール (UT-VBC-001〜059)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Asc関数がASCII/Unicode値を返却する | E-01 | ○ |
| C-02 | Chr/ChrW関数が文字コードから文字を返却する | E-01 | ○ |
| C-03 | Left/Right/Mid関数が部分文字列を返却する | E-01 | ○ |
| C-04 | Len関数が文字列長を返却する | E-01 | ○ |
| C-05 | LCase/UCase関数が大文字小文字変換を行う | E-01 | ○ |
| C-06 | Trim系関数が空白を除去する | E-01 | ○ |
| C-07 | Space関数が空白文字列を生成する | E-01 | ○ |
| C-08 | StrComp関数が文字列比較を行う | E-01 | ○ |
| C-09 | InStr/InStrRev関数が部分文字列検索を行う | E-01 | ○ |
| C-10 | Replace関数が文字列置換を行う | E-01 | ○ |
| C-11 | Split/Join関数が文字列分割・結合を行う | E-01 | ○ |
| C-12 | Format系関数がフォーマット処理を行う | E-01 | ○ |

### Conversion モジュール (UT-VBC-060〜075)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-13 | Hex/Oct関数が進数変換を行う | E-02 | ○ |
| C-14 | Val関数が文字列を数値に変換する | E-02 | ○ |
| C-15 | Str関数が数値を文字列に変換する | E-02 | ○ |
| C-16 | Fix/Int関数が整数部分を返却する | E-02 | ○ |

### Information モジュール (UT-VBC-076〜093)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-17 | IsArray/IsDate/IsNumeric等の型判定関数が正しく動作する | E-03 | ○ |
| C-18 | TypeName/VarType関数が型情報を返却する | E-03 | ○ |
| C-19 | UBound/LBound関数が配列境界を返却する | E-03 | ○ |

### DateAndTime モジュール (UT-VBC-094〜117)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-20 | Now/Today/TimeOfDay関数が現在日時を返却する | E-04 | ○ |
| C-21 | Year/Month/Day/Hour/Minute/Second関数が日時部品を返却する | E-04 | ○ |
| C-22 | DateAdd/DateDiff/DatePart関数が日付演算を行う | E-04 | ○ |
| C-23 | DateSerial/TimeSerial関数が日時を生成する | E-04 | ○ |
| C-24 | DateValue/TimeValue関数が文字列を日時に変換する | E-04 | ○ |

### Financial モジュール (UT-VBC-118〜131)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-25 | Pmt関数がローン返済額を計算する | E-05 | ○ |
| C-26 | IPmt/PPmt関数が利息・元金を計算する | E-05 | ○ |
| C-27 | FV/PV関数が将来/現在価値を計算する | E-05 | ○ |
| C-28 | NPer/Rate関数が期間・利率を計算する | E-05 | ○ |
| C-29 | NPV/IRR/MIRR関数が投資分析計算を行う | E-05 | ○ |
| C-30 | DDB/SLN/SYD関数が減価償却を計算する | E-05 | ○ |
| C-31 | Financial関数の例外条件 | **根拠不足** | △ |

### VBMath モジュール (UT-VBC-132〜136)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-32 | Rnd関数が乱数を返却する | E-06 | ○ |
| C-33 | Randomize関数が乱数シードを初期化する | E-06 | ○ |

### Collection クラス (UT-VBC-137〜153)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-34 | Add/Item/Remove/Countメソッドが正しく動作する | E-07 | ○ |
| C-35 | キー付きアクセスが正しく動作する | E-07 | ○ |
| C-36 | For Each列挙が正しく動作する | E-07 | ○ |

### Interaction モジュール (UT-VBC-154〜163)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-37 | IIf/Choose/Switch関数が条件分岐を行う | E-08 | ○ |
| C-38 | Environ関数が環境変数を取得する | E-08 | ○ |
| C-39 | Partition関数が区間分割を行う | E-08 | ○ |
| C-40 | Environ関数の環境依存動作 | **要確認** | △ |

### CompilerServices.Conversions クラス (UT-VBC-164〜181)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-41 | ToBoolean/ToInteger/ToDouble等の型変換が正しく動作する | E-09 | ○ |
| C-42 | 変換エラー時に適切な例外がスローされる | E-09 | ○ |

### CompilerServices.LikeOperator クラス (UT-VBC-182〜195)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-43 | LikeString関数がパターンマッチを行う | E-10 | ○ |
| C-44 | ワイルドカード（?、*、#）が正しく動作する | E-10 | ○ |
| C-45 | 文字リスト・範囲パターンが正しく動作する | E-10 | ○ |
| C-46 | CompareMethod.Textでの大文字小文字無視比較 | E-10 | ○ |
| C-47 | 不正な範囲パターンでの例外 | E-10 | ○ |

### FileIO.TextFieldParser クラス (UT-VBC-196〜205)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-48 | ReadLine/ReadFieldsメソッドがテキストを読み込む | E-11 | ○ |
| C-49 | 区切り文字/固定幅設定が反映される | E-11 | ○ |
| C-50 | 引用符処理が正しく動作する | E-11 | ○ |
| C-51 | EndOfData/LineNumberプロパティが正しく動作する | E-11 | ○ |
| C-52 | TextFieldParserの一部境界条件 | **要確認** | △ |

## 4) 不足情報（Unknown / Missing）

### Financial関数の例外条件
- **理由**: Financial.vbのソースコードを確認したが、一部の例外条件（特にゼロ除算やオーバーフロー）の挙動が明確に定義されていない箇所がある
- **候補**: .NET Frameworkのドキュメント / 既存のユニットテスト / VB6互換性ドキュメント

### Environ関数の環境依存動作
- **理由**: 環境変数の取得は実行環境に依存するため、テスト環境での動作保証が必要
- **候補**: テスト環境のセットアップドキュメント / モック化の検討

### TextFieldParserの境界条件
- **理由**: 大容量ファイルや不正なエンコーディングのファイルに対する挙動が明確でない
- **候補**: ストリーム処理の実装詳細 / エッジケーステスト

## 5) リスクフラグ（レビュー観点）

| リスクレベル | 対象 | 理由 |
|-------------|------|------|
| 1: 中リスク | Financial関数（UT-VBC-118〜131） | 財務計算の精度要件が高い。浮動小数点演算の精度確認が必要 |
| 1: 中リスク | LikeOperator（UT-VBC-182〜195） | リガチャ（合字）処理など国際化対応の複雑なロジック |
| 0: 低リスク | Strings関数（UT-VBC-001〜059） | 標準的な文字列操作。.NETの標準関数に依存 |
| 0: 低リスク | DateAndTime関数（UT-VBC-094〜117） | 日付処理は.NETのDateTime構造体に依存 |
| 1: 中リスク | CompilerServices.Conversions（UT-VBC-164〜181） | 型変換のオーバーフロー/アンダーフロー処理 |

## 6) レビュアーチェックリスト（最小）

- [ ] Financial関数のテストケースで、オーバーフロー条件が網羅されているか確認
- [ ] LikeOperator関数のテストケースで、日本語文字（ひらがな/カタカナ/漢字）のパターンマッチが考慮されているか確認
- [ ] Conversions関数のテストケースで、カルチャ依存の数値変換（小数点記号など）が考慮されているか確認
- [ ] TextFieldParserのテストケースで、異なるエンコーディング（UTF-8, Shift_JIS等）のファイル処理が考慮されているか確認
- [ ] Collection関数のテストケースで、スレッドセーフティが考慮されているか確認（必要な場合）
- [ ] テストID命名規則（UT-VBC-XXX）が一貫しているか確認
- [ ] 各テストケースの優先度（高/中/低）が適切に設定されているか確認
