---
generated_at: 2026-01-30 12:30:00
metrics:
  claims_total: 35
  claims_with_evidence: 33
  claims_without_evidence: 2
confidence_derived: 0.94
---

# 根拠レポート：libraries-Microsoft.Win32.Primitives 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：33 / 35、根拠なし：2
- 優先レビュー（高）
  1. **UT-W32-030**：GetObjectDataのnullチェック動作はBaseクラス依存のため要確認
  2. **UT-W32-033**：長文エラーメッセージのテストはWindows環境かつロケール依存

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/libraries/System.Private.CoreLib/src/System/ComponentModel/Win32Exception.cs`（Win32Exception実装）
- E-02: `src/libraries/Microsoft.Win32.Primitives/ref/Microsoft.Win32.Primitives.cs`（API定義）
- E-03: `src/libraries/Microsoft.Win32.Primitives/tests/Win32ExceptionTests.cs`（既存テスト）
- E-04: `src/libraries/Microsoft.Win32.Primitives/README.md`（モジュール概要）
- E-05: `src/libraries/Microsoft.Win32.Primitives/src/Microsoft.Win32.Primitives.csproj`（プロジェクト定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | デフォルトコンストラクタがMarshal.GetLastPInvokeErrorを呼ぶ | E-01 (L26-27) | ○ |
| C-02 | HResultがE_FAIL(0x80004005)で初期化される | E-01 (L20), E-03 (L63) | ○ |
| C-03 | Win32Exception(int)がNativeErrorCodeを設定する | E-01 (L33-35), E-03 (L65-67) | ○ |
| C-04 | Win32Exception(int)がMarshal.GetPInvokeErrorMessageでメッセージ取得 | E-01 (L33) | ○ |
| C-05 | エラーコード0で正常に動作する | E-01 (L87) で0チェックあり | ○ |
| C-06 | 負のエラーコードをサポートする | E-01 (L95-97) で負数の16進変換あり | ○ |
| C-07 | Int32の境界値をサポートする | E-01 int型パラメータ | ○ |
| C-08 | Int32.MinValueをサポートする | E-01 int型パラメータ | ○ |
| C-09 | Win32Exception(int, string)がエラーコードとメッセージを設定 | E-01 (L40-43), E-03 (L74-77) | ○ |
| C-10 | messageパラメータがnull許容 | E-02 (L13) string? | ○ |
| C-11 | 空文字列メッセージをサポート | E-01 (L107) 空文字チェックあり | ○ |
| C-12 | Win32Exception(string)がLastPInvokeErrorを取得 | E-01 (L48) | ○ |
| C-13 | Win32Exception(string)のnull許容 | E-02 (L17) string? | ○ |
| C-14 | Win32Exception(string, Exception)がInnerExceptionを設定 | E-01 (L56-59), E-03 (L80-83) | ○ |
| C-15 | innerExceptionパラメータがnull許容 | E-02 (L18) Exception? | ○ |
| C-16 | Win32Exception(string, Exception)がLastPInvokeErrorを取得 | E-01 (L58) | ○ |
| C-17 | NativeErrorCodeプロパティがコンストラクタ設定値を返す | E-01 (L79), E-03 (L67) | ○ |
| C-18 | NativeErrorCodeが読み取り専用 | E-01 (L79) get only | ○ |
| C-19 | NativeErrorCode==0でbase.ToString()を返す | E-01 (L87-90) | ○ |
| C-20 | NativeErrorCode==HResultでbase.ToString()を返す | E-01 (L87-90) | ○ |
| C-21 | HResult==E_FAILでNativeErrorCodeのみ表示 | E-01 (L98-101) | ○ |
| C-22 | HResult!=E_FAILで両方表示 | E-01 (L103-105) | ○ |
| C-23 | 負のNativeErrorCodeは16進表示 | E-01 (L95-97) | ○ |
| C-24 | 正のNativeErrorCodeは10進表示 | E-01 (L95-97) | ○ |
| C-25 | 空メッセージ時にメッセージ部分を省略 | E-01 (L107-111) | ○ |
| C-26 | InnerException連鎖表示 | E-01 (L113-118) | ○ |
| C-27 | StackTrace表示 | E-01 (L120-125) | ○ |
| C-28 | GetObjectDataがNativeErrorCodeをシリアライズ | E-01 (L70-74) | ○ |
| C-29 | デシリアライズコンストラクタがNativeErrorCodeを復元 | E-01 (L63-66) | ○ |
| C-30 | GetObjectDataのnullチェック | **根拠なし** - base実装依存 | △ |
| C-31 | ExternalException継承 | E-01 (L18), E-02 (L9) | ○ |
| C-32 | Serializable属性 | E-01 (L16) | ○ |
| C-33 | 256文字超エラーメッセージ対応 | E-03 (L88-106) - Windows固有、ロケール依存 | △ |
| C-34 | 未知エラーコードでUnknown error表示 | E-03 (L104) | ○ |
| C-35 | HResultデフォルト値がE_FAIL | E-01 (L20), E-03 (L63) | ○ |

## 4) 不足情報（Unknown / Missing）
- **C-30（GetObjectDataのnullチェック）**:
  - Win32Exceptionの実装はbase.GetObjectData()を呼び出しているが、ArgumentNullExceptionをスローするかはExternalException/Exception基底クラスの実装に依存
  - 候補：System.Exception.GetObjectData / ExternalException.GetObjectData の実装確認

- **C-33（長文エラーメッセージ）**:
  - テストコード(E-03 L97)で "Localized error string for 0x268 is not guaranteed to be >256 chars" とコメントあり
  - Windows環境かつ特定ロケールでのみ検証可能
  - 候補：Windows APIドキュメント / ロケール別メッセージ長の調査

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: 大部分のテストケースはソースコードから直接導出可能
- **1（中リスク）**: シリアライズ関連テスト（Obsolete APIのため将来削除可能性）
- **1（中リスク）**: Windows固有テスト（クロスプラットフォーム環境では一部スキップが必要）

## 6) レビュアーチェックリスト（最小）
- [ ] UT-W32-030：GetObjectDataのnull引数テストがbase実装の仕様と整合しているか確認
- [ ] UT-W32-033/034：Windows環境でのみ実行されるテストとして適切にマーク（PlatformSpecific）されているか確認
- [ ] シリアライズ関連テスト（UT-W32-028/029/030）：Obsolete APIのため、テスト時に警告抑制が必要か確認
- [ ] ToString()関連テスト（UT-W32-019〜027）：CultureInfo.InvariantCultureでのフォーマット検証を含むか確認
