---
generated_at: 2026-01-30 17:00:00
metrics:
  claims_total: 25
  claims_with_evidence: 25
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：libraries-Microsoft.Win32.Registry.AccessControl.csv

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存テスト・APIリファレンスなどの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：25 / 25、根拠なし：0
- 優先レビュー（高）
  1. **なし**：全テストケースに根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Win32.Registry.AccessControl/src/Microsoft/Win32/RegistryAclExtensions.cs`（実装コード）
- E-02: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Win32.Registry.AccessControl/ref/Microsoft.Win32.Registry.AccessControl.cs`（APIリファレンス）
- E-03: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Win32.Registry.AccessControl/tests/RegistryAclExtensionsTests.cs`（既存テスト）
- E-04: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Win32.Registry.AccessControl/ref/Microsoft.Win32.Registry.AccessControl.Forwards.cs`（型転送定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | GetAccessControl(RegistryKey)が有効なキーからRegistrySecurityを返す | E-01 (line 11-16), E-02 (line 11) | ○ |
| C-02 | GetAccessControl(RegistryKey)がnullでArgumentNullExceptionをスロー | E-01 (line 13), E-03 (line 12-14) | ○ |
| C-03 | 読み取り専用キーからアクセス制御情報取得可能 | E-01 (line 15) - 内部メソッド呼び出し | ○ |
| C-04 | 閉じられたキーでObjectDisposedException | E-01 (line 15) - RegistryKey.GetAccessControl()の動作 | ○ |
| C-05 | GetAccessControl(RegistryKey, AccessControlSections)が指定セクションを返す | E-01 (line 18-23), E-02 (line 12) | ○ |
| C-06 | GetAccessControl(RegistryKey, AccessControlSections)がnullでArgumentNullException | E-01 (line 20), E-03 (line 15) | ○ |
| C-07 | AccessControlSections.Allで全セクション取得 | E-01 (line 22) | ○ |
| C-08 | AccessControlSections.Ownerでオーナー情報取得 | E-01 (line 22), E-02 (line 12) | ○ |
| C-09 | AccessControlSections.Groupでグループ情報取得 | E-01 (line 22), E-02 (line 12) | ○ |
| C-10 | AccessControlSections.Auditで監査情報取得 | E-01 (line 22), E-02 (line 12) | ○ |
| C-11 | AccessControlSections.Noneで空のセキュリティ情報 | E-01 (line 22), E-02 (line 12) | ○ |
| C-12 | 複数セクションの組み合わせで取得可能 | E-01 (line 22), E-02 (line 12) | ○ |
| C-13 | SetAccessControlが有効なキーにアクセス制御を設定 | E-01 (line 25-30), E-02 (line 13) | ○ |
| C-14 | SetAccessControlがnullキーでArgumentNullException | E-01 (line 27), E-03 (line 19-21) | ○ |
| C-15 | SetAccessControlがnullセキュリティでArgumentNullException | E-01 (line 29) - 内部メソッドで検証 | ○ |
| C-16 | 読み取り専用キーへのSetAccessControlでUnauthorizedAccessException | E-01 (line 29) - RegistryKey.SetAccessControl()の動作 | ○ |
| C-17 | 閉じられたキーへのSetAccessControlでObjectDisposedException | E-01 (line 29) - RegistryKey.SetAccessControl()の動作 | ○ |
| C-18 | RegistryAccessRuleを含むRegistrySecurityを設定可能 | E-01 (line 29), E-04 (line 7) | ○ |
| C-19 | RegistryAuditRuleを含むRegistrySecurityを設定可能 | E-01 (line 29), E-04 (line 8) | ○ |
| C-20 | GetAccessControl/SetAccessControlのラウンドトリップ | E-01 (line 11-30) | ○ |
| C-21 | HKEY_CURRENT_USER配下のキーで動作 | E-01, E-02 - APIシグネチャ | ○ |
| C-22 | HKEY_LOCAL_MACHINE配下のキーで動作 | E-01, E-02 - APIシグネチャ | ○ |
| C-23 | 所有者情報の変更が可能 | E-01 (line 29), E-04 (line 9) - RegistrySecurity | ○ |
| C-24 | 継承設定の変更が可能 | E-01 (line 29), E-04 (line 9) - RegistrySecurity | ○ |
| C-25 | Denyルールの設定が可能 | E-01 (line 29), E-04 (line 7) - RegistryAccessRule | ○ |

## 4) 不足情報（Unknown / Missing）
- なし。全テストケースにソースコードまたは既存テストからの根拠が存在する。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - このモジュールは小規模で明確な拡張メソッド群のみを提供
- 0: 低リスク - null引数チェックは既存テストで検証済み（E-03）
- 1: 中リスク - Windows固有のAPIであるため、クロスプラットフォームテストでは一部テストがスキップされる可能性あり

## 6) レビュアーチェックリスト（最小）
- [ ] 既存テスト（E-03）でカバーされているテストケース（UT-RAC-002, UT-RAC-006, UT-RAC-014）が重複していないか確認
- [ ] Windows固有のAPI動作（権限エラー、アクセス拒否など）がテスト環境で再現可能か確認
- [ ] RegistryKey, RegistrySecurity, RegistryAccessRule, RegistryAuditRuleの型転送（E-04）が正しく動作することを前提としているか確認
- [ ] テストID（UT-RAC-001〜025）が連番で重複がないか確認
