---
generated_at: 2026-01-30 12:00:00
metrics:
  claims_total: 189
  claims_with_evidence: 189
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：libraries-Microsoft.Win32.Registry 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各テストケースに対して、ソースコード上のメソッド・プロパティ・例外処理の実装が存在するか
2. **根拠との整合性**：テストケースの期待結果がソースコードの実装と矛盾していないか
3. **網羅性**：公開API、エラー処理、境界値条件を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：189 / 189、根拠なし：0
- 優先レビュー（高）
  1. なし - すべてのテストケースはソースコードに基づいて生成

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Win32.Registry/src/Microsoft/Win32/Registry.cs`
- E-02: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Win32.Registry/src/Microsoft/Win32/RegistryKey.cs`
- E-03: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Win32.Registry/src/Microsoft/Win32/RegistryHive.cs`
- E-04: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Win32.Registry/src/Microsoft/Win32/RegistryKeyPermissionCheck.cs`
- E-05: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Win32.Registry/src/Microsoft/Win32/RegistryOptions.cs`
- E-06: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Win32.Registry/src/Microsoft/Win32/RegistryValueKind.cs`
- E-07: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Win32.Registry/src/Microsoft/Win32/RegistryValueOptions.cs`
- E-08: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Win32.Registry/src/Microsoft/Win32/RegistryView.cs`
- E-09: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Win32.Registry/src/System/Security/AccessControl/RegistryRights.cs`
- E-10: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.Win32.Registry/src/System/Security/AccessControl/RegistrySecurity.cs`

## 3) Claims と根拠の対応（レビューの主戦場）

### Microsoft.Win32.Registry クラス
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | GetValue - HKEY_CURRENT_USERからの値取得 | E-01 (Line 67-75) | ○ |
| C-02 | GetValue - 値が存在しない場合のdefaultValue | E-01 (Line 73) | ○ |
| C-03 | GetValue - keyNameがnullの場合のArgumentNullException | E-01 (Line 38) | ○ |
| C-04 | GetValue - 不正なkeyNameの場合のArgumentException | E-01 (Line 64) | ○ |
| C-05 | SetValue - レジストリ値の設定 | E-01 (Line 77-91) | ○ |
| C-06 | SetValue - RegistryValueKind指定 | E-01 (Line 82-90) | ○ |
| C-07 | SetValue - keyNameがnullの場合 | E-01 (Line 84, GetBaseKeyFromKeyName) | ○ |
| C-08〜C-13 | GetBaseKeyFromKeyName - 各ルートキーの解析 | E-01 (Line 36-65) | ○ |

### Microsoft.Win32.RegistryKey クラス
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-14〜C-23 | CreateSubKey - 各種オーバーロードとバリデーション | E-02 (Line 168-269) | ○ |
| C-24〜C-28 | DeleteSubKey - 削除処理とエラーハンドリング | E-02 (Line 277-326) | ○ |
| C-29〜C-32 | DeleteSubKeyTree - 再帰的削除 | E-02 (Line 330-381) | ○ |
| C-33〜C-36 | DeleteValue - 値削除 | E-02 (Line 385-416) | ○ |
| C-37〜C-41 | OpenBaseKey - ベースキー取得 | E-02 (Line 424-443) | ○ |
| C-42〜C-44 | OpenRemoteBaseKey - リモートレジストリ | E-02 (Line 449-491) | ○ |
| C-45〜C-51 | OpenSubKey - サブキー取得 | E-02 (Line 496-596) | ○ |
| C-52〜C-63 | GetValue - 値取得（各型） | E-02 (Line 961-1205) | ○ |
| C-64〜C-76 | SetValue - 値設定（各型） | E-02 (Line 1236-1408) | ○ |
| C-77〜C-80 | GetValueKind - 値型取得 | E-02 (Line 1207-1222) | ○ |
| C-81〜C-86 | GetSubKeyNames/GetValueNames | E-02 (Line 766-952) | ○ |
| C-87〜C-92 | SubKeyCount/ValueCount | E-02 (Line 619-848) | ○ |
| C-93〜C-98 | Name/View/Handle プロパティ | E-02 (Line 648-711, 1224-1231) | ○ |
| C-99〜C-105 | Flush/Close/Dispose/ToString | E-02 (Line 115-163, 1412-1416) | ○ |
| C-106〜C-109 | FromHandle | E-02 (Line 750-762) | ○ |
| C-110〜C-115 | GetAccessControl/SetAccessControl | E-02 (Line 598-615) | ○ |
| C-116〜C-118 | FixupName | E-02 (Line 1418-1479) | ○ |

### System.Security.AccessControl.RegistryAccessRule クラス
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-119〜C-122 | コンストラクタとRegistryRightsプロパティ | E-10 (Line 11-59) | ○ |

### System.Security.AccessControl.RegistryAuditRule クラス
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-123〜C-125 | コンストラクタとRegistryRightsプロパティ | E-10 (Line 62-83) | ○ |

### System.Security.AccessControl.RegistrySecurity クラス
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-126 | デフォルトコンストラクタ | E-10 (Line 88-91) | ○ |
| C-127〜C-133 | AddAccessRule/SetAccessRule/ResetAccessRule/RemoveAccessRule系 | E-10 (Line 180-208) | ○ |
| C-134〜C-138 | AddAuditRule/SetAuditRule/RemoveAuditRule系 | E-10 (Line 210-233) | ○ |
| C-139〜C-143 | ファクトリメソッドと型プロパティ | E-10 (Line 123-248) | ○ |
| C-144〜C-148 | GetAccessControlSectionsFromChanges/Persist | E-10 (Line 133-178) | ○ |
| C-149〜C-152 | _HandleErrorCode | E-10 (Line 98-121) | ○ |

### Enum 値検証
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-153〜C-158 | RegistryHive | E-03 | ○ |
| C-159〜C-161 | RegistryKeyPermissionCheck | E-04 | ○ |
| C-162〜C-163 | RegistryOptions | E-05 | ○ |
| C-164〜C-171 | RegistryValueKind | E-06 | ○ |
| C-172〜C-173 | RegistryValueOptions | E-07 | ○ |
| C-174〜C-176 | RegistryView | E-08 | ○ |
| C-177〜C-189 | RegistryRights | E-09 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし - すべてのテストケースは実在するソースコードに基づいて生成されました

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべてのテストケースがソースコードに基づいている

**注意点**:
- Windows固有のAPIであるため、非Windowsプラットフォームでの実行は制限される
- HKEY_PERFORMANCE_DATAへのアクセスは特殊な挙動（エラー時の例外スローなど）がある
- リモートレジストリアクセス（OpenRemoteBaseKey）は適切な権限が必要

## 6) レビュアーチェックリスト（最小）
- [ ] 高優先度テストケース（No.1-7, 14-28, 33-36, 45-51, 52-76）が業務要件を満たしているか
- [ ] 例外処理テストケースが適切なException型を期待しているか
- [ ] 境界値テストケース（キー名長255文字、値名長16383文字）が正確か
- [ ] RegistrySecurityに関するテストケースがセキュリティ要件を満たしているか
- [ ] Windows固有の動作（レジストリビュー、リモートアクセス）が正しく考慮されているか
