---
generated_at: 2026-01-30 17:15:00
metrics:
  claims_total: 95
  claims_with_evidence: 95
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：libraries-Microsoft.Win32.SystemEvents 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：95 / 95、根拠なし：0
- 優先レビュー（高）
  1. **該当なし**：全てのテストケースにソースコード根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/libraries/Microsoft.Win32.SystemEvents/src/Microsoft/Win32/SystemEvents.cs`
- E-02: `src/libraries/Microsoft.Win32.SystemEvents/src/Microsoft/Win32/PowerModeChangedEventArgs.cs`
- E-03: `src/libraries/Microsoft.Win32.SystemEvents/src/Microsoft/Win32/PowerModes.cs`
- E-04: `src/libraries/Microsoft.Win32.SystemEvents/src/Microsoft/Win32/SessionEndedEventArgs.cs`
- E-05: `src/libraries/Microsoft.Win32.SystemEvents/src/Microsoft/Win32/SessionEndReasons.cs`
- E-06: `src/libraries/Microsoft.Win32.SystemEvents/src/Microsoft/Win32/SessionEndingEventArgs.cs`
- E-07: `src/libraries/Microsoft.Win32.SystemEvents/src/Microsoft/Win32/SessionSwitchEventArgs.cs`
- E-08: `src/libraries/Microsoft.Win32.SystemEvents/src/Microsoft/Win32/SessionSwitchReason.cs`
- E-09: `src/libraries/Microsoft.Win32.SystemEvents/src/Microsoft/Win32/TimerElapsedEventArgs.cs`
- E-10: `src/libraries/Microsoft.Win32.SystemEvents/src/Microsoft/Win32/UserPreferenceChangedEventArgs.cs`
- E-11: `src/libraries/Microsoft.Win32.SystemEvents/src/Microsoft/Win32/UserPreferenceChangingEventArgs.cs`
- E-12: `src/libraries/Microsoft.Win32.SystemEvents/src/Microsoft/Win32/UserPreferenceCategories.cs`
- E-13: `src/libraries/Microsoft.Win32.SystemEvents/src/Microsoft/Win32/PowerModeChangedEventHandler.cs`
- E-14: `src/libraries/Microsoft.Win32.SystemEvents/src/Microsoft/Win32/SessionEndedEventHandler.cs`
- E-15: `src/libraries/Microsoft.Win32.SystemEvents/src/Microsoft/Win32/SessionEndingEventHandler.cs`
- E-16: `src/libraries/Microsoft.Win32.SystemEvents/src/Microsoft/Win32/SessionSwitchEventHandler.cs`
- E-17: `src/libraries/Microsoft.Win32.SystemEvents/src/Microsoft/Win32/TimerElapsedEventHandler.cs`
- E-18: `src/libraries/Microsoft.Win32.SystemEvents/src/Microsoft/Win32/UserPreferenceChangedEventHandler.cs`
- E-19: `src/libraries/Microsoft.Win32.SystemEvents/src/Microsoft/Win32/UserPreferenceChangingEventHandler.cs`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | CreateTimer: interval>0でタイマー作成 | E-01 (行383-400) | ○ |
| C-02 | CreateTimer: interval<=0でArgumentException | E-01 (行385-388) | ○ |
| C-03 | CreateTimer: 負のintervalでArgumentException | E-01 (行385-388) | ○ |
| C-04 | KillTimer: 有効なIDでタイマー停止 | E-01 (行788-800) | ○ |
| C-05 | KillTimer: 無効なIDでExternalException | E-01 (行797-798) | ○ |
| C-06 | InvokeOnEventsThread: デリゲート実行 | E-01 (行749-783) | ○ |
| C-07 | DisplaySettingsChangingイベント登録・解除 | E-01 (行102-112) | ○ |
| C-08 | DisplaySettingsChangedイベント登録・解除 | E-01 (行117-127) | ○ |
| C-09 | nullハンドラが無視される | E-01 (行321-324) | ○ |
| C-10 | InstalledFontsChangedイベント登録・解除 | E-01 (行144-154) | ○ |
| C-11 | PaletteChangedイベント登録・解除 | E-01 (行178-188) | ○ |
| C-12 | PowerModeChangedイベント登録・解除 | E-01 (行194-205) | ○ |
| C-13 | SessionEndedイベント登録・解除 | E-01 (行210-221) | ○ |
| C-14 | SessionEndingイベント登録・解除 | E-01 (行226-237) | ○ |
| C-15 | SessionSwitchイベント登録・解除 | E-01 (行242-254) | ○ |
| C-16 | TimeChangedイベント登録・解除 | E-01 (行259-270) | ○ |
| C-17 | TimerElapsedイベント登録・解除 | E-01 (行275-286) | ○ |
| C-18 | UserPreferenceChangedイベント登録・解除 | E-01 (行292-302) | ○ |
| C-19 | UserPreferenceChangingイベント登録・解除 | E-01 (行307-317) | ○ |
| C-20 | PowerModeChangedEventArgsコンストラクタ | E-02 (行18-21) | ○ |
| C-21 | PowerModeChangedEventArgs.Modeプロパティ | E-02 (行26-32) | ○ |
| C-22 | SessionEndedEventArgsコンストラクタ | E-04 (行18-21) | ○ |
| C-23 | SessionEndedEventArgs.Reasonプロパティ | E-04 (行26-32) | ○ |
| C-24 | SessionEndingEventArgsコンストラクタ | E-06 (行19-22) | ○ |
| C-25 | SessionEndingEventArgs.Reasonプロパティ | E-06 (行42-48) | ○ |
| C-26 | SessionEndingEventArgs.Cancelプロパティ | E-06 (行27-37) | ○ |
| C-27 | SessionSwitchEventArgsコンストラクタ | E-07 (行18-21) | ○ |
| C-28 | SessionSwitchEventArgs.Reasonプロパティ | E-07 (行26-32) | ○ |
| C-29 | TimerElapsedEventArgsコンストラクタ | E-09 (行18-21) | ○ |
| C-30 | TimerElapsedEventArgs.TimerIdプロパティ | E-09 (行26-32) | ○ |
| C-31 | UserPreferenceChangedEventArgsコンストラクタ | E-10 (行18-21) | ○ |
| C-32 | UserPreferenceChangedEventArgs.Categoryプロパティ | E-10 (行26-32) | ○ |
| C-33 | UserPreferenceChangingEventArgsコンストラクタ | E-11 (行18-21) | ○ |
| C-34 | UserPreferenceChangingEventArgs.Categoryプロパティ | E-11 (行26-32) | ○ |
| C-35 | PowerModes enum値 (Resume=1, StatusChange=2, Suspend=3) | E-03 (行15-28) | ○ |
| C-36 | SessionEndReasons enum値 (Logoff=1, SystemShutdown=2) | E-05 (行17-22) | ○ |
| C-37 | SessionSwitchReason enum値 | E-08 (行17-58) | ○ |
| C-38 | UserPreferenceCategory enum値 (全14カテゴリ) | E-12 (行17-107) | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし
  - 全てのテストケースはソースコードから直接導出されている

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全てのテストケースがソースコードに基づいている
- 注意点：
  - Windows固有のAPIに依存するため、非Windows環境では一部テストが実行不可能
  - SystemEventsクラスは静的クラスであり、テスト間の状態分離に注意が必要
  - タイマー関連テストは実際のWin32 API呼び出しが必要なため、モック化が困難

## 6) レビュアーチェックリスト（最小）
- [ ] CreateTimer/KillTimerの境界値テストが適切か確認
- [ ] 各イベントの登録・解除テストが対称的に定義されているか確認
- [ ] EventArgsクラスの各プロパティに対するテストが網羅的か確認
- [ ] enum値のテストが全ての定義値をカバーしているか確認
- [ ] Windows固有のテストとプラットフォーム非依存のテストが明確に区別されているか確認

## 7) 解析対象ファイル一覧

### 主要クラス
| ファイル | クラス | テストケース数 |
|---------|--------|--------------|
| SystemEvents.cs | SystemEvents | 31 |
| PowerModeChangedEventArgs.cs | PowerModeChangedEventArgs | 4 |
| SessionEndedEventArgs.cs | SessionEndedEventArgs | 3 |
| SessionEndingEventArgs.cs | SessionEndingEventArgs | 6 |
| SessionSwitchEventArgs.cs | SessionSwitchEventArgs | 10 |
| TimerElapsedEventArgs.cs | TimerElapsedEventArgs | 3 |
| UserPreferenceChangedEventArgs.cs | UserPreferenceChangedEventArgs | 15 |
| UserPreferenceChangingEventArgs.cs | UserPreferenceChangingEventArgs | 3 |

### 列挙型
| ファイル | 列挙型 | テストケース数 |
|---------|--------|--------------|
| PowerModes.cs | PowerModes | 3 |
| SessionEndReasons.cs | SessionEndReasons | 2 |
| SessionSwitchReason.cs | SessionSwitchReason | 1 |
| UserPreferenceCategories.cs | UserPreferenceCategory | 14 |

### デリゲート型（テスト対象外）
| ファイル | デリゲート |
|---------|----------|
| PowerModeChangedEventHandler.cs | PowerModeChangedEventHandler |
| SessionEndedEventHandler.cs | SessionEndedEventHandler |
| SessionEndingEventHandler.cs | SessionEndingEventHandler |
| SessionSwitchEventHandler.cs | SessionSwitchEventHandler |
| TimerElapsedEventHandler.cs | TimerElapsedEventHandler |
| UserPreferenceChangedEventHandler.cs | UserPreferenceChangedEventHandler |
| UserPreferenceChangingEventHandler.cs | UserPreferenceChangingEventHandler |

## 8) テスト観点カバレッジ

### 正常系
- イベントハンドラの登録・解除
- EventArgsのコンストラクタとプロパティアクセス
- タイマーの作成・停止
- enum値の確認

### 異常系
- 不正な引数（interval <= 0）
- 無効なタイマーID

### 境界値
- nullハンドラの処理
- IntPtr.Zeroの処理

### 備考
- Windows固有のInterop処理（WndProc、メッセージループ等）はモック化が困難なため、統合テストレベルで検証が必要
- スレッド間マーシャリング（InvokeOnEventsThread）は実環境での動作確認が推奨される
