---
generated_at: 2026-01-30 12:00:00
metrics:
  claims_total: 94
  claims_with_evidence: 94
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：libraries-Microsoft.XmlSerializer.Generator 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各テストケースに対して、ソースコードの該当メソッド・ロジックが存在するか
2. **根拠との整合性**：テストケースの内容がソースコードの実装と矛盾していないか
3. **網羅性**：全てのpublicメソッドと主要な内部ロジックがカバーされているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：94 / 94、根拠なし：0
- 優先レビュー（高）
  1. **UT-XSG-073～085（GenerateFile関連）**：実際のファイル生成・リフレクションを伴うため統合テストに近い
  2. **UT-XSG-038～040（LoadAssembly関連）**：実際のアセンブリロードを伴うためモック化が必要
  3. **UT-XSG-058～063（SgenAssemblyResolver関連）**：イベントハンドラのため単体テストが困難

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.XmlSerializer.Generator/src/Sgen.cs`（メインソースファイル、701行）
- E-02: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.XmlSerializer.Generator/tests/SGenTests.cs`（既存テスト、47行）
- E-03: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.XmlSerializer.Generator/tests/AlwaysPassTest.cs`（ダミーテスト、15行）
- E-04: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.XmlSerializer.Generator/src/Microsoft.XmlSerializer.Generator.csproj`（プロジェクトファイル）
- E-05: `/Users/tomoka.baba/Work/runtime-main/src/libraries/Microsoft.XmlSerializer.Generator/src/build/Microsoft.XmlSerializer.Generator.targets`（MSBuildターゲット）

## 3) Claims と根拠の対応（レビューの主戦場）

### Mainメソッド（UT-XSG-001～003）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | UT-XSG-001: --helpオプションで0を返す | E-01: 54-59行目 `ArgumentMatch(arg, "help")` で WriteHelp() 後に return 0 | ○ |
| C-02 | UT-XSG-002: -hオプションで0を返す | E-01: 54行目 `ShortNameArgumentMatch(arg, "h")` | ○ |
| C-03 | UT-XSG-003: 引数なしで0を返す | E-01: 184-193行目 assembly==null で WriteHelp() 後に return 0 | ○ |

### Runメソッド - オプション解析（UT-XSG-004～019）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-04 | UT-XSG-004: --forceオプション | E-01: 60-62行目 `ArgumentMatch(arg, "force")` で force = true | ○ |
| C-05 | UT-XSG-005: --proxytypesオプション | E-01: 64-66行目 `ArgumentMatch(arg, "proxytypes")` で proxyOnly = true | ○ |
| C-06 | UT-XSG-006: --outオプション | E-01: 68-78行目 `ArgumentMatch(arg, "out")` で codePath 設定 | ○ |
| C-07 | UT-XSG-007: -oオプション | E-01: 68行目 `ShortNameArgumentMatch(arg, "o")` | ○ |
| C-08 | UT-XSG-008: --typeオプション | E-01: 80-94行目 `ArgumentMatch(arg, "type")` で types.Add() | ○ |
| C-09 | UT-XSG-009: --assemblyオプション | E-01: 96-106行目 `ArgumentMatch(arg, "assembly")` で assembly 設定 | ○ |
| C-10 | UT-XSG-010: -aオプション | E-01: 96行目 `ShortNameArgumentMatch(arg, "a")` | ○ |
| C-11 | UT-XSG-011: --default-namespaceオプション | E-01: 108-118行目 `ArgumentMatch(arg, "default-namespace")` | ○ |
| C-12 | UT-XSG-012: --quietオプション | E-01: 120-122行目 `ArgumentMatch(arg, "quiet")` で disableRun = false | ○ |
| C-13 | UT-XSG-013: --nologoオプション | E-01: 124-126行目 `ArgumentMatch(arg, "nologo")` で noLogo = true | ○ |
| C-14 | UT-XSG-014: --silentオプション | E-01: 128-130行目 `ArgumentMatch(arg, "silent")` で silent = true | ○ |
| C-15 | UT-XSG-015: --parsableerrorsオプション | E-01: 132-134行目 `ArgumentMatch(arg, "parsableerrors")` | ○ |
| C-16 | UT-XSG-016: --verboseオプション | E-01: 136-138行目 `ArgumentMatch(arg, "verbose")` で verbose = true | ○ |
| C-17 | UT-XSG-017: --referenceオプション | E-01: 140-151行目 `ArgumentMatch(arg, "reference")` で s_references 設定 | ○ |
| C-18 | UT-XSG-018: .dllファイル直接指定 | E-01: 155-162行目 `.EndsWith(".dll")` でアセンブリとして認識 | ○ |
| C-19 | UT-XSG-019: .exeファイル直接指定 | E-01: 155行目 `.EndsWith(".exe")` でアセンブリとして認識 | ○ |

### Runメソッド - 異常系（UT-XSG-020～028）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-20 | UT-XSG-020: 不正な引数でエラー | E-01: 166行目 `errs.Add(SR.Format(SR.ErrInvalidArgument, arg))` | ○ |
| C-21 | UT-XSG-021: --out引数不足 | E-01: 71-73行目 `i >= args.Length` でエラー追加 | ○ |
| C-22 | UT-XSG-022: --type引数不足 | E-01: 83-85行目 `i >= args.Length` でエラー追加 | ○ |
| C-23 | UT-XSG-023: --assembly引数不足 | E-01: 99-101行目 `i >= args.Length` でエラー追加 | ○ |
| C-24 | UT-XSG-024: --default-namespace引数不足 | E-01: 111-113行目 `i >= args.Length` でエラー追加 | ○ |
| C-25 | UT-XSG-025: --reference引数不足 | E-01: 143-145行目 `i >= args.Length` でエラー追加 | ○ |
| C-26 | UT-XSG-026: アセンブリ重複指定 | E-01: 157-159行目 `assembly != null` でエラー追加 | ○ |
| C-27 | UT-XSG-027: --out重複指定 | E-01: 71行目 `codePath != null` でエラー追加 | ○ |
| C-28 | UT-XSG-028: 例外時に1を返す | E-01: 209-217行目 catch ブロックで return 1 | ○ |

### ArgumentMatch / ShortNameArgumentMatch（UT-XSG-029～037）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-29 | UT-XSG-029: 完全一致 | E-01: 423-432行目 `arg.Equals(formal, StringComparison.InvariantCultureIgnoreCase)` | ○ |
| C-30 | UT-XSG-030: 大文字小文字無視 | E-01: 431行目 `StringComparison.InvariantCultureIgnoreCase` | ○ |
| C-31 | UT-XSG-031: ダッシュ1つでマッチしない | E-01: 426-428行目 `arg[1] != '-'` で false | ○ |
| C-32 | UT-XSG-032: ダッシュなしでマッチしない | E-01: 426行目 `arg[0] != '-'` で false | ○ |
| C-33 | UT-XSG-033: 2文字以下はマッチしない | E-01: 426行目 `arg.Length < 3` で false | ○ |
| C-34 | UT-XSG-034: 短縮名マッチ | E-01: 434-443行目 ShortNameArgumentMatch 実装 | ○ |
| C-35 | UT-XSG-035: 短縮名大文字小文字無視 | E-01: 442行目 `StringComparison.InvariantCultureIgnoreCase` | ○ |
| C-36 | UT-XSG-036: 短縮名ダッシュなし | E-01: 438行目 `arg[0] != '-'` で false | ○ |
| C-37 | UT-XSG-037: 短縮名1文字以下 | E-01: 437行目 `arg.Length < 2` で false | ○ |

### LoadAssembly（UT-XSG-038～040）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-38 | UT-XSG-038: 絶対パスロード | E-01: 476-487行目 `Assembly.LoadFile(path)` | ○ |
| C-39 | UT-XSG-039: 相対パス変換 | E-01: 479行目 `Path.GetFullPath(assemblyName)` | ○ |
| C-40 | UT-XSG-040: 存在しないアセンブリ | E-01: 480-483行目 assembly==null で InvalidOperationException | ○ |

### GetXmlSerializerAssemblyName / GetTempAssemblyName（UT-XSG-041～046）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-41 | UT-XSG-041: 型からアセンブリ名取得 | E-01: 543-552行目 GetXmlSerializerAssemblyName 実装 | ○ |
| C-42 | UT-XSG-042: 名前空間付きアセンブリ名 | E-01: 548-552行目 defaultNamespace 渡し | ○ |
| C-43 | UT-XSG-043: null型で例外 | E-01: 550行目 `ArgumentNullException.ThrowIfNull(type)` | ○ |
| C-44 | UT-XSG-044: 名前空間なしの名前 | E-01: 555-558行目 `.XmlSerializers` のみ | ○ |
| C-45 | UT-XSG-045: 名前空間ありの名前 | E-01: 557行目 `$".{GetPersistentHashCode(ns)}"` | ○ |
| C-46 | UT-XSG-046: 空文字名前空間 | E-01: 557行目 `string.IsNullOrEmpty(ns)` で判定 | ○ |

### GetPersistentHashCode / ReadUInt32BigEndian（UT-XSG-047～052）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-47 | UT-XSG-047: 同じ文字列で同じハッシュ | E-01: 560-565行目 SHA512ベースの決定論的ハッシュ | ○ |
| C-48 | UT-XSG-048: 異なる文字列で異なるハッシュ | E-01: 560-565行目 SHA512の特性による | ○ |
| C-49 | UT-XSG-049: 空文字ハッシュ | E-01: 562行目 空文字もUTF8エンコード可能 | ○ |
| C-50 | UT-XSG-050: ビッグエンディアン読み取り | E-01: 567-570行目 `value[0] << 24 | value[1] << 16 | value[2] << 8 | value[3]` | ○ |
| C-51 | UT-XSG-051: 全て0で0 | E-01: 569行目 計算式から明らか | ○ |
| C-52 | UT-XSG-052: 全て0xFFで最大値 | E-01: 569行目 計算式から明らか | ○ |

### ParseReferences（UT-XSG-053～057）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-53 | UT-XSG-053: セミコロン区切り解析 | E-01: 572-584行目 `s_references.Split(';')` | ○ |
| C-54 | UT-XSG-054: 存在ファイルのみ追加 | E-01: 590行目 `File.Exists(reference)` | ○ |
| C-55 | UT-XSG-055: 空参照文字列 | E-01: 575行目 `s_references.Length > 0` 判定 | ○ |
| C-56 | UT-XSG-056: 空白エントリ無視 | E-01: 579-581行目 `trimentry`, `string.IsNullOrEmpty` | ○ |
| C-57 | UT-XSG-057: 拡張子フィルタ | E-01: 588行目 `.EndsWith(".dll") || .EndsWith(".exe")` | ○ |

### SgenAssemblyResolver（UT-XSG-058～063）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-58 | UT-XSG-058: 登録済みアセンブリ解決 | E-01: 618行目 `s_referencedic.TryGetValue(assemblyname, out string reference)` | ○ |
| C-59 | UT-XSG-059: ServiceModel.Primitives特殊処理 | E-01: 621-640行目 ref→lib 置換ロジック | ○ |
| C-60 | UT-XSG-060: 空アセンブリ名でnull | E-01: 607-609行目 `string.IsNullOrEmpty(e.Name)` | ○ |
| C-61 | UT-XSG-061: nullアセンブリ名でnull | E-01: 607行目 `string.IsNullOrEmpty(e.Name)` | ○ |
| C-62 | UT-XSG-062: 未登録でnull | E-01: 618行目 TryGetValue 失敗時はスキップ | ○ |
| C-63 | UT-XSG-063: ファイルなしでnull | E-01: 645行目 `File.Exists(reference)` | ○ |

### ParseResponseFile（UT-XSG-064～068）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-64 | UT-XSG-064: 通常引数はそのまま | E-01: 670-671行目 `.EndsWith(".rsp")` でなければ Add | ○ |
| C-65 | UT-XSG-065: rspファイル展開 | E-01: 678行目 `File.ReadAllLines(arg)` | ○ |
| C-66 | UT-XSG-066: スペース区切り分割 | E-01: 680-686行目 `line.Trim().IndexOf(' ')` で分割 | ○ |
| C-67 | UT-XSG-067: 存在しないrsp無視 | E-01: 693行目 `catch (FileNotFoundException)` で無視 | ○ |
| C-68 | UT-XSG-068: 空配列で空配列 | E-01: 667-698行目 foreach ループで処理なし | ○ |

### FormatMessage（UT-XSG-069～072）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-69 | UT-XSG-069: parsablefalseでメッセージのみ | E-01: 517-519行目 `if (!parsableerrors) return message;` | ○ |
| C-70 | UT-XSG-070: 警告形式 | E-01: 522行目 `"warning "` | ○ |
| C-71 | UT-XSG-071: エラー形式 | E-01: 522行目 `"error "` | ○ |
| C-72 | UT-XSG-072: カスタムコード | E-01: 515-522行目 code パラメータ使用 | ○ |

### GenerateFile（UT-XSG-073～085）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-73 | UT-XSG-073: コード生成 | E-01: 223-420行目 GenerateFile メソッド全体 | ○ |
| C-74 | UT-XSG-074: 指定型のみインポート | E-01: 249-261行目 typeNames ループ | ○ |
| C-75 | UT-XSG-075: verbose進捗出力 | E-01: 276-278行目 `if (verbose)` | ○ |
| C-76 | UT-XSG-076: silentで成功メッセージなし | E-01: 403-409行目 `if (!silent)` | ○ |
| C-77 | UT-XSG-077: force上書き | E-01: 339-342行目 `if (!force)` 分岐 | ○ |
| C-78 | UT-XSG-078: force無しで例外 | E-01: 342行目 `throw new InvalidOperationException` | ○ |
| C-79 | UT-XSG-079: ディレクトリ不存在で例外 | E-01: 324-333行目 `Directory.Exists` チェック | ○ |
| C-80 | UT-XSG-080: パスがディレクトリで例外 | E-01: 345-348行目 `Directory.Exists(codePath)` | ○ |
| C-81 | UT-XSG-081: 権限なしで例外 | E-01: 390-393行目 `catch (UnauthorizedAccessException)` | ○ |
| C-82 | UT-XSG-082: 型不存在でエラー | E-01: 255-258行目 `type == null` でエラー出力 | ○ |
| C-83 | UT-XSG-083: Obsoleteスキップ | E-01: 281-295行目 `ObsoleteAttribute` チェック | ○ |
| C-84 | UT-XSG-084: 部分ロード対応 | E-01: 234-246行目 `ReflectionTypeLoadException` catch | ○ |
| C-85 | UT-XSG-085: 型なし警告 | E-01: 416-419行目 `importedTypes.Count > 0` else | ○ |

### ImportType（UT-XSG-086～088）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-86 | UT-XSG-086: 有効な型インポート | E-01: 445-474行目 ImportType 実装 | ○ |
| C-87 | UT-XSG-087: インポート失敗時警告 | E-01: 453-466行目 catch ブロックで警告 | ○ |
| C-88 | UT-XSG-088: null型スキップ | E-01: 274行目 `if (type != null)` | ○ |

### WriteHeader / WriteHelp / WriteError / WriteWarning（UT-XSG-089～094）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-89 | UT-XSG-089: ヘッダー出力 | E-01: 489-493行目 WriteHeader 実装 | ○ |
| C-90 | UT-XSG-090: ヘルプ出力 | E-01: 495-508行目 WriteHelp 実装 | ○ |
| C-91 | UT-XSG-091: エラー出力 | E-01: 525-532行目 WriteError 実装 | ○ |
| C-92 | UT-XSG-092: エラー内部例外 | E-01: 528-531行目 `InnerException` 再帰 | ○ |
| C-93 | UT-XSG-093: 警告出力 | E-01: 534-541行目 WriteWarning 実装 | ○ |
| C-94 | UT-XSG-094: 警告内部例外 | E-01: 537-540行目 `InnerException` 再帰 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（全94件のテストケースについてソースコード上の根拠を確認済み）

## 5) リスクフラグ（レビュー観点）
- **リスクレベル: 1（中リスク）**
  - GenerateFile関連のテスト（UT-XSG-073～085）は実際のファイルI/OとリフレクションAPIを使用するため、統合テスト的な性質を持つ
  - LoadAssembly関連のテスト（UT-XSG-038～040）は実際のアセンブリロードを伴うため、テスト環境の準備が必要
  - SgenAssemblyResolver（UT-XSG-058～063）はAppDomain.AssemblyResolveイベントハンドラであり、単体テストが困難な場合がある

## 6) レビュアーチェックリスト（最小）
- [ ] CSVファイルがBOM付きUTF-8で出力されているか確認
- [ ] テストIDの命名規則（UT-XSG-XXX）が一貫しているか確認
- [ ] 正常系・異常系・境界値の観点が適切に分類されているか確認
- [ ] 優先度（高/中/低）の設定が妥当か確認
- [ ] GenerateFile関連テストについて、モック化の必要性を検討
- [ ] LoadAssembly関連テストについて、テスト用アセンブリの準備方法を検討
- [ ] 既存テスト（E-02: SGenTests.cs）との整合性を確認
