---
generated_at: 2026-01-30 12:00:00
metrics:
  claims_total: 169
  claims_with_evidence: 169
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：libraries-System.CodeDom 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：169 / 169、根拠なし：0
- 優先レビュー（高）
  1. **CodeDomProvider.CreateProvider関連テスト（UT-CDM-001〜004）**：ファクトリメソッドの正常系・異常系
  2. **CompilerErrorCollection.HasErrors/HasWarnings（UT-CDM-063〜065）**：エラー判定ロジック
  3. **CodeTypeDeclaration.IsClass/IsStruct/IsEnum排他制御（UT-CDM-095〜101）**：型フラグの相互作用

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/libraries/System.CodeDom/src/System/CodeDom/Compiler/CodeDomProvider.cs`
- E-02: `src/libraries/System.CodeDom/src/System/CodeDom/Compiler/CompilerInfo.cs`
- E-03: `src/libraries/System.CodeDom/src/System/CodeDom/Compiler/CompilerParameters.cs`
- E-04: `src/libraries/System.CodeDom/src/System/CodeDom/Compiler/CompilerResults.cs`
- E-05: `src/libraries/System.CodeDom/src/System/CodeDom/Compiler/CompilerError.cs`
- E-06: `src/libraries/System.CodeDom/src/System/CodeDom/Compiler/CompilerErrorCollection.cs`
- E-07: `src/libraries/System.CodeDom/src/System/CodeDom/Compiler/CodeGeneratorOptions.cs`
- E-08: `src/libraries/System.CodeDom/src/System/CodeDom/Compiler/CodeGenerator.cs`
- E-09: `src/libraries/System.CodeDom/src/Microsoft/CSharp/CSharpCodeProvider.cs`
- E-10: `src/libraries/System.CodeDom/src/Microsoft/CSharp/CSharpCodeGenerator.cs`
- E-11: `src/libraries/System.CodeDom/src/Microsoft/VisualBasic/VBCodeProvider.cs`
- E-12: `src/libraries/System.CodeDom/src/System/CodeDom/CodeCompileUnit.cs`
- E-13: `src/libraries/System.CodeDom/src/System/CodeDom/CodeNamespace.cs`
- E-14: `src/libraries/System.CodeDom/src/System/CodeDom/CodeTypeDeclaration.cs`
- E-15: `src/libraries/System.CodeDom/src/System/CodeDom/CodeTypeMember.cs`
- E-16: `src/libraries/System.CodeDom/src/System/CodeDom/CodeMemberMethod.cs`
- E-17: `src/libraries/System.CodeDom/src/System/CodeDom/CodeMemberProperty.cs`
- E-18: `src/libraries/System.CodeDom/src/System/CodeDom/CodeStatement.cs`
- E-19: `src/libraries/System.CodeDom/src/System/CodeDom/CodeStatementCollection.cs`
- E-20: `src/libraries/System.CodeDom/src/System/CodeDom/CodeConditionStatement.cs`
- E-21: `src/libraries/System.CodeDom/src/System/CodeDom/CodeAssignStatement.cs`
- E-22: `src/libraries/System.CodeDom/src/System/CodeDom/CodeBinaryOperatorExpression.cs`
- E-23: `src/libraries/System.CodeDom/src/System/CodeDom/CodeArrayCreateExpression.cs`

## 3) Claims と根拠の対応（レビューの主戦場）

### CodeDomProvider関連（UT-CDM-001〜015）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | CreateProvider(string)でC#プロバイダーが生成される | E-01 (L59-63, 静的コンストラクタでC#登録) | ○ |
| C-02 | CreateProvider(string)でVBプロバイダーが生成される | E-01 (L29-34, 静的コンストラクタでVB登録) | ○ |
| C-03 | 未登録言語でConfigurationErrorsExceptionがスローされる | E-01 (L79-86, GetCompilerInfo) | ○ |
| C-04 | CreateProvider(string, IDictionary)でオプション付き生成ができる | E-01 (L53-57) | ○ |
| C-05 | GetLanguageFromExtensionで拡張子から言語名取得 | E-01 (L65-73) | ○ |
| C-06 | IsDefinedLanguageで言語登録確認ができる | E-01 (L75) | ○ |
| C-07 | IsDefinedExtensionで拡張子登録確認ができる | E-01 (L77) | ○ |
| C-08 | GetCompilerInfoでnullチェックが行われる | E-01 (L89-96, ArgumentNullException.ThrowIfNull) | ○ |
| C-09 | GetAllCompilerInfoで全コンパイラ情報が取得できる | E-01 (L107) | ○ |
| C-10 | IsValidIdentifierで識別子検証ができる | E-01 (L139-140) | ○ |

### CSharpCodeProvider関連（UT-CDM-016〜021）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-11 | デフォルトコンストラクタで生成できる | E-09 (L18-21) | ○ |
| C-12 | オプション付きコンストラクタで生成できる | E-09 (L23-28) | ○ |
| C-13 | nullオプションでArgumentNullExceptionがスローされる | E-09 (L25, ArgumentNullException.ThrowIfNull) | ○ |
| C-14 | FileExtensionが"cs"である | E-09 (L30) | ○ |
| C-15 | GetConverterでMemberAttributesに対応したコンバーターが返る | E-09 (L38-41) | ○ |

### VBCodeProvider関連（UT-CDM-022〜025）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-16 | デフォルトコンストラクタで生成できる | E-11 (L16-19) | ○ |
| C-17 | オプション付きコンストラクタで生成できる | E-11 (L21-28) | ○ |
| C-18 | FileExtensionが"vb"である | E-11 (L30) | ○ |
| C-19 | LanguageOptionsがCaseInsensitiveである | E-11 (L32) | ○ |

### CompilerInfo関連（UT-CDM-026〜035）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-20 | GetLanguages()で言語一覧が取得できる | E-02 (L21) | ○ |
| C-21 | GetExtensions()で拡張子一覧が取得できる | E-02 (L23) | ○ |
| C-22 | CodeDomProviderTypeで型が取得できる | E-02 (L25-38) | ○ |
| C-23 | CreateProvider()でプロバイダーが生成できる | E-02 (L43-60) | ○ |
| C-24 | CreateProvider(IDictionary)でnullチェックが行われる | E-02 (L65, ArgumentNullException.ThrowIfNull) | ○ |
| C-25 | Equals/GetHashCodeが実装されている | E-02 (L86-96) | ○ |

### CompilerParameters関連（UT-CDM-036〜046）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-26 | デフォルトコンストラクタで生成できる | E-03 (L10-12) | ○ |
| C-27 | 参照アセンブリ指定で生成できる | E-03 (L14-16) | ○ |
| C-28 | 出力アセンブリ名指定で生成できる | E-03 (L19-22) | ○ |
| C-29 | WarningLevelのデフォルト値が-1である | E-03 (L69) | ○ |
| C-30 | TempFilesプロパティが遅延初期化される | E-03 (L59-63) | ○ |

### CompilerResults関連（UT-CDM-047〜051）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-31 | TempFileCollection指定で生成できる | E-04 (L13-16) | ○ |
| C-32 | CompiledAssemblyがPathToAssemblyからロードされる | E-04 (L20-31) | ○ |
| C-33 | Errorsコレクションが取得できる | E-04 (L32) | ○ |

### CompilerError関連（UT-CDM-052〜056）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-34 | デフォルトコンストラクタで生成できる | E-05 (L10) | ○ |
| C-35 | 全パラメータ指定で生成できる | E-05 (L12-19) | ○ |
| C-36 | ToStringでフォーマットされた文字列が返る | E-05 (L33-35) | ○ |
| C-37 | IsWarningでwarning/error文字列が変わる | E-05 (L37) | ○ |

### CompilerErrorCollection関連（UT-CDM-057〜069）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-38 | デフォルトコンストラクタで生成できる | E-06 (L10) | ○ |
| C-39 | コピーコンストラクタで生成できる | E-06 (L12-15) | ○ |
| C-40 | HasErrorsでエラー有無が判定できる | E-06 (L55-71) | ○ |
| C-41 | HasWarningsで警告有無が判定できる | E-06 (L73-89) | ○ |
| C-42 | AddRange(array)でnullチェックが行われる | E-06 (L32) | ○ |

### CodeGeneratorOptions関連（UT-CDM-070〜078）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-43 | IndentStringのデフォルト値が4スペースである | E-07 (L21-29) | ○ |
| C-44 | BracingStyleのデフォルト値が"Block"である | E-07 (L31-39) | ○ |
| C-45 | ElseOnClosingのデフォルト値がfalseである | E-07 (L41-49) | ○ |
| C-46 | BlankLinesBetweenMembersのデフォルト値がtrueである | E-07 (L51-59) | ○ |
| C-47 | インデクサでカスタムオプションが設定できる | E-07 (L15-19) | ○ |

### CodeCompileUnit関連（UT-CDM-079〜084）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-48 | Namespacesコレクションが取得できる | E-12 (L12) | ○ |
| C-49 | ReferencedAssembliesが遅延初期化される | E-12 (L14) | ○ |
| C-50 | AssemblyCustomAttributesが遅延初期化される | E-12 (L16) | ○ |
| C-51 | StartDirectives/EndDirectivesが遅延初期化される | E-12 (L18-20) | ○ |

### CodeNamespace関連（UT-CDM-085〜092）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-52 | 名前指定でインスタンスが生成できる | E-13 (L25-28) | ○ |
| C-53 | Name未設定時に空文字列が返却される | E-13 (L58-62) | ○ |
| C-54 | Typesコレクションが遅延初期化イベントを発火する | E-13 (L30-42) | ○ |
| C-55 | Imports/Commentsコレクションが取得できる | E-13 (L44-76) | ○ |

### CodeTypeDeclaration関連（UT-CDM-093〜106）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-56 | IsClassデフォルト値がtrueである | E-14 (L28, TypeAttributes初期値) | ○ |
| C-57 | IsClass=trueでIsStruct/IsEnumがfalseになる | E-14 (L44-57) | ○ |
| C-58 | IsStructでIsEnumがfalseになる | E-14 (L59-71) | ○ |
| C-59 | IsInterfaceでIsStruct/IsEnumがfalseになる | E-14 (L89-106) | ○ |
| C-60 | TypeParametersが遅延初期化される | E-14 (L124) | ○ |

### CodeTypeMember関連（UT-CDM-107〜112）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-61 | Name未設定時に空文字列が返却される | E-15 (L8-12) | ○ |
| C-62 | Attributesデフォルト値がPrivate|Finalである | E-15 (L14) | ○ |
| C-63 | CustomAttributesが遅延初期化される | E-15 (L16-20) | ○ |

### CodeMemberMethod関連（UT-CDM-113〜121）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-64 | ReturnTypeデフォルト値がvoidである | E-16 (L21-25) | ○ |
| C-65 | Parameters/Statementsコレクションが遅延初期化イベントを発火する | E-16 (L27-53) | ○ |
| C-66 | ImplementationTypesが遅延初期化される | E-16 (L57-71) | ○ |

### CodeMemberProperty関連（UT-CDM-122〜130）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-67 | HasGetがGetStatements追加時にtrueになる | E-17 (L21-32) | ○ |
| C-68 | HasGet=falseでGetStatementsがクリアされる | E-17 (L27-30) | ○ |
| C-69 | HasSetがSetStatements追加時にtrueになる | E-17 (L34-45) | ○ |

### CodeStatement関連（UT-CDM-131〜138）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-70 | StartDirectives/EndDirectivesが遅延初期化される | E-18 (L10-12) | ○ |
| C-71 | CodeStatementCollection.Add(CodeExpression)でCodeExpressionStatementとして追加される | E-19 (L30) | ○ |
| C-72 | AddRange(array)でnullチェックが行われる | E-19 (L34) | ○ |

### CodeConditionStatement関連（UT-CDM-139〜144）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-73 | 条件とtrueステートメント指定で生成できる | E-20 (L10-14) | ○ |
| C-74 | 両方のステートメント指定で生成できる | E-20 (L16-21) | ○ |
| C-75 | TrueStatements/FalseStatementsコレクションが取得できる | E-20 (L25-27) | ○ |

### CodeAssignStatement関連（UT-CDM-145〜148）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-76 | 左辺・右辺指定で生成できる | E-21 (L9-14) | ○ |
| C-77 | Left/Rightプロパティが設定できる | E-21 (L16-18) | ○ |

### CodeBinaryOperatorExpression関連（UT-CDM-149〜153）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-78 | 全パラメータ指定で生成できる | E-22 (L10-15) | ○ |
| C-79 | Left/Right/Operatorプロパティが設定できる | E-22 (L17-21) | ○ |

### CodeArrayCreateExpression関連（UT-CDM-154〜164）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-80 | 複数のコンストラクタオーバーロードが存在する | E-23 (L11-67) | ○ |
| C-81 | CreateType未設定時に空文字列型が返却される | E-23 (L69-72) | ○ |
| C-82 | Size/SizeExpressionプロパティが設定できる | E-23 (L77-79) | ○ |

### CodeGenerator関連（UT-CDM-165〜169）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-83 | IsValidLanguageIndependentIdentifierで識別子検証ができる | E-08 (L1558) | ○ |
| C-84 | ValidateIdentifiersでCodeObject検証ができる | E-08 (L1562-1566) | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし
  - 全てのテストケースについて、ソースコードから根拠を確認済み

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全テストケースがソースコードに基づいて作成されている
- 注意点:
  - Obsolete属性が付いたメソッド（CreateGenerator, CreateCompiler等）のテストは省略を検討
  - PlatformNotSupportedバージョンのテストは別途プラットフォーム固有テストとして検討が必要

## 6) レビュアーチェックリスト（最小）
- [ ] テストケースの優先度が適切に設定されているか（高: 重要なビジネスロジック、中: 通常機能、低: ユーティリティ）
- [ ] 異常系テストケースで例外の種類が正しく指定されているか
- [ ] 境界値テストが適切に含まれているか（空コレクション、null値、空文字列）
- [ ] 遅延初期化プロパティのテストが含まれているか
- [ ] 排他的なフラグ設定（IsClass/IsStruct/IsEnum）の相互作用がテストされているか
- [ ] コレクション操作（Add, AddRange, Remove, Contains等）のテストが網羅されているか
