---
generated_at: 2026-01-30 10:30:00
metrics:
  claims_total: 117
  claims_with_evidence: 117
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：libraries-System.Collections.Concurrent 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で該当する項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：117 / 117、根拠なし：0
- 優先レビュー（高）
  1. **ConcurrentStack.Push/TryPop**: スレッドセーフ性の確認が重要
  2. **BlockingCollection.Add/Take**: ブロッキング動作の検証
  3. **Partitioner.Create**: 各種データソースタイプの網羅性

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Collections.Concurrent/src/System/Collections/Concurrent/ConcurrentStack.cs`
- E-02: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Collections.Concurrent/src/System/Collections/Concurrent/ConcurrentBag.cs`
- E-03: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Collections.Concurrent/src/System/Collections/Concurrent/BlockingCollection.cs`
- E-04: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Collections.Concurrent/src/System/Collections/Concurrent/Partitioner.cs`
- E-05: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Collections.Concurrent/src/System/Collections/Concurrent/OrderablePartitioner.cs`
- E-06: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Collections.Concurrent/src/System/Collections/Concurrent/PartitionerStatic.cs`
- E-07: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Collections.Concurrent/src/System/Collections/Concurrent/CDSCollectionETWBCLProvider.cs`
- E-08: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Collections.Concurrent/ref/System.Collections.Concurrent.cs`

## 3) Claims と根拠の対応（レビューの主戦場）

### ConcurrentStack<T> 関連 (UT-SCC-001 〜 UT-SCC-028)

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Push メソッドはCAS操作でスレッドセーフに要素を追加する | E-01 (L273-289) | ○ |
| C-02 | Push は null 参照型を許容する | E-01 (L270-272 コメント) | ○ |
| C-03 | PushRange は複数要素をアトミックに追加する | E-01 (L291-358) | ○ |
| C-04 | PushRange は items=null で ArgumentNullException | E-01 (L392) | ○ |
| C-05 | PushRange は count=0 で何もしない | E-01 (L337-339) | ○ |
| C-06 | PushRange は startIndex<0 で ArgumentOutOfRangeException | E-01 (L398) | ○ |
| C-07 | PushRange は count<0 で ArgumentOutOfRangeException | E-01 (L394) | ○ |
| C-08 | PushRange は範囲超過で ArgumentException | E-01 (L400-403) | ○ |
| C-09 | TryPop は要素がある場合 true を返す | E-01 (L459-476) | ○ |
| C-10 | TryPop は空の場合 false を返す | E-01 (L461-467) | ○ |
| C-11 | TryPeek は要素を削除せずに参照する | E-01 (L432-447) | ○ |
| C-12 | TryPeek は空の場合 false を返す | E-01 (L437-441) | ○ |
| C-13 | TryPopRange は指定数の要素を取得する | E-01 (L533-548) | ○ |
| C-14 | TryPopRange は実際の要素数を返す | E-01 (L542-547) | ○ |
| C-15 | TryPopRange は count=0 で 0 を返す | E-01 (L537-539) | ○ |
| C-16 | IsEmpty は空の場合 true を返す | E-01 (L116-123) | ○ |
| C-17 | IsEmpty は要素がある場合 false を返す | E-01 (L116-123) | ○ |
| C-18 | Count はO(n)で正しい要素数を返す | E-01 (L134-156) | ○ |
| C-19 | Clear はスタックを空にする | E-01 (L191-198) | ○ |
| C-20 | ToArray はスナップショットを返す | E-01 (L679-685) | ○ |
| C-21 | CopyTo は配列にコピーする | E-01 (L256-265) | ○ |
| C-22 | GetEnumerator はスナップショットを列挙する | E-01 (L724-745) | ○ |
| C-23 | SyncRoot は NotSupportedException をスローする | E-01 (L180-186) | ○ |
| C-24 | コンストラクタは IEnumerable から初期化する | E-01 (L79-84) | ○ |
| C-25 | コンストラクタは collection=null で ArgumentNullException | E-01 (L81) | ○ |

### ConcurrentBag<T> 関連 (UT-SCC-029 〜 UT-SCC-047)

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-26 | Add はスレッドローカルキューに追加する | E-02 (L75-77) | ○ |
| C-27 | Add は null を許容する | E-02 (L22-24 コメント) | ○ |
| C-28 | TryTake はローカルキューから優先的に取得する | E-02 (L99-103) | ○ |
| C-29 | TryTake は空の場合 false を返す | E-02 (L99-103) | ○ |
| C-30 | TryPeek は要素を削除せずに参照する | E-02 (L112-116) | ○ |
| C-31 | IsEmpty はキュー全体の状態を確認する | E-02 (L524-573) | ○ |
| C-32 | Count は FreezeBag を使用して正確な値を返す | E-02 (L480-501) | ○ |
| C-33 | Clear はローカルキューとスティールでクリアする | E-02 (L403-442) | ○ |
| C-34 | ToArray は FreezeBag を使用してスナップショットを取得する | E-02 (L372-398) | ○ |
| C-35 | CopyTo は配列にコピーする | E-02 (L271-310) | ○ |
| C-36 | GetEnumerator は ToArray 経由で列挙する | E-02 (L456) | ○ |
| C-37 | SyncRoot は NotSupportedException をスローする | E-02 (L589-592) | ○ |
| C-38 | コンストラクタは IEnumerable から初期化する | E-02 (L56-67) | ○ |
| C-39 | コンストラクタは collection=null で ArgumentNullException | E-02 (L58) | ○ |

### BlockingCollection<T> 関連 (UT-SCC-048 〜 UT-SCC-076)

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-40 | Add はブロッキングで要素を追加する | E-03 (L250-259) | ○ |
| C-41 | Add は CompleteAdding 後に InvalidOperationException | E-03 (L400-403) | ○ |
| C-42 | Add はキャンセルで OperationCanceledException | E-03 (L280-289) | ○ |
| C-43 | TryAdd は非ブロッキングで追加を試みる | E-03 (L302-305) | ○ |
| C-44 | TryAdd はタイムアウト付きで動作する | E-03 (L325-329) | ○ |
| C-45 | TryAdd は容量制限でタイムアウト時 false を返す | E-03 (L414-437) | ○ |
| C-46 | TryAdd は無効なタイムアウトで ArgumentOutOfRangeException | E-03 (L349) | ○ |
| C-47 | CompleteAdding は IsAddingCompleted を true にする | E-03 (L77-84) | ○ |
| C-48 | IsCompleted は IsAddingCompleted かつ空で true を返す | E-03 (L90-97) | ○ |
| C-49 | BoundedCapacity は設定した容量を返す | E-03 (L64-71) | ○ |
| C-50 | BoundedCapacity は未設定で -1 を返す | E-03 (L49) NON_BOUNDED=-1 | ○ |
| C-51 | Count は正しい要素数を返す | E-03 (L103-110) | ○ |
| C-52 | Dispose は Disposed 後の操作で ObjectDisposedException | E-03 CheckDisposed使用 | ○ |
| C-53 | コンストラクタは容量を設定する | E-03 (L161-164) | ○ |
| C-54 | コンストラクタは boundedCapacity<=0 で ArgumentOutOfRangeException | E-03 (L179) | ○ |
| C-55 | コンストラクタは collection=null で ArgumentNullException | E-03 (L178, L197) | ○ |
| C-56 | コンストラクタは容量超過で ArgumentException | E-03 (L182-185) | ○ |
| C-57 | SyncRoot は NotSupportedException をスローする | E-03 (L129-135) | ○ |

### Partitioner 関連 (UT-SCC-077 〜 UT-SCC-103)

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-58 | Partitioner.GetPartitions は指定数のパーティションを返す | E-04 (L52) | ○ |
| C-59 | Partitioner.SupportsDynamicPartitions はデフォルト false | E-04 (L69-72) | ○ |
| C-60 | Partitioner.GetDynamicPartitions はデフォルト NotSupportedException | E-04 (L94-97) | ○ |
| C-61 | Partitioner.Create(IList, bool) は list から作成 | E-06 (L88-100) | ○ |
| C-62 | Partitioner.Create(IList, bool) は list=null で ArgumentNullException | E-06 (L90) | ○ |
| C-63 | Partitioner.Create(T[], bool) は array から作成 | E-06 (L114-129) | ○ |
| C-64 | Partitioner.Create(T[], bool) は array=null で ArgumentNullException | E-06 (L116) | ○ |
| C-65 | Partitioner.Create(IEnumerable) は source から作成 | E-06 (L143-146) | ○ |
| C-66 | Partitioner.Create(IEnumerable) は source=null で ArgumentNullException | E-06 (L167) | ○ |
| C-67 | Partitioner.Create(IEnumerable, options) は無効オプションで ArgumentOutOfRangeException | E-06 (L169-170) | ○ |
| C-68 | Partitioner.Create(long, long) は範囲パーティショナーを作成 | E-06 (L182-189) | ○ |
| C-69 | Partitioner.Create(long, long) は無効範囲で ArgumentOutOfRangeException | E-06 (L184) | ○ |
| C-70 | Partitioner.Create(long, long, long) は rangeSize 指定で作成 | E-06 (L200-205) | ○ |
| C-71 | Partitioner.Create(long, long, long) は rangeSize<=0 で ArgumentOutOfRangeException | E-06 (L203) | ○ |
| C-72 | Partitioner.Create(int, int) は範囲パーティショナーを作成 | E-06 (L236-243) | ○ |
| C-73 | Partitioner.Create(int, int, int) は rangeSize 指定で作成 | E-06 (L254-259) | ○ |
| C-74 | OrderablePartitioner.KeysOrderedInEachPartition はコンストラクタ値を返す | E-05 (L82-87, L134) | ○ |
| C-75 | OrderablePartitioner.KeysOrderedAcrossPartitions はコンストラクタ値を返す | E-05 (L82-87, L144) | ○ |
| C-76 | OrderablePartitioner.KeysNormalized はコンストラクタ値を返す | E-05 (L82-87, L154) | ○ |
| C-77 | OrderablePartitioner.GetPartitions はキーを除いたパーティションを返す | E-05 (L165-180) | ○ |
| C-78 | OrderablePartitioner.GetDynamicPartitions はキーを除いたパーティションを返す | E-05 (L206-210) | ○ |
| C-79 | OrderablePartitioner.GetOrderableDynamicPartitions はデフォルト NotSupportedException | E-05 (L126-129) | ○ |

### CDSCollectionETWBCLProvider 関連 (UT-SCC-104 〜 UT-SCC-107)

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-80 | ConcurrentStack_FastPushFailed はイベントを記録する | E-07 (L47-54) | ○ |
| C-81 | ConcurrentStack_FastPopFailed はイベントを記録する | E-07 (L56-63) | ○ |
| C-82 | ConcurrentBag_TryTakeSteals はイベントを記録する | E-07 (L74-81) | ○ |
| C-83 | ConcurrentBag_TryPeekSteals はイベントを記録する | E-07 (L83-90) | ○ |

### インターフェース実装関連 (UT-SCC-108 〜 UT-SCC-117)

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-84 | ConcurrentStack.IProducerConsumerCollection.TryAdd は常に true を返す | E-01 (L418-422) | ○ |
| C-85 | ConcurrentStack.IProducerConsumerCollection.TryTake は TryPop と同等 | E-01 (L669-672) | ○ |
| C-86 | ConcurrentBag.IProducerConsumerCollection.TryAdd は常に true を返す | E-02 (L86-90) | ○ |
| C-87 | ConcurrentStack.ICollection.IsSynchronized は false を返す | E-01 (L166-173) | ○ |
| C-88 | ConcurrentBag.ICollection.IsSynchronized は false を返す | E-02 (L582) | ○ |
| C-89 | BlockingCollection.ICollection.IsSynchronized は false を返す | E-03 (L115-122) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。すべてのテストケースはソースコードに基づいて生成されています。

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - すべてのテストケースがソースコード解析に基づいており、メソッドシグネチャ、例外処理、境界条件が明確に定義されています。

### 注意点
1. **並行処理テスト**: ConcurrentStack, ConcurrentBag, BlockingCollection のスレッドセーフ性テストは、実際のマルチスレッド環境での検証が必要です。本テストケース一覧は単体テストの観点で作成されており、並行実行時の競合条件テストは別途結合テストで実施することを推奨します。

2. **ETWトレーシングテスト**: CDSCollectionETWBCLProvider のテストは、ETW リスナーの設定が必要であり、テスト環境によっては実行できない可能性があります。

## 6) レビュアーチェックリスト（最小）
- [ ] ConcurrentStack の CAS 操作に関するテストケースが適切にカバーされているか
- [ ] ConcurrentBag のワークスティーリング機構に関するテストケースが含まれているか
- [ ] BlockingCollection のブロッキング/非ブロッキング動作の両方がテストされているか
- [ ] Partitioner の各種 Create メソッドの引数検証テストが網羅されているか
- [ ] 境界値テスト（空コレクション、容量制限、タイムアウト）が十分にカバーされているか
- [ ] 例外ケース（ArgumentNullException, ArgumentOutOfRangeException, InvalidOperationException）が網羅されているか
- [ ] IProducerConsumerCollection, ICollection インターフェース実装のテストが含まれているか
