---
generated_at: 2026-01-30 12:00:00
metrics:
  claims_total: 125
  claims_with_evidence: 125
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 単体テストケース一覧 根拠レポート: libraries-System.Collections.Immutable

## 概要

本レポートは、`libraries-System.Collections.Immutable` モジュールの単体テストケース一覧CSVファイルに記載された各テストケースの根拠を示すものです。

## 対象ファイル

- 出力CSV: `docs/code-to-docs/単体テストケース一覧/libraries-System.Collections.Immutable.csv`
- テストケース総数: 125件

## 解析対象ソースコード

| ファイルパス | 主要クラス |
|-------------|-----------|
| `src/libraries/System.Collections.Immutable/src/System/Collections/Immutable/ImmutableArray_1.cs` | ImmutableArray<T> |
| `src/libraries/System.Collections.Immutable/src/System/Collections/Immutable/ImmutableList_1.cs` | ImmutableList<T> |
| `src/libraries/System.Collections.Immutable/src/System/Collections/Immutable/ImmutableDictionary_2.cs` | ImmutableDictionary<TKey, TValue> |
| `src/libraries/System.Collections.Immutable/src/System/Collections/Immutable/ImmutableInterlocked.cs` | ImmutableInterlocked |
| `src/libraries/System.Collections.Immutable/src/System/Collections/Frozen/FrozenDictionary.cs` | FrozenDictionary<TKey, TValue> |
| `src/libraries/System.Collections.Immutable/src/System/Collections/Frozen/FrozenSet.cs` | FrozenSet<T> |

## テストケース根拠一覧

### ImmutableArray<T> (UT-SCI-001 ~ UT-SCI-016)

#### UT-SCI-001 ~ UT-SCI-006: IndexOf メソッド

**根拠**: `ImmutableArray_1.cs` のIndexOfメソッド実装

```csharp
public int IndexOf(T item, int startIndex, int count, IEqualityComparer<T>? equalityComparer)
{
    ImmutableArray<T> self = this;
    self.ThrowNullRefIfNotInitialized();

    if (count == 0 && startIndex == 0)
    {
        return -1;
    }

    Requires.Range(startIndex >= 0 && startIndex < self.Length, nameof(startIndex));
    Requires.Range(count >= 0 && startIndex + count <= self.Length, nameof(count));
    // ...
}
```

- 正常系: 配列内で要素を検索し、インデックスを返す基本機能
- 境界値: `count == 0 && startIndex == 0` で -1 を返す特殊処理
- 異常系: `Requires.Range` による入力検証、`ThrowNullRefIfNotInitialized` による初期化チェック

#### UT-SCI-007 ~ UT-SCI-008: LastIndexOf メソッド

**根拠**: `ImmutableArray_1.cs` のLastIndexOfメソッド実装

```csharp
public int LastIndexOf(T item)
{
    ImmutableArray<T> self = this;
    if (self.IsEmpty)
    {
        return -1;
    }
    return self.LastIndexOf(item, self.Length - 1, self.Length, EqualityComparer<T>.Default);
}
```

- 正常系: 逆方向検索で最後の出現位置を返す
- 境界値: `IsEmpty` の場合に -1 を返す

#### UT-SCI-009 ~ UT-SCI-010: Contains メソッド

**根拠**: `ImmutableArray_1.cs` のContainsメソッド実装

```csharp
public bool Contains(T item)
{
    return this.IndexOf(item) >= 0;
}
```

- IndexOfの結果に基づいてbool値を返す

#### UT-SCI-011 ~ UT-SCI-012: AsSpan / AsMemory メソッド

**根拠**: `ImmutableArray_1.cs` の実装

```csharp
public ReadOnlySpan<T> AsSpan() => new ReadOnlySpan<T>(array);
public ReadOnlyMemory<T> AsMemory() => new ReadOnlyMemory<T>(array);
```

- 内部配列をSpan/Memoryとして公開

#### UT-SCI-013 ~ UT-SCI-016: IList<T> / ICollection<T> インターフェース実装

**根拠**: `ImmutableArray_1.cs` のインターフェース実装

```csharp
T IList<T>.this[int index]
{
    get { /* ... */ self.ThrowInvalidOperationIfNotInitialized(); return self[index]; }
    set { throw new NotSupportedException(); }
}

int ICollection<T>.Count
{
    get { /* ... */ self.ThrowInvalidOperationIfNotInitialized(); return self.Length; }
}
```

- セッターは不変性を保証するため NotSupportedException をスロー
- 未初期化時は InvalidOperationException をスロー

### ImmutableList<T> (UT-SCI-017 ~ UT-SCI-040)

#### UT-SCI-017 ~ UT-SCI-020: Add / AddRange メソッド

**根拠**: `ImmutableList_1.cs` の実装

```csharp
public ImmutableList<T> Add(T value)
{
    ImmutableList<T>.Node result = _root.Add(value);
    return this.Wrap(result);
}

public ImmutableList<T> AddRange(IEnumerable<T> items)
{
    Requires.NotNull(items, nameof(items));
    if (this.IsEmpty)
    {
        return CreateRange(items);
    }
    // ...
}
```

- 新しいリストを返す不変操作
- null チェックによる入力検証
- 空リストの場合の最適化

#### UT-SCI-021 ~ UT-SCI-025: Insert / InsertRange メソッド

**根拠**: `ImmutableList_1.cs` の実装

```csharp
public ImmutableList<T> Insert(int index, T item)
{
    Requires.Range(index >= 0 && index <= this.Count, nameof(index));
    return this.Wrap(_root.Insert(index, item));
}
```

- インデックス範囲検証
- 先頭(index=0)および末尾(index=Count)への挿入サポート

#### UT-SCI-026 ~ UT-SCI-029: Remove / RemoveRange メソッド

**根拠**: `ImmutableList_1.cs` の実装

```csharp
public ImmutableList<T> Remove(T value, IEqualityComparer<T>? equalityComparer)
{
    int index = this.IndexOf(value, equalityComparer);
    return index < 0 ? this : this.RemoveAt(index);
}

public ImmutableList<T> RemoveRange(int index, int count)
{
    Requires.Range(index >= 0 && index <= this.Count, nameof(index));
    // ...
}
```

- 要素が見つからない場合は同じインスタンスを返す最適化
- 範囲検証による入力チェック

#### UT-SCI-030 ~ UT-SCI-032: BinarySearch メソッド

**根拠**: `ImmutableList_1.cs` の実装

```csharp
public int BinarySearch(T item) => this.BinarySearch(item, null);
public int BinarySearch(T item, IComparer<T>? comparer) => this.BinarySearch(0, this.Count, item, comparer);
public int BinarySearch(int index, int count, T item, IComparer<T>? comparer) => _root.BinarySearch(index, count, item, comparer);
```

- ソート済みリストでの効率的な検索
- 見つからない場合はビット反転インデックスを返す標準的な動作

#### UT-SCI-033 ~ UT-SCI-040: プロパティとその他メソッド

**根拠**: `ImmutableList_1.cs` の実装

```csharp
public T this[int index] => _root.ItemRef(index);
public ref readonly T ItemRef(int index) => ref _root.ItemRef(index);
public ImmutableList<T> Clear() => Empty;
public Builder ToBuilder() { return new Builder(this); }
public bool IsEmpty => _root.IsEmpty;
public int Count => _root.Count;
```

- インデクサ、参照取得、クリア、ビルダー変換など基本機能

### ImmutableDictionary<TKey, TValue> (UT-SCI-041 ~ UT-SCI-058)

#### UT-SCI-041 ~ UT-SCI-048: Add / インデクサ / TryGetValue / ContainsKey

**根拠**: `ImmutableDictionary_2.cs` の実装

```csharp
public TValue this[TKey key]
{
    get
    {
        Requires.NotNullAllowStructs(key, nameof(key));
        TValue value;
        if (!this.TryGetValue(key, out value!))
        {
            ThrowHelper.ThrowKeyNotFoundException(key);
        }
        return value;
    }
}
```

- 存在しないキーで KeyNotFoundException をスロー
- TryGetValue による安全な値取得

#### UT-SCI-049 ~ UT-SCI-058: Clear / プロパティ / ToBuilder

**根拠**: `ImmutableDictionary_2.cs` の実装

```csharp
public ImmutableDictionary<TKey, TValue> Clear()
{
    return this.IsEmpty ? this : EmptyWithComparers(_comparers);
}

public IEnumerable<TKey> Keys { get { foreach (var bucket in _root) { foreach (var item in bucket.Value) { yield return item.Key; } } } }
```

- 空の場合は同じインスタンスを返す最適化
- イテレータによるKeys/Valuesの遅延評価

### ImmutableInterlocked (UT-SCI-059 ~ UT-SCI-083)

#### UT-SCI-059 ~ UT-SCI-065: ImmutableArray用アトミック操作

**根拠**: `ImmutableInterlocked.cs` の実装

```csharp
public static bool Update<T>(ref ImmutableArray<T> location, Func<ImmutableArray<T>, ImmutableArray<T>> transformer)
{
    // スピンループでCAS操作を繰り返す
}

public static ImmutableArray<T> InterlockedExchange<T>(ref ImmutableArray<T> location, ImmutableArray<T> value)
{
    return Interlocked.Exchange(ref Unsafe.As<ImmutableArray<T>, T[]?>(ref location), value.array).AsImmutableArray();
}

public static bool InterlockedInitialize<T>(ref ImmutableArray<T> location, ImmutableArray<T> value)
{
    return InterlockedCompareExchange(ref location, value, default) == default;
}
```

- スレッドセーフなアトミック更新
- CAS操作による競合時のリトライ
- 遅延初期化のサポート

#### UT-SCI-066 ~ UT-SCI-077: ImmutableDictionary用アトミック操作

**根拠**: `ImmutableInterlocked.cs` の実装

```csharp
public static TValue GetOrAdd<TKey, TValue>(ref ImmutableDictionary<TKey, TValue> location, TKey key, TValue value)
{
    // キーが存在しない場合のみ追加
}

public static bool TryAdd<TKey, TValue>(ref ImmutableDictionary<TKey, TValue> location, TKey key, TValue value)
{
    // アトミックな追加試行
}

public static bool TryUpdate<TKey, TValue>(ref ImmutableDictionary<TKey, TValue> location, TKey key, TValue newValue, TValue comparisonValue)
{
    // CAS的な更新操作
}

public static bool TryRemove<TKey, TValue>(ref ImmutableDictionary<TKey, TValue> location, TKey key, [MaybeNullWhen(false)] out TValue value)
{
    // アトミックな削除操作
}
```

- GetOrAdd: キー存在時は既存値を返す
- TryAdd: 重複キーでfalseを返す
- TryUpdate: 現在値が一致する場合のみ更新
- TryRemove: キーが存在する場合のみ削除

#### UT-SCI-078 ~ UT-SCI-083: Stack/Queue用アトミック操作

**根拠**: `ImmutableInterlocked.cs` の実装

```csharp
public static void Push<T>(ref ImmutableStack<T> location, T value)
{
    // アトミックなプッシュ
}

public static bool TryPop<T>(ref ImmutableStack<T> location, [MaybeNullWhen(false)] out T value)
{
    // 空スタックでfalse
}

public static void Enqueue<T>(ref ImmutableQueue<T> location, T value)
{
    // アトミックなエンキュー
}

public static bool TryDequeue<T>(ref ImmutableQueue<T> location, [MaybeNullWhen(false)] out T value)
{
    // 空キューでfalse
}
```

- スタック/キューのスレッドセーフ操作

### FrozenDictionary<TKey, TValue> (UT-SCI-084 ~ UT-SCI-100)

#### UT-SCI-084 ~ UT-SCI-100: ファクトリ / 検索 / プロパティ

**根拠**: `FrozenDictionary.cs` の実装

```csharp
public static FrozenDictionary<TKey, TValue> Create<TKey, TValue>(IEnumerable<KeyValuePair<TKey, TValue>> source, IEqualityComparer<TKey>? comparer = null)
{
    // ファクトリメソッド
}

public TValue this[TKey key]
{
    get
    {
        if (!TryGetValue(key, out TValue? value))
        {
            ThrowHelper.ThrowKeyNotFoundException(key);
        }
        return value;
    }
}

public ref readonly TValue GetValueRefOrNullRef(TKey key)
{
    // 存在しない場合はnull参照を返す
}
```

- 読み取り最適化された不変辞書
- インデクサでKeyNotFoundExceptionをスロー
- GetValueRefOrNullRefで安全な参照取得

### FrozenSet<T> (UT-SCI-101 ~ UT-SCI-125)

#### UT-SCI-101 ~ UT-SCI-125: ファクトリ / 存在確認 / 集合演算

**根拠**: `FrozenSet.cs` の実装

```csharp
public static FrozenSet<T> Create<T>(IEnumerable<T> source, IEqualityComparer<T>? comparer = null)
{
    // ファクトリメソッド
}

public bool Contains(T item) => FindItemIndex(item) >= 0;

public bool IsSubsetOf(IEnumerable<T> other) { /* 部分集合判定 */ }
public bool IsSupersetOf(IEnumerable<T> other) { /* 上位集合判定 */ }
public bool IsProperSubsetOf(IEnumerable<T> other) { /* 真部分集合判定 */ }
public bool IsProperSupersetOf(IEnumerable<T> other) { /* 真上位集合判定 */ }
public bool Overlaps(IEnumerable<T> other) { /* 共通要素存在判定 */ }
public bool SetEquals(IEnumerable<T> other) { /* 集合等価判定 */ }
```

- 読み取り最適化された不変セット
- ISet<T>インターフェースの完全実装
- 集合演算のサポート

## テスト観点カバレッジ

| 観点 | テストケース数 | 割合 |
|------|---------------|------|
| 正常系 | 98 | 78.4% |
| 異常系 | 16 | 12.8% |
| 境界値 | 11 | 8.8% |
| **合計** | **125** | **100%** |

## 優先度分布

| 優先度 | テストケース数 | 割合 |
|--------|---------------|------|
| 高 | 78 | 62.4% |
| 中 | 47 | 37.6% |
| 低 | 0 | 0% |
| **合計** | **125** | **100%** |

## 結論

本テストケース一覧は、System.Collections.Immutableモジュールの主要クラス（ImmutableArray, ImmutableList, ImmutableDictionary, ImmutableInterlocked, FrozenDictionary, FrozenSet）について、ソースコードの実装に基づいた網羅的なテストケースを定義しています。

すべてのテストケースは実際のソースコード実装から導出されており、根拠のないテストケースは存在しません。
