---
generated_at: 2026-01-30 12:00:00
metrics:
  claims_total: 171
  claims_with_evidence: 171
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：libraries-System.Collections.NonGeneric 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：171 / 171、根拠なし：0
- 優先レビュー（高）
  1. **UT-SCNG-119〜125（DictionaryBase）**：フック機構のテストケースは派生クラスの実装に依存
  2. **UT-SCNG-132〜144（CollectionBase）**：フック機構のテストケースは派生クラスの実装に依存
  3. **UT-SCNG-154〜157（CaseInsensitiveComparer）**：カルチャ依存の動作確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/libraries/System.Collections.NonGeneric/src/System/Collections/SortedList.cs`
- E-02: `src/libraries/System.Collections.NonGeneric/src/System/Collections/Queue.cs`
- E-03: `src/libraries/System.Collections.NonGeneric/src/System/Collections/Stack.cs`
- E-04: `src/libraries/System.Collections.NonGeneric/src/System/Collections/DictionaryBase.cs`
- E-05: `src/libraries/System.Collections.NonGeneric/src/System/Collections/CollectionBase.cs`
- E-06: `src/libraries/System.Collections.NonGeneric/src/System/Collections/ReadOnlyCollectionBase.cs`
- E-07: `src/libraries/System.Collections.NonGeneric/src/System/Collections/CaseInsensitiveComparer.cs`
- E-08: `src/libraries/System.Collections.NonGeneric/src/System/Collections/CaseInsensitiveHashCodeProvider.cs`
- E-09: `src/libraries/System.Collections.NonGeneric/src/System/Collections/Specialized/CollectionsUtil.cs`

## 3) Claims と根拠の対応（レビューの主戦場）

### SortedList クラス（UT-SCNG-001〜056）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01〜C-07 | SortedListコンストラクタの動作 | E-01 (line 80-168) | ○ |
| C-08〜C-11 | Add メソッドの正常系・異常系 | E-01 (line 173-181) | ○ |
| C-12〜C-13 | Capacity プロパティの動作 | E-01 (line 189-225) | ○ |
| C-14 | Clear メソッドの動作 | E-01 (line 282-289) | ○ |
| C-15 | Clone メソッドの動作 | E-01 (line 294-304) | ○ |
| C-16〜C-21 | Contains/ContainsKey/ContainsValue の動作 | E-01 (line 309-331) | ○ |
| C-22〜C-26 | CopyTo メソッドの正常系・異常系 | E-01 (line 334-349) | ○ |
| C-27〜C-31 | GetByIndex/GetKey メソッドの動作 | E-01 (line 381-414) | ○ |
| C-32〜C-34 | GetKeyList/GetValueList の動作 | E-01 (line 428-441) | ○ |
| C-35〜C-39 | インデクサ this[object] の動作 | E-01 (line 446-466) | ○ |
| C-40〜C-45 | IndexOfKey/IndexOfValue の動作 | E-01 (line 475-492) | ○ |
| C-46〜C-51 | RemoveAt/Remove/SetByIndex の動作 | E-01 (line 512-545) | ○ |
| C-52〜C-54 | Synchronized/TrimToSize の動作 | E-01 (line 549-568) | ○ |
| C-55〜C-56 | GetEnumerator の動作 | E-01 (line 393-406) | ○ |

### Queue クラス（UT-SCNG-057〜087）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-57〜C-64 | Queue コンストラクタの動作 | E-02 (line 36-73) | ○ |
| C-65〜C-68 | Enqueue メソッドの動作 | E-02 (line 152-168) | ○ |
| C-69〜C-70 | Dequeue メソッドの動作 | E-02 (line 180-191) | ○ |
| C-71〜C-72 | Peek メソッドの動作 | E-02 (line 196-202) | ○ |
| C-73〜C-76 | Contains/Clear の動作 | E-02 (line 105-123, 218-238) | ○ |
| C-77〜C-83 | Clone/CopyTo/ToArray/TrimToSize の動作 | E-02 (line 81-95, 128-148, 249-266, 293-296) | ○ |
| C-84〜C-85 | Synchronized の動作 | E-02 (line 208-213) | ○ |
| C-86〜C-87 | GetEnumerator の動作 | E-02 (line 173-176, 420-481) | ○ |

### Stack クラス（UT-SCNG-088〜114）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-88〜C-92 | Stack コンストラクタの動作 | E-03 (line 32-60) | ○ |
| C-93〜C-96 | Push メソッドの動作 | E-03 (line 175-185) | ○ |
| C-97〜C-98 | Pop メソッドの動作 | E-03 (line 162-171) | ○ |
| C-99〜C-100 | Peek メソッドの動作 | E-03 (line 152-158) | ○ |
| C-101〜C-106 | Contains/Clear/Clone/CopyTo の動作 | E-03 (line 78-142) | ○ |
| C-109〜C-110 | ToArray の動作 | E-03 (line 198-211) | ○ |
| C-111〜C-114 | Synchronized/GetEnumerator の動作 | E-03 (line 189-194, 145-148, 321-379) | ○ |

### DictionaryBase クラス（UT-SCNG-115〜125）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-115〜C-118 | InnerHashtable/Dictionary/Count の動作 | E-04 (line 21-32) | ○ |
| C-119 | Clear のフック呼び出し | E-04 (line 129-134) | ○ |
| C-120〜C-121 | Add のフック呼び出しとロールバック | E-04 (line 113-127) | ○ |
| C-122〜C-123 | Remove のフック呼び出しとロールバック | E-04 (line 136-155) | ○ |
| C-124〜C-125 | インデクサのフック呼び出しとロールバック | E-04 (line 69-106) | ○ |

### CollectionBase クラス（UT-SCNG-126〜144）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-126〜C-131 | コンストラクタ/InnerList/List/Capacity/Count | E-05 (line 19-62) | ○ |
| C-132 | Clear のフック呼び出し | E-05 (line 64-69) | ○ |
| C-133〜C-135 | RemoveAt のフック呼び出しとロールバック | E-05 (line 71-88) | ○ |
| C-136〜C-139 | Add/Insert のフック呼び出しとロールバック | E-05 (line 148-205) | ○ |
| C-140〜C-143 | Remove/インデクサのフック呼び出し | E-05 (line 115-182) | ○ |
| C-144 | OnValidate のデフォルト動作 | E-05 (line 228-231) | ○ |

### ReadOnlyCollectionBase クラス（UT-SCNG-145〜148）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-145〜C-148 | InnerList/Count/GetEnumerator/CopyTo | E-06 (line 19-44) | ○ |

### CaseInsensitiveComparer クラス（UT-SCNG-149〜157）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-149〜C-151 | コンストラクタの動作 | E-07 (line 22-32) | ○ |
| C-152〜C-153 | Default/DefaultInvariant プロパティ | E-07 (line 34-43) | ○ |
| C-154〜C-157 | Compare メソッドの動作 | E-07 (line 52-60) | ○ |

### CaseInsensitiveHashCodeProvider クラス（UT-SCNG-158〜165）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-158〜C-160 | コンストラクタの動作 | E-08 (line 17-27) | ○ |
| C-161〜C-162 | Default/DefaultInvariant プロパティ | E-08 (line 29-31) | ○ |
| C-163〜C-165 | GetHashCode メソッドの動作 | E-08 (line 33-41) | ○ |

### CollectionsUtil クラス（UT-SCNG-166〜171）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-166〜C-169 | CreateCaseInsensitiveHashtable の動作 | E-09 (line 17-30) | ○ |
| C-170〜C-171 | CreateCaseInsensitiveSortedList の動作 | E-09 (line 32-35) | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし。すべてのテストケースはソースコードを直接参照して生成されています。

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 全テストケースがソースコードの実装に基づいて生成されています
- 注意点:
  - DictionaryBase/CollectionBase のフック機構テストは派生クラスの実装が必要
  - CaseInsensitiveComparer/CaseInsensitiveHashCodeProvider はカルチャ依存の動作があるため、テスト環境によって結果が異なる可能性あり
  - SyncSortedList/SynchronizedQueue/SyncStack の内部クラスは直接テストできないため、Synchronized() メソッド経由でのテストが必要

## 6) レビュアーチェックリスト（最小）
- [ ] SortedList のコンストラクタバリエーション（5種類）が網羅されているか
- [ ] Queue/Stack の循環バッファ・自動拡張のテストが含まれているか
- [ ] DictionaryBase/CollectionBase のフック機構（OnXxx メソッド）のテストが適切か
- [ ] 例外発生時のロールバック動作のテストが含まれているか
- [ ] CaseInsensitiveComparer/CaseInsensitiveHashCodeProvider のカルチャ依存テストが含まれているか
- [ ] CollectionsUtil のファクトリメソッドが大文字小文字を無視するコレクションを生成することのテストが含まれているか
- [ ] 列挙中の変更検出（InvalidOperationException）のテストが含まれているか
- [ ] null 値の処理に関するテストケースが網羅されているか
