---
generated_at: 2026-01-30 10:00:00
metrics:
  claims_total: 276
  claims_with_evidence: 276
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：libraries-System.Collections.Specialized 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各テストケースに対して、ソースコード内のメソッド・プロパティ定義が存在するか
2. **根拠との整合性**：テストケースの入力値・期待結果がソースコードの実装と矛盾していないか
3. **網羅性**：対象クラスの主要なpublic/protectedメンバーを適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：276 / 276、根拠なし：0
- 優先レビュー（高）
  1. **HybridDictionaryの内部切り替えロジック（CutoverPoint）**：実装詳細に依存するテストケース
  2. **OrderedDictionaryの順序保証テスト**：実装の暗黙的保証に依存
  3. **BitVector32のセクション境界値テスト**：32ビット制限の検証

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/libraries/System.Collections.Specialized/src/System/Collections/Specialized/StringCollection.cs`
- E-02: `src/libraries/System.Collections.Specialized/src/System/Collections/Specialized/HybridDictionary.cs`
- E-03: `src/libraries/System.Collections.Specialized/src/System/Collections/Specialized/OrderedDictionary.cs`
- E-04: `src/libraries/System.Collections.Specialized/src/System/Collections/Specialized/StringDictionary.cs`
- E-05: `src/libraries/System.Collections.Specialized/src/System/Collections/Specialized/NameObjectCollectionBase.cs`
- E-06: `src/libraries/System.Collections.Specialized/src/System/Collections/Specialized/NameValueCollection.cs`
- E-07: `src/libraries/System.Collections.Specialized/src/System/Collections/Specialized/BitVector32.cs`
- E-08: `src/libraries/System.Collections.Specialized/src/System/Collections/Specialized/ListDictionary.cs`
- E-09: `src/libraries/System.Collections.Specialized/src/System/Collections/Specialized/IOrderedDictionary.cs`

## 3) Claims と根拠の対応（レビューの主戦場）

### StringCollection (UT-SCS-001 - UT-SCS-026)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | StringCollection.this[int]インデクサ取得 | E-01: lines 19-29 | ○ |
| C-02 | StringCollection.Countプロパティ | E-01: lines 35-41 | ○ |
| C-03 | StringCollection.Addメソッド | E-01: lines 64-67 | ○ |
| C-04 | StringCollection.AddRangeメソッド（null検証含む） | E-01: lines 72-77 | ○ |
| C-05 | StringCollection.Clear/Contains/CopyTo/IndexOf/Insert/Remove/RemoveAt | E-01: lines 83-173 | ○ |
| C-06 | StringEnumerator.Current/MoveNext/Reset | E-01: lines 235-261 | ○ |

### HybridDictionary (UT-SCS-027 - UT-SCS-056)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-07 | HybridDictionaryコンストラクタ群 | E-02: lines 33-60 | ○ |
| C-08 | HybridDictionary.this[object]インデクサ（内部切り替え含む） | E-02: lines 62-115 | ○ |
| C-09 | HybridDictionary.ChangeOverメソッド（CutoverPoint=9） | E-02: lines 119-142, constant at line 24 | ○ |
| C-10 | HybridDictionary.Count/Keys/Values | E-02: lines 144-224 | ○ |
| C-11 | HybridDictionary.Add（切り替えロジック含む） | E-02: lines 226-250 | ○ |
| C-12 | HybridDictionary.Clear/Contains/CopyTo/GetEnumerator/Remove | E-02: lines 252-335 | ○ |

### OrderedDictionary (UT-SCS-057 - UT-SCS-097)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-13 | OrderedDictionaryコンストラクタ群 | E-03: lines 39-66 | ○ |
| C-14 | OrderedDictionary.this[int]インデクサ（ReadOnly検証含む） | E-03: lines 151-174 | ○ |
| C-15 | OrderedDictionary.this[object]インデクサ | E-03: lines 179-207 | ○ |
| C-16 | OrderedDictionary.Add（ReadOnly検証含む） | E-03: lines 224-234 | ○ |
| C-17 | OrderedDictionary.Clear/AsReadOnly/Contains | E-03: lines 239-269 | ○ |
| C-18 | OrderedDictionary.Insert/RemoveAt/Remove（境界値検証含む） | E-03: lines 310-363 | ○ |
| C-19 | OrderedDictionary.GetEnumerator（順序保証） | E-03: lines 366-378 | ○ |

### StringDictionary (UT-SCS-098 - UT-SCS-127)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-20 | StringDictionaryコンストラクタ | E-04: lines 34-36 | ○ |
| C-21 | StringDictionary.this[string]インデクサ（ToLowerInvariant変換） | E-04: lines 65-79 | ○ |
| C-22 | StringDictionary.Keys/Values/SyncRoot/IsSynchronized | E-04: lines 84-113 | ○ |
| C-23 | StringDictionary.Add（キー小文字化） | E-04: lines 118-123 | ○ |
| C-24 | StringDictionary.ContainsKey/ContainsValue/Remove | E-04: lines 136-176 | ○ |

### NameObjectCollectionBase (UT-SCS-128 - UT-SCS-165)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-25 | NameObjectCollectionBaseコンストラクタ群 | E-05: lines 41-79 | ○ |
| C-26 | NameObjectCollectionBase.IsReadOnlyプロパティ | E-05: lines 148-152 | ○ |
| C-27 | NameObjectCollectionBase.BaseHasKeys | E-05: lines 158-161 | ○ |
| C-28 | NameObjectCollectionBase.BaseAdd（nullキー対応含む） | E-05: lines 171-194 | ○ |
| C-29 | NameObjectCollectionBase.BaseRemove/BaseRemoveAt/BaseClear | E-05: lines 200-270 | ○ |
| C-30 | NameObjectCollectionBase.BaseGet/BaseSet（名前・インデックス両対応） | E-05: lines 280-346 | ○ |
| C-31 | NameObjectCollectionBase.GetEnumerator/Count | E-05: lines 355-369 | ○ |
| C-32 | NameObjectCollectionBase.BaseGetAllKeys/BaseGetAllValues | E-05: lines 406-451 | ○ |
| C-33 | NameObjectCollectionBase.KeysCollection | E-05: lines 543-625 | ○ |

### NameValueCollection (UT-SCS-166 - UT-SCS-198)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-34 | NameValueCollectionコンストラクタ群 | E-06: lines 35-91 | ○ |
| C-35 | NameValueCollection.InvalidateCachedArrays | E-06: lines 106-110 | ○ |
| C-36 | NameValueCollection.Add（複数値マージ） | E-06: lines 158-279 | ○ |
| C-37 | NameValueCollection.Get/GetValues（カンマ区切り・配列） | E-06: lines 284-297 | ○ |
| C-38 | NameValueCollection.Set/Remove | E-06: lines 302-321 | ○ |
| C-39 | NameValueCollection.this[string]/this[int]インデクサ | E-06: lines 327-381 | ○ |
| C-40 | NameValueCollection.AllKeys | E-06: line 390 | ○ |

### BitVector32 (UT-SCS-199 - UT-SCS-232)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-41 | BitVector32コンストラクタ群 | E-07: lines 20-32 | ○ |
| C-42 | BitVector32.this[int bit]インデクサ | E-07: lines 37-57 | ○ |
| C-43 | BitVector32.this[Section]インデクサ | E-07: lines 62-82 | ○ |
| C-44 | BitVector32.Dataプロパティ | E-07: lines 87-93 | ○ |
| C-45 | BitVector32.CreateMask（オーバーフロー検証含む） | E-07: lines 98-119 | ○ |
| C-46 | BitVector32.CreateSection（境界値・オーバーフロー検証含む） | E-07: lines 124-149 | ○ |
| C-47 | BitVector32.Equals/GetHashCode/ToString | E-07: lines 151-181 | ○ |
| C-48 | BitVector32.Sectionの全メンバー | E-07: lines 187-230 | ○ |

### ListDictionary (UT-SCS-233 - UT-SCS-276)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-49 | ListDictionaryコンストラクタ群 | E-08: lines 21-28 | ○ |
| C-50 | ListDictionary.this[object]インデクサ（比較子使用含む） | E-08: lines 30-99 | ○ |
| C-51 | ListDictionary.Count/Keys/Values | E-08: lines 101-149 | ○ |
| C-52 | ListDictionary.Add（重複キー検証） | E-08: lines 151-180 | ○ |
| C-53 | ListDictionary.Clear/Contains/CopyTo/GetEnumerator/Remove | E-08: lines 182-260 | ○ |
| C-54 | ListDictionary.NodeEnumerator全メンバー | E-08: lines 262-349 | ○ |
| C-55 | ListDictionary.NodeKeyValueCollection全メンバー | E-08: lines 351-467 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（全テストケースにソースコード根拠あり）

## 5) リスクフラグ（レビュー観点）
- **0 (低リスク)**: StringCollection, StringDictionary - 単純なラッパークラス
- **1 (中リスク)**: NameObjectCollectionBase, NameValueCollection, ListDictionary - 内部状態管理あり
- **2 (高リスク)**:
  - HybridDictionary - 内部でListDictionaryからHashtableへの切り替えロジックがあり、CutoverPoint（9）を正確にテストする必要がある
  - OrderedDictionary - 順序保証とReadOnlyモードの両方を持つ複合的な振る舞い
  - BitVector32 - 32ビット境界とSection作成のオーバーフロー検証が重要

## 6) レビュアーチェックリスト（最小）
- [ ] HybridDictionaryのCutoverPoint（9要素）での切り替えテストが正しく設計されているか
- [ ] OrderedDictionaryのReadOnlyモードでの全操作（Add/Remove/Insert/Clear/Set）が例外をスローすることを確認
- [ ] BitVector32.CreateSectionの32ビット境界テストが適切か
- [ ] StringDictionaryのToLowerInvariant変換によるキー処理が正しくテストされているか
- [ ] NameValueCollectionの複数値マージ（同一キーへのAdd）テストが含まれているか
- [ ] ListDictionaryの列挙中変更検出テストが含まれているか
- [ ] 全クラスのnullキー/null値の境界条件テストが含まれているか
