---
generated_at: 2026-01-30 10:30:00
metrics:
  claims_total: 200
  claims_with_evidence: 195
  claims_without_evidence: 5
confidence_derived: 0.975
---

# 根拠レポート：libraries-System.Collections単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.975**
  - 根拠あり：195 / 200、根拠なし：5
- 優先レビュー（高）
  1. **TreeSet<T>内部動作**：SortedDictionaryとの関係性の詳細確認が必要
  2. **SortedSetEqualityComparer**：内部クラスのため外部公開されていない可能性
  3. **OrderedDictionary SetAt(int, TKey, TValue)**：メソッドシグネチャの正確性確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Collections/src/System/Collections/Generic/LinkedList.cs`
- E-02: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Collections/src/System/Collections/Generic/Stack.cs`
- E-03: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Collections/src/System/Collections/Generic/PriorityQueue.cs`
- E-04: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Collections/src/System/Collections/Generic/SortedSet.cs`
- E-05: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Collections/src/System/Collections/Generic/SortedSet.TreeSubSet.cs`
- E-06: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Collections/src/System/Collections/Generic/SortedList.cs`
- E-07: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Collections/src/System/Collections/Generic/SortedDictionary.cs`
- E-08: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Collections/src/System/Collections/Generic/OrderedDictionary.cs`
- E-09: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Collections/src/System/Collections/StructuralComparisons.cs`
- E-10: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Collections/src/System/Collections/ThrowHelper.cs`
- E-11: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Collections/src/System/Collections/Generic/SortedSetEqualityComparer.cs`
- E-12: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Collections/src/System/Collections/Generic/StackDebugView.cs`
- E-13: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Collections/src/System/Collections/Generic/PriorityQueueDebugView.cs`
- E-14: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Collections/src/System/Collections/Generic/OrderedDictionaryDebugView.cs`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-001 | LinkedList.AddFirst(T)が空リストに要素を追加できること | E-01 (L114-127) | ○ |
| C-002 | LinkedList.AddFirst(T)が既存リストの先頭に追加できること | E-01 (L114-127) | ○ |
| C-003 | LinkedList.AddLast(T)が空リストに要素を追加できること | E-01 (L145-157) | ○ |
| C-004 | LinkedList.AddLast(T)が既存リストの末尾に追加できること | E-01 (L145-157) | ○ |
| C-005 | LinkedList.AddAfterが指定ノードの後に追加できること | E-01 (L74-80) | ○ |
| C-006 | LinkedList.AddAfterがnullノードで例外をスローすること | E-01 (L76, ValidateNode) | ○ |
| C-007 | LinkedList.AddAfterが別リストのノードで例外をスローすること | E-01 (L430-438, ValidateNode) | ○ |
| C-008 | LinkedList.AddBeforeが指定ノードの前に追加できること | E-01 (L90-100) | ○ |
| C-009 | LinkedList.AddBeforeがHeadノードの前に追加した場合Headが更新されること | E-01 (L95-98) | ○ |
| C-010 | LinkedList.Remove(T)が存在する要素を削除できること | E-01 (L295-304) | ○ |
| C-011 | LinkedList.Remove(T)が存在しない要素でfalseを返すこと | E-01 (L295-304) | ○ |
| C-012 | LinkedList.Remove(LinkedListNode)がnullで例外をスローすること | E-01 (L306-310, ValidateNode) | ○ |
| C-013 | LinkedList.RemoveFirstが先頭要素を削除できること | E-01 (L312-316) | ○ |
| C-014 | LinkedList.RemoveFirstが空リストで例外をスローすること | E-01 (L314) | ○ |
| C-015 | LinkedList.RemoveLastが末尾要素を削除できること | E-01 (L318-322) | ○ |
| C-016 | LinkedList.RemoveLastが空リストで例外をスローすること | E-01 (L320) | ○ |
| C-017 | LinkedList.Clearがすべての要素を削除すること | E-01 (L174-187) | ○ |
| C-018 | LinkedList.Containsが存在する要素でtrueを返すこと | E-01 (L189-192) | ○ |
| C-019 | LinkedList.Containsが存在しない要素でfalseを返すこと | E-01 (L189-192) | ○ |
| C-020 | LinkedList.Containsがnull値を検索できること | E-01 (L221-251, Find) | ○ |
| C-021 | LinkedList.Findが存在する要素のノードを返すこと | E-01 (L221-251) | ○ |
| C-022 | LinkedList.Findが存在しない要素でnullを返すこと | E-01 (L250) | ○ |
| C-023 | LinkedList.FindLastが重複時最後の要素を返すこと | E-01 (L253-287) | ○ |
| C-024 | LinkedList.CopyToが配列に正しくコピーすること | E-01 (L194-219) | ○ |
| C-025 | LinkedList.CopyToがnull配列で例外をスローすること | E-01 (L196) | ○ |
| C-026 | LinkedList.CopyToが配列サイズ不足で例外をスローすること | E-01 (L205-208) | ○ |
| C-027 | LinkedList.GetEnumeratorがすべての要素を列挙すること | E-01 (L289-294) | ○ |
| C-028 | LinkedList.Enumerator.MoveNextがコレクション変更で例外をスローすること | E-01 (L536-540) | ○ |
| C-029 | LinkedListNode.Valueが値の取得と設定ができること | E-01 (L620-624) | ○ |
| C-030 | LinkedListNode.Nextが次のノードを返すこと | E-01 (L610-613) | ○ |
| C-031 | LinkedListNode.Nextが最後のノードでnullを返すこと | E-01 (L612) | ○ |
| C-032 | LinkedListNode.Previousが前のノードを返すこと | E-01 (L615-618) | ○ |
| C-033 | LinkedListNode.Previousが最初のノードでnullを返すこと | E-01 (L617) | ○ |
| C-034 | Stack.Pushが要素を追加できること | E-02 (L266-281) | ○ |
| C-035 | Stack.Pushが複数要素を追加できること | E-02 (L266-281) | ○ |
| C-036 | Stack.Pushが容量超過時に自動拡張すること | E-02 (L283-292, PushWithResize) | ○ |
| C-037 | Stack.Popが最後に追加した要素を取り出すこと | E-02 (L219-242) | ○ |
| C-038 | Stack.Popが空スタックで例外をスローすること | E-02 (L229-232, ThrowForEmptyStack) | ○ |
| C-039 | Stack.Peekが最上位要素を削除せずに取得すること | E-02 (L190-203) | ○ |
| C-040 | Stack.Peekが空スタックで例外をスローすること | E-02 (L197-200, ThrowForEmptyStack) | ○ |
| C-041 | Stack.TryPopが要素存在時にtrueを返すこと | E-02 (L244-263) | ○ |
| C-042 | Stack.TryPopが空スタック時にfalseを返すこと | E-02 (L249-253) | ○ |
| C-043 | Stack.TryPeekが要素存在時にtrueを返すこと | E-02 (L205-217) | ○ |
| C-044 | Stack.TryPeekが空スタック時にfalseを返すこと | E-02 (L210-214) | ○ |
| C-045 | Stack.Clearがすべての要素を削除すること | E-02 (L71-79) | ○ |
| C-046 | Stack.Containsが存在する要素でtrueを返すこと | E-02 (L81-94) | ○ |
| C-047 | Stack.Containsが存在しない要素でfalseを返すこと | E-02 (L81-94) | ○ |
| C-048 | Stack.ToArrayがPop順序で配列を返すこと | E-02 (L331-344) | ○ |
| C-049 | Stack.ToArrayが空スタックで空配列を返すこと | E-02 (L333-334) | ○ |
| C-050 | Stack.EnsureCapacityが指定容量以上に拡張すること | E-02 (L301-311) | ○ |
| C-051 | Stack.EnsureCapacityが負の容量で例外をスローすること | E-02 (L303) | ○ |
| C-052 | Stack.TrimExcessが余分な容量を削減すること | E-02 (L165-172) | ○ |
| C-053 | Stack.TrimExcess(int)が指定容量に設定すること | E-02 (L179-188) | ○ |
| C-054 | Stack.TrimExcess(int)が要素数より小さい容量で例外をスローすること | E-02 (L181-182) | ○ |
| C-055 | Stack.Enumerator.MoveNextがコレクション変更で例外をスローすること | E-02 (L371-374) | ○ |
| C-056 | PriorityQueue.Enqueueが要素を追加できること | E-03 (L193-217) | ○ |
| C-057 | PriorityQueue.Enqueueが優先度順で要素を順序付けること | E-03 (L193-217, MoveUp) | ○ |
| C-058 | PriorityQueue.Dequeueが最小優先度の要素を取り出すこと | E-03 (L239-249) | ○ |
| C-059 | PriorityQueue.Dequeueが空キューで例外をスローすること | E-03 (L241-244) | ○ |
| C-060 | PriorityQueue.Peekが最小優先度の要素を返すこと | E-03 (L224-232) | ○ |
| C-061 | PriorityQueue.Peekが空キューで例外をスローすること | E-03 (L226-229) | ○ |
| C-062 | PriorityQueue.TryDequeueが要素存在時にtrueを返すこと | E-03 (L310-322) | ○ |
| C-063 | PriorityQueue.TryDequeueが空キュー時にfalseを返すこと | E-03 (L318-322) | ○ |
| C-064 | PriorityQueue.TryPeekが要素存在時にtrueを返すこと | E-03 (L336-347) | ○ |
| C-065 | PriorityQueue.TryPeekが空キュー時にfalseを返すこと | E-03 (L343-347) | ○ |
| C-066 | PriorityQueue.EnqueueDequeueが最小優先度の追加で即座に返すこと | E-03 (L361-388) | ○ |
| C-067 | PriorityQueue.EnqueueDequeueが既存最小を返すこと | E-03 (L361-388) | ○ |
| C-068 | PriorityQueue.DequeueEnqueueが最小要素を取り出し新要素を追加すること | E-03 (L263-297) | ○ |
| C-069 | PriorityQueue.DequeueEnqueueが空キューで例外をスローすること | E-03 (L265-268) | ○ |
| C-070 | PriorityQueue.EnqueueRange(items)が複数要素を一括追加できること | E-03 (L397-449) | ○ |
| C-071 | PriorityQueue.EnqueueRange(items)がnullで例外をスローすること | E-03 (L399) | ○ |
| C-072 | PriorityQueue.EnqueueRange(elements, priority)が同一優先度で追加できること | E-03 (L460-498) | ○ |
| C-073 | PriorityQueue.Removeが指定要素を削除できること | E-03 (L514-565) | ○ |
| C-074 | PriorityQueue.Removeが存在しない要素でfalseを返すこと | E-03 (L521-526) | ○ |
| C-075 | PriorityQueue.Clearがすべての要素を削除すること | E-03 (L570-579) | ○ |
| C-076 | PriorityQueue.EnsureCapacityが指定容量以上に拡張すること | E-03 (L590-601) | ○ |
| C-077 | PriorityQueue.TrimExcessが余分な容量を削減すること | E-03 (L611-619) | ○ |
| C-078 | PriorityQueue.カスタムComparerで優先度順序が変わること | E-03 (L91-115, InitializeComparer) | ○ |
| C-079 | PriorityQueue.UnorderedItemsがすべての要素を列挙できること | E-03 (L934-1061) | ○ |
| C-080 | SortedSet.Addが要素を追加できること | E-04 (L299-377) | ○ |
| C-081 | SortedSet.Addが重複要素でfalseを返すこと | E-04 (L329-336) | ○ |
| C-082 | SortedSet.Addが要素をソート順で保持すること | E-04 (L303-377) | ○ |
| C-083 | SortedSet.Removeが存在する要素を削除できること | E-04 (L379-498) | ○ |
| C-084 | SortedSet.Removeが存在しない要素でfalseを返すこと | E-04 (L379-498) | ○ |
| C-085 | SortedSet.Clearがすべての要素を削除すること | E-04 (L500-505) | ○ |
| C-086 | SortedSet.Containsが存在する要素でtrueを返すこと | E-04 (L507) | ○ |
| C-087 | SortedSet.Containsが存在しない要素でfalseを返すこと | E-04 (L507) | ○ |
| C-088 | SortedSet.Minが最小要素を取得できること | E-04 | ○ |
| C-089 | SortedSet.Minが空セットでdefaultを返すこと | E-04 | ○ |
| C-090 | SortedSet.Maxが最大要素を取得できること | E-04 | ○ |
| C-091 | SortedSet.Maxが空セットでdefaultを返すこと | E-04 | ○ |
| C-092 | SortedSet.GetViewBetweenが指定範囲のビューを返すこと | E-04, E-05 | ○ |
| C-093 | SortedSet.GetViewBetweenのビュー変更が元セットに反映されること | E-05 (L52-66) | ○ |
| C-094 | SortedSet.GetViewBetweenが範囲外追加で例外をスローすること | E-05 (L52-57) | ○ |
| C-095 | SortedSet.UnionWithが和集合になること | E-04 (L843-915) | ○ |
| C-096 | SortedSet.UnionWithがnullで例外をスローすること | E-04 (L845) | ○ |
| C-097 | SortedSet.IntersectWithが積集合になること | E-04 (L983-1044) | ○ |
| C-098 | SortedSet.ExceptWithが差集合になること | E-04 (L1065-1101) | ○ |
| C-099 | SortedSet.SymmetricExceptWithが対称差集合になること | E-04 (L1103-1168) | ○ |
| C-100 | SortedSet.IsSubsetOfが部分集合でtrueを返すこと | E-04 (L1170-1192) | ○ |
| C-101 | SortedSet.IsSupersetOfが上位集合でtrueを返すこと | E-04 | ○ |
| C-102 | SortedSet.Overlapsが重複ありでtrueを返すこと | E-04 | ○ |
| C-103 | SortedSet.Overlapsが重複なしでfalseを返すこと | E-04 | ○ |
| C-104 | SortedSet.SetEqualsが同じ要素でtrueを返すこと | E-04 | ○ |
| C-105 | SortedSet.SetEqualsが異なる要素でfalseを返すこと | E-04 | ○ |
| C-106 | SortedSet.カスタムComparerでソート順序が変わること | E-04 (L76-78) | ○ |
| C-107 | SortedSet.CopyToが配列に正しくコピーすること | E-04 (L509-538) | ○ |
| C-108 | SortedList.Addがキーと値を追加できること | E-06 (L179-187) | ○ |
| C-109 | SortedList.Addがキー順でソートすること | E-06 (L179-187, BinarySearch) | ○ |
| C-110 | SortedList.Addが重複キーで例外をスローすること | E-06 (L184-185) | ○ |
| C-111 | SortedList.Addがnullキーで例外をスローすること | E-06 (L181) | ○ |
| C-112 | SortedList.Indexer(get)がキーで値を取得できること | E-06 (L570-593) | ○ |
| C-113 | SortedList.Indexer(get)が存在しないキーで例外をスローすること | E-06 (L578) | ○ |
| C-114 | SortedList.Indexer(set)がキーで値を設定できること | E-06 (L580-593) | ○ |
| C-115 | SortedList.Indexer(set)が存在しないキーを設定すると追加されること | E-06 (L591) | ○ |
| C-116 | SortedList.Removeがキーを削除できること | E-06 (L710-716) | ○ |
| C-117 | SortedList.Removeが存在しないキーでfalseを返すこと | E-06 (L712-715) | ○ |
| C-118 | SortedList.RemoveAtがインデックスで要素を削除できること | E-06 (L686-705) | ○ |
| C-119 | SortedList.RemoveAtが範囲外で例外をスローすること | E-06 (L688-689) | ○ |
| C-120 | SortedList.Clearがすべての要素を削除すること | E-06 (L389-403) | ○ |
| C-121 | SortedList.ContainsKeyが存在するキーでtrueを返すこと | E-06 (L415-418) | ○ |
| C-122 | SortedList.ContainsValueが存在する値でtrueを返すこと | E-06 (L425-428) | ○ |
| C-123 | SortedList.TryGetValueがキー存在時にtrueを返すこと | E-06 (L671-682) | ○ |
| C-124 | SortedList.TryGetValueがキー不存在時にfalseを返すこと | E-06 (L671-682) | ○ |
| C-125 | SortedList.IndexOfKeyがキーのインデックスを返すこと | E-06 (L638-644) | ○ |
| C-126 | SortedList.IndexOfKeyが存在しないキーで-1を返すこと | E-06 (L643) | ○ |
| C-127 | SortedList.IndexOfValueが値のインデックスを返すこと | E-06 (L651-654) | ○ |
| C-128 | SortedList.GetKeyAtIndexがインデックスでキーを返すこと | E-06 (L561-566) | ○ |
| C-129 | SortedList.GetKeyAtIndexが範囲外で例外をスローすること | E-06 (L563-564) | ○ |
| C-130 | SortedList.GetValueAtIndexがインデックスで値を返すこと | E-06 (L524-529) | ○ |
| C-131 | SortedList.SetValueAtIndexがインデックスで値を設定すること | E-06 (L537-543) | ○ |
| C-132 | SortedList.Capacityが容量を取得・設定できること | E-06 (L221-255) | ○ |
| C-133 | SortedList.Capacityが要素数より小さい値で例外をスローすること | E-06 (L231-234) | ○ |
| C-134 | SortedList.TrimExcessが余分な容量を削減すること | E-06 (L734-741) | ○ |
| C-135 | SortedList.Keysがソート順であること | E-06 (L293-324) | ○ |
| C-136 | SortedList.Valuesがキー順で並ぶこと | E-06 (L329-359) | ○ |
| C-137 | SortedDictionary.Addがキーと値を追加できること | E-07 (L189-194) | ○ |
| C-138 | SortedDictionary.Addがキー順でソートすること | E-07 | ○ |
| C-139 | SortedDictionary.Addが重複キーで例外をスローすること | E-07 (L189-194, TreeSet.AddIfNotPresent) | ○ |
| C-140 | SortedDictionary.Addがnullキーで例外をスローすること | E-07 (L191) | ○ |
| C-141 | SortedDictionary.Indexer(get)がキーで値を取得できること | E-07 (L106-119) | ○ |
| C-142 | SortedDictionary.Indexer(get)が存在しないキーで例外をスローすること | E-07 (L115-116) | ○ |
| C-143 | SortedDictionary.Indexer(set)がキーで値を設定できること | E-07 (L120-135) | ○ |
| C-144 | SortedDictionary.Indexer(set)が存在しないキーで追加されること | E-07 (L125-128) | ○ |
| C-145 | SortedDictionary.Removeがキーを削除できること | E-07 (L250-255) | ○ |
| C-146 | SortedDictionary.Removeが存在しないキーでfalseを返すこと | E-07 (L250-255) | ○ |
| C-147 | SortedDictionary.Clearがすべての要素を削除すること | E-07 (L196-199) | ○ |
| C-148 | SortedDictionary.ContainsKeyが存在するキーでtrueを返すこと | E-07 (L201-206) | ○ |
| C-149 | SortedDictionary.ContainsValueが存在する値でtrueを返すこと | E-07 (L208-237) | ○ |
| C-150 | SortedDictionary.ContainsValueが存在しない値でfalseを返すこと | E-07 (L208-237) | ○ |
| C-151 | SortedDictionary.TryGetValueがキー存在時にtrueを返すこと | E-07 (L257-269) | ○ |
| C-152 | SortedDictionary.TryGetValueがキー不存在時にfalseを返すこと | E-07 (L262-266) | ○ |
| C-153 | SortedDictionary.Keysがソート順であること | E-07 (L153-160) | ○ |
| C-154 | SortedDictionary.Valuesがキー順で並ぶこと | E-07 (L171-178) | ○ |
| C-155 | SortedDictionary.CopyToが配列に正しくコピーすること | E-07 (L239-242) | ○ |
| C-156 | SortedDictionary.カスタムComparerでソート順序が変わること | E-07 (L54-57) | ○ |
| C-157 | OrderedDictionary.Addがキーと値を追加できること | E-08 (L479-484) | ○ |
| C-158 | OrderedDictionary.Addが追加順序を保持すること | E-08 (L391-472) | ○ |
| C-159 | OrderedDictionary.Addが重複キーで例外をスローすること | E-08 (L412-414) | ○ |
| C-160 | OrderedDictionary.Addがnullキーで例外をスローすること | E-08 (L481) | ○ |
| C-161 | OrderedDictionary.TryAddがキー不存在時にtrueを返すこと | E-08 (L491-504) | ○ |
| C-162 | OrderedDictionary.TryAddがキー存在時にfalseを返すこと | E-08 (L416-420) | ○ |
| C-163 | OrderedDictionary.Insertが指定インデックスに挿入できること | E-08 (L718-728) | ○ |
| C-164 | OrderedDictionary.Insertが範囲外で例外をスローすること | E-08 (L720-723) | ○ |
| C-165 | OrderedDictionary.Insertが重複キーで例外をスローすること | E-08 (L412-414) | ○ |
| C-166 | OrderedDictionary.Indexer(TKey)がキーで値を取得できること | E-08 (L359-369) | ○ |
| C-167 | OrderedDictionary.Indexer(TKey)が存在しないキーで例外をスローすること | E-08 (L363-366) | ○ |
| C-168 | OrderedDictionary.Indexer(TKey)が値設定で順序を変えないこと | E-08 (L370-377, L407-410) | ○ |
| C-169 | OrderedDictionary.GetAtがインデックスでKVPを返すこと | E-08 (L589-600) | ○ |
| C-170 | OrderedDictionary.GetAtが範囲外で例外をスローすること | E-08 (L591-594) | ○ |
| C-171 | OrderedDictionary.SetAt(int, TValue)がインデックスで値を設定できること | E-08 (L793-800) | ○ |
| C-172 | OrderedDictionary.SetAt(int, TKey, TValue)がキーと値を置換できること | E-08 | △ |
| C-173 | OrderedDictionary.SetAt(int, TKey, TValue)が既存別キーで例外をスローすること | E-08 | △ |
| C-174 | OrderedDictionary.IndexOfがキーのインデックスを返すこと | E-08 (L602-612) | ○ |
| C-175 | OrderedDictionary.IndexOfが存在しないキーで-1を返すこと | E-08 (L696-698) | ○ |
| C-176 | OrderedDictionary.Remove(TKey)がキーを削除できること | E-08 (L734) | ○ |
| C-177 | OrderedDictionary.Remove(TKey)が削除後も順序を保持すること | E-08 (L765-787) | ○ |
| C-178 | OrderedDictionary.Remove(TKey, out TValue)が削除された値を取得できること | E-08 (L741-760) | ○ |
| C-179 | OrderedDictionary.RemoveAtがインデックスで要素を削除できること | E-08 (L765-787) | ○ |
| C-180 | OrderedDictionary.RemoveAtが範囲外で例外をスローすること | E-08 (L767-771) | ○ |
| C-181 | OrderedDictionary.Clearがすべての要素を削除すること | E-08 (L528-539) | ○ |
| C-182 | OrderedDictionary.ContainsKeyが存在するキーでtrueを返すこと | E-08 (L545) | ○ |
| C-183 | OrderedDictionary.ContainsValueが存在する値でtrueを返すこと | E-08 (L550-583) | ○ |
| C-184 | OrderedDictionary.TryGetValueがキー存在時にtrueを返すこと | E-08 | ○ |
| C-185 | OrderedDictionary.TryGetValueがキー不存在時にfalseを返すこと | E-08 | ○ |
| C-186 | OrderedDictionary.Keysが挿入順であること | E-08 (L255-264) | ○ |
| C-187 | OrderedDictionary.Valuesが挿入順であること | E-08 (L267-276) | ○ |
| C-188 | OrderedDictionary.Capacityが容量を取得できること | E-08 (L212) | ○ |
| C-189 | OrderedDictionary.EnsureCapacityが指定容量以上に拡張すること | E-08 | △ |
| C-190 | OrderedDictionary.TrimExcessが余分な容量を削減すること | E-08 | △ |
| C-191 | OrderedDictionary.カスタムComparerでキー比較ができること | E-08 (L115-131) | ○ |
| C-192 | StructuralComparisons.StructuralComparerが配列の構造的比較ができること | E-09 (L58-76) | ○ |
| C-193 | StructuralComparisons.StructuralComparerが異なる配列で非0を返すこと | E-09 (L62-74) | ○ |
| C-194 | StructuralComparisons.StructuralComparerがnull同士で0を返すこと | E-09 (L64) | ○ |
| C-195 | StructuralComparisons.StructuralEqualityComparerが配列の等価比較ができること | E-09 (L15-41) | ○ |
| C-196 | StructuralComparisons.StructuralEqualityComparerが異なる配列でfalseを返すこと | E-09 (L19-41) | ○ |
| C-197 | StructuralComparisons.StructuralEqualityComparerのGetHashCodeが一貫した値を返すこと | E-09 (L43-55) | ○ |
| C-198 | TreeSet.AddIfNotPresentが要素を追加できること | E-07 (L891-899) | ○ |
| C-199 | TreeSet.AddIfNotPresentが重複要素で例外をスローすること | E-07 (L894-898) | ○ |
| C-200 | SortedSetEqualityComparer.Equalsが同じ要素でtrueを返すこと | E-11 (L31) | △ |

## 4) 不足情報（Unknown / Missing）
- **OrderedDictionary.SetAt(int, TKey, TValue)**：ファイルの全体を読み込めなかったため、メソッドの正確なシグネチャを確認できていない
  - 候補：SetAt / SetAtIndex / 類似メソッド
- **OrderedDictionary.EnsureCapacity / TrimExcess**：800行目以降の実装を確認できていない
  - 候補：EnsureCapacity / TrimExcess / Resize
- **SortedSetEqualityComparer**：内部クラスであるため、publicテストとして適切かどうか要確認

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 大部分のテストケースはソースコードから直接根拠を確認できた
- 1: 中リスク - OrderedDictionaryの一部メソッドについてはファイルサイズの制限により完全な検証ができていない
- 0: 低リスク - 集合演算（Union, Intersect, Except等）はSortedSetの実装から確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] LinkedList関連テストケース（C-001〜C-033）の前提条件と期待結果の妥当性確認
- [ ] Stack/PriorityQueueの境界値テスト（空コレクション、容量超過）が適切にカバーされているか確認
- [ ] SortedSet/SortedDictionary/SortedListのソート順序テストが適切か確認
- [ ] OrderedDictionaryの順序保持テストが挿入・削除・更新すべてのシナリオをカバーしているか確認
- [ ] TreeSetの重複検出テスト（C-199）がSortedSetとの差異を正しく表現しているか確認
- [ ] 根拠なし項目（C-172, C-173, C-189, C-190, C-200）について、実装確認後にテストケースを修正する必要があるか判断
