---
generated_at: 2026-01-30 12:00:00
metrics:
  claims_total: 128
  claims_with_evidence: 128
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：libraries-System.ComponentModel.Annotations 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各テストケースに対して、ソースコード内の実装が根拠（Evidence）として存在するか
2. **根拠との整合性**：テストケースの内容が実装コードと矛盾していないか
3. **網羅性**：主要なクラス・メソッドのテストケースが適切にカバーされているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：128 / 128、根拠なし：0
- 優先レビュー（高）
  1. **全テストケースに根拠あり** - ソースコードから直接抽出

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/libraries/System.ComponentModel.Annotations/src/System/ComponentModel/DataAnnotations/ValidationAttribute.cs`
- E-02: `src/libraries/System.ComponentModel.Annotations/src/System/ComponentModel/DataAnnotations/RequiredAttribute.cs`
- E-03: `src/libraries/System.ComponentModel.Annotations/src/System/ComponentModel/DataAnnotations/RangeAttribute.cs`
- E-04: `src/libraries/System.ComponentModel.Annotations/src/System/ComponentModel/DataAnnotations/StringLengthAttribute.cs`
- E-05: `src/libraries/System.ComponentModel.Annotations/src/System/ComponentModel/DataAnnotations/RegularExpressionAttribute.cs`
- E-06: `src/libraries/System.ComponentModel.Annotations/src/System/ComponentModel/DataAnnotations/EmailAddressAttribute.cs`
- E-07: `src/libraries/System.ComponentModel.Annotations/src/System/ComponentModel/DataAnnotations/CompareAttribute.cs`
- E-08: `src/libraries/System.ComponentModel.Annotations/src/System/ComponentModel/DataAnnotations/MaxLengthAttribute.cs`
- E-09: `src/libraries/System.ComponentModel.Annotations/src/System/ComponentModel/DataAnnotations/MinLengthAttribute.cs`
- E-10: `src/libraries/System.ComponentModel.Annotations/src/System/ComponentModel/DataAnnotations/LengthAttribute.cs`
- E-11: `src/libraries/System.ComponentModel.Annotations/src/System/ComponentModel/DataAnnotations/AllowedValuesAttribute.cs`
- E-12: `src/libraries/System.ComponentModel.Annotations/src/System/ComponentModel/DataAnnotations/DeniedValuesAttribute.cs`
- E-13: `src/libraries/System.ComponentModel.Annotations/src/System/ComponentModel/DataAnnotations/DataTypeAttribute.cs`
- E-14: `src/libraries/System.ComponentModel.Annotations/src/System/ComponentModel/DataAnnotations/CustomValidationAttribute.cs`
- E-15: `src/libraries/System.ComponentModel.Annotations/src/System/ComponentModel/DataAnnotations/Validator.cs`
- E-16: `src/libraries/System.ComponentModel.Annotations/src/System/ComponentModel/DataAnnotations/ValidationContext.cs`
- E-17: `src/libraries/System.ComponentModel.Annotations/src/System/ComponentModel/DataAnnotations/ValidationResult.cs`
- E-18: `src/libraries/System.ComponentModel.Annotations/src/System/ComponentModel/DataAnnotations/DisplayAttribute.cs`
- E-19: `src/libraries/System.ComponentModel.Annotations/src/System/ComponentModel/DataAnnotations/Schema/ColumnAttribute.cs`
- E-20: `src/libraries/System.ComponentModel.Annotations/src/System/ComponentModel/DataAnnotations/Schema/TableAttribute.cs`

## 3) Claims と根拠の対応（レビューの主戦場）

### ValidationAttribute（UT-SCA-001 〜 UT-SCA-010）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ValidationAttribute.IsValid - 有効な値でtrue | E-01: IsValid(object)メソッド実装 (L352-365) | ○ |
| C-02 | ValidationAttribute.IsValid - 無効な値でfalse | E-01: IsValid(object, ValidationContext)メソッド実装 (L389-402) | ○ |
| C-03 | FormatErrorMessage - エラーメッセージフォーマット | E-01: FormatErrorMessage(string)メソッド実装 (L330-331) | ○ |
| C-04 | GetValidationResult - 成功時Success | E-01: GetValidationResult(object, ValidationContext)メソッド実装 (L430-447) | ○ |
| C-05 | GetValidationResult - 失敗時ValidationResult | E-01: GetValidationResult実装でnull以外を返す (L437-443) | ○ |
| C-06 | GetValidationResult - null引数でArgumentNullException | E-01: ArgumentNullException.ThrowIfNull(validationContext) (L432) | ○ |
| C-07 | Validate(object, string) - 有効値で例外なし | E-01: Validate(object, string)メソッド実装 (L468-474) | ○ |
| C-08 | Validate(object, string) - 無効値でValidationException | E-01: throw new ValidationException (L472) | ○ |
| C-09 | ErrorMessageResourceAccessor - リソースからメッセージ取得 | E-01: SetResourceAccessorByPropertyLookup()メソッド (L262-296) | ○ |
| C-10 | ErrorMessage/ResourceNameの排他制御 | E-01: SetupResourceAccessor()での検証 (L234-238) | ○ |

### RequiredAttribute（UT-SCA-011 〜 UT-SCA-015）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-11 | IsValid - 非null値でtrue | E-02: IsValid実装 (L38-47) | ○ |
| C-12 | IsValid - null値でfalse | E-02: if (value is null) return false (L40-43) | ○ |
| C-13 | IsValid - 空文字列でfalse（デフォルト） | E-02: AllowEmptyStrings判定 (L46) | ○ |
| C-14 | IsValid - AllowEmptyStrings=trueで空文字列許可 | E-02: AllowEmptyStringsプロパティ (L28) | ○ |
| C-15 | IsValid - 空白文字のみでfalse | E-02: string.IsNullOrWhiteSpace判定 (L46) | ○ |

### RangeAttribute（UT-SCA-016 〜 UT-SCA-027）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-16 | IsValid - 範囲内整数でtrue | E-03: IsValid実装 (L131-170) | ○ |
| C-17 | IsValid - 下限未満でfalse | E-03: min.CompareTo(convertedValue)判定 (L167-169) | ○ |
| C-18 | IsValid - 上限超過でfalse | E-03: max.CompareTo(convertedValue)判定 (L167-169) | ○ |
| C-19 | IsValid - 最小値でtrue（包含） | E-03: MinimumIsExclusive判定 (L168) | ○ |
| C-20 | IsValid - 最大値でtrue（包含） | E-03: MaximumIsExclusive判定 (L169) | ○ |
| C-21 | IsValid - MinimumIsExclusive=trueで最小値false | E-03: MinimumIsExclusiveプロパティ (L77) | ○ |
| C-22 | IsValid - MaximumIsExclusive=trueで最大値false | E-03: MaximumIsExclusiveプロパティ (L82) | ○ |
| C-23 | IsValid - double範囲検証 | E-03: コンストラクタ(double, double) (L35-42) | ○ |
| C-24 | IsValid - null許可 | E-03: if (value is null or string { Length: 0 }) return true (L137-140) | ○ |
| C-25 | IsValid - 空文字列許可 | E-03: string { Length: 0 }判定 (L137) | ○ |
| C-26 | SetupConversion - min>maxでInvalidOperationException | E-03: Initialize内のcmp比較 (L110-118) | ○ |
| C-27 | IsValid - 型変換失敗でfalse | E-03: FormatException/InvalidCastException catch (L148-159) | ○ |

### StringLengthAttribute（UT-SCA-028 〜 UT-SCA-035）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-28 | IsValid - 最大長以内でtrue | E-04: IsValid実装 (L45-59) | ○ |
| C-29 | IsValid - 最大長超過でfalse | E-04: length <= MaximumLength判定 (L58) | ○ |
| C-30 | IsValid - 最大長と等しい長さでtrue | E-04: <=演算子による包含判定 (L58) | ○ |
| C-31 | IsValid - MinimumLength以上でtrue | E-04: length >= MinimumLength判定 (L58) | ○ |
| C-32 | IsValid - MinimumLength未満でfalse | E-04: MinimumLengthプロパティ (L33) | ○ |
| C-33 | IsValid - null許可 | E-04: if (value == null) return true (L52-55) | ○ |
| C-34 | EnsureLegalLengths - 負のMaximumLengthでException | E-04: if (MaximumLength < 0) throw (L86-89) | ○ |
| C-35 | EnsureLegalLengths - MaximumLength<MinimumLengthでException | E-04: if (MaximumLength < MinimumLength) throw (L91-94) | ○ |

### RegularExpressionAttribute（UT-SCA-036 〜 UT-SCA-042）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-36 | IsValid - パターン一致でtrue | E-05: IsValid実装 (L56-77) | ○ |
| C-37 | IsValid - パターン不一致でfalse | E-05: EnumerateMatchesで完全一致判定 (L69-76) | ○ |
| C-38 | IsValid - null許可 | E-05: if (string.IsNullOrEmpty(stringValue)) return true (L64-67) | ○ |
| C-39 | IsValid - 空文字列許可 | E-05: IsNullOrEmpty判定 (L64) | ○ |
| C-40 | SetupRegex - 空パターンでInvalidOperationException | E-05: if (string.IsNullOrEmpty(Pattern)) throw (L106-109) | ○ |
| C-41 | SetupRegex - nullパターンでInvalidOperationException | E-05: Pattern null判定 (L106) | ○ |
| C-42 | MatchTimeout - タイムアウト設定 | E-05: MatchTimeoutInMillisecondsプロパティ (L32) | ○ |

### EmailAddressAttribute（UT-SCA-043 〜 UT-SCA-049）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-43 | IsValid - 有効なメールアドレスでtrue | E-06: IsValid実装 (L18-43) | ○ |
| C-44 | IsValid - @なしでfalse | E-06: int index = valueAsString.IndexOf('@') (L37) | ○ |
| C-45 | IsValid - @先頭でfalse | E-06: index > 0判定 (L40) | ○ |
| C-46 | IsValid - @末尾でfalse | E-06: index != valueAsString.Length - 1判定 (L41) | ○ |
| C-47 | IsValid - 複数@でfalse | E-06: index == valueAsString.LastIndexOf('@')判定 (L42) | ○ |
| C-48 | IsValid - 改行文字でfalse | E-06: ContainsAny('\r', '\n')判定 (L30-33) | ○ |
| C-49 | IsValid - null許可 | E-06: if (value == null) return true (L20-23) | ○ |

### CompareAttribute（UT-SCA-050 〜 UT-SCA-053）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-50 | IsValid - 値一致でSuccess | E-07: if (!Equals(value, otherPropertyValue))判定 (L49) | ○ |
| C-51 | IsValid - 値不一致でValidationResult | E-07: return new ValidationResult (L56) | ○ |
| C-52 | IsValid - プロパティ不存在でValidationResult | E-07: if (otherPropertyInfo == null) return new ValidationResult (L39-42) | ○ |
| C-53 | RequiresValidationContext - true | E-07: override bool RequiresValidationContext => true (L26) | ○ |

### MaxLengthAttribute（UT-SCA-054 〜 UT-SCA-061）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-54 | IsValid - 最大長以内文字列でtrue | E-08: IsValid実装 (L66-88) | ○ |
| C-55 | IsValid - 最大長超過文字列でfalse | E-08: length <= Length判定 (L87) | ○ |
| C-56 | IsValid - 最大長以内コレクションでtrue | E-08: CountPropertyHelper.TryGetCount (L82-85) | ○ |
| C-57 | IsValid - 最大長超過コレクションでfalse | E-08: length <= Length判定 (L87) | ○ |
| C-58 | IsValid - null許可 | E-08: if (value == null) return true (L73-76) | ○ |
| C-59 | IsValid - Length=-1で任意長許可 | E-08: MaxAllowableLength == Length (L87) | ○ |
| C-60 | EnsureLegalLengths - Length=0でException | E-08: if (Length == 0 || Length < -1) throw (L105-108) | ○ |
| C-61 | EnsureLegalLengths - Length<-1でException | E-08: Length < -1判定 (L105) | ○ |

### MinLengthAttribute（UT-SCA-062 〜 UT-SCA-066）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-62 | IsValid - 最小長以上でtrue | E-09: IsValid実装 (L49-71) | ○ |
| C-63 | IsValid - 最小長未満でfalse | E-09: length >= Length判定 (L70) | ○ |
| C-64 | IsValid - コレクション長検証 | E-09: CountPropertyHelper.TryGetCount (L65) | ○ |
| C-65 | IsValid - null許可 | E-09: if (value == null) return true (L56-59) | ○ |
| C-66 | EnsureLegalLengths - 負のLengthでException | E-09: if (Length < 0) throw (L88-91) | ○ |

### LengthAttribute（UT-SCA-067 〜 UT-SCA-072）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-67 | IsValid - 範囲内長さでtrue | E-10: IsValid実装 (L49-71) | ○ |
| C-68 | IsValid - 最小長未満でfalse | E-10: (uint)(length - MinimumLength)判定 (L70) | ○ |
| C-69 | IsValid - 最大長超過でfalse | E-10: <= (uint)(MaximumLength - MinimumLength)判定 (L70) | ○ |
| C-70 | IsValid - null許可 | E-10: if (value is null) return true (L56-59) | ○ |
| C-71 | EnsureLegalLengths - 負のMinimumLengthでException | E-10: if (MinimumLength < 0) throw (L88-91) | ○ |
| C-72 | EnsureLegalLengths - MaximumLength<MinimumLengthでException | E-10: if (MaximumLength < MinimumLength) throw (L93-96) | ○ |

### AllowedValuesAttribute（UT-SCA-073 〜 UT-SCA-076）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-73 | IsValid - 許可値でtrue | E-11: IsValid実装 (L44-55) | ○ |
| C-74 | IsValid - 非許可値でfalse | E-11: return false (L54) | ○ |
| C-75 | IsValid - null含む許可リストでnull許可 | E-11: allowed is null ? value is null判定 (L48) | ○ |
| C-76 | IsValid - null含まない許可リストでnull拒否 | E-11: foreachループでfalse return (L54) | ○ |

### DeniedValuesAttribute（UT-SCA-077 〜 UT-SCA-080）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-77 | IsValid - 非拒否値でtrue | E-12: IsValid実装 (L44-55) | ○ |
| C-78 | IsValid - 拒否値でfalse | E-12: return false (L50) | ○ |
| C-79 | IsValid - null含まない拒否リストでnull許可 | E-12: return true (L54) | ○ |
| C-80 | IsValid - null含む拒否リストでnull拒否 | E-12: denied is null ? value is null判定 (L48) | ○ |

### DataTypeAttribute（UT-SCA-081 〜 UT-SCA-085）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-81 | IsValid - 常にtrue | E-13: return true (L108) | ○ |
| C-82 | GetDataTypeName - enum名返却 | E-13: _dataTypeStrings[(int)DataType] (L94) | ○ |
| C-83 | GetDataTypeName - カスタム型名返却 | E-13: return CustomDataType! (L90) | ○ |
| C-84 | EnsureValidDataType - 空CustomDataTypeでException | E-13: if (string.IsNullOrWhiteSpace(CustomDataType)) throw (L117-120) | ○ |
| C-85 | DisplayFormat - Date時の設定 | E-13: case DataType.Date: DisplayFormat設定 (L31-35) | ○ |

### CustomValidationAttribute（UT-SCA-086 〜 UT-SCA-090）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-86 | IsValid - 成功でSuccess | E-14: IsValid実装 (L137-185) | ○ |
| C-87 | IsValid - エラーでValidationResult | E-14: return result (L179) | ○ |
| C-88 | ValidatorType - nullでException | E-14: ValidateValidatorTypeParameter() (L217-229) | ○ |
| C-89 | Method - 空でException | E-14: if (string.IsNullOrEmpty(Method)) return error (L238-241) | ○ |
| C-90 | Method - 存在しないでException | E-14: if (methodInfo == null) return error (L246-249) | ○ |

### Validator（UT-SCA-091 〜 UT-SCA-099）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-91 | TryValidateProperty - 有効値でtrue | E-15: TryValidateProperty実装 (L49-70) | ○ |
| C-92 | TryValidateProperty - 無効値でfalse | E-15: result = false (L64) | ○ |
| C-93 | TryValidateObject - 有効オブジェクトでtrue | E-15: TryValidateObject実装 (L133-154) | ○ |
| C-94 | TryValidateObject - 無効オブジェクトでfalse | E-15: result = false (L148) | ○ |
| C-95 | TryValidateObject - 全プロパティ検証 | E-15: validateAllPropertiesパラメータ (L134) | ○ |
| C-96 | ValidateProperty - 有効値で例外なし | E-15: ValidateProperty実装 (L216-229) | ○ |
| C-97 | ValidateProperty - 無効値でException | E-15: errors[0].ThrowValidationException() (L227) | ○ |
| C-98 | ValidateObject - nullでArgumentNullException | E-15: ArgumentNullException.ThrowIfNull(instance) (L279) | ○ |
| C-99 | ValidateObject - インスタンス不一致でArgumentException | E-15: if (instance != validationContext.ObjectInstance) throw (L282-285) | ○ |

### ValidationContext（UT-SCA-100 〜 UT-SCA-107）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-100 | コンストラクタ - インスタンスから生成 | E-16: コンストラクタ実装 (L87-99) | ○ |
| C-101 | コンストラクタ - null instanceでException | E-16: ArgumentNullException.ThrowIfNull(instance) (L89) | ○ |
| C-102 | DisplayName - 設定値返却 | E-16: DisplayNameプロパティ (L168-190) | ○ |
| C-103 | DisplayName - MemberNameフォールバック | E-16: GetDisplayName() (L174) | ○ |
| C-104 | DisplayName - 空文字列でException | E-16: throw new ArgumentNullException (L186-187) | ○ |
| C-105 | GetService - サービス取得 | E-16: GetService実装 (L265) | ○ |
| C-106 | GetService - 未設定でnull | E-16: _serviceProvider?.Invoke (L265) | ○ |
| C-107 | Items - 辞書利用可能 | E-16: Items => _items (L208) | ○ |

### ValidationResult（UT-SCA-108 〜 UT-SCA-111）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-108 | コンストラクタ - エラーメッセージから生成 | E-17: コンストラクタ(string?) (L40-43) | ○ |
| C-109 | コンストラクタ - メッセージとメンバー名から生成 | E-17: コンストラクタ(string?, IEnumerable<string>?) (L57-61) | ○ |
| C-110 | MemberNames - nullで空配列 | E-17: Array.Empty<string>() (L60) | ○ |
| C-111 | ToString - ErrorMessage返却 | E-17: ToString()実装 (L107) | ○ |

### DisplayAttribute（UT-SCA-112 〜 UT-SCA-118）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-112 | GetName - Name返却 | E-18: GetName()実装 (L332) | ○ |
| C-113 | GetShortName - ShortName返却 | E-18: GetShortName()実装 (L305) | ○ |
| C-114 | GetShortName - Nameフォールバック | E-18: ?? GetName() (L305) | ○ |
| C-115 | GetDescription - Description返却 | E-18: GetDescription()実装 (L355) | ○ |
| C-116 | GetOrder - Order返却 | E-18: GetOrder()実装 (L439) | ○ |
| C-117 | Order - 未設定でException | E-18: throw new InvalidOperationException (L266-270) | ○ |
| C-118 | AutoGenerateField - 未設定でException | E-18: throw new InvalidOperationException (L208-213) | ○ |

### Schema Attributes（UT-SCA-119 〜 UT-SCA-128）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-119 | ColumnAttribute - 列名から生成 | E-19: コンストラクタ(string) (L29-33) | ○ |
| C-120 | ColumnAttribute - 空列名でException | E-19: ArgumentException.ThrowIfNullOrWhiteSpace (L31) | ○ |
| C-121 | ColumnAttribute.Order - 設定可能 | E-19: Orderプロパティ (L43-52) | ○ |
| C-122 | ColumnAttribute.Order - 負でException | E-19: ArgumentOutOfRangeException.ThrowIfNegative (L48) | ○ |
| C-123 | ColumnAttribute.TypeName - 設定可能 | E-19: TypeNameプロパティ (L58-66) | ○ |
| C-124 | ColumnAttribute.TypeName - 空でException | E-19: ArgumentException.ThrowIfNullOrWhiteSpace (L63) | ○ |
| C-125 | TableAttribute - テーブル名から生成 | E-20: コンストラクタ(string) (L21-25) | ○ |
| C-126 | TableAttribute - 空テーブル名でException | E-20: ArgumentException.ThrowIfNullOrWhiteSpace (L23) | ○ |
| C-127 | TableAttribute.Schema - 設定可能 | E-20: Schemaプロパティ (L36-44) | ○ |
| C-128 | TableAttribute.Schema - 空でException | E-20: ArgumentException.ThrowIfNullOrWhiteSpace (L41) | ○ |

## 4) 不足情報（Unknown / Missing）
- 根拠なしの項目なし
- 全テストケースがソースコードの実装から直接導出されている

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全テストケースに明確な根拠あり
- 既存のテストファイル（tests/配下）との整合性は別途確認を推奨

## 6) レビュアーチェックリスト（最小）
- [ ] 各バリデーション属性のIsValidメソッドのテストケースが正常系・異常系・境界値を網羅しているか
- [ ] 例外がスローされるケースのテストが適切に定義されているか
- [ ] ValidationContext依存のテストケースでコンテキスト設定が適切か
- [ ] Schema関連属性のテストケースでプロパティ設定の検証が含まれているか
- [ ] テストID命名規則（UT-SCA-XXX）が正しく適用されているか
