---
generated_at: 2026-01-30 12:00:00
metrics:
  claims_total: 180
  claims_with_evidence: 175
  claims_without_evidence: 5
confidence_derived: 0.97
---

# 根拠レポート：libraries-System.ComponentModel.Composition 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：175 / 180、根拠なし：5
- 優先レビュー（高）
  1. **UT-CMP-091**: SatisfyImportsOnceの完全な動作検証には追加テストが必要
  2. **UT-CMP-178**: TryMakeGenericPartDefinitionのジェネリック特殊化ロジックの詳細
  3. **UT-CMP-069**: ContractBasedImportDefinition.IsConstraintSatisfiedByの最適化パス

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `src/libraries/System.ComponentModel.Composition/src/System/ComponentModel/Composition/CompositionException.cs`
- E-02: `src/libraries/System.ComponentModel.Composition/src/System/ComponentModel/Composition/CompositionError.cs`
- E-03: `src/libraries/System.ComponentModel.Composition/src/System/ComponentModel/Composition/Primitives/ComposablePartCatalog.cs`
- E-04: `src/libraries/System.ComponentModel.Composition/src/System/ComponentModel/Composition/Primitives/ComposablePart.cs`
- E-05: `src/libraries/System.ComponentModel.Composition/src/System/ComponentModel/Composition/Primitives/Export.cs`
- E-06: `src/libraries/System.ComponentModel.Composition/src/System/ComponentModel/Composition/Primitives/ExportDefinition.cs`
- E-07: `src/libraries/System.ComponentModel.Composition/src/System/ComponentModel/Composition/Primitives/ImportDefinition.cs`
- E-08: `src/libraries/System.ComponentModel.Composition/src/System/ComponentModel/Composition/Primitives/ContractBasedImportDefinition.cs`
- E-09: `src/libraries/System.ComponentModel.Composition/src/System/ComponentModel/Composition/Hosting/CompositionContainer.cs`
- E-10: `src/libraries/System.ComponentModel.Composition/src/System/ComponentModel/Composition/Hosting/ExportProvider.cs`
- E-11: `src/libraries/System.ComponentModel.Composition/src/System/ComponentModel/Composition/Hosting/TypeCatalog.cs`
- E-12: `src/libraries/System.ComponentModel.Composition/src/System/ComponentModel/Composition/Hosting/AggregateCatalog.cs`
- E-13: `src/libraries/System.ComponentModel.Composition/src/System/ComponentModel/Composition/Hosting/CompositionBatch.cs`
- E-14: `src/libraries/System.ComponentModel.Composition/src/System/ComponentModel/Composition/ImportCardinalityMismatchException.cs`
- E-15: `src/libraries/System.ComponentModel.Composition/src/System/ComponentModel/Composition/Primitives/ComposablePartException.cs`
- E-16: `src/libraries/System.ComponentModel.Composition/src/System/ComponentModel/Composition/ExportAttribute.cs`
- E-17: `src/libraries/System.ComponentModel.Composition/src/System/ComponentModel/Composition/ReflectionModel/LazyMemberInfo.cs`
- E-18: `src/libraries/System.ComponentModel.Composition/src/System/ComponentModel/Composition/ReflectionModel/ReflectionModelServices.cs`

## 3) Claims と根拠の対応（レビューの主戦場）

### CompositionException関連 (UT-CMP-001 - UT-CMP-009)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | デフォルトコンストラクタの動作 | E-01 (line 29-32) | ○ |
| C-02 | メッセージ付きコンストラクタの動作 | E-01 (line 43-46) | ○ |
| C-03 | 内部例外付きコンストラクタの動作 | E-01 (line 63-66) | ○ |
| C-04 | エラーコレクション付きコンストラクタの動作 | E-01 (line 86-89) | ○ |
| C-05 | errorsのnull要素検証 | E-01 (line 94) | ○ |
| C-06 | 空のErrorsコレクション | E-01 (line 122-128) | ○ |
| C-07 | Messageプロパティの動的構築 | E-01 (line 118-132) | ○ |
| C-08 | 基底クラスMessageの利用 | E-01 (line 122-128) | ○ |
| C-09 | RootCausesの抽出ロジック | E-01 (line 134-158) | ○ |

### CompositionError関連 (UT-CMP-010 - UT-CMP-016)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-10 | メッセージ付きコンストラクタ | E-02 (line 31-34) | ○ |
| C-11 | nullメッセージ時の空文字設定 | E-02 (line 106) | ○ |
| C-12 | Element設定 | E-02 (line 52-55) | ○ |
| C-13 | Exception設定 | E-02 (line 72-75) | ○ |
| C-14 | Descriptionプロパティ | E-02 (line 130-133) | ○ |
| C-15 | ToString実装 | E-02 (line 163-166) | ○ |
| C-16 | 静的Createメソッド | E-02 (line 168-181) | ○ |

### ComposablePartCatalog関連 (UT-CMP-017 - UT-CMP-023)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-17 | Partsプロパティの動作 | E-03 (line 52-69) | ○ |
| C-18 | Dispose後のアクセス | E-03 (line 139-146) | ○ |
| C-19 | GetExportsの動作 | E-03 (line 97-118) | ○ |
| C-20 | definitionのnull検証 | E-03 (line 101) | ○ |
| C-21 | 空結果の処理 | E-03 (line 117) | ○ |
| C-22 | Disposeの動作 | E-03 (line 128-137) | ○ |
| C-23 | GetEnumeratorの動作 | E-03 (line 158-166) | ○ |

### ComposablePart関連 (UT-CMP-024 - UT-CMP-031)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-24 | ExportDefinitionsプロパティ | E-04 (line 47) | ○ |
| C-25 | ImportDefinitionsプロパティ | E-04 (line 75) | ○ |
| C-26 | Metadataデフォルト値 | E-04 (line 107-113) | ○ |
| C-27 | Activateデフォルト実装 | E-04 (line 125-127) | ○ |
| C-28 | GetExportedValueの動作 | E-04 (line 157) | ○ |
| C-29 | GetExportedValueのnull検証 | E-04 | ○ |
| C-30 | SetImportの動作 | E-04 (line 206) | ○ |
| C-31 | SetImportのnull検証 | E-04 | ○ |

### Export関連 (UT-CMP-032 - UT-CMP-040)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-32 | 基本コンストラクタ | E-05 (line 58-61) | ○ |
| C-33 | contractNameのnull検証 | E-05 (line 117) | ○ |
| C-34 | 空文字検証 | E-05 (line 56) | ○ |
| C-35 | メタデータ付きコンストラクタ | E-05 (line 91-94) | ○ |
| C-36 | Definitionプロパティ | E-05 (line 140-151) | ○ |
| C-37 | 未オーバーライド時のException | E-05 (line 149) | ○ |
| C-38 | Metadataアクセス | E-05 (line 169-177) | ○ |
| C-39 | Value遅延評価 | E-05 (line 196-209) | ○ |
| C-40 | Valueキャッシュ | E-05 (line 202-208) | ○ |

### ExportDefinition関連 (UT-CMP-041 - UT-CMP-047)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-41 | 基本コンストラクタ | E-06 (line 54-64) | ○ |
| C-42 | contractNameのnull検証 | E-06 (line 56) | ○ |
| C-43 | 空文字検証 | E-06 (line 56) | ○ |
| C-44 | ContractNameプロパティ | E-06 (line 82-93) | ○ |
| C-45 | Metadataプロパティ | E-06 (line 115-123) | ○ |
| C-46 | nullメタデータの処理 | E-06 (line 60-63) | ○ |
| C-47 | ToString実装 | E-06 (line 131-134) | ○ |

### ImportDefinition関連 (UT-CMP-048 - UT-CMP-061)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-48 | 基本コンストラクタ | E-07 (line 81-87) | ○ |
| C-49 | constraintのnull検証 | E-07 (line 84) | ○ |
| C-50 | cardinalityの列挙値検証 | E-07 (line 99-106) | ○ |
| C-51 | ContractNameプロパティ | E-07 (line 129-137) | ○ |
| C-52 | Cardinalityプロパティ | E-07 (line 178-181) | ○ |
| C-53 | Cardinalityデフォルト値 | E-07 (line 20) | ○ |
| C-54 | IsPrerequisiteプロパティ | E-07 (line 222-225) | ○ |
| C-55 | IsPrerequisiteデフォルト値 | E-07 (line 23) | ○ |
| C-56 | IsRecomposableプロパティ | E-07 (line 235-238) | ○ |
| C-57 | IsRecomposableデフォルト値 | E-07 (line 22) | ○ |
| C-58 | Constraintプロパティ | E-07 (line 200-211) | ○ |
| C-59 | IsConstraintSatisfiedBy(true) | E-07 (line 262-269) | ○ |
| C-60 | IsConstraintSatisfiedBy(false) | E-07 (line 262-269) | ○ |
| C-61 | IsConstraintSatisfiedByのnull検証 | E-07 (line 264) | ○ |

### ContractBasedImportDefinition関連 (UT-CMP-062 - UT-CMP-073)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-62 | 基本コンストラクタ | E-08 (line 163-177) | ○ |
| C-63 | RequiredTypeIdentityプロパティ | E-08 (line 187-190) | ○ |
| C-64 | RequiredMetadataプロパティ | E-08 (line 208-218) | ○ |
| C-65 | RequiredMetadataの検証 | E-08 (line 220-234) | ○ |
| C-66 | RequiredCreationPolicyプロパティ | E-08 (line 250-253) | ○ |
| C-67 | RequiredCreationPolicyデフォルト値 | E-08 (line 26) | ○ |
| C-68 | Constraint自動生成 | E-08 (line 272-273) | ○ |
| C-69 | ContractName一致判定 | E-08 (line 295-305) | ○ |
| C-70 | ContractName不一致判定 | E-08 (line 299-302) | ○ |
| C-71 | RequiredMetadata一致判定 | E-08 (line 319-347) | ○ |
| C-72 | RequiredMetadata不足判定 | E-08 (line 324-327) | ○ |
| C-73 | CreationPolicy評価 | E-08 (line 350-357) | ○ |

### CompositionContainer関連 (UT-CMP-074 - UT-CMP-094)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-74 | デフォルトコンストラクタ | E-09 (line 35-38) | ○ |
| C-75 | providers設定 | E-09 (line 53-56) | ○ |
| C-76 | null要素検証 | E-09 (line 178-181) | ○ |
| C-77 | カタログとプロバイダ設定 | E-09 (line 93-96) | ○ |
| C-78 | CompositionOptions設定 | E-09 (line 138-143) | ○ |
| C-79 | 無効オプション検証 | E-09 (line 139-142) | ○ |
| C-80 | Catalogプロパティ | E-09 (line 250-258) | ○ |
| C-81 | Dispose後のアクセス | E-09 (line 601-608) | ○ |
| C-82 | Providersプロパティ | E-09 (line 282-291) | ○ |
| C-83 | Disposeの動作 | E-09 (line 296-366) | ○ |
| C-84 | 二重Dispose対策 | E-09 (line 310-348) | ○ |
| C-85 | Composeの動作 | E-09 (line 368-374) | ○ |
| C-86 | batchのnull検証 | E-09 (line 370) | ○ |
| C-87 | ReleaseExportの動作 | E-09 (line 395-403) | ○ |
| C-88 | exportのnull検証 | E-09 (line 397) | ○ |
| C-89 | ReleaseExportsの動作 | E-09 (line 445-453) | ○ |
| C-90 | null要素検証 | E-09 (line 447) | ○ |
| C-91 | SatisfyImportsOnceの動作 | E-09 (line 514-534) | △ |
| C-92 | GetExportsCore(Any) | E-09 (line 579-585) | ○ |
| C-93 | GetExportsCore(Local) | E-09 (line 586-591) | ○ |
| C-94 | GetExportsCore(NonLocal) | E-09 (line 593-595) | ○ |

### ExportProvider関連 (UT-CMP-095 - UT-CMP-102)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-95 | ExportsChangedイベント | E-10 (line 28, 182-190) | ○ |
| C-96 | ExportsChangingイベント | E-10 (line 33, 198-206) | ○ |
| C-97 | GetExportsの動作 | E-10 (line 63-116) | ○ |
| C-98 | definitionのnull検証 | E-10 (line 99) | ○ |
| C-99 | ExactlyOneで0件 | E-10 (line 108) | ○ |
| C-100 | ExactlyOneで複数件 | E-10 (line 114) | ○ |
| C-101 | TryGetExports成功 | E-10 (line 144-150) | ○ |
| C-102 | TryGetExports失敗 | E-10 (line 148-149) | ○ |

### TypeCatalog関連 (UT-CMP-103 - UT-CMP-113)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-103 | 基本コンストラクタ | E-11 (line 52-54) | ○ |
| C-104 | typesのnull検証 | E-11 (line 76) | ○ |
| C-105 | null要素検証 | E-11 (line 209-212) | ○ |
| C-106 | ReflectionOnly検証 | E-11 (line 214-217) | ○ |
| C-107 | definitionOrigin設定 | E-11 (line 101-110) | ○ |
| C-108 | reflectionContext設定 | E-11 (line 130-139) | ○ |
| C-109 | GetEnumeratorの動作 | E-11 (line 223-227) | ○ |
| C-110 | Dispose後のアクセス | E-11 (line 396-403) | ○ |
| C-111 | GetCandidatePartsの動作 | E-11 (line 287-303) | ○ |
| C-112 | 空ContractNameの処理 | E-11 (line 292-295) | ○ |
| C-113 | ToString実装 | E-11 (line 342-345) | ○ |

### AggregateCatalog関連 (UT-CMP-114 - UT-CMP-123)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-114 | デフォルトコンストラクタ | E-12 (line 27-29) | ○ |
| C-115 | カタログ配列設定 | E-12 (line 46-48) | ○ |
| C-116 | null要素検証 | E-12 (line 65) | ○ |
| C-117 | Catalogsプロパティ | E-12 (line 165-174) | ○ |
| C-118 | Dispose後のアクセス | E-12 (line 221-228) | ○ |
| C-119 | GetExportsの集約 | E-12 (line 119-153) | ○ |
| C-120 | Changedイベント | E-12 (line 73-83) | ○ |
| C-121 | Changingイベント | E-12 (line 88-98) | ○ |
| C-122 | Disposeの動作 | E-12 (line 176-192) | ○ |
| C-123 | GetEnumeratorの動作 | E-12 (line 194-197) | ○ |

### CompositionBatch関連 (UT-CMP-124 - UT-CMP-134)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-124 | デフォルトコンストラクタ | E-13 (line 25-28) | ○ |
| C-125 | 追加・削除部品設定 | E-13 (line 35-64) | ○ |
| C-126 | partsToAddのnull要素検証 | E-13 (line 42-45) | ○ |
| C-127 | PartsToAddプロパティ | E-13 (line 70-81) | ○ |
| C-128 | PartsToRemoveプロパティ | E-13 (line 87-98) | ○ |
| C-129 | AddPartの動作 | E-13 (line 109-122) | ○ |
| C-130 | AddPartのnull検証 | E-13 (line 111) | ○ |
| C-131 | RemovePartの動作 | E-13 (line 133-146) | ○ |
| C-132 | RemovePartのnull検証 | E-13 (line 135) | ○ |
| C-133 | AddExportの動作 | E-13 (line 163-172) | ○ |
| C-134 | AddExportのnull検証 | E-13 (line 165) | ○ |

### Exception関連 (UT-CMP-135 - UT-CMP-140)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-135 | ImportCardinalityMismatchExceptionデフォルト | E-14 (line 23-26) | ○ |
| C-136 | メッセージコンストラクタ | E-14 (line 37-40) | ○ |
| C-137 | 内部例外コンストラクタ | E-14 (line 57-60) | ○ |
| C-138 | ComposablePartExceptionデフォルト | E-15 (line 24-27) | ○ |
| C-139 | Element設定 | E-15 (line 89-92) | ○ |
| C-140 | Elementプロパティ | E-15 (line 148-151) | ○ |

### Attribute関連 (UT-CMP-141 - UT-CMP-146)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-141 | ExportAttributeデフォルト | E-16 (line 30-33) | ○ |
| C-142 | 型指定コンストラクタ | E-16 (line 61-64) | ○ |
| C-143 | 名前指定コンストラクタ | E-16 (line 86-89) | ○ |
| C-144 | 複合コンストラクタ | E-16 (line 116-120) | ○ |
| C-145 | ContractNameプロパティ | E-16 (line 129) | ○ |
| C-146 | ContractTypeプロパティ | E-16 (line 139) | ○ |

### ReflectionModel関連 (UT-CMP-147 - UT-CMP-180)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-147 | LazyMemberInfo MemberInfoコンストラクタ | E-17 (line 17-42) | ○ |
| C-148 | memberのnull検証 | E-17 (line 19) | ○ |
| C-149 | Propertyアクセサ設定 | E-17 (line 27-34) | ○ |
| C-150 | Eventアクセサ設定 | E-17 (line 35-38) | ○ |
| C-151 | MemberTypeとアクセサ配列 | E-17 (line 45-59) | ○ |
| C-152 | サポートされないMemberType | E-17 (line 146-150) | ○ |
| C-153 | 遅延初期化コンストラクタ | E-17 (line 61-69) | ○ |
| C-154 | MemberTypeプロパティ | E-17 (line 71-74) | ○ |
| C-155 | GetAccessorsの動作 | E-17 (line 76-92) | ○ |
| C-156 | 遅延初期化実行 | E-17 (line 78-88) | ○ |
| C-157 | 不正アクセサ検証 | E-17 (line 82-86) | ○ |
| C-158 | Equals(true) | E-17 (line 115-135) | ○ |
| C-159 | Equals(false) | E-17 (line 118-121) | ○ |
| C-160 | GetHashCode | E-17 (line 94-107) | ○ |
| C-161 | GetPartType | E-18 (line 17-28) | ○ |
| C-162 | 非Reflection部品定義検証 | E-18 (line 22-25) | ○ |
| C-163 | IsDisposalRequired | E-18 (line 30-41) | ○ |
| C-164 | GetExportingMember | E-18 (line 43-56) | ○ |
| C-165 | 非Reflectionエクスポート定義検証 | E-18 (line 47-53) | ○ |
| C-166 | GetImportingMember | E-18 (line 58-71) | ○ |
| C-167 | GetImportingParameter | E-18 (line 73-87) | ○ |
| C-168 | IsImportingParameter(true) | E-18 (line 89-102) | ○ |
| C-169 | IsImportingParameter(false) | E-18 (line 101) | ○ |
| C-170 | IsExportFactoryImportDefinition | E-18 (line 104-109) | ○ |
| C-171 | GetExportFactoryProductImportDefinition | E-18 (line 111-124) | ○ |
| C-172 | CreatePartDefinition | E-18 (line 126-144) | ○ |
| C-173 | partTypeのnull検証 | E-18 (line 134) | ○ |
| C-174 | CreateExportDefinition | E-18 (line 146-159) | ○ |
| C-175 | contractNameのnull検証 | E-18 (line 152) | ○ |
| C-176 | CreateImportDefinition(Member) | E-18 (line 161-245) | ○ |
| C-177 | ExportFactoryインポート作成 | E-18 (line 216-229) | ○ |
| C-178 | TryMakeGenericPartDefinition(true) | E-18 (line 302-314) | △ |
| C-179 | TryMakeGenericPartDefinition(false) | E-18 (line 313) | △ |
| C-180 | partDefinitionのnull検証 | E-18 (line 304) | ○ |

## 4) 不足情報（Unknown / Missing）
- **SatisfyImportsOnceの完全な動作検証**: ImportEngineの内部動作に依存するため、追加のモック/統合テストが必要
  - 候補：ImportEngine.cs / RecompositionManager.cs / EngineContext.cs
- **TryMakeGenericPartDefinitionのジェネリック特殊化**: GenericSpecializationPartCreationInfo.csの詳細な動作
  - 候補：GenericSpecializationPartCreationInfo.cs / GenericServices.cs
- **非公開内部クラスのテスト**: ReflectionPartCreationInfo等の内部クラスは直接テスト不可
  - 候補：統合テストまたはReflectionによるアクセス

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - Exception/Attribute関連のコンストラクタとプロパティテスト
- **1: 中リスク** - 遅延初期化やキャッシュ動作のテスト（マルチスレッド環境での挙動）
- **2: 高リスク** - SatisfyImportsOnce、TryMakeGenericPartDefinition（複雑な内部ロジック）

## 6) レビュアーチェックリスト（最小）
- [ ] 各クラスの主要なコンストラクタと引数検証がカバーされているか
- [ ] null/空文字列/境界値のテストケースが含まれているか
- [ ] Disposeパターンのテストが含まれているか（IDisposable実装クラス）
- [ ] イベント発火のテストケースが含まれているか（Changed/Changing等）
- [ ] 例外クラスのシリアライゼーションは現在非推奨のためテストから除外されているが、レガシーサポートが必要な場合は追加検討
- [ ] スレッドセーフ性のテスト（IsThreadSafeオプション使用時）は統合テストで補完が必要
- [ ] ReflectionModelServicesの静的メソッド群は、適切なモックDefinitionを使用したテストが必要
