---
generated_at: 2026-01-30 17:15:00
metrics:
  claims_total: 216
  claims_with_evidence: 216
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：libraries-System.ComponentModel.Primitives 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：216 / 216、根拠なし：0
- 優先レビュー（高）
  1. 全テストケースはソースコードを直接解析して生成されており、根拠は十分
  2. 特に優先的にレビューが必要な項目はなし
  3. ただし、実際のテスト実装時は各APIの動作を実機で確認すること

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.ComponentModel.Primitives/src/System/ComponentModel/Component.cs`
- E-02: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.ComponentModel.Primitives/src/System/ComponentModel/EventHandlerList.cs`
- E-03: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.ComponentModel.Primitives/src/System/ComponentModel/ComponentCollection.cs`
- E-04: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.ComponentModel.Primitives/src/System/ComponentModel/BrowsableAttribute.cs`
- E-05: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.ComponentModel.Primitives/src/System/ComponentModel/CategoryAttribute.cs`
- E-06: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.ComponentModel.Primitives/src/System/ComponentModel/DescriptionAttribute.cs`
- E-07: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.ComponentModel.Primitives/src/System/ComponentModel/DisplayNameAttribute.cs`
- E-08: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.ComponentModel.Primitives/src/System/ComponentModel/DesignOnlyAttribute.cs`
- E-09: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.ComponentModel.Primitives/src/System/ComponentModel/ReadOnlyAttribute.cs`
- E-10: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.ComponentModel.Primitives/src/System/ComponentModel/LocalizableAttribute.cs`
- E-11: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.ComponentModel.Primitives/src/System/ComponentModel/MergablePropertyAttribute.cs`
- E-12: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.ComponentModel.Primitives/src/System/ComponentModel/NotifyParentPropertyAttribute.cs`
- E-13: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.ComponentModel.Primitives/src/System/ComponentModel/ParenthesizePropertyNameAttribute.cs`
- E-14: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.ComponentModel.Primitives/src/System/ComponentModel/ImmutableObjectAttribute.cs`
- E-15: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.ComponentModel.Primitives/src/System/ComponentModel/RefreshPropertiesAttribute.cs`
- E-16: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.ComponentModel.Primitives/src/System/ComponentModel/DesignerAttribute.cs`
- E-17: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.ComponentModel.Primitives/src/System/ComponentModel/DesignerCategoryAttribute.cs`
- E-18: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.ComponentModel.Primitives/src/System/ComponentModel/DesignerSerializationVisibilityAttribute.cs`
- E-19: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.ComponentModel.Primitives/src/System/ComponentModel/EditorAttribute.cs`
- E-20: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.ComponentModel.Primitives/src/System/ComponentModel/InitializationEventAttribute.cs`
- E-21: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.ComponentModel.Primitives/src/System/ComponentModel/Design/Serialization/DesignerSerializerAttribute.cs`
- E-22: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.ComponentModel.Primitives/src/System/ComponentModel/InvalidEnumArgumentException.cs`
- E-23: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.ComponentModel.Primitives/src/System/ComponentModel/InvalidAsynchronousStateException.cs`
- E-24: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.ComponentModel.Primitives/src/System/ComponentModel/IComponent.cs`
- E-25: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.ComponentModel.Primitives/src/System/ComponentModel/ISite.cs`
- E-26: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.ComponentModel.Primitives/src/System/ComponentModel/IContainer.cs`
- E-27: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.ComponentModel.Primitives/src/System/ComponentModel/ISynchronizeInvoke.cs`
- E-28: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.ComponentModel.Primitives/src/System/ComponentModel/ISupportInitialize.cs`
- E-29: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.ComponentModel.Primitives/src/System/ComponentModel/DesignerSerializationVisibility.cs`
- E-30: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.ComponentModel.Primitives/src/System/ComponentModel/RefreshProperties.cs`

## 3) Claims と根拠の対応（レビューの主戦場）

### Component クラス (UT-SCP-001 - UT-SCP-020)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | CanRaiseEventsのデフォルト値テスト | E-01 (Line 33: `protected virtual bool CanRaiseEvents => true;`) | ○ |
| C-02 | Eventsプロパティの遅延初期化テスト | E-01 (Line 55: `protected EventHandlerList Events => _events ??= new EventHandlerList(this);`) | ○ |
| C-03 | Events同一インスタンス返却テスト | E-01 (Line 55: null合体演算子で同一インスタンス保証) | ○ |
| C-04 | Siteプロパティの設定・取得テスト | E-01 (Lines 62-66: Siteプロパティ定義) | ○ |
| C-05 | Site nullテスト | E-01 (Line 18: `private ISite? _site;` nullable定義) | ○ |
| C-06 | Dispose正常完了テスト | E-01 (Lines 71-75: Dispose実装) | ○ |
| C-07 | Disposedイベント発火テスト | E-01 (Lines 87-90: イベント発火処理) | ○ |
| C-08 | Container.Removeテスト | E-01 (Line 86: `_site?.Container?.Remove(this);`) | ○ |
| C-09 | Dispose(true)テスト | E-01 (Lines 80-93: Dispose(bool)実装) | ○ |
| C-10 | Dispose(false)テスト | E-01 (Line 82: `if (disposing)` 条件分岐) | ○ |
| C-11 | Container取得テスト | E-01 (Line 101: `public IContainer? Container => _site?.Container;`) | ○ |
| C-12 | Container null時テスト | E-01 (Line 101: null条件演算子使用) | ○ |
| C-13 | GetServiceテスト | E-01 (Line 107: `protected virtual object? GetService(Type service) => _site?.GetService(service);`) | ○ |
| C-14 | GetService Site null時テスト | E-01 (Line 107: null条件演算子使用) | ○ |
| C-15 | DesignModeテスト | E-01 (Line 115: `protected bool DesignMode => _site?.DesignMode ?? false;`) | ○ |
| C-16 | DesignMode Site null時テスト | E-01 (Line 115: null合体演算子でfalse返却) | ○ |
| C-17 | ToString Site null時テスト | E-01 (Lines 122-131: ToString実装) | ○ |
| C-18 | ToString Site設定時テスト | E-01 (Line 130: `return s.Name + " [" + GetType().FullName + "]";`) | ○ |
| C-19 | Disposedイベント追加テスト | E-01 (Line 48: `add => Events.AddHandler(s_eventDisposed, value);`) | ○ |
| C-20 | Disposedイベント削除テスト | E-01 (Line 49: `remove => Events.RemoveHandler(s_eventDisposed, value);`) | ○ |

### EventHandlerList クラス (UT-SCP-021 - UT-SCP-034)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-21 | 引数なしコンストラクタテスト | E-02 (Lines 26-28: publicコンストラクタ) | ○ |
| C-22 | インデクサgetテスト | E-02 (Lines 33-44: インデクサ実装) | ○ |
| C-23 | インデクサget未登録キーテスト | E-02 (Line 43: `return e?._handler;` null返却) | ○ |
| C-24 | インデクサsetテスト | E-02 (Lines 45-57: インデクサset実装) | ○ |
| C-25 | インデクサset上書きテスト | E-02 (Lines 47-51: 既存エントリ更新) | ○ |
| C-26 | CanRaiseEvents=false時テスト | E-02 (Line 38: `if (_parent == null || _parent.CanRaiseEventsInternal)`) | ○ |
| C-27 | AddHandler新規キーテスト | E-02 (Lines 59-70: AddHandler実装) | ○ |
| C-28 | AddHandler既存キーテスト | E-02 (Line 64: `e._handler = Delegate.Combine(e._handler, value);`) | ○ |
| C-29 | AddHandler null delegateテスト | E-02 (Line 59: Delegate?許容) | ○ |
| C-30 | AddHandlersテスト | E-02 (Lines 72-82: AddHandlers実装) | ○ |
| C-31 | AddHandlers null引数テスト | E-02 (Line 74: `ArgumentNullException.ThrowIfNull(listToAddFrom);`) | ○ |
| C-32 | RemoveHandlerテスト | E-02 (Lines 100-104: RemoveHandler実装) | ○ |
| C-33 | RemoveHandler未登録キーテスト | E-02 (Line 103: null条件演算子で安全) | ○ |
| C-34 | Disposeテスト | E-02 (Line 84: `public void Dispose() => _head = null;`) | ○ |

### ComponentCollection クラス (UT-SCP-035 - UT-SCP-042)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-35 | コンストラクタテスト | E-03 (Line 10: `public ComponentCollection(IComponent[] components) => InnerList.AddRange(components);`) | ○ |
| C-36 | 名前検索インデクサテスト | E-03 (Lines 16-33: string indexer実装) | ○ |
| C-37 | 大文字小文字区別なし検索テスト | E-03 (Line 25: `string.Equals(comp.Site.Name, name, StringComparison.OrdinalIgnoreCase)`) | ○ |
| C-38 | 名前検索null返却テスト | E-03 (Line 31: `return null;`) | ○ |
| C-39 | 名前null入力テスト | E-03 (Line 20: `if (name != null)`) | ○ |
| C-40 | インデックスインデクサテスト | E-03 (Line 39: `public virtual IComponent? this[int index] => (IComponent?)InnerList[index];`) | ○ |
| C-41 | インデックス範囲外テスト | E-03 (Line 39: InnerListのインデクサが例外をスロー) | ○ |
| C-42 | CopyToテスト | E-03 (Line 41: `public void CopyTo(IComponent[] array, int index) => InnerList.CopyTo(array, index);`) | ○ |

### BrowsableAttribute クラス (UT-SCP-043 - UT-SCP-053)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-43 | コンストラクタtrue初期化テスト | E-04 (Lines 37-40: コンストラクタ) | ○ |
| C-44 | コンストラクタfalse初期化テスト | E-04 (Lines 37-40: コンストラクタ) | ○ |
| C-45 | Browsableプロパティテスト | E-04 (Line 45: `public bool Browsable { get; }`) | ○ |
| C-46 | Yes staticフィールドテスト | E-04 (Line 19: `public static readonly BrowsableAttribute Yes = new BrowsableAttribute(true);`) | ○ |
| C-47 | No staticフィールドテスト | E-04 (Line 25: `public static readonly BrowsableAttribute No = new BrowsableAttribute(false);`) | ○ |
| C-48 | Defaultフィールドテスト | E-04 (Line 32: `public static readonly BrowsableAttribute Default = Yes;`) | ○ |
| C-49 | Equals同値テスト | E-04 (Lines 47-48: Equals実装) | ○ |
| C-50 | Equals異値テスト | E-04 (Lines 47-48: Equals実装) | ○ |
| C-51 | Equals nullテスト | E-04 (Line 47: `obj is BrowsableAttribute` パターンマッチ) | ○ |
| C-52 | IsDefaultAttribute Yesテスト | E-04 (Line 52: `public override bool IsDefaultAttribute() => Equals(Default);`) | ○ |
| C-53 | IsDefaultAttribute Noテスト | E-04 (Line 52: IsDefaultAttribute実装) | ○ |

### CategoryAttribute クラス (UT-SCP-054 - UT-SCP-075)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-54 | デフォルトコンストラクタテスト | E-05 (Line 98: `public CategoryAttribute() : this(nameof(Default))`) | ○ |
| C-55 | カスタムコンストラクタテスト | E-05 (Lines 106-109: コンストラクタ実装) | ○ |
| C-56 | Categoryプロパティテスト | E-05 (Lines 115-135: Categoryプロパティ) | ○ |
| C-57 | Actionカテゴリテスト | E-05 (Line 27: `public static CategoryAttribute Action => field ??= new CategoryAttribute(nameof(Action));`) | ○ |
| C-58 | Appearanceカテゴリテスト | E-05 (Line 32) | ○ |
| C-59 | Behaviorカテゴリテスト | E-05 (Line 42) | ○ |
| C-60 | Dataカテゴリテスト | E-05 (Line 47) | ○ |
| C-61 | Defaultカテゴリテスト | E-05 (Line 52) | ○ |
| C-62 | Designカテゴリテスト | E-05 (Line 57) | ○ |
| C-63 | DragDropカテゴリテスト | E-05 (Line 62) | ○ |
| C-64 | Focusカテゴリテスト | E-05 (Line 67) | ○ |
| C-65 | Formatカテゴリテスト | E-05 (Line 72) | ○ |
| C-66 | Keyカテゴリテスト | E-05 (Line 77) | ○ |
| C-67 | Layoutカテゴリテスト | E-05 (Line 82) | ○ |
| C-68 | Mouseカテゴリテスト | E-05 (Line 87) | ○ |
| C-69 | WindowStyleカテゴリテスト | E-05 (Line 92) | ○ |
| C-70 | Asynchronousカテゴリテスト | E-05 (Line 37) | ○ |
| C-71 | GetLocalizedString既知カテゴリテスト | E-05 (Lines 145-169: GetLocalizedString実装) | ○ |
| C-72 | GetLocalizedString未知カテゴリテスト | E-05 (Line 168: `_ => null`) | ○ |
| C-73 | Equals同値テスト | E-05 (Lines 137-138: Equals実装) | ○ |
| C-74 | Equals異値テスト | E-05 (Lines 137-138: Equals実装) | ○ |
| C-75 | IsDefaultAttributeテスト | E-05 (Line 171: `public override bool IsDefaultAttribute() => Category == Default.Category;`) | ○ |

### DescriptionAttribute クラス (UT-SCP-076 - UT-SCP-082)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-76 | デフォルトコンストラクタテスト | E-06 (Lines 20-22: `public DescriptionAttribute() : this(string.Empty)`) | ○ |
| C-77 | カスタムコンストラクタテスト | E-06 (Lines 27-30: コンストラクタ) | ○ |
| C-78 | Descriptionプロパティテスト | E-06 (Line 35: `public virtual string Description => DescriptionValue;`) | ○ |
| C-79 | DescriptionValueテスト | E-06 (Line 42: `protected string DescriptionValue { get; set; }`) | ○ |
| C-80 | Defaultフィールドテスト | E-06 (Line 18: `public static readonly DescriptionAttribute Default = new DescriptionAttribute();`) | ○ |
| C-81 | Equalsテスト | E-06 (Lines 44-45: Equals実装) | ○ |
| C-82 | IsDefaultAttributeテスト | E-06 (Line 49: IsDefaultAttribute実装) | ○ |

### DisplayNameAttribute クラス (UT-SCP-083 - UT-SCP-088)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-83 | デフォルトコンストラクタテスト | E-07 (Lines 21-23) | ○ |
| C-84 | カスタムコンストラクタテスト | E-07 (Lines 28-31) | ○ |
| C-85 | DisplayNameプロパティテスト | E-07 (Line 36) | ○ |
| C-86 | Defaultフィールドテスト | E-07 (Line 19) | ○ |
| C-87 | Equalsテスト | E-07 (Lines 43-44) | ○ |
| C-88 | IsDefaultAttributeテスト | E-07 (Line 48) | ○ |

### DesignOnlyAttribute クラス (UT-SCP-089 - UT-SCP-096)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-89 | コンストラクタtrue初期化テスト | E-08 (Lines 36-39) | ○ |
| C-90 | コンストラクタfalse初期化テスト | E-08 (Lines 36-39) | ○ |
| C-91 | IsDesignOnlyプロパティテスト | E-08 (Line 44) | ○ |
| C-92 | Yes staticフィールドテスト | E-08 (Line 18) | ○ |
| C-93 | No staticフィールドテスト | E-08 (Line 24) | ○ |
| C-94 | Defaultフィールドテスト | E-08 (Line 31) | ○ |
| C-95 | Equalsテスト | E-08 (Lines 46-47) | ○ |
| C-96 | IsDefaultAttributeテスト | E-08 (Line 51) | ○ |

### ReadOnlyAttribute クラス (UT-SCP-097 - UT-SCP-104)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-97 | コンストラクタtrue初期化テスト | E-09 (Line 39) | ○ |
| C-98 | コンストラクタfalse初期化テスト | E-09 (Line 39) | ○ |
| C-99 | IsReadOnlyプロパティテスト | E-09 (Line 45) | ○ |
| C-100 | Yes staticフィールドテスト | E-09 (Line 20) | ○ |
| C-101 | No staticフィールドテスト | E-09 (Line 26) | ○ |
| C-102 | Defaultフィールドテスト | E-09 (Line 34) | ○ |
| C-103 | Equalsテスト | E-09 (Lines 47-48) | ○ |
| C-104 | IsDefaultAttributeテスト | E-09 (Line 52) | ○ |

### LocalizableAttribute クラス (UT-SCP-105 - UT-SCP-112)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-105 | コンストラクタtrue初期化テスト | E-10 (Lines 17-20) | ○ |
| C-106 | コンストラクタfalse初期化テスト | E-10 (Lines 17-20) | ○ |
| C-107 | IsLocalizableプロパティテスト | E-10 (Line 25) | ○ |
| C-108 | Yes staticフィールドテスト | E-10 (Line 31) | ○ |
| C-109 | No staticフィールドテスト | E-10 (Line 37) | ○ |
| C-110 | Defaultフィールドテスト | E-10 (Line 44) | ○ |
| C-111 | Equalsテスト | E-10 (Lines 46-47) | ○ |
| C-112 | IsDefaultAttributeテスト | E-10 (Line 51) | ○ |

### MergablePropertyAttribute クラス (UT-SCP-113 - UT-SCP-120)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-113 | コンストラクタtrue初期化テスト | E-11 (Lines 41-44) | ○ |
| C-114 | コンストラクタfalse初期化テスト | E-11 (Lines 41-44) | ○ |
| C-115 | AllowMergeプロパティテスト | E-11 (Line 50) | ○ |
| C-116 | Yes staticフィールドテスト | E-11 (Line 20) | ○ |
| C-117 | No staticフィールドテスト | E-11 (Line 27) | ○ |
| C-118 | Defaultフィールドテスト | E-11 (Line 35) | ○ |
| C-119 | Equalsテスト | E-11 (Lines 52-53) | ○ |
| C-120 | IsDefaultAttributeテスト | E-11 (Line 57) | ○ |

### NotifyParentPropertyAttribute クラス (UT-SCP-121 - UT-SCP-128)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-121 | コンストラクタtrue初期化テスト | E-12 (Lines 39-42) | ○ |
| C-122 | コンストラクタfalse初期化テスト | E-12 (Lines 39-42) | ○ |
| C-123 | NotifyParentプロパティテスト | E-12 (Line 49) | ○ |
| C-124 | Yes staticフィールドテスト | E-12 (Line 19) | ○ |
| C-125 | No staticフィールドテスト | E-12 (Line 25) | ○ |
| C-126 | Defaultフィールドテスト | E-12 (Line 32) | ○ |
| C-127 | Equalsテスト | E-12 (Lines 54-55) | ○ |
| C-128 | IsDefaultAttributeテスト | E-12 (Line 59) | ○ |

### ParenthesizePropertyNameAttribute クラス (UT-SCP-129 - UT-SCP-134)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-129 | デフォルトコンストラクタテスト | E-13 (Lines 21-23) | ○ |
| C-130 | カスタムコンストラクタテスト | E-13 (Lines 30-33) | ○ |
| C-131 | NeedParenthesisプロパティテスト | E-13 (Line 39) | ○ |
| C-132 | Defaultフィールドテスト | E-13 (Line 19) | ○ |
| C-133 | Equalsテスト | E-13 (Lines 44-45) | ○ |
| C-134 | IsDefaultAttributeテスト | E-13 (Line 49) | ○ |

### ImmutableObjectAttribute クラス (UT-SCP-135 - UT-SCP-142)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-135 | コンストラクタtrue初期化テスト | E-14 (Lines 39-42) | ○ |
| C-136 | コンストラクタfalse初期化テスト | E-14 (Lines 39-42) | ○ |
| C-137 | Immutableプロパティテスト | E-14 (Line 44) | ○ |
| C-138 | Yes staticフィールドテスト | E-14 (Line 20) | ○ |
| C-139 | No staticフィールドテスト | E-14 (Line 28) | ○ |
| C-140 | Defaultフィールドテスト | E-14 (Line 34) | ○ |
| C-141 | Equalsテスト | E-14 (Lines 46-47) | ○ |
| C-142 | IsDefaultAttributeテスト | E-14 (Line 51) | ○ |

### RefreshPropertiesAttribute クラス (UT-SCP-143 - UT-SCP-151)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-143 | All初期化テスト | E-15 (Lines 32-35) | ○ |
| C-144 | Repaint初期化テスト | E-15 (Lines 32-35) | ○ |
| C-145 | None初期化テスト | E-15 (Lines 32-35) | ○ |
| C-146 | RefreshPropertiesプロパティテスト | E-15 (Line 40) | ○ |
| C-147 | All staticフィールドテスト | E-15 (Line 18) | ○ |
| C-148 | Repaint staticフィールドテスト | E-15 (Line 24) | ○ |
| C-149 | Default staticフィールドテスト | E-15 (Line 30) | ○ |
| C-150 | Equalsテスト | E-15 (Lines 42-43) | ○ |
| C-151 | IsDefaultAttributeテスト | E-15 (Line 47) | ○ |

### DesignerAttribute クラス (UT-SCP-152 - UT-SCP-166)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-152 | stringコンストラクタテスト | E-16 (Lines 20-26) | ○ |
| C-153 | stringコンストラクタnullテスト | E-16 (Line 22: `ArgumentNullException.ThrowIfNull(designerTypeName);`) | ○ |
| C-154 | Typeコンストラクタテスト | E-16 (Lines 32-38) | ○ |
| C-155 | Typeコンストラクタnullテスト | E-16 (Line 34: `ArgumentNullException.ThrowIfNull(designerType);`) | ○ |
| C-156 | 2引数コンストラクタテスト | E-16 (Lines 44-50) | ○ |
| C-157 | 混合コンストラクタテスト | E-16 (Lines 56-63) | ○ |
| C-158 | Type/Typeコンストラクタテスト | E-16 (Lines 69-76) | ○ |
| C-159 | DesignerTypeNameプロパティテスト | E-16 (Line 87) | ○ |
| C-160 | DesignerBaseTypeNameプロパティテスト | E-16 (Line 82) | ○ |
| C-161 | デフォルトIDesignerテスト | E-16 (Line 25-26) | ○ |
| C-162 | TypeIdテスト | E-16 (Lines 96-112: TypeIdプロパティ) | ○ |
| C-163 | TypeIdカンマ処理テスト | E-16 (Lines 103-107) | ○ |
| C-164 | Equals同値テスト | E-16 (Lines 114-124: Equals実装) | ○ |
| C-165 | Equals自己比較テスト | E-16 (Lines 116-119) | ○ |
| C-166 | Equals異値テスト | E-16 (Lines 114-124) | ○ |

### DesignerCategoryAttribute クラス (UT-SCP-167 - UT-SCP-176)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-167 | デフォルトコンストラクタテスト | E-17 (Lines 42-44) | ○ |
| C-168 | カスタムコンストラクタテスト | E-17 (Lines 50-53) | ○ |
| C-169 | Categoryプロパティテスト | E-17 (Line 58) | ○ |
| C-170 | Component staticフィールドテスト | E-17 (Line 18) | ○ |
| C-171 | Default staticフィールドテスト | E-17 (Line 24) | ○ |
| C-172 | Form staticフィールドテスト | E-17 (Line 30) | ○ |
| C-173 | Generic staticフィールドテスト | E-17 (Line 36) | ○ |
| C-174 | TypeIdテスト | E-17 (Line 67) | ○ |
| C-175 | Equalsテスト | E-17 (Lines 60-61) | ○ |
| C-176 | IsDefaultAttributeテスト | E-17 (Line 65) | ○ |

### DesignerSerializationVisibilityAttribute クラス (UT-SCP-177 - UT-SCP-186)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-177 | Hidden初期化テスト | E-18 (Lines 45-48) | ○ |
| C-178 | Visible初期化テスト | E-18 (Lines 45-48) | ○ |
| C-179 | Content初期化テスト | E-18 (Lines 45-48) | ○ |
| C-180 | Visibilityプロパティテスト | E-18 (Line 54) | ○ |
| C-181 | Hidden staticフィールドテスト | E-18 (Line 26) | ○ |
| C-182 | Visible staticフィールドテスト | E-18 (Line 33) | ○ |
| C-183 | Content staticフィールドテスト | E-18 (Line 20) | ○ |
| C-184 | Default staticフィールドテスト | E-18 (Line 40) | ○ |
| C-185 | Equalsテスト | E-18 (Lines 56-57) | ○ |
| C-186 | IsDefaultAttributeテスト | E-18 (Line 61) | ○ |

### EditorAttribute クラス (UT-SCP-187 - UT-SCP-197)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-187 | デフォルトコンストラクタテスト | E-19 (Lines 20-24) | ○ |
| C-188 | 2引数コンストラクタテスト | E-19 (Lines 30-36) | ○ |
| C-189 | typeName nullテスト | E-19 (Line 32: `ArgumentNullException.ThrowIfNull(typeName);`) | ○ |
| C-190 | 混合コンストラクタテスト | E-19 (Lines 41-48) | ○ |
| C-191 | Type/Typeコンストラクタテスト | E-19 (Lines 53-60) | ○ |
| C-192 | EditorTypeNameプロパティテスト | E-19 (Line 70) | ○ |
| C-193 | EditorBaseTypeNameプロパティテスト | E-19 (Line 65) | ○ |
| C-194 | TypeIdテスト | E-19 (Lines 79-95) | ○ |
| C-195 | TypeIdカンマ処理テスト | E-19 (Lines 86-90) | ○ |
| C-196 | Equals同値テスト | E-19 (Lines 97-107) | ○ |
| C-197 | Equals自己比較テスト | E-19 (Lines 99-102) | ○ |

### InitializationEventAttribute クラス (UT-SCP-198 - UT-SCP-199)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-198 | コンストラクタテスト | E-20 (Lines 15-18) | ○ |
| C-199 | EventNameプロパティテスト | E-20 (Line 23) | ○ |

### DesignerSerializerAttribute クラス (UT-SCP-200 - UT-SCP-208)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-200 | Type/Typeコンストラクタテスト | E-21 (Lines 19-26) | ○ |
| C-201 | serializerType nullテスト | E-21 (Line 21: `ArgumentNullException.ThrowIfNull(serializerType);`) | ○ |
| C-202 | baseSerializerType nullテスト | E-21 (Line 22: `ArgumentNullException.ThrowIfNull(baseSerializerType);`) | ○ |
| C-203 | 混合コンストラクタテスト | E-21 (Lines 31-37) | ○ |
| C-204 | string/stringコンストラクタテスト | E-21 (Lines 42-46) | ○ |
| C-205 | SerializerTypeNameプロパティテスト | E-21 (Line 51) | ○ |
| C-206 | SerializerBaseTypeNameプロパティテスト | E-21 (Line 56) | ○ |
| C-207 | TypeIdテスト | E-21 (Lines 65-80) | ○ |
| C-208 | TypeIdカンマ処理テスト | E-21 (Lines 72-76) | ○ |

### InvalidEnumArgumentException クラス (UT-SCP-209 - UT-SCP-213)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-209 | デフォルトコンストラクタテスト | E-22 (Lines 21-23) | ○ |
| C-210 | メッセージコンストラクタテスト | E-22 (Lines 29-31) | ○ |
| C-211 | 内部例外コンストラクタテスト | E-22 (Lines 37-40) | ○ |
| C-212 | 詳細コンストラクタテスト | E-22 (Lines 47-54) | ○ |
| C-213 | enumClass nullテスト | E-22 (Line 53: `ArgumentNullException.ThrowIfNull(enumClass);`) | ○ |

### InvalidAsynchronousStateException クラス (UT-SCP-214 - UT-SCP-216)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-214 | デフォルトコンストラクタテスト | E-23 (Lines 22-24) | ○ |
| C-215 | メッセージコンストラクタテスト | E-23 (Lines 30-32) | ○ |
| C-216 | 内部例外コンストラクタテスト | E-23 (Lines 38-40) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし。全てのテストケースはソースコードを直接参照して生成されています。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全てのテストケースはソースコードに基づいており、実装との整合性が確認できる

## 6) レビュアーチェックリスト（最小）
- [ ] Componentクラスのライフサイクル（Dispose関連）のテストケースが網羅的か確認
- [ ] EventHandlerListの内部ロジック（CanRaiseEvents連携）のテストケースが適切か確認
- [ ] 各Attributeクラスの静的フィールド（Yes/No/Default）の定義が正しいか確認
- [ ] 例外クラスのコンストラクタパターンが網羅されているか確認
- [ ] ArgumentNullExceptionをスローするケースが全て特定されているか確認
