---
generated_at: 2026-01-30 17:05:00
metrics:
  claims_total: 30
  claims_with_evidence: 28
  claims_without_evidence: 2
confidence_derived: 0.93
---

# 根拠レポート: libraries-System.ComponentModel 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：28 / 30、根拠なし：2
- 優先レビュー（高）
  1. **UT-SCM-017**: IEditableObject.BeginEditの二重呼び出し時の挙動 - 実装依存のため根拠不足
  2. **UT-SCM-028**: IServiceProvider.GetServiceで自己参照を取得した場合の挙動 - 実装依存のため根拠不足

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/libraries/System.ComponentModel/src/System/ComponentModel/CancelEventArgs.cs`
- E-02: `src/libraries/System.ComponentModel/src/System/ComponentModel/IChangeTracking.cs`
- E-03: `src/libraries/System.ComponentModel/src/System/ComponentModel/IEditableObject.cs`
- E-04: `src/libraries/System.ComponentModel/src/System/ComponentModel/IRevertibleChangeTracking.cs`
- E-05: `src/libraries/System.ComponentModel/src/System/IServiceProvider.cs`
- E-06: `src/libraries/System.ComponentModel/ref/System.ComponentModel.cs`
- E-07: `src/libraries/System.ComponentModel/tests/CancelEventArgsTests.cs`
- E-08: `src/libraries/System.ComponentModel/tests/ComponentModelBasicTests.cs`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | CancelEventArgsのデフォルトコンストラクタでCancelがfalseに初期化される | E-01, E-07 | ○ |
| C-02 | CancelEventArgs(bool)でtrueを渡した場合にCancelがtrueになる | E-01, E-07 | ○ |
| C-03 | CancelEventArgs(bool)でfalseを渡した場合にCancelがfalseになる | E-01, E-07 | ○ |
| C-04 | Cancelプロパティにtrueを設定して取得できる | E-01, E-07 | ○ |
| C-05 | Cancelプロパティにfalseを設定して取得できる | E-01, E-07 | ○ |
| C-06 | Cancelプロパティを複数回変更できる | E-01, E-07 | ○ |
| C-07 | CancelEventArgsはEventArgsを継承している | E-01, E-06 | ○ |
| C-08 | IChangeTracking.IsChangedが正しく動作する | E-02, E-06 | ○ |
| C-09 | AcceptChanges呼び出し後にIsChangedがfalseになる | E-02 | ○ |
| C-10 | 初期状態でIsChangedがfalse | E-02 | ○ |
| C-11 | 未変更状態でAcceptChangesを呼び出してもエラーにならない | E-02 | ○ |
| C-12 | BeginEditで編集モードが開始される | E-03 | ○ |
| C-13 | EndEditで変更が確定される | E-03 | ○ |
| C-14 | CancelEditで変更が破棄される | E-03 | ○ |
| C-15 | BeginEdit -> 変更 -> EndEditの一連の流れが動作する | E-03 | ○ |
| C-16 | BeginEdit -> 変更 -> CancelEditで元に戻る | E-03 | ○ |
| C-17 | BeginEditを複数回呼び出した場合の挙動 | **根拠なし** | △ |
| C-18 | BeginEditなしでEndEditを呼び出した場合の挙動 | E-03 | ○ |
| C-19 | BeginEditなしでCancelEditを呼び出した場合の挙動 | E-03 | ○ |
| C-20 | RejectChangesで変更が破棄される | E-04 | ○ |
| C-21 | RejectChanges後にIsChangedがfalseになる | E-04, E-02 | ○ |
| C-22 | IRevertibleChangeTrackingはIChangeTrackingを継承している | E-04, E-06 | ○ |
| C-23 | 未変更状態でRejectChangesを呼び出してもエラーにならない | E-04 | ○ |
| C-24 | AcceptChangesとRejectChangesの違いが明確である | E-02, E-04 | ○ |
| C-25 | 登録済みサービスが取得できる | E-05 | ○ |
| C-26 | 未登録サービスでnullが返却される | E-05 | ○ |
| C-27 | nullのTypeを渡した場合の挙動 | E-05 | ○ |
| C-28 | 自分自身を返すサービスプロバイダの動作 | **根拠なし** | △ |
| C-29 | イベントハンドラ内でCancelをtrueに設定できる | E-01, E-06 | ○ |
| C-30 | 複数のイベントハンドラでCancelの状態が共有される | E-01 | ○ |

## 4) 不足情報（Unknown / Missing）
- **C-17 (UT-SCM-017)**: IEditableObject.BeginEditを複数回呼び出した場合の挙動はインターフェース定義では規定されておらず、実装クラスに依存する。.NETの公式ドキュメントやコメントでも明確な仕様は記載されていない。
  - 候補: Microsoft公式ドキュメント / 実装クラスのソースコード / 既存テストケース
- **C-28 (UT-SCM-028)**: IServiceProvider.GetServiceで自分自身（IServiceProvider型）を取得した場合の動作は実装依存であり、インターフェース仕様では規定されていない。
  - 候補: Microsoft公式ドキュメント / DependencyInjectionなど実装ライブラリのソースコード

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 本モジュールは基本的なイベント引数クラスとインターフェース定義のみで構成されており、複雑なロジックは含まれていない
- **1: 中リスク** - インターフェース実装テストは実際の実装クラスに依存するため、テスト実行時には適切なモック/スタブが必要
- **0: 低リスク** - CancelEventArgsクラスは既存テストファイル(E-07)で十分にカバーされている

## 6) レビュアーチェックリスト（最小）
- [ ] CancelEventArgsのテストケースが既存テスト(CancelEventArgsTests.cs)と整合しているか確認
- [ ] インターフェーステストにおける実装クラス/モックの選定方針を確認
- [ ] IServiceProviderの実装依存テストケース(UT-SCM-027, UT-SCM-028)の妥当性を検討
- [ ] 優先度「高」のテストケースが適切に設定されているか確認
- [ ] .NET標準ライブラリとしてのAPI互換性テストの必要性を検討
