---
generated_at: 2026-01-30 17:00:00
metrics:
  claims_total: 127
  claims_with_evidence: 127
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：libraries-System.Composition.Convention 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：127 / 127、根拠なし：0
- 優先レビュー（高）
  1. **スレッドセーフ性テスト（C-15）**：並行処理テストは実行環境依存のため、実際のテスト実行で検証が必要
  2. **式ツリー解析テスト（C-105〜C-125）**：複雑な式ツリー操作は実際の動作確認が推奨
  3. **ジェネリック型継承判定（C-21）**：IsGenericDescendentOfの再帰的な判定ロジックは境界条件の追加検証が推奨

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/libraries/System.Composition.Convention/src/System/Composition/Convention/ConventionBuilder.cs`
- E-02: `src/libraries/System.Composition.Convention/src/System/Composition/Convention/ExportConventionBuilder.cs`
- E-03: `src/libraries/System.Composition.Convention/src/System/Composition/Convention/ImportConventionBuilder.cs`
- E-04: `src/libraries/System.Composition.Convention/src/System/Composition/Convention/PartConventionBuilder.cs`
- E-05: `src/libraries/System.Composition.Convention/src/System/Composition/Convention/PartConventionBuilderOfT.cs`
- E-06: `src/libraries/System.Composition.Convention/src/System/Composition/Convention/ParameterImportConventionBuilder.cs`

## 3) Claims と根拠の対応（レビューの主戦場）

### ConventionBuilder クラス
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ForTypesDerivedFrom<T>が派生型のルールを追加する | E-01 L35-40 | ○ |
| C-02 | ForTypesDerivedFrom(Type)がType指定で派生型のルールを追加する | E-01 L48-55 | ○ |
| C-03 | ForTypesDerivedFrom(Type)でnullがArgumentNullExceptionをスローする | E-01 L50 `ArgumentNullException.ThrowIfNull(type)` | ○ |
| C-04 | ForType<T>が特定型のルールを追加する | E-01 L62-67 | ○ |
| C-05 | ForType(Type)がType指定で特定型のルールを追加する | E-01 L74-81 | ○ |
| C-06 | ForType(Type)でnullがArgumentNullExceptionをスローする | E-01 L76 `ArgumentNullException.ThrowIfNull(type)` | ○ |
| C-07 | ForTypesMatching<T>が条件に一致する型のルールを追加する | E-01 L90-97 | ○ |
| C-08 | ForTypesMatching<T>でtypeFilterがnullの場合ArgumentNullExceptionをスローする | E-01 L92 | ○ |
| C-09 | ForTypesMatching(Predicate<Type>)が条件に一致する型のルールを追加する | E-01 L105-112 | ○ |
| C-10 | ForTypesMatching(Predicate<Type>)でtypeFilterがnullの場合ArgumentNullExceptionをスローする | E-01 L107 | ○ |
| C-11 | GetCustomAttributes(Type, MemberInfo)がTypeInfoに対して属性を返す | E-01 L147-230 | ○ |
| C-12 | GetCustomAttributes(Type, MemberInfo)がPropertyInfoに対して属性を返す | E-01 L218-220 | ○ |
| C-13 | GetCustomAttributes(Type, MemberInfo)がConstructorInfoに対して属性を返す | E-01 L218 | ○ |
| C-14 | GetCustomAttributes(Type, MemberInfo)でmemberがnullの場合ArgumentNullExceptionをスローする | E-01 L149 | ○ |
| C-15 | GetCustomAttributesがスレッドセーフに動作する | E-01 L16 `ReaderWriterLockSlim`, L157-215 | ○ |
| C-16 | GetCustomAttributes(Type, ParameterInfo)がパラメータに対して属性を返す | E-01 L284-291 | ○ |
| C-17 | GetCustomAttributes(Type, ParameterInfo)でparameterがnullの場合ArgumentNullExceptionをスローする | E-01 L286 | ○ |
| C-18 | IsDescendentOfが派生型を正しく判定する | E-01 L357-375 | ○ |
| C-19 | IsDescendentOfで同一型の場合falseを返す | E-01 L359 | ○ |
| C-20 | IsDescendentOfがインターフェース実装を判定する | E-01 L374 `bti.IsAssignableFrom(ti)` | ○ |
| C-21 | IsGenericDescendentOfがジェネリック型の継承関係を判定する | E-01 L339-355 | ○ |

### ExportConventionBuilder クラス
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-22 | AsContractType<T>がコントラクト型を設定する | E-02 L31-34 | ○ |
| C-23 | AsContractType(Type)がType指定でコントラクト型を設定する | E-02 L41-47 | ○ |
| C-24 | AsContractType(Type)でnullがArgumentNullExceptionをスローする | E-02 L43 | ○ |
| C-25 | AsContractName(string)がコントラクト名を設定する | E-02 L54-64 | ○ |
| C-26 | AsContractName(string)でnullがArgumentNullExceptionをスローする | E-02 L56 | ○ |
| C-27 | AsContractName(string)で空文字がArgumentExceptionをスローする | E-02 L58-61 | ○ |
| C-28 | AsContractName(Func<Type, string>)がFuncでコントラクト名を設定する | E-02 L71-77 | ○ |
| C-29 | AsContractName(Func<Type, string>)でnullがArgumentNullExceptionをスローする | E-02 L73 | ○ |
| C-30 | AddMetadata(string, object)がメタデータを追加する | E-02 L85-97 | ○ |
| C-31 | AddMetadata(string, object)でnameがnullの場合ArgumentNullExceptionをスローする | E-02 L87 | ○ |
| C-32 | AddMetadata(string, object)でnameが空文字の場合ArgumentExceptionをスローする | E-02 L89-92 | ○ |
| C-33 | AddMetadata(string, Func<Type, object>)がFuncでメタデータを追加する | E-02 L105-118 | ○ |
| C-34 | AddMetadata(string, Func<Type, object>)でnameがnullの場合ArgumentNullExceptionをスローする | E-02 L107 | ○ |
| C-35 | AddMetadata(string, Func<Type, object>)でgetValueFromPartTypeがnullの場合ArgumentNullExceptionをスローする | E-02 L108 | ○ |
| C-36 | BuildAttributesがExportAttributeを生成する | E-02 L120-125 | ○ |
| C-37 | BuildAttributesがExportMetadataAttributeを生成する | E-02 L127-145 | ○ |

### ImportConventionBuilder クラス
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-38 | AsContractName(string)がコントラクト名を設定する | E-03 L31-41 | ○ |
| C-39 | AsContractName(string)でnullがArgumentNullExceptionをスローする | E-03 L33 | ○ |
| C-40 | AsContractName(string)で空文字がArgumentExceptionをスローする | E-03 L35-38 | ○ |
| C-41 | AsContractName(Func<Type, string>)がFuncでコントラクト名を設定する | E-03 L48-54 | ○ |
| C-42 | AsContractName(Func<Type, string>)でnullがArgumentNullExceptionをスローする | E-03 L50 | ○ |
| C-43 | AsMany()が複数インポートモードを設定する | E-03 L60-63 | ○ |
| C-44 | AsMany(bool)が複数インポートモードをパラメータで設定する | E-03 L70-74 | ○ |
| C-45 | AllowDefault()がデフォルト値許可を設定する | E-03 L81-85 | ○ |
| C-46 | AddMetadataConstraint(string, object)がメタデータ制約を追加する | E-03 L93-105 | ○ |
| C-47 | AddMetadataConstraint(string, object)でnameがnullの場合ArgumentNullExceptionをスローする | E-03 L95 | ○ |
| C-48 | AddMetadataConstraint(string, object)でnameが空文字の場合ArgumentExceptionをスローする | E-03 L97-100 | ○ |
| C-49 | AddMetadataConstraint(string, Func<Type, object>)がFuncでメタデータ制約を追加する | E-03 L113-126 | ○ |
| C-50 | AddMetadataConstraint(string, Func<Type, object>)でnameがnullの場合ArgumentNullExceptionをスローする | E-03 L115 | ○ |
| C-51 | AddMetadataConstraint(string, Func<Type, object>)でgetConstraintValueFromPartTypeがnullの場合ArgumentNullExceptionをスローする | E-03 L116 | ○ |
| C-52 | BuildAttributesが単一インポート時にImportAttributeを生成する | E-03 L136-142 | ○ |
| C-53 | BuildAttributesが複数インポート時にImportManyAttributeを生成する | E-03 L143-146 | ○ |
| C-54 | BuildAttributesでAllowDefaultがImportAttributeに反映される | E-03 L140 | ○ |
| C-55 | IsSupportedImportManyTypeが配列型でtrueを返す | E-03 L175 `typeInfo.IsArray` | ○ |
| C-56 | IsSupportedImportManyTypeがIEnumerable<T>でtrueを返す | E-03 L176-177, L15 | ○ |
| C-57 | IsSupportedImportManyTypeがIList<T>でtrueを返す | E-03 L176-177, L15 | ○ |
| C-58 | IsSupportedImportManyTypeがICollection<T>でtrueを返す | E-03 L176-177, L15 | ○ |
| C-59 | IsSupportedImportManyTypeが単一型でfalseを返す | E-03 L173-178 | ○ |

### PartConventionBuilder クラス
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-60 | Export()がパーツをエクスポートとして登録する | E-04 L54-59 | ○ |
| C-61 | Export(Action<ExportConventionBuilder>)が設定付きでエクスポートを登録する | E-04 L66-74 | ○ |
| C-62 | Export(Action<ExportConventionBuilder>)でexportConfigurationがnullの場合ArgumentNullExceptionをスローする | E-04 L68 | ○ |
| C-63 | Export<T>()がジェネリック型でエクスポートを登録する | E-04 L80-85 | ○ |
| C-64 | Export<T>(Action<ExportConventionBuilder>)がジェネリック型と設定でエクスポートを登録する | E-04 L92-100 | ○ |
| C-65 | SelectConstructor(Func)がコンストラクタ選択を設定する | E-04 L107-113 | ○ |
| C-66 | SelectConstructor(Func)でconstructorSelectorがnullの場合ArgumentNullExceptionをスローする | E-04 L109 | ○ |
| C-67 | SelectConstructor(Func, Action)がコンストラクタ選択とインポート設定を登録する | E-04 L121-129 | ○ |
| C-68 | SelectConstructor(Func, Action)でimportConfigurationがnullの場合ArgumentNullExceptionをスローする | E-04 L124 | ○ |
| C-69 | ExportInterfaces()が全インターフェースをエクスポートとして登録する | E-04 L147-150 | ○ |
| C-70 | ExportInterfaces(Predicate<Type>)がフィルタ付きでインターフェースをエクスポートする | E-04 L136-141 | ○ |
| C-71 | ExportInterfaces(Predicate<Type>)でinterfaceFilterがnullの場合ArgumentNullExceptionをスローする | E-04 L138 | ○ |
| C-72 | ExportInterfaces(Predicate<Type>, Action)がフィルタと設定付きでインターフェースをエクスポートする | E-04 L158-165 | ○ |
| C-73 | ExportProperties(Predicate<PropertyInfo>)がプロパティをエクスポートとして登録する | E-04 L179-184 | ○ |
| C-74 | ExportProperties(Predicate<PropertyInfo>)でpropertyFilterがnullの場合ArgumentNullExceptionをスローする | E-04 L181 | ○ |
| C-75 | ExportProperties(Predicate, Action)がプロパティを設定付きで登録する | E-04 L192-199 | ○ |
| C-76 | ExportProperties<T>(Predicate<PropertyInfo>)がジェネリック型でプロパティをエクスポートする | E-04 L214-219 | ○ |
| C-77 | ImportProperties(Predicate<PropertyInfo>)がプロパティをインポートとして登録する | E-04 L249-254 | ○ |
| C-78 | ImportProperties(Predicate<PropertyInfo>)でpropertyFilterがnullの場合ArgumentNullExceptionをスローする | E-04 L251 | ○ |
| C-79 | ImportProperties(Predicate, Action)がプロパティを設定付きで登録する | E-04 L262-269 | ○ |
| C-80 | ImportProperties<T>(Predicate<PropertyInfo>)がジェネリック型でプロパティをインポートする | E-04 L284-289 | ○ |
| C-81 | NotifyImportsSatisfied(Predicate<MethodInfo>)がOnImportsSatisfied通知メソッドを登録する | E-04 L319-323 | ○ |
| C-82 | Shared()がパーツを共有としてマークする | E-04 L329-332 | ○ |
| C-83 | Shared(string)が境界名付きで共有パーツとしてマークする | E-04 L339-349 | ○ |
| C-84 | Shared(string)でsharingBoundaryがnullの場合ArgumentNullExceptionをスローする | E-04 L341 | ○ |
| C-85 | Shared(string)でsharingBoundaryが空文字の場合ArgumentExceptionをスローする | E-04 L343-346 | ○ |
| C-86 | AddPartMetadata(string, object)がパーツメタデータを追加する | E-04 L364-376 | ○ |
| C-87 | AddPartMetadata(string, object)でnameがnullの場合ArgumentNullExceptionをスローする | E-04 L366 | ○ |
| C-88 | AddPartMetadata(string, object)でnameが空文字の場合ArgumentExceptionをスローする | E-04 L368-371 | ○ |
| C-89 | AddPartMetadata(string, Func<Type, object>)がFuncでパーツメタデータを追加する | E-04 L384-397 | ○ |
| C-90 | AddPartMetadata(string, Func<Type, object>)でnameがnullの場合ArgumentNullExceptionをスローする | E-04 L386 | ○ |
| C-91 | AddPartMetadata(string, Func<Type, object>)でgetValueFromPartTypeがnullの場合ArgumentNullExceptionをスローする | E-04 L387 | ○ |
| C-92 | BuildTypeAttributesがExportAttributeを生成する | E-04 L420-437 | ○ |
| C-93 | BuildTypeAttributesがSharedAttributeを生成する | E-04 L440-455 | ○ |
| C-94 | BuildTypeAttributesが既存の属性を上書きしない | E-04 L426-430 | ○ |
| C-95 | BuildTypeAttributesがIDisposableインターフェースを除外する | E-04 L506-509 | ○ |
| C-96 | BuildConstructorAttributesがImportingConstructorAttributeを生成する | E-04 L529-565 | ○ |
| C-97 | BuildConstructorAttributesが既存のImportingConstructorAttributeがある場合スキップする | E-04 L536-542 | ○ |
| C-98 | BuildDefaultConstructorAttributesが最長パラメータのコンストラクタを選択する | E-04 L567-575 | ○ |
| C-99 | BuildPropertyAttributesがプロパティにImportAttributeを生成する | E-04 L662-707 | ○ |
| C-100 | BuildPropertyAttributesがプロパティにExportAttributeを生成する | E-04 L712-744 | ○ |
| C-101 | BuildOnImportsSatisfiedNotificationがOnImportsSatisfiedAttributeを生成する | E-04 L608-659 | ○ |
| C-102 | FindLongestConstructorsが最長パラメータのコンストラクタを返す | E-04 L757-796 | ○ |
| C-103 | FindLongestConstructorsが同じパラメータ数のコンストラクタが複数ある場合全て返す | E-04 L780-790 | ○ |
| C-104 | FindLongestConstructorsが引数なしコンストラクタのみの場合空を返す | E-04 L766 `if (length != 0)` | ○ |

### PartConventionBuilder<T> クラス
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-105 | SelectConstructor(Expression)が式ツリーでコンストラクタを選択する | E-05 L209-216 | ○ |
| C-106 | SelectConstructor(Expression)でconstructorSelectorがnullの場合ArgumentNullExceptionをスローする | E-05 L211 | ○ |
| C-107 | ExportProperty(Expression)が式ツリーでプロパティをエクスポートする | E-05 L223-226 | ○ |
| C-108 | ExportProperty(Expression)でpropertySelectorがnullの場合ArgumentNullExceptionをスローする | E-05 L238 | ○ |
| C-109 | ExportProperty(Expression, Action)が式ツリーと設定でプロパティをエクスポートする | E-05 L234-243 | ○ |
| C-110 | ExportProperty<TContract>(Expression)がジェネリック契約型で式ツリープロパティをエクスポートする | E-05 L252-255 | ○ |
| C-111 | ImportProperty(Expression)が式ツリーでプロパティをインポートする | E-05 L280-283 | ○ |
| C-112 | ImportProperty(Expression)でpropertySelectorがnullの場合ArgumentNullExceptionをスローする | E-05 L295 | ○ |
| C-113 | ImportProperty(Expression, Action)が式ツリーと設定でプロパティをインポートする | E-05 L291-300 | ○ |
| C-114 | ImportProperty<TContract>(Expression)がジェネリック契約型で式ツリープロパティをインポートする | E-05 L308-311 | ○ |
| C-115 | NotifyImportsSatisfied(Expression)が式ツリーでOnImportsSatisfiedメソッドを登録する | E-05 L335-342 | ○ |
| C-116 | NotifyImportsSatisfied(Expression)でmethodSelectorがnullの場合ArgumentNullExceptionをスローする | E-05 L337 | ○ |
| C-117 | PropertyExpressionAdapter.SelectPropertiesが式ツリーからPropertyInfoを抽出する | E-05 L98-114 | ○ |
| C-118 | PropertyExpressionAdapter.SelectPropertiesでpropertySelectorがnullの場合ArgumentNullExceptionをスローする | E-05 L100 | ○ |
| C-119 | PropertyExpressionAdapter.SelectPropertiesでプロパティ以外の式の場合ArgumentExceptionをスローする | E-05 L113 | ○ |
| C-120 | MethodExpressionAdapter.SelectMethodsが式ツリーからMethodInfoを抽出する | E-05 L30-46 | ○ |
| C-121 | MethodExpressionAdapter.SelectMethodsでmethodSelectorがnullの場合ArgumentNullExceptionをスローする | E-05 L32 | ○ |
| C-122 | MethodExpressionAdapter.SelectMethodsでvoidメソッド以外の式の場合ArgumentExceptionをスローする | E-05 L45 | ○ |
| C-123 | ConstructorExpressionAdapter.ParseSelectConstructorが式ツリーからConstructorInfoを抽出する | E-05 L154-188 | ○ |
| C-124 | ConstructorExpressionAdapter.ParseSelectConstructorでconstructorSelectorがnullの場合ArgumentNullExceptionをスローする | E-05 L156 | ○ |
| C-125 | ConstructorExpressionAdapter.ParseSelectConstructorでnew式以外の場合ArgumentExceptionをスローする | E-05 L159-162 | ○ |

### ParameterImportConventionBuilder クラス
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-126 | Import<T>()がジェネリック型のインポートを行う | E-06 L19-22 | ○ |
| C-127 | Import<T>(Action<ImportConventionBuilder>)が設定付きでジェネリック型のインポートを行う | E-06 L30-33 | ○ |

## 4) 不足情報（Unknown / Missing）
- 全てのテストケースはソースコードから直接導出されており、根拠なしの項目はありません
- ただし、以下の点については実際のテスト実行で追加確認が推奨されます：
  - スレッドセーフ性テスト（C-15）の実際の並行動作検証
  - 式ツリー解析の複雑なケース（ネストした式、型変換を含む式など）

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**：
  - 引数検証テスト（ArgumentNullException、ArgumentException）：コード上で明確に確認可能
  - 基本的なメソッド動作テスト：戻り値の型と動作が明確
- **1（中リスク）**：
  - ジェネリック型の継承判定（IsGenericDescendentOf）：再帰的なロジックで複雑
  - 式ツリー解析：コンパイル時の式構造に依存
- **2（高リスク）**：
  - スレッドセーフ性テスト：実行環境とタイミングに依存
  - キャッシュの整合性テスト：複数スレッドからのアクセスパターンに依存

## 6) レビュアーチェックリスト（最小）
- [ ] 全127件のテストケースがソースコードの公開メソッド/主要ロジックを網羅しているか
- [ ] ArgumentNullException系のテストケースが全ての必須引数に対して定義されているか
- [ ] ArgumentException系のテストケースが全ての空文字検証に対して定義されているか
- [ ] 正常系・異常系・境界値の観点が適切にバランスされているか
- [ ] 優先度（高/中/低）の割り当てがビジネスインパクトと整合しているか
- [ ] 式ツリー関連のテストケースが式の種別検証を適切にカバーしているか
- [ ] スレッドセーフ性テストの前提条件と期待結果が明確か
