---
generated_at: 2026-01-30 17:15:00
metrics:
  claims_total: 150
  claims_with_evidence: 150
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：libraries-System.Composition.Hosting 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：150 / 150、根拠なし：0
- 優先レビュー（高）
  1. なし（全テストケースに根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/libraries/System.Composition.Hosting/src/System/Composition/Hosting/CompositionHost.cs`
- E-02: `src/libraries/System.Composition.Hosting/src/System/Composition/Hosting/Core/LifetimeContext.cs`
- E-03: `src/libraries/System.Composition.Hosting/src/System/Composition/Hosting/Core/ExportDescriptor.cs`
- E-04: `src/libraries/System.Composition.Hosting/src/System/Composition/Hosting/Core/ExportDescriptorProvider.cs`
- E-05: `src/libraries/System.Composition.Hosting/src/System/Composition/Hosting/Core/CompositionOperation.cs`
- E-06: `src/libraries/System.Composition.Hosting/src/System/Composition/Hosting/Core/CompositionDependency.cs`
- E-07: `src/libraries/System.Composition.Hosting/src/System/Composition/Hosting/Core/ExportDescriptorPromise.cs`
- E-08: `src/libraries/System.Composition.Hosting/src/System/Composition/Hosting/Core/DependencyAccessor.cs`
- E-09: `src/libraries/System.Composition.Hosting/src/System/Composition/Hosting/Core/ExportDescriptorRegistry.cs`
- E-10: `src/libraries/System.Composition.Hosting/src/System/Composition/Hosting/Core/ExportDescriptorRegistryUpdate.cs`
- E-11: `src/libraries/System.Composition.Hosting/src/System/Composition/Hosting/Core/DirectExportDescriptor.cs`
- E-12: `src/libraries/System.Composition.Hosting/src/System/Composition/Hosting/Core/CycleBreakingExportDescriptor.cs`
- E-13: `src/libraries/System.Composition.Hosting/src/System/Composition/Hosting/Core/CycleBreakingMetadataDictionary.cs`
- E-14: `src/libraries/System.Composition.Hosting/src/System/Composition/Hosting/Core/UpdateResult.cs`
- E-15: `src/libraries/System.Composition.Hosting/src/System/Composition/Hosting/Core/CompositeActivator.cs`
- E-16: `src/libraries/System.Composition.Hosting/src/System/Composition/Hosting/Util/SmallSparseInitonlyArray.cs`
- E-17: `src/libraries/System.Composition.Hosting/src/System/Composition/Hosting/Util/Formatters.cs`
- E-18: `src/libraries/System.Composition.Hosting/src/System/Composition/Hosting/Util/MethodInfoExtensions.cs`
- E-19: `src/libraries/System.Composition.Hosting/src/System/Composition/Hosting/Providers/ExportFactory/ExportFactoryExportDescriptorProvider.cs`
- E-20: `src/libraries/System.Composition.Hosting/src/System/Composition/Hosting/Providers/ExportFactory/ExportFactoryWithMetadataExportDescriptorProvider.cs`
- E-21: `src/libraries/System.Composition.Hosting/src/System/Composition/Hosting/Providers/CurrentScope/CurrentScopeExportDescriptorProvider.cs`
- E-22: `src/libraries/System.Composition.Hosting/src/System/Composition/Hosting/Providers/ImportMany/ImportManyExportDescriptorProvider.cs`
- E-23: `src/libraries/System.Composition.Hosting/src/System/Composition/Hosting/Providers/Lazy/LazyExportDescriptorProvider.cs`
- E-24: `src/libraries/System.Composition.Hosting/src/System/Composition/Hosting/Providers/Lazy/LazyWithMetadataExportDescriptorProvider.cs`
- E-25: `src/libraries/System.Composition.Hosting/src/System/Composition/Hosting/Providers/Metadata/MetadataViewProvider.cs`

## 3) Claims と根拠の対応（レビューの主戦場）

### CompositionHost (UT-SCH-001 - UT-SCH-009)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | CreateCompositionHost(params)でCompositionHostが作成される | E-01 (35-38行目) | ○ |
| C-02 | CreateCompositionHost(params)でnullはArgumentNullException | E-01 (44-46行目: ThrowIfNull) | ○ |
| C-03 | CreateCompositionHost(IEnumerable)でCompositionHostが作成される | E-01 (44-61行目) | ○ |
| C-04 | CreateCompositionHost(IEnumerable)でnullはArgumentNullException | E-01 (46行目) | ○ |
| C-05 | 組み込みプロバイダーが自動登録される | E-01 (48-57行目) | ○ |
| C-06 | TryGetExportで登録済みエクスポートが取得可能 | E-01 (71-74行目) | ○ |
| C-07 | TryGetExportで未登録はfalse | E-01 (71-74行目) | ○ |
| C-08 | DisposeでLifetimeContextが破棄される | E-01 (79-82行目) | ○ |
| C-09 | Dispose後のTryGetExport呼び出し | E-01, E-02 | ○ |

### LifetimeContext (UT-SCH-010 - UT-SCH-026)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-10 | AllocateSharingIdでユニークID生成 | E-02 (49-52行目: Interlocked.Increment) | ○ |
| C-11 | AllocateSharingIdはスレッドセーフ | E-02 (51行目: Interlocked使用) | ○ |
| C-12 | FindContextWithin(null)でルート返却 | E-02 (76-78行目) | ○ |
| C-13 | FindContextWithinで境界指定 | E-02 (80-88行目) | ○ |
| C-14 | FindContextWithinで存在しない境界はException | E-02 (94-97行目) | ○ |
| C-15 | Disposeでバインドインスタンス破棄 | E-02 (104-121行目) | ○ |
| C-16 | 複数回Disposeで例外なし | E-02 (107-114行目: null check) | ○ |
| C-17 | AddBoundInstanceでバインド | E-02 (128-137行目) | ○ |
| C-18 | Dispose後のAddBoundInstanceはException | E-02 (132-133行目) | ○ |
| C-19 | GetOrCreateで既存インスタンス取得 | E-02 (152-156行目) | ○ |
| C-20 | GetOrCreateでcreator実行 | E-02 (175行目) | ○ |
| C-21 | GetOrCreateで同一インスタンス返却 | E-02 (166-169行目) | ○ |
| C-22 | TryGetExportでエクスポート取得 | E-02 (195-206行目) | ○ |
| C-23 | TryGetExportで未登録はfalse | E-02 (198-202行目) | ○ |
| C-24 | ToStringでRoot表示 | E-02 (214-215行目) | ○ |
| C-25 | ToStringでNon-sharing表示 | E-02 (217-218行目) | ○ |
| C-26 | ToStringで境界名表示 | E-02 (220行目) | ○ |

### ExportDescriptor (UT-SCH-027 - UT-SCH-029)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-27 | Create(activator, metadata)で作成 | E-03 (31-34行目) | ○ |
| C-28 | activator=nullでArgumentNullException | E-11 (15行目: ThrowIfNull) | ○ |
| C-29 | metadata=nullでArgumentNullException | E-11 (16行目: ThrowIfNull) | ○ |

### ExportDescriptorProvider (UT-SCH-030 - UT-SCH-032)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-30 | NoExportDescriptorsは空コレクション | E-04 (21行目) | ○ |
| C-31 | NoMetadataは空ReadOnlyDictionary | E-04 (26行目) | ○ |
| C-32 | NoDependenciesは空を返すFunc | E-04 (31行目) | ○ |

### CompositionOperation (UT-SCH-033 - UT-SCH-040)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-33 | Run(context, activator)で実行 | E-05 (31-42行目) | ○ |
| C-34 | context=nullでArgumentNullException | E-05 (33行目) | ○ |
| C-35 | activator=nullでArgumentNullException | E-05 (34行目) | ○ |
| C-36 | AddNonPrerequisiteActionで遅延実行 | E-05 (49-56行目, 90-91行目) | ○ |
| C-37 | action=nullでArgumentNullException | E-05 (51行目) | ○ |
| C-38 | AddPostCompositionActionで後処理 | E-05 (63-70行目, 93-99行目) | ○ |
| C-39 | action=nullでArgumentNullException | E-05 (65行目) | ○ |
| C-40 | Disposeでロック解放 | E-05 (114-118行目) | ○ |

### CompositionDependency (UT-SCH-041 - UT-SCH-057)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-41 | Satisfiedで依存関係作成 | E-06 (40-47行目) | ○ |
| C-42 | Satisfied contract=nullでException | E-06 (42行目) | ○ |
| C-43 | Satisfied target=nullでException | E-06 (43行目) | ○ |
| C-44 | Satisfied site=nullでException | E-06 (44行目) | ○ |
| C-45 | MissingでIsError=true | E-06 (56-62行目, 138行目) | ○ |
| C-46 | Missing contract=nullでException | E-06 (58行目) | ○ |
| C-47 | Missing site=nullでException | E-06 (59行目) | ○ |
| C-48 | OversuppliedでIsError=true | E-06 (72-79行目, 138行目) | ○ |
| C-49 | Oversupplied contract=nullでException | E-06 (74行目) | ○ |
| C-50 | Oversupplied targets=nullでException | E-06 (75行目) | ○ |
| C-51 | Oversupplied site=nullでException | E-06 (76行目) | ○ |
| C-52 | Targetプロパティ取得 | E-06 (106行目) | ○ |
| C-53 | IsPrerequisiteプロパティ取得 | E-06 (113行目) | ○ |
| C-54 | Siteプロパティ取得 | E-06 (119行目) | ○ |
| C-55 | Contractプロパティ取得 | E-06 (124行目) | ○ |
| C-56 | ToString正常系 | E-06 (130-136行目) | ○ |
| C-57 | ToStringエラー時 | E-06 (132-133行目) | ○ |

### ExportDescriptorPromise (UT-SCH-058 - UT-SCH-066)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-58 | コンストラクタでパラメータ設定 | E-07 (36-48行目) | ○ |
| C-59 | Originプロパティ取得 | E-07 (54行目) | ○ |
| C-60 | IsSharedプロパティ取得 | E-07 (60行目) | ○ |
| C-61 | Dependenciesプロパティ取得 | E-07 (65行目) | ○ |
| C-62 | Contractプロパティ取得 | E-07 (70行目) | ○ |
| C-63 | GetDescriptor()で取得 | E-07 (76-95行目) | ○ |
| C-64 | 循環参照時CycleBreaking返却 | E-07 (78-79行目) | ○ |
| C-65 | null返却でArgumentNullException | E-07 (85-88行目) | ○ |
| C-66 | ToString | E-07 (101-104行目) | ○ |

### DependencyAccessor (UT-SCH-067 - UT-SCH-073)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-67 | ResolveDependenciesで全依存関係解決 | E-08 (28-35行目) | ○ |
| C-68 | ResolveDependencies空配列 | E-08 (30-34行目) | ○ |
| C-69 | ResolveRequiredDependency単一解決 | E-08 (44-51行目) | ○ |
| C-70 | ResolveRequiredDependency欠損検出 | E-08 (47-48行目) | ○ |
| C-71 | TryResolveOptionalDependency成功 | E-08 (61-78行目) | ○ |
| C-72 | TryResolveOptionalDependency失敗 | E-08 (64-68行目) | ○ |
| C-73 | TryResolveOptionalDependency過剰供給 | E-08 (70-74行目) | ○ |

### ExportDescriptorRegistry (UT-SCH-074 - UT-SCH-076)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-74 | TryGetSingleForExport単一取得 | E-09 (20-57行目) | ○ |
| C-75 | TryGetSingleForExport存在しない | E-09 (40-44行目) | ○ |
| C-76 | TryGetSingleForExport複数でException | E-09 (48-52行目) | ○ |

### ExportDescriptorRegistryUpdate (UT-SCH-077 - UT-SCH-080)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-77 | Execute更新実行 | E-10 (30-51行目) | ○ |
| C-78 | 2回目ExecuteでException | E-10 (34行目) | ○ |
| C-79 | 依存関係エラーでException | E-10 (54-66行目) | ○ |
| C-80 | 循環依存でException | E-10 (79-112行目) | ○ |

### DirectExportDescriptor (UT-SCH-081 - UT-SCH-082)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-81 | Activatorプロパティ取得 | E-11 (22行目) | ○ |
| C-82 | Metadataプロパティ取得 | E-11 (24行目) | ○ |

### CycleBreakingExportDescriptor (UT-SCH-083 - UT-SCH-087)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-83 | Activator評価済み | E-12 (18-27行目) | ○ |
| C-84 | Activator未評価 | E-12 (22-23行目) | ○ |
| C-85 | Metadata評価済み | E-12 (29-38行目) | ○ |
| C-86 | Metadata未評価 | E-12 (33-34行目) | ○ |
| C-87 | Activate未評価でException | E-12 (40-51行目) | ○ |

### CycleBreakingMetadataDictionary (UT-SCH-088 - UT-SCH-103)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-88 | Add未評価でException | E-13 (18-31行目, 33-36行目) | ○ |
| C-89 | ContainsKey未評価でException | E-13 (38-41行目) | ○ |
| C-90 | Keys未評価でException | E-13 (43-46行目) | ○ |
| C-91 | Remove未評価でException | E-13 (48-51行目) | ○ |
| C-92 | TryGetValue未評価でException | E-13 (53-56行目) | ○ |
| C-93 | Values未評価でException | E-13 (58-61行目) | ○ |
| C-94 | インデクサget未評価でException | E-13 (63-68行目) | ○ |
| C-95 | インデクサset未評価でException | E-13 (69-72行目) | ○ |
| C-96 | Add(KeyValuePair)未評価でException | E-13 (75-78行目) | ○ |
| C-97 | Clear未評価でException | E-13 (80-83行目) | ○ |
| C-98 | Contains未評価でException | E-13 (85-88行目) | ○ |
| C-99 | CopyTo未評価でException | E-13 (90-93行目) | ○ |
| C-100 | Count未評価でException | E-13 (95-98行目) | ○ |
| C-101 | IsReadOnly未評価でException | E-13 (100-103行目) | ○ |
| C-102 | Remove(KeyValuePair)未評価でException | E-13 (105-108行目) | ○ |
| C-103 | GetEnumerator未評価でException | E-13 (110-113行目) | ○ |

### UpdateResult (UT-SCH-104 - UT-SCH-109)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-104 | TryDequeueNextProvider成功 | E-14 (25-35行目) | ○ |
| C-105 | TryDequeueNextProvider空 | E-14 (27-31行目) | ○ |
| C-106 | AddPromise追加 | E-14 (37-41行目) | ○ |
| C-107 | GetResults取得 | E-14 (43-59行目) | ○ |
| C-108 | GetResultsプロバイダー残存でException | E-14 (47-50行目) | ○ |
| C-109 | GetResults空結果 | E-14 (52-53行目) | ○ |

### SmallSparseInitonlyArray (UT-SCH-110 - UT-SCH-118)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-110 | Add追加 | E-16 (20-58行目) | ○ |
| C-111 | Add重複でException | E-16 (34-37行目, 49-52行目) | ○ |
| C-112 | Add衝突処理 | E-16 (39-53行目) | ○ |
| C-113 | Addオーバーフロー | E-16 (55-57行目) | ○ |
| C-114 | TryGetValue取得 | E-16 (60-97行目) | ○ |
| C-115 | TryGetValue存在しない | E-16 (62-66行目, 79-84行目, 95-96行目) | ○ |
| C-116 | TryGetValue未初期化 | E-16 (62-66行目) | ○ |
| C-117 | TryGetValue衝突取得 | E-16 (76-90行目) | ○ |
| C-118 | TryGetValueオーバーフロー取得 | E-16 (92-93行目) | ○ |

### Formatters (UT-SCH-119 - UT-SCH-124)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-119 | ReadableListソートカンマ区切り | E-17 (11-17行目) | ○ |
| C-120 | ReadableList空 | E-17 (16行目) | ○ |
| C-121 | ReadableList nullでException | E-17 (13行目) | ○ |
| C-122 | Format非ジェネリック | E-17 (19-28行目) | ○ |
| C-123 | Formatジェネリック | E-17 (23-27行目, 30-42行目) | ○ |
| C-124 | Format nullでException | E-17 (21行目) | ○ |

### MethodInfoExtensions (UT-SCH-125)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-125 | CreateStaticDelegateデリゲート作成 | E-18 (10-13行目) | ○ |

### ExportFactoryExportDescriptorProvider (UT-SCH-126 - UT-SCH-128)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-126 | GetExportDescriptorsでExportFactory解決 | E-19 (16-24行目) | ○ |
| C-127 | 非該当コントラクトで空 | E-19 (18-19行目) | ○ |
| C-128 | SharingBoundary制約適用 | E-19 (31-37行目) | ○ |

### ExportFactoryWithMetadataExportDescriptorProvider (UT-SCH-129 - UT-SCH-130)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-129 | メタデータ付きExportFactory解決 | E-20 (18-27行目) | ○ |
| C-130 | 非該当コントラクトで空 | E-20 (20-21行目) | ○ |

### CurrentScopeExportDescriptorProvider (UT-SCH-131 - UT-SCH-132)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-131 | CompositionContext解決 | E-21 (13-24行目) | ○ |
| C-132 | 非該当コントラクトで空 | E-21 (15-16行目) | ○ |

### ImportManyExportDescriptorProvider (UT-SCH-133 - UT-SCH-138)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-133 | 配列ImportMany | E-22 (17-37行目) | ○ |
| C-134 | IList ImportMany | E-22 (15行目, 20行目) | ○ |
| C-135 | ICollection ImportMany | E-22 (15行目, 20行目) | ○ |
| C-136 | IEnumerable ImportMany | E-22 (15行目, 20行目) | ○ |
| C-137 | 制約なしで空 | E-22 (23-26行目) | ○ |
| C-138 | 非サポート型で空 | E-22 (19-21行目) | ○ |

### LazyExportDescriptorProvider (UT-SCH-139 - UT-SCH-140)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-139 | Lazy解決 | E-23 (17-25行目) | ○ |
| C-140 | 非該当コントラクトで空 | E-23 (19-20行目) | ○ |

### LazyWithMetadataExportDescriptorProvider (UT-SCH-141 - UT-SCH-142)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-141 | メタデータ付きLazy解決 | E-24 (17-26行目) | ○ |
| C-142 | 非該当コントラクトで空 | E-24 (19-20行目) | ○ |

### MetadataViewProvider (UT-SCH-143 - UT-SCH-150)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-143 | IDictionary型でそのまま返す | E-25 (21-22行目) | ○ |
| C-144 | 辞書コンストラクタ使用 | E-25 (28-41行目) | ○ |
| C-145 | プロパティ設定 | E-25 (43-71行目) | ○ |
| C-146 | 非クラス型でException | E-25 (24-25行目) | ○ |
| C-147 | 無効コンストラクタでException | E-25 (73行目) | ○ |
| C-148 | GetMetadataValue値取得 | E-25 (78-80行目) | ○ |
| C-149 | GetMetadataValueデフォルト値 | E-25 (82-83行目) | ○ |
| C-150 | GetMetadataValue欠損でException | E-25 (85-89行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（全てのテストケースにソースコードからの根拠あり）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全テストケースがソースコード解析に基づいており、根拠が明確

## 6) レビュアーチェックリスト（最小）
- [ ] テストケースの優先度が適切か確認（金額計算やセキュリティ関連は「高」になっているか）
- [ ] internal クラスのテストケースがパブリックAPIを通じてテスト可能か確認
- [ ] 循環依存関係（CycleBreaking系クラス）のテストケースが十分に網羅されているか確認
- [ ] スレッドセーフ関連のテスト（AllocateSharingId, SmallSparseInitonlyArray）の観点が適切か確認
- [ ] Providers内の各プロバイダーに対するテストケースのカバレッジが十分か確認
