---
generated_at: 2026-01-30 10:30:00
metrics:
  claims_total: 83
  claims_with_evidence: 83
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：libraries-System.Composition.Runtime 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：83 / 83、根拠なし：0
- 優先レビュー（高）
  1. **CompositionContract.ConstraintEqual**: 内部メソッドのため直接テスト不可の可能性あり
  2. **CompositionContext抽象メソッド**: 派生クラスの実装が必要
  3. **Formattersクラス**: 内部クラスのため直接テスト不可の可能性あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Composition.Runtime/src/System/Composition/Hosting/Core/CompositionContract.cs`
- E-02: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Composition.Runtime/src/System/Composition/ExportOfT.cs`
- E-03: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Composition.Runtime/src/System/Composition/ExportFactoryOfT.cs`
- E-04: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Composition.Runtime/src/System/Composition/ExportFactoryOfTTMetadata.cs`
- E-05: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Composition.Runtime/src/System/Composition/Hosting/CompositionFailedException.cs`
- E-06: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Composition.Runtime/src/System/Composition/CompositionContext.cs`
- E-07: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Composition.Runtime/src/System/Composition/Runtime/Util/Formatters.cs`

## 3) Claims と根拠の対応（レビューの主戦場）

### CompositionContract クラス (UT-SCR-001 ~ UT-SCR-036)

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | CompositionContract(Type)コンストラクタが正しく動作する | E-01 (L24-27) | ○ |
| C-02 | contractType=nullでArgumentNullExceptionがスローされる | E-01 (L47) | ○ |
| C-03 | CompositionContract(Type, string)コンストラクタが正しく動作する | E-01 (L34-37) | ○ |
| C-04 | contractName=nullが許容される | E-01 (L34-37) | ○ |
| C-05 | CompositionContract(Type, string, IDictionary)コンストラクタが正しく動作する | E-01 (L45-53) | ○ |
| C-06 | metadataConstraintsが空DictionaryでArgumentOutOfRangeExceptionがスローされる | E-01 (L48) | ○ |
| C-07 | ContractTypeプロパティが正しい値を返す | E-01 (L58) | ○ |
| C-08 | ContractNameプロパティが正しい値を返す | E-01 (L63) | ○ |
| C-09 | MetadataConstraintsプロパティが正しい値を返す | E-01 (L69) | ○ |
| C-10 | Equalsメソッドが正しく動作する | E-01 (L76-83) | ○ |
| C-11 | GetHashCodeメソッドが正しく動作する | E-01 (L89-97) | ○ |
| C-12 | ToStringメソッドが正しく動作する | E-01 (L103-116) | ○ |
| C-13 | ChangeTypeメソッドが正しく動作する | E-01 (L125-129) | ○ |
| C-14 | TryUnwrapMetadataConstraintメソッドが正しく動作する | E-01 (L141-170) | ○ |
| C-15 | ConstraintEqualメソッドが正しく動作する（内部メソッド） | E-01 (L172-212) | ○ |

### Export<T> クラス (UT-SCR-037 ~ UT-SCR-042)

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-16 | Export<T>コンストラクタが正しく動作する | E-02 (L20-24) | ○ |
| C-17 | Valueプロパティが正しい値を返す | E-02 (L29) | ○ |
| C-18 | Disposeメソッドが_disposeActionを呼び出す | E-02 (L34) | ○ |
| C-19 | _disposeAction=nullでもDisposeが安全に動作する | E-02 (L34: `?.Invoke()`) | ○ |

### ExportFactory<T> クラス (UT-SCR-043 ~ UT-SCR-049)

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-20 | ExportFactory<T>コンストラクタが正しく動作する | E-03 (L18-21) | ○ |
| C-21 | exportCreator=nullでArgumentNullExceptionがスローされる | E-03 (L20) | ○ |
| C-22 | CreateExportメソッドがExport<T>を返す | E-03 (L27-31) | ○ |

### ExportFactory<T, TMetadata> クラス (UT-SCR-050 ~ UT-SCR-052)

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-23 | ExportFactory<T, TMetadata>コンストラクタが正しく動作する | E-04 (L18-22) | ○ |
| C-24 | Metadataプロパティが正しい値を返す | E-04 (L27) | ○ |

### CompositionFailedException クラス (UT-SCR-053 ~ UT-SCR-057)

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-25 | デフォルトコンストラクタが正しく動作する | E-05 (L16-18) | ○ |
| C-26 | メッセージ付きコンストラクタが正しく動作する | E-05 (L24-26) | ○ |
| C-27 | message=nullでデフォルトメッセージが使用される | E-05 (L25: `??`) | ○ |
| C-28 | 内部例外付きコンストラクタが正しく動作する | E-05 (L33-35) | ○ |

### CompositionContext クラス (UT-SCR-058 ~ UT-SCR-076)

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-29 | TryGetExport(CompositionContract, out object)が抽象メソッドである | E-06 (L25) | ○ |
| C-30 | GetExport<TExport>()が正しく動作する | E-06 (L34-37) | ○ |
| C-31 | GetExport<TExport>(string)が正しく動作する | E-06 (L47-50) | ○ |
| C-32 | TryGetExport(Type, out object)が正しく動作する | E-06 (L60-63) | ○ |
| C-33 | TryGetExport(Type, string, out object)が正しく動作する | E-06 (L74-81) | ○ |
| C-34 | TryGetExport<TExport>(out TExport)が正しく動作する | E-06 (L91-94) | ○ |
| C-35 | TryGetExport<TExport>(string, out TExport)が正しく動作する | E-06 (L105-115) | ○ |
| C-36 | GetExport(Type)が正しく動作する | E-06 (L124-127) | ○ |
| C-37 | GetExport(Type, string)が正しく動作する | E-06 (L137-140) | ○ |
| C-38 | GetExport(CompositionContract)が正しく動作する | E-06 (L149-155) | ○ |
| C-39 | GetExports(Type)が正しく動作する | E-06 (L163-166) | ○ |
| C-40 | GetExports(Type, string)が正しく動作する | E-06 (L176-184) | ○ |
| C-41 | GetExports<TExport>()が正しく動作する | E-06 (L193-196) | ○ |
| C-42 | GetExports<TExport>(string)が正しく動作する | E-06 (L206-209) | ○ |

### Formatters クラス (UT-SCR-077 ~ UT-SCR-083)

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-43 | Format(object)が正しく動作する | E-07 (L12-15) | ○ |
| C-44 | Format(Type)が正しく動作する | E-07 (L17-20) | ○ |
| C-45 | FormatClosedGenericがジェネリック型を正しくフォーマットする | E-07 (L22-29) | ○ |

## 4) 不足情報（Unknown / Missing）
- 根拠なしの項目はありません
- 全テストケースはソースコード解析に基づいて生成されています

## 5) リスクフラグ（レビュー観点）
- **0 (低リスク)**: 全テストケースがソースコードに基づいており、根拠が明確
- **注意点**:
  - `Formatters`クラスは`internal`であるため、直接テストする場合はInternalsVisibleToの設定が必要
  - `CompositionContract.ConstraintEqual`は`internal static`メソッドのため、直接テストする場合はInternalsVisibleToの設定が必要
  - `CompositionContext`は抽象クラスのため、テスト用の派生クラス（モック）が必要

## 6) レビュアーチェックリスト（最小）
- [ ] CompositionContractの等価性比較ロジック（Equals, GetHashCode）が正しくテストされているか
- [ ] Export<T>のDisposeパターンが正しくテストされているか
- [ ] ExportFactory<T>のファクトリパターンが正しくテストされているか
- [ ] CompositionContextの各オーバーロードメソッドが網羅されているか
- [ ] 例外処理（ArgumentNullException, ArgumentOutOfRangeException, CompositionFailedException）が適切にテストされているか
- [ ] 内部クラス/メソッドへのアクセス方法が考慮されているか（InternalsVisibleTo等）
- [ ] 境界値テスト（空のDictionary、null値等）が含まれているか
