---
generated_at: 2026-01-30 10:30:00
metrics:
  claims_total: 111
  claims_with_evidence: 108
  claims_without_evidence: 3
confidence_derived: 0.97
---

# 根拠レポート：libraries-System.Composition.TypedParts 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各テストケースに対して、ソースコード上に対応するメソッド・処理が存在するか
2. **根拠との整合性**：テストケースの内容がソースコードの実装と矛盾していないか
3. **網羅性**：対象モジュールの主要なクラス・メソッドを適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：108 / 111、根拠なし：3
- 優先レビュー（高）
  1. **UT-CTP-088（スコープ越境）**：異なるスコープでのCompositionOperation.Run呼び出しの詳細動作確認が必要
  2. **UT-CTP-050（アクティベータキャッシュ）**：キャッシュ動作の暗黙的実装の検証
  3. **UT-CTP-053（重複クロージング防止）**：_appliedArgumentsリストの内部動作の検証

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `src/libraries/System.Composition.TypedParts/src/System/Composition/CompositionContextExtensions.cs`
- E-02: `src/libraries/System.Composition.TypedParts/src/System/Composition/Hosting/ContainerConfiguration.cs`
- E-03: `src/libraries/System.Composition.TypedParts/src/System/Composition/Hosting/SinglePartExportDescriptorProvider.cs`
- E-04: `src/libraries/System.Composition.TypedParts/src/System/Composition/Hosting/InstanceExportDescriptorProvider.cs`
- E-05: `src/libraries/System.Composition.TypedParts/src/System/Composition/TypedParts/TypedPartExportDescriptorProvider.cs`
- E-06: `src/libraries/System.Composition.TypedParts/src/System/Composition/TypedParts/Discovery/TypeInspector.cs`
- E-07: `src/libraries/System.Composition.TypedParts/src/System/Composition/TypedParts/Discovery/DiscoveredPart.cs`
- E-08: `src/libraries/System.Composition.TypedParts/src/System/Composition/TypedParts/Discovery/DiscoveredExport.cs`
- E-09: `src/libraries/System.Composition.TypedParts/src/System/Composition/TypedParts/Discovery/DiscoveredInstanceExport.cs`
- E-10: `src/libraries/System.Composition.TypedParts/src/System/Composition/TypedParts/Discovery/DiscoveredPropertyExport.cs`
- E-11: `src/libraries/System.Composition.TypedParts/src/System/Composition/TypedParts/ContractHelpers.cs`
- E-12: `src/libraries/System.Composition.TypedParts/src/System/Composition/TypedParts/ImportInfo.cs`
- E-13: `src/libraries/System.Composition.TypedParts/src/System/Composition/TypedParts/ActivationFeatures/ActivationFeature.cs`
- E-14: `src/libraries/System.Composition.TypedParts/src/System/Composition/TypedParts/ActivationFeatures/DisposalFeature.cs`
- E-15: `src/libraries/System.Composition.TypedParts/src/System/Composition/TypedParts/ActivationFeatures/PropertyInjectionFeature.cs`
- E-16: `src/libraries/System.Composition.TypedParts/src/System/Composition/TypedParts/ActivationFeatures/OnImportsSatisfiedFeature.cs`
- E-17: `src/libraries/System.Composition.TypedParts/src/System/Composition/TypedParts/ActivationFeatures/LifetimeFeature.cs`
- E-18: `src/libraries/System.Composition.TypedParts/src/System/Composition/TypedParts/ActivationFeatures/PropertyImportSite.cs`
- E-19: `src/libraries/System.Composition.TypedParts/src/System/Composition/TypedParts/Discovery/ParameterImportSite.cs`
- E-20: `src/libraries/System.Composition.TypedParts/src/System/Composition/TypedParts/Util/DirectAttributeContext.cs`
- E-21: `src/libraries/System.Composition.TypedParts/src/System/Composition/Convention/AttributedModelProviderExtensions.cs`
- E-22: `src/libraries/System.Composition.TypedParts/src/System/Composition/Debugging/DiscoveredPartDebuggerProxy.cs`
- E-23: `src/libraries/System.Composition.TypedParts/src/System/Composition/Debugging/ContainerConfigurationDebuggerProxy.cs`

## 3) Claims と根拠の対応（レビューの主戦場）

### CompositionContextExtensions（UT-CTP-001〜007）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | SatisfyImportsでImport属性付きプロパティに値が設定される | E-01: L28-31, L53-69 | ○ |
| C-02 | OnImportsSatisfiedAttributeメソッドが呼び出される | E-01: L72-76 | ○ |
| C-03 | exportProviderがnullの場合ArgumentNullException | E-01: L47 | ○ |
| C-04 | objectWithLooseImportsがnullの場合ArgumentNullException | E-01: L48 | ○ |
| C-05 | conventionsがnullの場合ArgumentNullException | E-01: L49 | ○ |
| C-06 | 必須Import依存が解決できない場合CompositionFailedException | E-01: L64-68 | ○ |
| C-07 | AllowDefault=trueの場合例外なし | E-01: L64 | ○ |

### ContainerConfiguration（UT-CTP-008〜024）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-08 | CreateContainerでCompositionHostが作成される | E-02: L31-43 | ○ |
| C-09 | WithProviderでプロバイダーが追加される | E-02: L50-56 | ○ |
| C-10 | WithProviderでnullの場合ArgumentNullException | E-02: L52 | ○ |
| C-11 | WithDefaultConventionsでコンベンション設定 | E-02: L65-74 | ○ |
| C-12 | WithDefaultConventionsでnullの場合ArgumentNullException | E-02: L67 | ○ |
| C-13 | WithDefaultConventions二重設定でInvalidOperationException | E-02: L69-70 | ○ |
| C-14 | WithPart(Type)でパート型追加 | E-02: L82-85 | ○ |
| C-15 | WithPart(Type)でnullの場合ArgumentNullException | E-02: L96 | ○ |
| C-16 | WithPart<TPart>でジェネリック指定追加 | E-02: L106-121 | ○ |
| C-17 | WithParts(Type[])で複数パート追加 | E-02: L129-132 | ○ |
| C-18 | WithParts(IEnumerable)でnullの場合ArgumentNullException | E-02: L154 | ○ |
| C-19 | WithAssemblyでアセンブリから追加 | E-02: L166-181 | ○ |
| C-20 | WithAssembliesでnullの場合ArgumentNullException | E-02: L203 | ○ |
| C-21 | WithExport<TExport>でインスタンス追加 | E-02: L214-219 | ○ |
| C-22 | WithExport<TExport>でnullの場合ArgumentNullException | E-02: L216 | ○ |
| C-23 | WithExport(Type, object)で型指定追加 | E-02: L242-248 | ○ |
| C-24 | WithExport(Type, object)でnullの場合ArgumentNullException | E-02: L244-245 | ○ |

### SinglePartExportDescriptorProvider（UT-CTP-025〜029）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-25 | IsSupportedContractで型・名前一致時true | E-03: L22-38 | ○ |
| C-26 | 契約型不一致でfalse | E-03: L24-26 | ○ |
| C-27 | 契約名不一致でfalse | E-03: L24-26 | ○ |
| C-28 | メタデータ制約一致でtrue | E-03: L28-36 | ○ |
| C-29 | メタデータ制約不一致でfalse | E-03: L34-35 | ○ |

### InstanceExportDescriptorProvider（UT-CTP-030〜031）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-30 | サポート契約でExportDescriptorPromise返却 | E-04: L19-23 | ○ |
| C-31 | 非サポート契約で空返却 | E-04: L21 | ○ |

### TypedPartExportDescriptorProvider（UT-CTP-032〜034）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-32 | 登録済みパートのExportDescriptorPromise返却 | E-05: L55-74 | ○ |
| C-33 | オープンジェネリックからクローズド生成 | E-05: L104-122 | ○ |
| C-34 | メタデータ制約付き契約で適切なエクスポート返却 | E-05: L77-100 | ○ |

### TypeInspector（UT-CTP-035〜042）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-35 | Export属性付きクラスからDiscoveredPart作成 | E-06: L27-41 | ○ |
| C-36 | 抽象クラスでfalse | E-06: L31 | ○ |
| C-37 | 非クラス型でfalse | E-06: L31 | ○ |
| C-38 | PartNotDiscoverable属性でfalse | E-06: L31 | ○ |
| C-39 | Export属性なしでfalse | E-06: L40 | ○ |
| C-40 | プロパティエクスポート発見 | E-06: L75-100 | ○ |
| C-41 | 契約型が代入不可でCompositionFailedException | E-06: L164-176, L224-234 | ○ |
| C-42 | ジェネリック型で非ジェネリック契約でCompositionFailedException | E-06: L178-184 | ○ |

### DiscoveredPart（UT-CTP-043〜055）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-43 | AddDiscoveredExportでエクスポート追加 | E-07: L66-70 | ○ |
| C-44 | IsSharedでSharingBoundaryありならtrue | E-07: L64 | ○ |
| C-45 | IsSharedでSharingBoundaryなしならfalse | E-07: L64 | ○ |
| C-46 | GetDependenciesでコンストラクタ依存関係取得 | E-07: L72-79 | ○ |
| C-47 | 複数ImportingConstructorでCompositionFailedException | E-07: L91-95 | ○ |
| C-48 | コンストラクタなしでCompositionFailedException | E-07: L108-112 | ○ |
| C-49 | GetActivatorでCompositeActivator返却 | E-07: L164-206 | ○ |
| C-50 | GetActivator2回目で同一インスタンス | E-07: L166 | △ |
| C-51 | TryCloseGenericPartでジェネリックパートクロージング | E-07: L222-256 | ○ |
| C-52 | 型制約不満足でfalse | E-07: L224-234 | ○ |
| C-53 | 同じ型引数で2回目はfalse | E-07: L236-239 | △ |
| C-54 | GetPartMetadataでメタデータ取得 | E-07: L208-220 | ○ |
| C-55 | メタデータなしで空辞書 | E-07: L219 | ○ |

### DiscoveredExport（UT-CTP-056〜060）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-56 | GetExportDescriptorPromiseでPromise生成 | E-08: L30-44 | ○ |
| C-57 | DiscoveredInstanceExport.GetExportDescriptor | E-09: L17-20 | ○ |
| C-58 | DiscoveredInstanceExport.CloseGenericExport | E-09: L22-27 | ○ |
| C-59 | DiscoveredPropertyExport.GetExportDescriptor | E-10: L23-33 | ○ |
| C-60 | DiscoveredPropertyExport.CloseGenericExport | E-10: L36-42 | ○ |

### ContractHelpers（UT-CTP-061〜070）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-61 | TryGetExplicitImportInfoでImport属性検出 | E-11: L17-27 | ○ |
| C-62 | TryGetExplicitImportInfoでImportMany属性検出 | E-11: L19 | ○ |
| C-63 | Import属性なしでfalse | E-11: L19-25 | ○ |
| C-64 | GetImportInfoでImportInfo作成 | E-11: L29-93 | ○ |
| C-65 | 契約名設定 | E-11: L41 | ○ |
| C-66 | AllowDefault設定 | E-11: L42 | ○ |
| C-67 | ImportMetadataConstraint処理 | E-11: L57-63 | ○ |
| C-68 | ImportとImportMany両方でCompositionFailedException | E-11: L81-85 | ○ |
| C-69 | IsSharedでSharingBoundaryキーありでtrue | E-11: L95-98 | ○ |
| C-70 | IsSharedでSharingBoundaryキーなしでfalse | E-11: L95-98 | ○ |

### ImportInfo（UT-CTP-071〜072）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-71 | Contractプロパティ | E-12: L21 | ○ |
| C-72 | AllowDefaultプロパティ | E-12: L19 | ○ |

### ActivationFeatures（UT-CTP-073〜092）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-73 | ActivationFeature.GetDependenciesデフォルト実装 | E-13: L40-43 | ○ |
| C-74 | DisposalFeatureでIDisposableバインド | E-14: L15-30 | ○ |
| C-75 | DisposalFeatureで非IDisposableは元のまま | E-14: L21-22 | ○ |
| C-76 | PropertyInjectionFeature.GetDependencies | E-15: L27-59 | ○ |
| C-77 | PropertyInjectionFeature依存なしで空配列 | E-15: L37-38 | ○ |
| C-78 | PropertyInjectionFeature.RewriteActivator | E-15: L61-112 | ○ |
| C-79 | PropertyInjectionFeature依存なしで元のまま | E-15: L71-72 | ○ |
| C-80 | OnImportsSatisfiedFeature.RewriteActivator | E-16: L29-64 | ○ |
| C-81 | OnImportsSatisfiedFeatureメソッドなしで元のまま | E-16: L35, L38-39 | ○ |
| C-82 | OnImportsSatisfiedFeatureでstaticメソッドエラー | E-16: L43-48 | ○ |
| C-83 | OnImportsSatisfiedFeatureで戻り値ありエラー | E-16: L43-48 | ○ |
| C-84 | OnImportsSatisfiedFeatureでパラメータありエラー | E-16: L43-48 | ○ |
| C-85 | OnImportsSatisfiedFeatureコンストラクタnullチェック | E-16: L24 | ○ |
| C-86 | LifetimeFeatureで共有パート処理 | E-17: L18-42 | ○ |
| C-87 | LifetimeFeatureで非共有は元のまま | E-17: L24-25 | ○ |
| C-88 | LifetimeFeatureで異なるスコープ処理 | E-17: L36-40 | △ |
| C-89 | PropertyImportSite.Property | E-18: L20 | ○ |
| C-90 | PropertyImportSite.ToString | E-18: L22-25 | ○ |
| C-91 | ParameterImportSite.Parameter | E-19: L17 | ○ |
| C-92 | ParameterImportSite.ToString | E-19: L19-22 | ○ |

### DirectAttributeContext（UT-CTP-093〜099）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-93 | GetCustomAttributes(MemberInfo)でメンバー属性取得 | E-20: L12-21 | ○ |
| C-94 | reflectedType nullでArgumentNullException | E-20: L14 | ○ |
| C-95 | member nullでArgumentNullException | E-20: L15 | ○ |
| C-96 | 宣言型不一致で空配列 | E-20: L17-18 | ○ |
| C-97 | GetCustomAttributes(ParameterInfo)でパラメータ属性取得 | E-20: L23-30 | ○ |
| C-98 | reflectedType nullでArgumentNullException（ParameterInfo版） | E-20: L27 | ○ |
| C-99 | parameter nullでArgumentNullException | E-20: L25 | ○ |

### AttributedModelProviderExtensions（UT-CTP-100〜105）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-100 | GetDeclaredAttribute<TAttribute>(MemberInfo) | E-21: L14-17 | ○ |
| C-101 | GetDeclaredAttributes(MemberInfo) | E-21: L19-22 | ○ |
| C-102 | GetDeclaredAttributes<TAttribute>(MemberInfo) | E-21: L24-27 | ○ |
| C-103 | GetDeclaredAttribute<TAttribute>(ParameterInfo) | E-21: L29-32 | ○ |
| C-104 | GetDeclaredAttributes(ParameterInfo) | E-21: L34-37 | ○ |
| C-105 | GetDeclaredAttributes<TAttribute>(ParameterInfo) | E-21: L39-42 | ○ |

### デバッグプロキシ（UT-CTP-106〜111）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-106 | DiscoveredPartDebuggerProxy.PartType | E-22: L20-23 | ○ |
| C-107 | DiscoveredPartDebuggerProxy.Exports | E-22: L25-28 | ○ |
| C-108 | DiscoveredPartDebuggerProxy.PartMetadata | E-22: L30-33 | ○ |
| C-109 | ContainerConfigurationDebuggerProxy.AddedExportDescriptorProviders | E-23: L26-30 | ○ |
| C-110 | ContainerConfigurationDebuggerProxy.DiscoveredParts | E-23: L32-40 | ○ |
| C-111 | ContainerConfigurationDebuggerProxy.IgnoredTypes | E-23: L42-50 | ○ |

## 4) 不足情報（Unknown / Missing）
- **UT-CTP-050（アクティベータキャッシュ）**：`_partActivator`フィールドのキャッシュ動作は実装から推測したものであり、明示的なテストシナリオの根拠が不足
  - 候補：既存テストコードの確認 / 実装コメントの確認
- **UT-CTP-053（重複クロージング防止）**：`_appliedArguments`リストによる重複防止は内部実装詳細であり、公開APIとしての仕様根拠が不足
  - 候補：設計ドキュメント / 既存テストコードの確認
- **UT-CTP-088（スコープ越境）**：`FindContextWithin`と`CompositionOperation.Run`の連携動作は他モジュール（System.Composition.Hosting）に依存
  - 候補：System.Composition.Hostingのドキュメント確認

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: デバッグプロキシ関連（UT-CTP-106〜111）- テスト実行に影響なし
- **1（中リスク）**: プロパティ・パラメータのnullチェック系テストケース - 実装が明確だが網羅性確認が必要
- **2（高リスク）**: ジェネリック型クロージング関連（UT-CTP-033, 051〜053）- 複雑なロジックでエッジケースが存在する可能性

## 6) レビュアーチェックリスト（最小）
- [ ] ジェネリック型のクロージング処理（TryCloseGenericPart）のテストケースが型制約の全パターンをカバーしているか確認
- [ ] OnImportsSatisfiedFeatureのエラーケースが全てのメソッドシグネチャ違反パターンをカバーしているか確認
- [ ] ContainerConfigurationの各WithXxxメソッドのfluent APIチェーンが正しく動作することを確認するテストがあるか
- [ ] 共有パート（Shared）と非共有パートのライフタイム管理の境界条件テストが十分か確認
- [ ] メタデータ制約マッチングのエッジケース（部分一致、null値など）がカバーされているか確認
