---
generated_at: 2026-01-30 12:30:00
metrics:
  claims_total: 140
  claims_with_evidence: 138
  claims_without_evidence: 2
confidence_derived: 0.99
---

# 根拠レポート：libraries-System.Composition 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各テストケースに対して、ソースコード内のメソッド定義・パラメータ検証・例外処理などの根拠（Evidence）が存在するか
2. **根拠との整合性**：テストケースの内容が実装コードと矛盾していないか
3. **網羅性**：主要なクラス・メソッドを適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.99**
  - 根拠あり：138 / 140、根拠なし：2
- 優先レビュー（高）
  1. **C-139**: SatisfyImports拡張メソッドの実装詳細確認が必要
  2. **C-140**: SatisfyImportsの例外ケースの実装詳細確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Composition.Runtime/src/System/Composition/CompositionContext.cs`
- E-02: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Composition.Runtime/src/System/Composition/ExportOfT.cs`
- E-03: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Composition.Runtime/src/System/Composition/ExportFactoryOfT.cs`
- E-04: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Composition.Runtime/src/System/Composition/Hosting/Core/CompositionContract.cs`
- E-05: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Composition.Runtime/src/System/Composition/Hosting/CompositionFailedException.cs`
- E-06: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Composition.Hosting/src/System/Composition/Hosting/CompositionHost.cs`
- E-07: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Composition.Hosting/src/System/Composition/Hosting/Core/LifetimeContext.cs`
- E-08: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Composition.Hosting/src/System/Composition/Hosting/Core/ExportDescriptorProvider.cs`
- E-09: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Composition.Hosting/src/System/Composition/Hosting/Core/ExportDescriptor.cs`
- E-10: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Composition.Hosting/src/System/Composition/Hosting/Core/CompositionDependency.cs`
- E-11: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Composition.Hosting/src/System/Composition/Hosting/Core/ExportDescriptorPromise.cs`
- E-12: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Composition.Hosting/src/System/Composition/Hosting/Core/CompositionOperation.cs`
- E-13: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Composition.AttributedModel/src/System/Composition/ExportAttribute.cs`
- E-14: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Composition.AttributedModel/src/System/Composition/ImportAttribute.cs`
- E-15: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Composition.AttributedModel/src/System/Composition/ImportManyAttribute.cs`
- E-16: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Composition.AttributedModel/src/System/Composition/SharedAttribute.cs`
- E-17: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Composition.AttributedModel/src/System/Composition/SharingBoundaryAttribute.cs`
- E-18: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Composition.AttributedModel/src/System/Composition/ExportMetadataAttribute.cs`
- E-19: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Composition.AttributedModel/src/System/Composition/PartMetadataAttribute.cs`
- E-20: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Composition.AttributedModel/src/System/Composition/PartNotDiscoverableAttribute.cs`
- E-21: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Composition.AttributedModel/src/System/Composition/ImportMetadataConstraintAttribute.cs`
- E-22: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Composition.AttributedModel/src/System/Composition/ImportingConstructorAttribute.cs`
- E-23: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Composition.TypedParts/src/System/Composition/Hosting/ContainerConfiguration.cs`
- E-24: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Composition.Convention/src/System/Composition/Convention/ConventionBuilder.cs`
- E-25: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Composition.TypedParts/src/System/Composition/CompositionContextExtensions.cs`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | CompositionContext.TryGetExport(CompositionContract)正常系 | E-01 (line 25) | ○ |
| C-02 | CompositionContext.GetExport<TExport>()正常系 | E-01 (lines 34-37) | ○ |
| C-03 | CompositionContext.GetExport<TExport>(string)正常系 | E-01 (lines 47-50) | ○ |
| C-04 | CompositionContext.GetExport(Type, string)正常系 | E-01 (lines 137-140) | ○ |
| C-05 | CompositionContext.GetExport異常系（未登録） | E-01 (lines 149-155) CompositionFailedException | ○ |
| C-06 | CompositionContext.TryGetExport(Type)正常系 | E-01 (lines 60-63) | ○ |
| C-07 | CompositionContext.TryGetExport(Type, string)異常系 | E-01 (lines 74-81) | ○ |
| C-08 | CompositionContext.TryGetExport<TExport>正常系 | E-01 (lines 91-94) | ○ |
| C-09 | CompositionContext.GetExports(Type)正常系 | E-01 (lines 163-184) | ○ |
| C-10 | CompositionContext.GetExports<TExport>正常系 | E-01 (lines 193-196) | ○ |
| C-11 | CompositionContext.GetExports<TExport>(string)正常系 | E-01 (lines 206-209) | ○ |
| C-12 | Export<T>コンストラクタ正常系 | E-02 (lines 20-24) | ○ |
| C-13 | Export<T>.Value正常系 | E-02 (line 29) | ○ |
| C-14 | Export<T>.Dispose正常系 | E-02 (line 34) | ○ |
| C-15 | Export<T>.Dispose null安全性 | E-02 (line 34) _disposeAction?.Invoke() | ○ |
| C-16 | ExportFactory<T>コンストラクタ正常系 | E-03 (lines 17-21) | ○ |
| C-17 | ExportFactory<T>コンストラクタnull検証 | E-03 (line 20) throw ArgumentNullException | ○ |
| C-18 | ExportFactory<T>.CreateExport正常系 | E-03 (lines 27-31) | ○ |
| C-19 | ExportFactory<T>.CreateExport複数回呼び出し | E-03 (lines 27-31) 毎回Invoke | ○ |
| C-20 | CompositionContract(Type)正常系 | E-04 (lines 24-27) | ○ |
| C-21 | CompositionContract(Type)null検証 | E-04 (line 47) throw ArgumentNullException | ○ |
| C-22 | CompositionContract(Type, string)正常系 | E-04 (lines 34-37) | ○ |
| C-23 | CompositionContract(Type, string, IDictionary)正常系 | E-04 (lines 45-53) | ○ |
| C-24 | CompositionContract空制約エラー | E-04 (line 48) ArgumentOutOfRangeException | ○ |
| C-25 | CompositionContract.ContractType | E-04 (line 58) | ○ |
| C-26 | CompositionContract.ContractName | E-04 (line 63) | ○ |
| C-27 | CompositionContract.Equals同一 | E-04 (lines 76-83) | ○ |
| C-28 | CompositionContract.Equals異なる | E-04 (lines 76-83) | ○ |
| C-29 | CompositionContract.Equals null | E-04 (lines 78-79) as pattern | ○ |
| C-30 | CompositionContract.GetHashCode | E-04 (lines 89-97) | ○ |
| C-31 | CompositionContract.ToString | E-04 (lines 103-116) | ○ |
| C-32 | CompositionContract.ChangeType正常系 | E-04 (lines 125-129) | ○ |
| C-33 | CompositionContract.ChangeType null検証 | E-04 (line 127) throw ArgumentNullException | ○ |
| C-34 | CompositionContract.TryUnwrapMetadataConstraint正常系 | E-04 (lines 141-170) | ○ |
| C-35 | CompositionContract.TryUnwrapMetadataConstraint存在しない | E-04 (lines 148-152) | ○ |
| C-36 | CompositionContract.TryUnwrapMetadataConstraint null検証 | E-04 (line 143) ArgumentNullException.ThrowIfNull | ○ |
| C-37 | CompositionFailedExceptionデフォルトコンストラクタ | E-05 (lines 16-18) | ○ |
| C-38 | CompositionFailedException(string) | E-05 (lines 24-26) | ○ |
| C-39 | CompositionFailedException(string) null処理 | E-05 (line 25) ?? operator | ○ |
| C-40 | CompositionFailedException(string, Exception) | E-05 (lines 33-35) | ○ |
| C-41 | CompositionHost.CreateCompositionHost(params) | E-06 (lines 35-38) | ○ |
| C-42 | CompositionHost.CreateCompositionHost(IEnumerable) | E-06 (lines 44-61) | ○ |
| C-43 | CompositionHost.CreateCompositionHost null検証 | E-06 (line 46) ArgumentNullException.ThrowIfNull | ○ |
| C-44 | CompositionHost.TryGetExport | E-06 (lines 71-74) | ○ |
| C-45 | CompositionHost.Dispose | E-06 (lines 79-82) | ○ |
| C-46 | LifetimeContext.AllocateSharingId | E-07 (lines 49-52) | ○ |
| C-47 | LifetimeContext.AllocateSharingId一意性 | E-07 (line 51) Interlocked.Increment | ○ |
| C-48 | LifetimeContext.FindContextWithin正常系 | E-07 (lines 75-98) | ○ |
| C-49 | LifetimeContext.FindContextWithin null→root | E-07 (lines 77-78) | ○ |
| C-50 | LifetimeContext.FindContextWithin存在しない境界 | E-07 (lines 94-97) CompositionFailedException | ○ |
| C-51 | LifetimeContext.Dispose | E-07 (lines 104-121) | ○ |
| C-52 | LifetimeContext.AddBoundInstance正常系 | E-07 (lines 128-137) | ○ |
| C-53 | LifetimeContext.AddBoundInstance Dispose後 | E-07 (lines 132-133) ObjectDisposedException | ○ |
| C-54 | LifetimeContext.GetOrCreate新規生成 | E-07 (lines 152-185) | ○ |
| C-55 | LifetimeContext.GetOrCreate既存取得 | E-07 (lines 155-156, 166-169) | ○ |
| C-56 | LifetimeContext.TryGetExport | E-07 (lines 195-206) | ○ |
| C-57 | LifetimeContext.ToString | E-07 (lines 212-221) | ○ |
| C-58 | ExportDescriptorProvider.NoExportDescriptors | E-08 (line 21) | ○ |
| C-59 | ExportDescriptorProvider.NoMetadata | E-08 (line 26) | ○ |
| C-60 | ExportDescriptorProvider.NoDependencies | E-08 (line 31) | ○ |
| C-61 | ExportDescriptor.Create | E-09 (lines 31-34) | ○ |
| C-62 | ExportDescriptor.Activator | E-09 (line 18) | ○ |
| C-63 | ExportDescriptor.Metadata | E-09 (line 23) | ○ |
| C-64 | CompositionDependency.Satisfied | E-10 (lines 40-47) | ○ |
| C-65 | CompositionDependency.Satisfied null検証 | E-10 (lines 42-44) ArgumentNullException.ThrowIfNull | ○ |
| C-66 | CompositionDependency.Missing | E-10 (lines 56-62) | ○ |
| C-67 | CompositionDependency.Oversupplied | E-10 (lines 72-79) | ○ |
| C-68 | CompositionDependency.Target | E-10 (line 106) | ○ |
| C-69 | CompositionDependency.IsPrerequisite | E-10 (line 113) | ○ |
| C-70 | CompositionDependency.Contract | E-10 (line 124) | ○ |
| C-71 | CompositionDependency.ToString | E-10 (lines 130-136) | ○ |
| C-72 | ExportDescriptorPromiseコンストラクタ | E-11 (lines 36-48) | ○ |
| C-73 | ExportDescriptorPromise.Origin | E-11 (line 54) | ○ |
| C-74 | ExportDescriptorPromise.IsShared | E-11 (line 60) | ○ |
| C-75 | ExportDescriptorPromise.Dependencies | E-11 (line 65) | ○ |
| C-76 | ExportDescriptorPromise.Contract | E-11 (line 70) | ○ |
| C-77 | ExportDescriptorPromise.GetDescriptor正常系 | E-11 (lines 76-95) | ○ |
| C-78 | ExportDescriptorPromise.GetDescriptor null例外 | E-11 (lines 85-88) ArgumentNullException | ○ |
| C-79 | ExportDescriptorPromise.GetDescriptor循環検出 | E-11 (lines 78-79) CycleBreakingExportDescriptor | ○ |
| C-80 | CompositionOperation.Run正常系 | E-12 (lines 31-42) | ○ |
| C-81 | CompositionOperation.Run context null | E-12 (line 33) ArgumentNullException.ThrowIfNull | ○ |
| C-82 | CompositionOperation.Run activator null | E-12 (line 34) ArgumentNullException.ThrowIfNull | ○ |
| C-83 | CompositionOperation.AddNonPrerequisiteAction正常系 | E-12 (lines 49-56) | ○ |
| C-84 | CompositionOperation.AddNonPrerequisiteAction null | E-12 (line 51) ArgumentNullException.ThrowIfNull | ○ |
| C-85 | CompositionOperation.AddPostCompositionAction正常系 | E-12 (lines 63-70) | ○ |
| C-86 | CompositionOperation.AddPostCompositionAction null | E-12 (line 65) ArgumentNullException.ThrowIfNull | ○ |
| C-87 | CompositionOperation.Dispose | E-12 (lines 114-118) | ○ |
| C-88 | ExportAttributeデフォルトコンストラクタ | E-13 (lines 18-20) | ○ |
| C-89 | ExportAttribute(Type) | E-13 (lines 33-35) | ○ |
| C-90 | ExportAttribute(string) | E-13 (lines 46-48) | ○ |
| C-91 | ExportAttribute(string, Type) | E-13 (lines 64-68) | ○ |
| C-92 | ImportAttributeデフォルトコンストラクタ | E-14 (lines 18-20) | ○ |
| C-93 | ImportAttribute(string) | E-14 (lines 31-34) | ○ |
| C-94 | ImportAttribute.AllowDefault | E-14 (line 50) | ○ |
| C-95 | ImportManyAttributeデフォルトコンストラクタ | E-15 (lines 18-20) | ○ |
| C-96 | ImportManyAttribute(string) | E-15 (lines 31-34) | ○ |
| C-97 | SharedAttributeデフォルトコンストラクタ | E-16 (lines 22-24) | ○ |
| C-98 | SharedAttribute(string) | E-16 (lines 32-34) | ○ |
| C-99 | SharingBoundaryAttribute(params string[]) | E-17 (lines 30-33) | ○ |
| C-100 | SharingBoundaryAttribute null検証 | E-17 (line 32) throw ArgumentNullException | ○ |
| C-101 | ExportMetadataAttribute(string, object) | E-18 (lines 27-31) | ○ |
| C-102 | ExportMetadataAttribute name null処理 | E-18 (line 29) ?? string.Empty | ○ |
| C-103 | PartMetadataAttribute(string, object) | E-19 (lines 24-28) | ○ |
| C-104 | PartMetadataAttribute name null検証 | E-19 (line 26) throw ArgumentNullException | ○ |
| C-105 | PartNotDiscoverableAttributeコンストラクタ | E-20 (lines 14-16) | ○ |
| C-106 | ImportMetadataConstraintAttribute(string, object) | E-21 (lines 17-21) | ○ |
| C-107 | ImportingConstructorAttributeコンストラクタ | E-22 (lines 19-21) | ○ |
| C-108 | ContainerConfiguration.CreateContainer | E-23 (lines 31-43) | ○ |
| C-109 | ContainerConfiguration.WithProvider正常系 | E-23 (lines 50-56) | ○ |
| C-110 | ContainerConfiguration.WithProvider null検証 | E-23 (line 52) ArgumentNullException.ThrowIfNull | ○ |
| C-111 | ContainerConfiguration.WithDefaultConventions正常系 | E-23 (lines 65-74) | ○ |
| C-112 | ContainerConfiguration.WithDefaultConventions null検証 | E-23 (line 67) ArgumentNullException.ThrowIfNull | ○ |
| C-113 | ContainerConfiguration.WithDefaultConventions重複設定 | E-23 (lines 69-70) InvalidOperationException | ○ |
| C-114 | ContainerConfiguration.WithPart(Type)正常系 | E-23 (lines 82-85) | ○ |
| C-115 | ContainerConfiguration.WithPart(Type) null検証 | E-23 (line 96) throw ArgumentNullException | ○ |
| C-116 | ContainerConfiguration.WithPart<TPart>() | E-23 (lines 106-109) | ○ |
| C-117 | ContainerConfiguration.WithParts(params Type[]) | E-23 (lines 129-132) | ○ |
| C-118 | ContainerConfiguration.WithParts(IEnumerable<Type>) | E-23 (lines 140-143) | ○ |
| C-119 | ContainerConfiguration.WithParts null検証 | E-23 (line 154) ArgumentNullException.ThrowIfNull | ○ |
| C-120 | ContainerConfiguration.WithAssembly(Assembly) | E-23 (lines 166-169) | ○ |
| C-121 | ContainerConfiguration.WithAssemblies(IEnumerable<Assembly>) | E-23 (lines 201-206) | ○ |
| C-122 | ContainerConfiguration.WithAssemblies null検証 | E-23 (line 203) ArgumentNullException.ThrowIfNull | ○ |
| C-123 | ContainerConfiguration.WithExport<TExport>(TExport) | E-23 (lines 214-219) | ○ |
| C-124 | ContainerConfiguration.WithExport null検証 | E-23 (line 216) ArgumentNullException.ThrowIfNull | ○ |
| C-125 | ContainerConfiguration.WithExport(Type, object, string, IDictionary) | E-23 (lines 258-264) | ○ |
| C-126 | ConventionBuilder.ForTypesDerivedFrom<T> | E-24 (lines 35-40) | ○ |
| C-127 | ConventionBuilder.ForTypesDerivedFrom(Type) | E-24 (lines 48-55) | ○ |
| C-128 | ConventionBuilder.ForTypesDerivedFrom(Type) null検証 | E-24 (line 50) ArgumentNullException.ThrowIfNull | ○ |
| C-129 | ConventionBuilder.ForType<T> | E-24 (lines 62-67) | ○ |
| C-130 | ConventionBuilder.ForType(Type) | E-24 (lines 74-81) | ○ |
| C-131 | ConventionBuilder.ForType(Type) null検証 | E-24 (line 76) ArgumentNullException.ThrowIfNull | ○ |
| C-132 | ConventionBuilder.ForTypesMatching<T> | E-24 (lines 90-97) | ○ |
| C-133 | ConventionBuilder.ForTypesMatching<T> null検証 | E-24 (line 92) ArgumentNullException.ThrowIfNull | ○ |
| C-134 | ConventionBuilder.ForTypesMatching | E-24 (lines 105-112) | ○ |
| C-135 | ConventionBuilder.GetCustomAttributes(Type, MemberInfo) | E-24 (lines 147-230) | ○ |
| C-136 | ConventionBuilder.GetCustomAttributes member null検証 | E-24 (line 149) ArgumentNullException.ThrowIfNull | ○ |
| C-137 | ConventionBuilder.GetCustomAttributes(Type, ParameterInfo) | E-24 (lines 284-291) | ○ |
| C-138 | ConventionBuilder.GetCustomAttributes parameter null検証 | E-24 (line 286) ArgumentNullException.ThrowIfNull | ○ |
| C-139 | CompositionContextExtensions.SatisfyImports正常系 | E-25 | △ |
| C-140 | CompositionContextExtensions.SatisfyImports異常系 | E-25 | △ |

## 4) 不足情報（Unknown / Missing）
- **CompositionContextExtensions.SatisfyImportsの詳細実装**
  - 根拠ファイルE-25は存在するが、具体的なメソッド実装の詳細確認が必要
  - 候補：既存テストコード `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Composition/tests/LooseImportsTests.cs` を参照して補完可能

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 大部分のテストケースはソースコードから直接確認可能
- 1: 中リスク - CompositionContextExtensions関連（C-139, C-140）は実装詳細の確認推奨
- 0: 低リスク - 属性クラスのテストケースは単純なコンストラクタ・プロパティ検証のみ

## 6) レビュアーチェックリスト（最小）
- [ ] C-139, C-140のSatisfyImports関連テストケースの妥当性確認
- [ ] 優先度「高」のテストケースが実際のビジネスロジック・エラーハンドリングをカバーしているか確認
- [ ] 境界値テストケースの網羅性確認（特にnullチェック、空コレクション）
- [ ] マルチスレッド関連のテストケース（GetOrCreate、ロック処理）の妥当性確認
- [ ] 循環参照検出テストケース（C-79）の実装詳細との整合性確認
