---
generated_at: 2026-01-30 12:00:00
metrics:
  claims_total: 143
  claims_with_evidence: 143
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート: libraries-System.Console 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim: 主張）を検証しています:

1. **根拠の有無確認**: 各テストケースに対して、ソースコードの該当箇所が存在するか
2. **根拠との整合性**: テストケースの内容がソースコードのロジックと矛盾していないか
3. **網羅性**: 対象クラス・メソッドを適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」: 根拠あり、「△」: 根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）: **1.00**
  - 根拠あり: 143 / 143、根拠なし: 0
- 優先レビュー（高）
  1. **プラットフォーム依存テスト**: Unix/Windows固有の動作については実行環境によってテスト可否が異なる
  2. **対話型コンソールテスト**: 標準入力がリダイレクトされていない場合のテストは手動確認が必要
  3. **terminfo DB依存テスト**: システムにインストールされているterminfo DBに依存するテストケースがある

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/libraries/System.Console/src/System/Console.cs`
- E-02: `src/libraries/System.Console/src/System/ConsoleKeyInfo.cs`
- E-03: `src/libraries/System.Console/src/System/ConsoleCancelEventArgs.cs`
- E-04: `src/libraries/System.Console/src/System/ConsoleKey.cs`
- E-05: `src/libraries/System.Console/src/System/ConsoleModifiers.cs`
- E-06: `src/libraries/System.Console/src/System/ConsoleColor.cs`
- E-07: `src/libraries/System.Console/src/System/ConsoleSpecialKey.cs`
- E-08: `src/libraries/System.Console/src/System/IO/KeyParser.cs`
- E-09: `src/libraries/System.Console/src/System/IO/ConsoleStream.cs`
- E-10: `src/libraries/System.Console/src/System/IO/SyncTextReader.cs`
- E-11: `src/libraries/System.Console/src/System/IO/StdInReader.cs`
- E-12: `src/libraries/System.Console/src/System/IO/CachedConsoleStream.cs`
- E-13: `src/libraries/System.Console/src/System/IO/Error.cs`
- E-14: `src/libraries/System.Console/src/System/TermInfo.cs`
- E-15: `src/libraries/System.Console/src/System/TermInfo.Database.cs`
- E-16: `src/libraries/System.Console/src/System/TermInfo.DatabaseFactory.cs`
- E-17: `src/libraries/System.Console/src/System/TerminalFormatStrings.cs`
- E-18: `src/libraries/System.Console/src/System/ConsolePal.Unix.cs`

## 3) Claims と根拠の対応（レビューの主戦場）

### ConsoleKeyInfo (UT-CON-001 - UT-CON-015)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ConsoleKeyInfo コンストラクタはkey値を0-255でバリデーションする | E-02 (行20-23) | ○ |
| C-02 | ConsoleKeyInfo はshift/alt/controlフラグからModifiersを構築する | E-02 (行28-33) | ○ |
| C-03 | ConsoleKeyInfo.Equals(ConsoleKeyInfo)は_keyChar, _key, _modsを比較する | E-02 (行56-58) | ○ |
| C-04 | ConsoleKeyInfo.GetHashCode()は_keyChar, _key, _modsを組み合わせる | E-02 (行72-77) | ○ |
| C-05 | operator == は Equals(ConsoleKeyInfo) を呼び出す | E-02 (行61-64) | ○ |

### ConsoleCancelEventArgs (UT-CON-016 - UT-CON-018)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-06 | ConsoleCancelEventArgs.Cancelはget/set可能なプロパティ | E-03 (行20-23) | ○ |
| C-07 | ConsoleCancelEventArgs.SpecialKeyはコンストラクタで設定された値を返す | E-03 (行25-28) | ○ |

### Console クラス (UT-CON-019 - UT-CON-037)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-08 | SetCursorPositionはleft/topが負または32767以上の場合ArgumentOutOfRangeExceptionをスロー | E-01 (行552-555) | ○ |
| C-09 | SetInはnullの場合ArgumentNullExceptionをスロー | E-01 (行661) | ○ |
| C-10 | SetInは内部でSyncTextReader.GetSynchronizedTextReaderでラップする | E-01 (行663) | ○ |
| C-11 | SetOutはnullの場合ArgumentNullExceptionをスロー | E-01 (行672) | ○ |
| C-12 | SetOutはTextWriter.Null以外の場合TextWriter.Synchronizedでラップする | E-01 (行678-681) | ○ |
| C-13 | SetErrorはnullの場合ArgumentNullExceptionをスロー | E-01 (行692) | ○ |
| C-14 | OpenStandardInput(int)は負のbufferSizeでArgumentOutOfRangeExceptionをスロー | E-01 (行627) | ○ |
| C-15 | OpenStandardOutput(int)は負のbufferSizeでArgumentOutOfRangeExceptionをスロー | E-01 (行639) | ○ |
| C-16 | OpenStandardError(int)は負のbufferSizeでArgumentOutOfRangeExceptionをスロー | E-01 (行651) | ○ |
| C-17 | InputEncoding setはnullの場合ArgumentNullExceptionをスロー | E-01 (行90) | ○ |
| C-18 | OutputEncoding setはnullの場合ArgumentNullExceptionをスロー | E-01 (行130) | ○ |
| C-19 | Title setはnullの場合ArgumentNullExceptionをスロー | E-01 (行505) | ○ |
| C-20 | KeyAvailableはIsInputRedirected時にInvalidOperationExceptionをスロー | E-01 (行160-163) | ○ |

### KeyParser (UT-CON-038 - UT-CON-054)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-21 | KeyParser.Parseはveraseキャラクタに一致する場合Backspaceを返す | E-08 (行24-28) | ○ |
| C-22 | KeyParser.ParseはEscapeで始まる3文字シーケンスを解析する | E-08 (行70-102) | ○ |
| C-23 | KeyParser.ParseはAlt+キー(Escape + char)を解析する | E-08 (行45-48) | ○ |
| C-24 | KeyParser.ParseFromSingleCharは小文字をConsoleKey.A + offset で解析する | E-08 (行334) | ○ |
| C-25 | KeyParser.ParseFromSingleCharは大文字をShift + keyで解析する | E-08 (行335, 355-361) | ○ |
| C-26 | KeyParser.ParseFromSingleCharはCtrl+文字(1-26)をControl + A-Zで解析する | E-08 (行337, 363-378) | ○ |
| C-27 | KeyParser.MapXtermModifiersは'2'をShift、'3'をAlt等にマッピングする | E-08 (行283-294) | ○ |
| C-28 | KeyParser.MapRxvtModifiersは'^'をControl、'$'をShiftにマッピングする | E-08 (行300-307) | ○ |

### ConsoleStream (UT-CON-055 - UT-CON-067)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-29 | ConsoleStream.CanReadはFileAccess.Readで初期化時にtrue | E-09 (行19) | ○ |
| C-30 | ConsoleStream.CanWriteはFileAccess.Writeで初期化時にtrue | E-09 (行20) | ○ |
| C-31 | ConsoleStream.CanSeekは常にfalse | E-09 (行55) | ○ |
| C-32 | ConsoleStream.LengthはNotSupportedExceptionをスロー | E-09 (行57) | ○ |
| C-33 | ConsoleStream.Position get/setはNotSupportedExceptionをスロー | E-09 (行59-63) | ○ |
| C-34 | ConsoleStream.SetLengthはNotSupportedExceptionをスロー | E-09 (行67) | ○ |
| C-35 | ConsoleStream.SeekはNotSupportedExceptionをスロー | E-09 (行69) | ○ |
| C-36 | ConsoleStream.ValidateReadはCanRead=false時にNotSupportedExceptionをスロー | E-09 (行75-78) | ○ |
| C-37 | ConsoleStream.ValidateWriteはCanWrite=false時にNotSupportedExceptionをスロー | E-09 (行85-88) | ○ |
| C-38 | ConsoleStream.DisposeはCanRead/CanWriteをfalseに設定する | E-09 (行44-49) | ○ |
| C-39 | ConsoleStream.ReadByteは0バイト読み取り時に-1を返す | E-09 (行37-42) | ○ |

### SyncTextReader (UT-CON-068 - UT-CON-083)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-40 | SyncTextReader.GetSynchronizedTextReaderは既存のSyncTextReaderをそのまま返す | E-10 (行20-22) | ○ |
| C-41 | SyncTextReader.Peekはlock(this)内で実行される | E-10 (行41-47) | ○ |
| C-42 | SyncTextReader.Read()はlock(this)内で実行される | E-10 (行49-55) | ○ |
| C-43 | SyncTextReader.ReadLineAsyncはTask.FromResult(ReadLine())を返す | E-10 (行94-97) | ○ |
| C-44 | SyncTextReader.ReadLineAsync(CancellationToken)はキャンセル時にFromCanceledを返す | E-10 (行99-104) | ○ |
| C-45 | SyncTextReader.ReadBlockAsyncはbuffer null時にArgumentNullExceptionをスロー | E-10 (行120) | ○ |
| C-46 | SyncTextReader.ReadBlockAsyncはindex/count負値時にArgumentOutOfRangeExceptionをスロー | E-10 (行122-123) | ○ |
| C-47 | SyncTextReader.ReadBlockAsyncはバッファオーバーフロー時にArgumentExceptionをスロー | E-10 (行124-125) | ○ |
| C-48 | SyncTextReader.Disposeは内部_inのDisposeを呼び出す | E-10 (行30-39) | ○ |

### StdInReader (UT-CON-084 - UT-CON-097)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-49 | StdInReader.IsUnprocessedBufferEmptyは_startIndex >= _endIndex時にtrue | E-11 (行49-51) | ○ |
| C-50 | StdInReader.AppendExtraBufferはバッファが不足時にリサイズする | E-11 (行76-80) | ○ |
| C-51 | StdInReader.ReadLineはEnterキーで行を終了する | E-11 (行179-186) | ○ |
| C-52 | StdInReader.ReadLine(Span<byte>)は空バッファで0を返す | E-11 (行107-112) | ○ |
| C-53 | StdInReader.ReadOrPeekはEOL時に-1を返す | E-11 (行294-301) | ○ |
| C-54 | StdInReader.ReadKey(intercept)はintercept=false時にEchoToTerminalを呼び出す | E-11 (行330-333) | ○ |
| C-55 | StdInReader.ReadKey(intercept)は_availableKeysにキーがある場合それをポップする | E-11 (行323-326) | ○ |

### CachedConsoleStream (UT-CON-098 - UT-CON-100)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-56 | CachedConsoleStream.WriteはLastIndexOf('\\n')で改行を検出しPrintを呼び出す | E-12 (行49-70) | ○ |
| C-57 | CachedConsoleStream.WriteOrCacheは改行がない場合キャッシュに追加する | E-12 (行73-74) | ○ |
| C-58 | CachedConsoleStream.ReadはNotSupportedExceptionをスロー | E-12 (行23) | ○ |

### Error クラス (UT-CON-101 - UT-CON-104)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-59 | Error.GetFileNotOpenはObjectDisposedExceptionを返す | E-13 (行8-11) | ○ |
| C-60 | Error.GetReadNotSupportedはNotSupportedExceptionを返す | E-13 (行13-16) | ○ |
| C-61 | Error.GetSeekNotSupportedはNotSupportedExceptionを返す | E-13 (行18-21) | ○ |
| C-62 | Error.GetWriteNotSupportedはNotSupportedExceptionを返す | E-13 (行23-26) | ○ |

### TermInfo.Database (UT-CON-105 - UT-CON-113)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-63 | Database.GetStringは範囲外インデックスでnullを返す | E-15 (行112-117) | ○ |
| C-64 | Database.GetStringはtableIndex=-1でnullを返す | E-15 (行119-125) | ○ |
| C-65 | Database.GetExtendedStringは_extendedStringsから値を取得する | E-15 (行133-139) | ○ |
| C-66 | Database.GetNumberは範囲外インデックスで-1を返す | E-15 (行149-154) | ○ |
| C-67 | Database constructorは無効なマジックナンバーでInvalidOperationExceptionをスロー | E-15 (行49-53) | ○ |
| C-68 | Database constructorは負のセクションサイズでInvalidOperationExceptionをスロー | E-15 (行61-68) | ○ |

### TermInfo.DatabaseFactory (UT-CON-114 - UT-CON-120)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-69 | DatabaseFactory.ReadActiveDatabaseはTERM環境変数から読み込む | E-16 (行40-44) | ○ |
| C-70 | DatabaseFactory.ReadDatabaseはTERMINFO環境変数を優先する | E-16 (行55-59) | ○ |
| C-71 | DatabaseFactory.ReadDatabase(term, path)はterm/pathが空の場合nullを返す | E-16 (行105-108) | ○ |

### TermInfo.ParameterizedStrings (UT-CON-121 - UT-CON-136)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-72 | ParameterizedStrings.Evaluateはformat nullでArgumentNullExceptionをスロー | E-14 (行62) | ○ |
| C-73 | ParameterizedStrings.Evaluateはargs nullでArgumentNullExceptionをスロー | E-14 (行63) | ○ |
| C-74 | ParameterizedStrings.Evaluateは%%でリテラル%を出力する | E-14 (行134-136) | ○ |
| C-75 | ParameterizedStrings.Evaluateは%cでスタックトップを文字として出力する | E-14 (行137-139) | ○ |
| C-76 | ParameterizedStrings.Evaluateは%sでスタックトップを文字列として出力する | E-14 (行140-142) | ○ |
| C-77 | ParameterizedStrings.Evaluateは%dでスタックトップを整数として出力する | E-14 (行143-145) | ○ |
| C-78 | ParameterizedStrings.Evaluateは%iで最初の2引数をインクリメントする | E-14 (行271-278) | ○ |
| C-79 | ParameterizedStrings.Evaluateは%+で加算を行う | E-14 (行226-257) | ○ |
| C-80 | ParameterizedStrings.Evaluateは%?%t%e%;で条件分岐を行う | E-14 (行280-334) | ○ |
| C-81 | FormatParam.Stringはnullの場合空文字列を返す | E-14 (行459) | ○ |

### TerminalFormatStrings (UT-CON-137 - UT-CON-143)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-82 | TerminalFormatStrings constructorはdb=nullで早期リターンする | E-17 (行66-68) | ○ |
| C-83 | TerminalFormatStrings constructorはDBからフォーマット文字列を取得する | E-17 (行70-86) | ○ |
| C-84 | TerminalFormatStrings constructorはキーマッピングを構築する | E-17 (行101-159) | ○ |
| C-85 | TerminalFormatStrings.IsRxvtTermは端末名に"rxvt"を含む場合true | E-17 (行88) | ○ |
| C-86 | TerminalFormatStrings.MaxColorsは16以上の場合16に正規化される | E-17 (行95-99) | ○ |
| C-87 | TerminalFormatStrings constructorはMinKeyFormatLength/MaxKeyFormatLengthを計算する | E-17 (行161-177) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。全てのテストケースについてソースコードレベルでの根拠が確認できました。

## 5) リスクフラグ（レビュー観点）
- **0 (低リスク)**: 143テストケース全てにソースコードの根拠あり
- **1 (中リスク)**: プラットフォーム依存テスト (Unix/Windows固有機能) は実行環境によって動作が異なる
  - ConsolePal.Unix.cs関連: UT-CON-038 - UT-CON-054 (KeyParser)
  - terminfo関連: UT-CON-105 - UT-CON-143
- **1 (中リスク)**: 対話型コンソール必須のテストは自動テストが困難
  - StdInReader関連: UT-CON-084 - UT-CON-097

## 6) レビュアーチェックリスト（最小）
- [ ] ConsoleKeyInfoのコンストラクタ境界値テスト (UT-CON-003 - UT-CON-006) が実際のコード範囲チェックと一致しているか
- [ ] SetCursorPositionの境界値テスト (UT-CON-020 - UT-CON-023) がshort.MaxValue基準であることを確認
- [ ] KeyParserのエスケープシーケンス解析テストが主要なターミナルエミュレータを網羅しているか
- [ ] TermInfo.ParameterizedStrings の条件分岐テストが全ての分岐パターンをカバーしているか
- [ ] SyncTextReaderの非同期メソッドが実際に同期的に実行されることを確認するテストが適切か
