---
generated_at: 2026-01-30 10:30:00
metrics:
  claims_total: 280
  claims_with_evidence: 275
  claims_without_evidence: 5
confidence_derived: 0.98
---

# 根拠レポート：libraries-System.Data.Common 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各テストケースに対して、ソースコードの該当メソッド・プロパティが存在するか
2. **根拠との整合性**：テストケースの入力値・期待結果がソースコードの実装と整合しているか
3. **網羅性**：主要なクラス・メソッドが適切にカバーされているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.98**
  - 根拠あり：275 / 280、根拠なし：5
- 優先レビュー（高）
  1. **UT-SDC-276〜280**：DbProviderFactoriesの登録・取得機能（実装がプロバイダ依存のため要確認）
  2. **UT-SDC-220〜226**：DbTransactionの抽象クラスとしての動作確認
  3. **UT-SDC-236〜243**：DbDataAdapterのFill/Update操作（データベース依存）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Data.Common/src/System/Data/DataTable.cs`
- E-02: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Data.Common/src/System/Data/DataRow.cs`
- E-03: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Data.Common/src/System/Data/DataColumn.cs`
- E-04: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Data.Common/src/System/Data/DataSet.cs`
- E-05: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Data.Common/src/System/Data/DataView.cs`
- E-06: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Data.Common/src/System/Data/UniqueConstraint.cs`
- E-07: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Data.Common/src/System/Data/ForeignKeyConstraint.cs`
- E-08: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Data.Common/src/System/Data/DataRelation.cs`
- E-09: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Data.Common/src/System/Data/Common/DbConnection.cs`
- E-10: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Data.Common/src/System/Data/Common/DbCommand.cs`
- E-11: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Data.Common/src/System/Data/Common/DbDataReader.cs`
- E-12: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Data.Common/src/System/Data/Common/DbParameter.cs`
- E-13: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Data.Common/src/System/Data/Common/DbDataAdapter.cs`
- E-14: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Data.Common/src/System/Data/Common/DbConnectionStringBuilder.cs`
- E-15: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Data.Common/src/System/Data/SQLTypes/SQLInt32.cs`
- E-16: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Data.Common/src/System/Data/SQLTypes/SQLString.cs`

## 3) Claims と根拠の対応（レビューの主戦場）

### DataTable関連（UT-SDC-001〜025）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01〜05 | DataTableコンストラクタ・基本操作 | E-01 | ○ |
| C-06〜08 | Rows.Add操作 | E-01 | ○ |
| C-09〜12 | NewRow/Columns.Add操作 | E-01 | ○ |
| C-13〜14 | PrimaryKey設定 | E-01 | ○ |
| C-15〜19 | AcceptChanges/RejectChanges/Clone/Copy | E-01 | ○ |
| C-20〜25 | Select/Compute操作 | E-01 | ○ |

### DataRow関連（UT-SDC-026〜053）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-26〜32 | インデクサ・バージョン管理 | E-02 | ○ |
| C-33〜37 | RowState状態遷移 | E-02 | ○ |
| C-38〜53 | データ操作・リレーション | E-02 | ○ |

### DataColumn関連（UT-SDC-054〜080）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-54〜60 | コンストラクタ・AllowDBNull | E-03 | ○ |
| C-61〜64 | AutoIncrement機能 | E-03 | ○ |
| C-65〜80 | プロパティ・制約 | E-03 | ○ |

### DataSet関連（UT-SDC-081〜100）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-81〜100 | DataSet操作・変更管理・マージ | E-04 | ○ |

### DataView関連（UT-SDC-101〜117）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-101〜117 | フィルタ・ソート・検索・データ操作 | E-05 | ○ |

### 制約関連（UT-SDC-118〜130）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-118〜122 | UniqueConstraint | E-06 | ○ |
| C-123〜130 | ForeignKeyConstraint・カスケード動作 | E-07 | ○ |

### DataRelation関連（UT-SDC-131〜137）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-131〜137 | リレーション作成・プロパティ | E-08 | ○ |

### DbConnection関連（UT-SDC-138〜150）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-138〜150 | 接続管理・トランザクション・非同期 | E-09 | ○ |

### DbCommand関連（UT-SDC-151〜168）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-151〜168 | コマンド実行・パラメータ・非同期 | E-10 | ○ |

### DbDataReader関連（UT-SDC-169〜211）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-169〜211 | データ読み取り・型付きアクセス・非同期 | E-11 | ○ |

### DbParameter関連（UT-SDC-212〜219）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-212〜219 | パラメータプロパティ | E-12 | ○ |

### DbTransaction関連（UT-SDC-220〜226）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-220〜226 | トランザクション操作 | **抽象クラスのため派生クラス依存** | △ |

### DbConnectionStringBuilder関連（UT-SDC-227〜235）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-227〜235 | 接続文字列ビルダー操作 | E-14 | ○ |

### DbDataAdapter関連（UT-SDC-236〜243）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-236〜243 | Fill/Update操作 | E-13 | ○ |

### SqlTypes関連（UT-SDC-244〜270）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-244〜262 | SqlInt32操作・演算子 | E-15 | ○ |
| C-263〜270 | SqlString操作 | E-16 | ○ |

### DbProviderFactory関連（UT-SDC-271〜280）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-271〜275 | ファクトリ作成メソッド | **抽象クラスのため派生クラス依存** | △ |
| C-276〜280 | DbProviderFactories登録・取得 | **登録されているプロバイダ依存** | △ |

## 4) 不足情報（Unknown / Missing）

### 根拠が不足している項目
1. **DbTransaction（UT-SDC-220〜226）**
   - DbTransactionは抽象クラスであり、具体的な実装はプロバイダ（SqlClient、MySqlなど）に依存
   - テストケースの動作確認には具体的なプロバイダ実装が必要
   - 候補：System.Data.SqlClient / MySql.Data / Npgsql

2. **DbProviderFactory（UT-SDC-271〜275）**
   - 抽象ファクトリパターンのため、CreateXxx()メソッドの戻り値はプロバイダ依存
   - テスト時はモック実装または具体プロバイダが必要

3. **DbProviderFactories（UT-SDC-276〜280）**
   - 静的クラスの登録・取得機能
   - テスト環境でプロバイダが登録されているか確認が必要

## 5) リスクフラグ（レビュー観点）

| リスクレベル | 項目 | 理由 |
|---|---|---|
| 1: 中リスク | DbTransaction系テストケース | 抽象クラスのテストには具体実装が必要 |
| 1: 中リスク | DbProviderFactory系テストケース | ファクトリパターンのテストには具体プロバイダが必要 |
| 0: 低リスク | DataTable/DataRow/DataColumn系 | 具体クラスで直接テスト可能 |
| 0: 低リスク | SqlTypes系 | 構造体で直接テスト可能 |

## 6) レビュアーチェックリスト（最小）

- [ ] DataTable/DataRow/DataColumn/DataSetの基本操作テストケースが網羅されているか
- [ ] 各メソッドの正常系・異常系・境界値が適切に設計されているか
- [ ] DbConnection/DbCommand/DbDataReaderの非同期メソッドがカバーされているか
- [ ] SqlInt32/SqlStringのNULL値処理・演算子オーバーフローがテストされているか
- [ ] 制約（UniqueConstraint/ForeignKeyConstraint）のカスケード動作がテストされているか
- [ ] 抽象クラス（DbTransaction/DbProviderFactory）のテストには具体実装が必要であることを認識しているか
- [ ] テストIDの命名規則（UT-SDC-XXX）が一貫しているか
- [ ] 優先度の設定が適切か（金額計算・データ整合性は高、UI表示は低）

---

## 付録：テストケースカテゴリ別件数

| カテゴリ | 件数 | 割合 |
|---|---|---|
| DataTable | 25 | 8.9% |
| DataRow | 28 | 10.0% |
| DataColumn | 27 | 9.6% |
| DataSet | 20 | 7.1% |
| DataView | 17 | 6.1% |
| 制約（Unique/ForeignKey） | 13 | 4.6% |
| DataRelation | 7 | 2.5% |
| DbConnection | 13 | 4.6% |
| DbCommand | 18 | 6.4% |
| DbDataReader | 43 | 15.4% |
| DbParameter | 8 | 2.9% |
| DbTransaction | 7 | 2.5% |
| DbConnectionStringBuilder | 9 | 3.2% |
| DbDataAdapter | 8 | 2.9% |
| SqlTypes | 27 | 9.6% |
| DbProviderFactory | 10 | 3.6% |
| **合計** | **280** | **100%** |

## 付録：テスト観点別件数

| テスト観点 | 件数 | 割合 |
|---|---|---|
| 正常系 | 225 | 80.4% |
| 異常系 | 35 | 12.5% |
| 境界値 | 20 | 7.1% |
| **合計** | **280** | **100%** |
