---
generated_at: 2026-01-30 10:30:00
metrics:
  claims_total: 235
  claims_with_evidence: 228
  claims_without_evidence: 7
confidence_derived: 0.97
---

# 根拠レポート：libraries-System.Data.Odbc 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各テストケースに対して、ソースコードから根拠（Evidence）が存在するか
2. **根拠との整合性**：テストケースの内容がソースコードの実装と矛盾していないか
3. **網羅性**：主要なクラス・メソッドを適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：228 / 235、根拠なし：7
- 優先レビュー（高）
  1. **UT-ODBC-031**: Open()のUnixプラットフォーム固有のDllNotFoundException - 実行環境依存
  2. **UT-ODBC-032**: ReleaseObjectPool()の内部動作 - OdbcEnvironmentの詳細実装未確認
  3. **UT-ODBC-140**: Read()の全行読み取り後の動作 - 実際のODBCドライバー動作依存

## 2) 参照した情報（Evidence一覧）
> ソースコードから抽出した根拠

- E-01: `src/libraries/System.Data.Odbc/src/System/Data/Odbc/OdbcConnection.cs`
- E-02: `src/libraries/System.Data.Odbc/src/System/Data/Odbc/OdbcCommand.cs`
- E-03: `src/libraries/System.Data.Odbc/src/System/Data/Odbc/OdbcParameter.cs`
- E-04: `src/libraries/System.Data.Odbc/src/System/Data/Odbc/OdbcDataReader.cs`
- E-05: `src/libraries/System.Data.Odbc/src/System/Data/Odbc/OdbcTransaction.cs`
- E-06: `src/libraries/System.Data.Odbc/src/System/Data/Odbc/OdbcConnectionStringbuilder.cs`
- E-07: `src/libraries/System.Data.Odbc/src/System/Data/Odbc/OdbcParameterCollection.cs`
- E-08: `src/libraries/System.Data.Odbc/src/System/Data/Odbc/OdbcException.cs`
- E-09: `src/libraries/System.Data.Odbc/src/System/Data/Odbc/OdbcError.cs`
- E-10: `src/libraries/System.Data.Odbc/src/System/Data/Odbc/OdbcErrorCollection.cs`
- E-11: `src/libraries/System.Data.Odbc/src/System/Data/Odbc/OdbcFactory.cs`
- E-12: `src/libraries/System.Data.Odbc/src/System/Data/Odbc/OdbcDataAdapter.cs`
- E-13: `src/libraries/System.Data.Odbc/src/System/Data/Odbc/OdbcCommandBuilder.cs`
- E-14: `src/libraries/System.Data.Odbc/src/System/Data/Odbc/OdbcType.cs`

## 3) Claims と根拠の対応（レビューの主戦場）

### OdbcConnection クラス (UT-ODBC-001 - UT-ODBC-034)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ConnectionString get/set動作 | E-01 (line 51-61) | ○ |
| C-02 | ConnectionTimeout負値検証 | E-01 (line 75-76: `if (value < 0) throw ODBC.NegativeArgument()`) | ○ |
| C-03 | ConnectionTimeout接続中設定禁止 | E-01 (line 77-78: `if (IsOpen) throw ODBC.CantSetPropertyOnOpenConnection()`) | ○ |
| C-04 | Database未接続時の空文字列 | E-01 (line 96-99) | ○ |
| C-05 | BeginTransaction Chaos分離レベル例外 | E-01 (line 917-918: `case IsolationLevel.Chaos: throw ODBC.NotSupportedIsolationLevel(isolevel)`) | ○ |
| C-06 | ParallelTransactionsNotSupported | E-01 (line 902-905) | ○ |
| C-07 | Open_ChangeDatabase空文字列検証 | E-01 (line 940-942: `if (string.IsNullOrWhiteSpace(value)) throw ADP.EmptyDatabaseName()`) | ○ |
| C-08 | Open_ChangeDatabaseの長さ制限 | E-01 (line 944-947) | ○ |
| C-09 | CheckState例外 | E-01 (line 311-317) | ○ |
| C-10 | Open()のUnix DllNotFoundException | E-01 (line 566-568) | △ |
| C-11 | TransactionConnectionMismatch | E-01 (line 618-619, 626-629) | ○ |

### OdbcCommand クラス (UT-ODBC-035 - UT-ODBC-067)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-12 | CommandTimeout負値検証 | E-02 (line 183-186: `if (value < 0) throw ADP.InvalidCommandTimeout(value)`) | ○ |
| C-13 | CommandType TableDirect例外 | E-02 (line 228-229: `case CommandType.TableDirect: throw ODBC.NotSupportedCommandType(value)`) | ○ |
| C-14 | ExecuteNonQuery空コマンドテキスト | E-02 (line 566-568) | ○ |
| C-15 | ExecuteReader OpenReaderExists | E-02 (line 597-607) | ○ |
| C-16 | Prepare TableDirect動作 | E-02 (line 883-886: `if (CommandType == CommandType.TableDirect) return`) | ○ |
| C-17 | Clone実装 | E-02 (line 463-482) | ○ |
| C-18 | Cancel実装 | E-02 (line 433-460) | ○ |

### OdbcParameter クラス (UT-ODBC-068 - UT-ODBC-088)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-19 | DbTypeデフォルト値NVarChar | E-03 (line 157: `return TypeMap._NVarChar._dbType`) | ○ |
| C-20 | OdbcTypeデフォルト値 | E-03 (line 187: `return TypeMap._NVarChar._odbcType`) | ○ |
| C-21 | ResetOdbcType | E-03 (line 200-205) | ○ |
| C-22 | PrecisionInternal値推論 | E-03 (line 256-259) | ○ |
| C-23 | ScaleInternal値推論 | E-03 (line 291-296) | ○ |
| C-24 | PrepareForBindオフセット検証 | E-03 (line 636-665) | ○ |
| C-25 | SqlDirectionFromParameterDirection | E-03 (line 1094-1111) | ○ |

### OdbcTransaction クラス (UT-ODBC-089 - UT-ODBC-099)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-26 | IsolationLevelゾンビ検出 | E-05 (line 42-45: `if (null == connection) throw ADP.TransactionZombied(this)`) | ○ |
| C-27 | CommitのTransactionZombied | E-05 (line 70-74) | ○ |
| C-28 | CommitのNotInTransaction | E-05 (line 80-83: `if (null == _handle) throw ODBC.NotInTransaction()`) | ○ |
| C-29 | RollbackのTransactionZombied | E-05 (line 144-148) | ○ |
| C-30 | RollbackのNotInTransaction | E-05 (line 153-156) | ○ |
| C-31 | Disposeでのロールバック | E-05 (line 99-140) | ○ |

### OdbcConnectionStringBuilder クラス (UT-ODBC-100 - UT-ODBC-116)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-32 | Driver/Dsnプロパティ | E-06 (line 98-118) | ○ |
| C-33 | インデクサの動作 | E-06 (line 51-96) | ○ |
| C-34 | Clearでのリセット | E-06 (line 176-184) | ○ |
| C-35 | ContainsKey | E-06 (line 186-189) | ○ |
| C-36 | Remove | E-06 (line 209-227) | ○ |
| C-37 | TryGetValue | E-06 (line 250-259) | ○ |

### OdbcDataReader クラス (UT-ODBC-117 - UT-ODBC-143)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-38 | Depthが常に0 | E-04 (line 151-160: `return 0`) | ○ |
| C-39 | DepthのDataReaderClosed | E-04 (line 155-157) | ○ |
| C-40 | FieldCountのDataReaderClosed | E-04 (line 167-169) | ○ |
| C-41 | HasRowsの動作 | E-04 (line 193-207) | ○ |
| C-42 | CalculateRecordsAffected累積 | E-04 (line 271-285) | ○ |
| C-43 | Close CloseConnection動作 | E-04 (line 357-362) | ○ |
| C-44 | GetDataTypeNameのDataReaderNoData | E-04 (line 400-407) | ○ |

### OdbcParameterCollection クラス (UT-ODBC-144 - UT-ODBC-163)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-45 | インデクサ動作 | E-07 (line 31-57) | ○ |
| C-46 | Add/AddWithValue | E-07 (line 59-93) | ○ |
| C-47 | Bind処理 | E-07 (line 103-110) | ○ |
| C-48 | CalcParameterBufferSize | E-07 (line 112-128) | ○ |
| C-49 | GetOutputValuesのrebind条件 | E-07 (line 160-171) | ○ |

### OdbcException/OdbcError/OdbcErrorCollection (UT-ODBC-164 - UT-ODBC-181)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-50 | CreateException | E-08 (line 16-29) | ○ |
| C-51 | Sourceが空エラー時の空文字列 | E-08 (line 68-79) | ○ |
| C-52 | OdbcErrorプロパティ | E-09 (line 24-54) | ○ |
| C-53 | OdbcErrorCollectionのSetSource | E-10 (line 64-70) | ○ |

### OdbcFactory クラス (UT-ODBC-182 - UT-ODBC-188)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-54 | Instanceシングルトン | E-11 (line 10: `public static readonly OdbcFactory Instance`) | ○ |
| C-55 | CreateXxxメソッド群 | E-11 (line 16-44) | ○ |

### OdbcDataAdapter クラス (UT-ODBC-189 - UT-ODBC-199)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-56 | コマンドプロパティ | E-12 (line 44-98) | ○ |
| C-57 | Clone実装 | E-12 (line 138-141) | ○ |
| C-58 | RowUpdated/RowUpdatingイベント | E-12 (line 100-170) | ○ |

### OdbcCommandBuilder クラス (UT-ODBC-200 - UT-ODBC-218)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-59 | DeriveParameters null検証 | E-13 (line 105-108) | ○ |
| C-60 | DeriveParameters CommandType検証 | E-13 (line 109-120) | ○ |
| C-61 | DeriveParameters 接続検証 | E-13 (line 126-138) | ○ |
| C-62 | GetParameterPlaceholder | E-13 (line 75-78: `return "?"`) | ○ |
| C-63 | QuoteIdentifier QuotePrefixNotSet | E-13 (line 269-272) | ○ |

### CMDWrapper内部クラス (UT-ODBC-221 - UT-ODBC-235)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-64 | CMDWrapperプロパティ | E-02 (line 980-1014) | ○ |
| C-65 | CreateStatementHandle | E-02 (line 1030-1034) | ○ |
| C-66 | Dispose処理 | E-02 (line 1036-1050) | ○ |
| C-67 | UnbindStmtColumnsのスキップ条件 | E-02 (line 1166-1173) | ○ |
| C-68 | StatementErrorHandler | E-02 (line 1153-1163) | ○ |

## 4) 不足情報（Unknown / Missing）

1. **OdbcEnvironment.ReleaseObjectPool()の内部実装**
   - ReleaseObjectPool静的メソッドの具体的な実装詳細は別ファイル
   - 候補：OdbcEnvironment.cs / OdbcConnectionPool関連ファイル

2. **ネイティブODBCドライバーとの相互作用テスト**
   - 実際のSQLReturnコードに対する動作は実環境依存
   - 候補：統合テスト / モック使用テスト

3. **プラットフォーム固有の動作（Unix/Windows）**
   - DllNotFoundExceptionのUnix固有動作は実行環境依存
   - 候補：条件付きテスト / プラットフォームスキップ

4. **OdbcDataReaderのデータ型変換詳細**
   - GetValue内部のinternalGetXxx系メソッドの詳細動作
   - 候補：OdbcDataReader.csの残り部分

5. **TypeMapクラスの型マッピング詳細**
   - OdbcType <-> DbType <-> System.Typeの変換ルール
   - 候補：TypeMap関連ファイル

6. **ODBC32定数定義**
   - SQL_ATTR, SQL_TYPE, SQLRETURNなどの詳細
   - 候補：Odbc32.cs / ODBC32.Common.cs

7. **接続プーリングの動作**
   - DbConnectionPoolとの連携詳細
   - 候補：ProviderBase配下のファイル

## 5) リスクフラグ（レビュー観点）

| リスクレベル | 対象 | 理由 |
|---|---|---|
| 2 (高) | トランザクション関連テスト (UT-ODBC-017-021, 089-099) | データ整合性に直結。ゾンビトランザクション検出は重要 |
| 2 (高) | 接続状態管理テスト (UT-ODBC-025-031) | 接続リーク防止に重要 |
| 2 (高) | パラメータバインディングテスト (UT-ODBC-084-088, 159-162) | SQLインジェクション防止に関連 |
| 1 (中) | DataReader状態管理テスト (UT-ODBC-117-143) | リソースリーク防止 |
| 1 (中) | CommandBuilder DeriveParameters (UT-ODBC-207-211) | ストアドプロシージャ連携 |
| 0 (低) | Factory/Enumテスト (UT-ODBC-182-188, 219-220) | シンプルな構造 |

## 6) レビュアーチェックリスト（最小）

- [ ] トランザクション関連テスト（UT-ODBC-017-021, 089-099）の例外パターンが網羅されているか
- [ ] 接続状態チェック（CheckState, SetStateExecuting）の例外条件が正確か
- [ ] パラメータのオフセット/サイズ検証（UT-ODBC-084-086）が境界値を含むか
- [ ] OdbcDataReaderのClose時リソース解放パターンが完全か
- [ ] CommandBuilderのDeriveParametersで接続状態検証が十分か
- [ ] 各クラスのClone/Dispose実装でリソースリークがないことを確認するテストがあるか
- [ ] CMDWrapperの内部状態管理テストが適切か
