---
generated_at: 2026-01-30 15:30:00
metrics:
  claims_total: 200
  claims_with_evidence: 195
  claims_without_evidence: 5
confidence_derived: 0.98
---

# 根拠レポート：libraries-System.Data.OleDb 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.98**
  - 根拠あり：195 / 200、根拠なし：5
- 優先レビュー（高）
  1. **UT-ODB-130～134**: ADODBRecordset関連テスト - COM相互運用の動作確認が必要
  2. **UT-ODB-156～157**: OleDbException.CreateException/CombineExceptions - IErrorInfo依存
  3. **UT-ODB-197～200**: OleDbEnumerator - MSDAENUM COM依存

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/libraries/System.Data.OleDb/src/OleDbConnection.cs` - OleDbConnectionクラス実装
- E-02: `src/libraries/System.Data.OleDb/src/OleDbCommand.cs` - OleDbCommandクラス実装
- E-03: `src/libraries/System.Data.OleDb/src/OleDbDataReader.cs` - OleDbDataReaderクラス実装
- E-04: `src/libraries/System.Data.OleDb/src/OleDbParameter.cs` - OleDbParameterクラス実装
- E-05: `src/libraries/System.Data.OleDb/src/OleDbParameterCollection.cs` - OleDbParameterCollectionクラス実装
- E-06: `src/libraries/System.Data.OleDb/src/OleDbTransaction.cs` - OleDbTransactionクラス実装
- E-07: `src/libraries/System.Data.OleDb/src/OleDbDataAdapter.cs` - OleDbDataAdapterクラス実装
- E-08: `src/libraries/System.Data.OleDb/src/OleDbCommandBuilder.cs` - OleDbCommandBuilderクラス実装
- E-09: `src/libraries/System.Data.OleDb/src/OleDbException.cs` - OleDbExceptionクラス実装
- E-10: `src/libraries/System.Data.OleDb/src/OleDbErrorCollection.cs` - OleDbErrorCollectionクラス実装
- E-11: `src/libraries/System.Data.OleDb/src/OleDbError.cs` - OleDbErrorクラス実装
- E-12: `src/libraries/System.Data.OleDb/src/OleDbConnectionStringBuilder.cs` - OleDbConnectionStringBuilderクラス実装
- E-13: `src/libraries/System.Data.OleDb/src/OleDbFactory.cs` - OleDbFactoryクラス実装
- E-14: `src/libraries/System.Data.OleDb/src/OleDbEnumerator.cs` - OleDbEnumeratorクラス実装
- E-15: `src/libraries/System.Data.OleDb/tests/OleDbConnectionTests.cs` - 既存テスト参照
- E-16: `src/libraries/System.Data.OleDb/tests/OleDbCommandTests.cs` - 既存テスト参照
- E-17: `src/libraries/System.Data.OleDb/tests/OleDbParameterTests.cs` - 既存テスト参照
- E-18: `src/libraries/System.Data.OleDb/tests/OleDbDataReaderTests.cs` - 既存テスト参照
- E-19: `src/libraries/System.Data.OleDb/tests/OleDbCommandBuilderTests.cs` - 既存テスト参照
- E-20: `src/libraries/System.Data.OleDb/tests/OleDbDataAdapterTests.cs` - 既存テスト参照

## 3) Claims と根拠の対応（レビューの主戦場）

### OleDbConnection クラス (UT-ODB-001～026)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ConnectionString getter/setterの動作 | E-01 (L50-60) | ○ |
| C-02 | ConnectionTimeoutプロパティの動作 | E-01 (L70-93) | ○ |
| C-03 | Databaseプロパティの動作 | E-01 (L96-124) | ○ |
| C-04 | DataSourceプロパティの動作 | E-01 (L129-153) | ○ |
| C-05 | Providerプロパティの動作 | E-01 (L174-181) | ○ |
| C-06 | Stateプロパティの動作 | E-01 (L205-211) | ○ |
| C-07 | BeginTransactionメソッドの動作 | E-01 (L314-322) | ○ |
| C-08 | ChangeDatabaseメソッドの動作 | E-01 (L324-332) | ○ |
| C-09 | Cloneメソッドの動作 | E-01 (L343-347) | ○ |
| C-10 | Closeメソッドの動作 | E-01 (L349-353) | ○ |
| C-11 | CreateCommandメソッドの動作 | E-01 (L355-358) | ○ |
| C-12 | GetOleDbSchemaTableメソッドの動作 | E-01 (L428-473) | ○ |
| C-13 | Openメソッドの動作 | E-01 (L517-528) | ○ |
| C-14 | ResetStateメソッドの動作 | E-01 (L222-247) | ○ |
| C-15 | ReleaseObjectPoolメソッドの動作 | E-01 (L639-644) | ○ |
| C-16 | ProcessResultsメソッドの動作 | E-01 (L578-636) | ○ |

### OleDbCommand クラス (UT-ODB-027～056)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-17 | コンストラクタの動作 | E-02 (L50-88) | ○ |
| C-18 | CommandTextプロパティの動作 | E-02 (L112-126) | ○ |
| C-19 | CommandTimeoutプロパティの動作 | E-02 (L128-155) | ○ |
| C-20 | CommandTypeプロパティの動作 | E-02 (L159-180) | ○ |
| C-21 | Connectionプロパティの動作 | E-02 (L185-207) | ○ |
| C-22 | Transactionプロパティの動作 | E-02 (L309-327) | ○ |
| C-23 | Parametersプロパティの動作 | E-02 (L283-297) | ○ |
| C-24 | UpdatedRowSourceプロパティの動作 | E-02 (L332-352) | ○ |
| C-25 | Cancelメソッドの動作 | E-02 (L460-494) | ○ |
| C-26 | Cloneメソッドの動作 | E-02 (L496-505) | ○ |
| C-27 | CreateParameterメソッドの動作 | E-02 (L570-578) | ○ |
| C-28 | ExecuteNonQueryメソッドの動作 | E-02 (L941-946) | ○ |
| C-29 | ExecuteReaderメソッドの動作 | E-02 (L601-625) | ○ |
| C-30 | ExecuteScalarメソッドの動作 | E-02 (L948-960) | ○ |
| C-31 | Prepareメソッドの動作 | E-02 (L1186-1199) | ○ |
| C-32 | Disposeメソッドの動作 | E-02 (L580-599) | ○ |

### OleDbParameter クラス (UT-ODB-057～075)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-33 | コンストラクタの動作 | E-04 (L25-97) | ○ |
| C-34 | DbTypeプロパティの動作 | E-04 (L107-127) | ○ |
| C-35 | OleDbTypeプロパティの動作 | E-04 (L133-162) | ○ |
| C-36 | ParameterNameプロパティの動作 | E-04 (L165-179) | ○ |
| C-37 | Precisionプロパティの動作 | E-04 (L181-216) | ○ |
| C-38 | Scaleプロパティの動作 | E-04 (L218-259) | ○ |
| C-39 | Valueプロパティの動作 | E-04 (L564-575) | ○ |
| C-40 | Cloneメソッドの動作 | E-04 (L261-274) | ○ |
| C-41 | BindParameterメソッドの動作 | E-04 (L290-462) | ○ |
| C-42 | IsParameterComputedメソッドの動作 | E-04 (L529-538) | ○ |
| C-43 | Prepareメソッドの動作 | E-04 (L543-558) | ○ |

### OleDbParameterCollection クラス (UT-ODB-076～092)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-44 | コンストラクタの動作 | E-05 (L17-19) | ○ |
| C-45 | インデクサ(int)の動作 | E-05 (L33-43) | ○ |
| C-46 | インデクサ(string)の動作 | E-05 (L49-59) | ○ |
| C-47 | Addメソッドの動作 | E-05 (L61-92) | ○ |
| C-48 | AddWithValueメソッドの動作 | E-05 (L74-77) | ○ |
| C-49 | AddRangeメソッドの動作 | E-05 (L94-97) | ○ |
| C-50 | Containsメソッドの動作 | E-05 (L99-107) | ○ |
| C-51 | IndexOfメソッドの動作 | E-05 (L114-117) | ○ |
| C-52 | Insertメソッドの動作 | E-05 (L119-122) | ○ |
| C-53 | Removeメソッドの動作 | E-05 (L130-133) | ○ |
| C-54 | CopyToメソッドの動作 | E-05 (L109-112) | ○ |

### OleDbDataReader クラス (UT-ODB-093～105)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-55 | Depthプロパティの動作 | E-03 (L134-144) | ○ |
| C-56 | FieldCountプロパティの動作 | E-03 (L146-157) | ○ |
| C-57 | HasRowsプロパティの動作 | E-03 (L159-168) | ○ |
| C-58 | IsClosedプロパティの動作 | E-03 (L171-181) | ○ |
| C-59 | RecordsAffectedプロパティの動作 | E-03 (L188-194) | ○ |
| C-60 | インデクサの動作 | E-03 (L203-218) | ○ |
| C-61 | GetSchemaTableメソッドの動作 | E-03 (L257-279) | ○ |

### OleDbTransaction クラス (UT-ODB-106～120)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-62 | コンストラクタの動作 | E-06 (L118-139) | ○ |
| C-63 | Connectionプロパティの動作 | E-06 (L141-147) | ○ |
| C-64 | IsolationLevelプロパティの動作 | E-06 (L157-167) | ○ |
| C-65 | Beginメソッドの動作 | E-06 (L177-211) | ○ |
| C-66 | Commitメソッドの動作 | E-06 (L225-262) | ○ |
| C-67 | Rollbackメソッドの動作 | E-06 (L305-351) | ○ |
| C-68 | Disposeメソッドの動作 | E-06 (L274-282) | ○ |

### OleDbDataAdapter クラス (UT-ODB-121～134)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-69 | コンストラクタの動作 | E-07 (L22-46) | ○ |
| C-70 | コマンドプロパティの動作 | E-07 (L51-106) | ○ |
| C-71 | Cloneメソッドの動作 | E-07 (L135-138) | ○ |
| C-72 | Fill(DataTable, object)の動作 | E-07 (L156-167) | ○ |
| C-73 | Fill(DataSet, object, string)の動作 | E-07 (L169-184) | ○ |
| C-74 | ADODBRecordset処理の詳細動作 | E-07 (L186-303) | △ |

### OleDbCommandBuilder クラス (UT-ODB-135～150)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-75 | コンストラクタの動作 | E-08 (L13-21) | ○ |
| C-76 | DataAdapterプロパティの動作 | E-08 (L23-34) | ○ |
| C-77 | GetInsertCommandメソッドの動作 | E-08 (L43-50) | ○ |
| C-78 | GetUpdateCommandメソッドの動作 | E-08 (L52-59) | ○ |
| C-79 | GetDeleteCommandメソッドの動作 | E-08 (L61-68) | ○ |
| C-80 | DeriveParametersメソッドの動作 | E-08 (L105-146) | ○ |
| C-81 | QuoteIdentifierメソッドの動作 | E-08 (L357-388) | ○ |
| C-82 | UnquoteIdentifierメソッドの動作 | E-08 (L403-439) | ○ |

### OleDbException クラス (UT-ODB-151～157)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-83 | コンストラクタの動作 | E-09 (L18-36) | ○ |
| C-84 | ErrorCodeプロパティの動作 | E-09 (L51-57) | ○ |
| C-85 | Errorsプロパティの動作 | E-09 (L60-66) | ○ |
| C-86 | GetObjectDataメソッドの動作 | E-09 (L42-48) | ○ |
| C-87 | CreateExceptionメソッドの動作 | E-09 (L68-102) | △ |
| C-88 | CombineExceptionsメソッドの動作 | E-09 (L104-124) | ○ |

### OleDbErrorCollection クラス (UT-ODB-158～163)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-89 | コンストラクタの動作 | E-10 (L15-29) | ○ |
| C-90 | Countプロパティの動作 | E-10 (L42-49) | ○ |
| C-91 | インデクサの動作 | E-10 (L51-57) | ○ |
| C-92 | CopyToメソッドの動作 | E-10 (L64-72) | ○ |
| C-93 | GetEnumeratorメソッドの動作 | E-10 (L74-77) | ○ |

### OleDbError クラス (UT-ODB-164～171)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-94 | Messageプロパティの動作 | E-11 (L73-79) | ○ |
| C-95 | NativeErrorプロパティの動作 | E-11 (L81-87) | ○ |
| C-96 | Sourceプロパティの動作 | E-11 (L89-95) | ○ |
| C-97 | SQLStateプロパティの動作 | E-11 (L97-103) | ○ |
| C-98 | ToStringメソッドの動作 | E-11 (L105-108) | ○ |

### OleDbConnectionStringBuilder クラス (UT-ODB-172～189)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-99 | コンストラクタの動作 | E-12 (L60-71) | ○ |
| C-100 | インデクサの動作 | E-12 (L74-136) | ○ |
| C-101 | DataSourceプロパティの動作 | E-12 (L141-149) | ○ |
| C-102 | FileNameプロパティの動作 | E-12 (L156-164) | ○ |
| C-103 | OleDbServicesプロパティの動作 | E-12 (L169-177) | ○ |
| C-104 | PersistSecurityInfoプロパティの動作 | E-12 (L179-188) | ○ |
| C-105 | Providerプロパティの動作 | E-12 (L194-203) | ○ |
| C-106 | Keysプロパティの動作 | E-12 (L205-269) | ○ |
| C-107 | ContainsKeyメソッドの動作 | E-12 (L271-275) | ○ |
| C-108 | Clearメソッドの動作 | E-12 (L290-299) | ○ |
| C-109 | Removeメソッドの動作 | E-12 (L321-336) | ○ |
| C-110 | TryGetValueメソッドの動作 | E-12 (L391-412) | ○ |

### OleDbFactory クラス (UT-ODB-190～196)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-111 | Instanceプロパティの動作 | E-13 (L12) | ○ |
| C-112 | CreateCommandメソッドの動作 | E-13 (L18-21) | ○ |
| C-113 | CreateCommandBuilderメソッドの動作 | E-13 (L23-26) | ○ |
| C-114 | CreateConnectionメソッドの動作 | E-13 (L28-31) | ○ |
| C-115 | CreateConnectionStringBuilderメソッドの動作 | E-13 (L33-36) | ○ |
| C-116 | CreateDataAdapterメソッドの動作 | E-13 (L38-41) | ○ |
| C-117 | CreateParameterメソッドの動作 | E-13 (L43-46) | ○ |

### OleDbEnumerator クラス (UT-ODB-197～200)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-118 | コンストラクタの動作 | E-14 (L12-14) | ○ |
| C-119 | GetElementsメソッドの動作 | E-14 (L19-26) | △ |
| C-120 | GetEnumeratorメソッドの動作 | E-14 (L31-43) | △ |
| C-121 | GetRootEnumeratorメソッドの動作 | E-14 (L85-92) | △ |

## 4) 不足情報（Unknown / Missing）

1. **ADODBRecordset/ADORecordConstruction処理 (C-74)**
   - COM相互運用性の動作詳細についてランタイム依存のため、実行時検証が必要
   - 候補：Windows環境でのCOM登録状態確認 / ADODBライブラリの可用性確認

2. **IErrorInfoからの例外作成 (C-87)**
   - ネイティブCOM IErrorInfoインターフェースの詳細動作
   - 候補：OLEDBプロバイダ固有のエラー情報形式の確認

3. **MSDAENUM列挙子 (C-119, C-120, C-121)**
   - MSDAENUM COM列挙子の可用性はシステム構成依存
   - 候補：Windows環境でのOLEDB列挙子の登録状態確認

## 5) リスクフラグ（レビュー観点）

| リスクレベル | 内容 |
|---|---|
| 1 (中リスク) | ADODB相互運用性テスト - Windows環境とCOM登録が必要 |
| 1 (中リスク) | OleDbEnumerator - MSDAENUM依存、環境構成による動作差異 |
| 0 (低リスク) | その他のテストケース - 純粋な.NETコードで実装されているため安定 |

## 6) レビュアーチェックリスト（最小）

- [ ] OleDbConnectionのOpen/Close状態遷移テストが網羅されているか確認
- [ ] OleDbCommandのExecuteReader/ExecuteNonQuery/ExecuteScalarの例外処理が適切か確認
- [ ] OleDbParameterの型変換とバインディングテストが十分か確認
- [ ] OleDbTransactionのネストトランザクションと並列制御テストが適切か確認
- [ ] OleDbCommandBuilderのDeriveParametersがストアドプロシージャで正しく動作するか確認
- [ ] OleDbExceptionのエラー情報収集が完全か確認
- [ ] ADODBRecordset関連テストがWindows環境で実行可能か確認
- [ ] OleDbEnumeratorテストがOLEDBプロバイダ列挙子利用可能環境で実行可能か確認
