---
generated_at: 2026-01-30 12:00:00
metrics:
  claims_total: 85
  claims_with_evidence: 85
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：libraries-System.Diagnostics.Contracts 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存テストコード・APIリファレンスなどの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：85 / 85、根拠なし：0
- 優先レビュー（高）
  1. なし（全テストケースに根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/libraries/System.Private.CoreLib/src/System/Diagnostics/Contracts/Contracts.cs` - Contract クラス本体実装
- E-02: `src/libraries/System.Private.CoreLib/src/System/Diagnostics/Contracts/ContractFailedEventArgs.cs` - ContractFailedEventArgs クラス実装
- E-03: `src/libraries/System.Private.CoreLib/src/System/Diagnostics/Contracts/ContractException.cs` - ContractException クラス実装
- E-04: `src/libraries/System.Private.CoreLib/src/System/Runtime/CompilerServices/ContractHelper.cs` - ContractHelper クラス実装
- E-05: `src/libraries/System.Diagnostics.Contracts/ref/System.Diagnostics.Contracts.cs` - API リファレンス定義
- E-06: `src/libraries/System.Diagnostics.Contracts/tests/AssertTests.cs` - 既存の Assert テスト
- E-07: `src/libraries/System.Diagnostics.Contracts/tests/AssumeTests.cs` - 既存の Assume テスト
- E-08: `src/libraries/System.Diagnostics.Contracts/tests/ForAllTests.cs` - 既存の ForAll テスト
- E-09: `src/libraries/System.Diagnostics.Contracts/tests/ExistsTests.cs` - 既存の Exists テスト
- E-10: `src/libraries/System.Diagnostics.Contracts/tests/ValueTests.cs` - 既存の Value テスト
- E-11: `src/libraries/System.Diagnostics.Contracts/tests/ContractFailedTests.cs` - 既存の ContractFailed テスト
- E-12: `src/libraries/System.Diagnostics.Contracts/tests/Utilities.cs` - テストユーティリティ

## 3) Claims と根拠の対応（レビューの主戦場）

### Contract.Assert / Contract.Assume メソッド
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Assert(true)でイベント発生しない | E-01 (line 263-267), E-06 | ○ |
| C-02 | Assert(false)でContractFailedイベント発生 | E-01 (line 263-267), E-06 | ○ |
| C-03 | Assert(false)+SetUnwindでContractException | E-01, E-04 (line 61-66), E-06 | ○ |
| C-04 | userMessageがイベント引数に含まれる | E-01, E-04, E-11 | ○ |
| C-05 | Assume(true)でイベント発生しない | E-01 (line 225-231), E-07 | ○ |
| C-06 | Assume(false)でContractFailedイベント発生 | E-01 (line 225-231), E-07 | ○ |
| C-07 | Assume(false)+SetUnwindでContractException | E-01, E-04, E-07 | ○ |
| C-08 | FailureKindがAssumeである | E-01 (line 229), E-11 | ○ |
| C-09 | FailureKindがAssertである | E-01 (line 266), E-11 | ○ |

### Contract.ForAll メソッド
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-10 | predicate=nullでArgumentNullException | E-01 (line 520), E-08 | ○ |
| C-11 | collection=nullでArgumentNullException | E-01 (line 540), E-08 | ○ |
| C-12 | predicate=null(IEnumerable版)でArgumentNullException | E-01 (line 541), E-08 | ○ |
| C-13 | fromInclusive>toExclusiveでArgumentException | E-01 (line 518-519), E-08 | ○ |
| C-14 | 空コレクションでtrue | E-01 (line 543-545), E-08 | ○ |
| C-15 | 空範囲でtrue | E-01 (line 522-524), E-08 | ○ |
| C-16 | 全要素満たすでtrue | E-01 (line 522-525), E-08 | ○ |
| C-17 | 一部要素満たさないでfalse | E-01 (line 523), E-08 | ○ |
| C-18 | 短絡評価で即時終了 | E-01 (line 523), E-08 | ○ |
| C-19 | IEnumerable版で全要素満たすでtrue | E-01 (line 543-545), E-08 | ○ |
| C-20 | predicate内例外が伝播 | E-08 | ○ |

### Contract.Exists メソッド
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-21 | predicate=nullでArgumentNullException | E-01 (line 567), E-09 | ○ |
| C-22 | collection=nullでArgumentNullException | E-01 (line 586), E-09 | ○ |
| C-23 | predicate=null(IEnumerable版)でArgumentNullException | E-01 (line 587), E-09 | ○ |
| C-24 | fromInclusive>toExclusiveでArgumentException | E-01 (line 565-566), E-09 | ○ |
| C-25 | 空コレクションでfalse | E-01 (line 589-591), E-09 | ○ |
| C-26 | 空範囲でfalse | E-01 (line 569-571), E-09 | ○ |
| C-27 | 全要素満たさないでfalse | E-01 (line 569-571), E-09 | ○ |
| C-28 | 一部要素満たすでtrue | E-01 (line 570), E-09 | ○ |
| C-29 | 短絡評価で即時終了 | E-01 (line 570), E-09 | ○ |
| C-30 | IEnumerable版で一部要素満たすでtrue | E-01 (line 590), E-09 | ○ |
| C-31 | predicate内例外が伝播 | E-09 | ○ |

### Contract.Result / OldValue / ValueAtReturn メソッド
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-32 | Result<int>で0返却 | E-01 (line 434), E-10 | ○ |
| C-33 | Result<string>でnull返却 | E-01 (line 434), E-10 | ○ |
| C-34 | OldValue<int>で0返却 | E-01 (line 458), E-10 | ○ |
| C-35 | OldValue<string>でnull返却 | E-01 (line 458), E-10 | ○ |
| C-36 | ValueAtReturn<int>で0返却、out値も0 | E-01 (line 446), E-10 | ○ |
| C-37 | ValueAtReturn<string>でnull返却、out値もnull | E-01 (line 446), E-10 | ○ |

### ContractFailedEventArgs クラス
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-38 | コンストラクタで全プロパティ設定 | E-02 (line 17-24) | ○ |
| C-39 | SetHandled後Handled=true | E-02 (line 34-37) | ○ |
| C-40 | SetUnwind後Unwind=true | E-02 (line 41-44) | ○ |
| C-41 | Handled初期値false | E-02 (line 12) | ○ |
| C-42 | Unwind初期値false | E-02 (line 13) | ○ |
| C-43 | FailureKindプロパティ取得 | E-02 (line 28) | ○ |
| C-44 | Messageプロパティ取得 | E-02 (line 26) | ○ |
| C-45 | Conditionプロパティ取得 | E-02 (line 27) | ○ |
| C-46 | OriginalExceptionプロパティ取得 | E-02 (line 29) | ○ |

### ContractException クラス
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-47 | コンストラクタで全プロパティ設定 | E-03 (line 29-36) | ○ |
| C-48 | Kindプロパティ取得 | E-03 (line 18) | ○ |
| C-49 | Failureプロパティ取得 | E-03 (line 19) | ○ |
| C-50 | UserMessageプロパティ取得 | E-03 (line 20) | ○ |
| C-51 | Conditionプロパティ取得 | E-03 (line 21) | ○ |
| C-52 | HResult=COR_E_CODECONTRACTFAILED | E-03 (line 27, 32) | ○ |

### ContractHelper クラス
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-53 | ハンドラ未登録時displayMessage返却 | E-04 (line 45-46, 77) | ○ |
| C-54 | SetHandled時null返却 | E-04 (line 71-73) | ○ |
| C-55 | SetUnwind時ContractException | E-04 (line 61-66) | ○ |
| C-56 | 無効failureKindでArgumentException | E-04 (line 35-36) | ○ |
| C-57 | ハンドラ例外がinnerExceptionに設定 | E-04 (line 55-59, 64-65) | ○ |
| C-58 | displayMessage null/空でメッセージ生成 | E-04 (line 90-93) | ○ |
| C-59 | displayMessage指定時そのまま使用 | E-04 (line 95) | ○ |

### Contract.ContractFailed イベント
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-60 | ハンドラ追加動作 | E-01 (line 674-678) | ○ |
| C-61 | ハンドラ削除動作 | E-01 (line 679-682) | ○ |
| C-62 | 複数ハンドラ順次呼出し | E-04 (line 49-60) | ○ |

### ContractFailureKind 列挙型
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-63 | Precondition=0 | E-01 (line 691) | ○ |
| C-64 | Postcondition=1 | E-01 (line 692) | ○ |
| C-65 | PostconditionOnException=2 | E-01 (line 693) | ○ |
| C-66 | Invariant=3 | E-01 (line 694) | ○ |
| C-67 | Assert=4 | E-01 (line 695) | ○ |
| C-68 | Assume=5 | E-01 (line 696) | ○ |

### 属性クラス
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-69 | PureAttribute作成 | E-01 (line 33-35) | ○ |
| C-70 | ContractClassAttribute.TypeContainingContracts | E-01 (line 43-53) | ○ |
| C-71 | ContractClassForAttribute.TypeContractsAreFor | E-01 (line 60-70) | ○ |
| C-72 | ContractInvariantMethodAttribute作成 | E-01 (line 80-84) | ○ |
| C-73 | ContractReferenceAssemblyAttribute作成 | E-01 (line 89-92) | ○ |
| C-74 | ContractRuntimeIgnoredAttribute作成 | E-01 (line 97-101) | ○ |
| C-75 | ContractVerificationAttribute.Value=true | E-01 (line 114-123) | ○ |
| C-76 | ContractVerificationAttribute.Value=false | E-01 (line 114-123) | ○ |
| C-77 | ContractPublicPropertyNameAttribute.Name | E-01 (line 129-141) | ○ |
| C-78 | ContractArgumentValidatorAttribute作成 | E-01 (line 147-151) | ○ |
| C-79 | ContractAbbreviatorAttribute作成 | E-01 (line 156-160) | ○ |
| C-80 | ContractOptionAttribute(bool)プロパティ | E-01 (line 167-195) | ○ |
| C-81 | ContractOptionAttribute(string)プロパティ | E-01 (line 167-195) | ○ |

### 条件付きコンパイル関連
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-82 | Requires CONTRACTS_FULL未定義時動作なし | E-01 (line 296-301, Conditional attribute) | ○ |
| C-83 | Ensures CONTRACTS_FULL未定義時動作なし | E-01 (line 364-369, Conditional attribute) | ○ |
| C-84 | Invariant CONTRACTS_FULL未定義時動作なし | E-01 (line 475-480, Conditional attribute) | ○ |
| C-85 | EndContractBlock正常完了 | E-01 (line 603-604) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（全テストケースにソースコードまたは既存テストに基づく根拠あり）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全テストケースが実装コードおよび既存テストに基づいて生成されている

## 6) レビュアーチェックリスト（最小）
- [x] 全テストケースにソースコードの根拠がある
- [x] 既存テストコードとの整合性を確認
- [x] Contract.Assert/Assume のDEBUGビルド条件を考慮
- [x] ForAll/Exists の境界値・異常系を網羅
- [x] ContractFailedEventArgs/ContractException のプロパティ検証を含む
- [x] 属性クラスのコンストラクタとプロパティを網羅
- [ ] CONTRACTS_FULL定義時の動作（バイナリリライタ必要）は実際のテスト環境で要確認
