---
generated_at: 2026-01-30 12:00:00
metrics:
  claims_total: 132
  claims_with_evidence: 132
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：libraries-System.Diagnostics.DiagnosticSource 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各テストケースに対して、ソースコードの該当メソッド・プロパティが存在するか
2. **根拠との整合性**：テストケースの内容がソースコードの実装と矛盾していないか
3. **網羅性**：主要なクラス・メソッドをカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：132 / 132、根拠なし：0
- 優先レビュー（高）
  1. **Activity関連テストケース（UT-DDS-001〜019）**：コア機能のため優先度高
  2. **Metrics関連テストケース（UT-DDS-083〜118）**：測定機能のため重要
  3. **DiagnosticListener関連テストケース（UT-DDS-061〜069）**：イベント通知の基盤

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/libraries/System.Diagnostics.DiagnosticSource/src/System/Diagnostics/Activity.cs`
- E-02: `src/libraries/System.Diagnostics.DiagnosticSource/src/System/Diagnostics/ActivitySource.cs`
- E-03: `src/libraries/System.Diagnostics.DiagnosticSource/src/System/Diagnostics/ActivityListener.cs`
- E-04: `src/libraries/System.Diagnostics.DiagnosticSource/src/System/Diagnostics/ActivityContext.cs`
- E-05: `src/libraries/System.Diagnostics.DiagnosticSource/src/System/Diagnostics/ActivityTagsCollection.cs`
- E-06: `src/libraries/System.Diagnostics.DiagnosticSource/src/System/Diagnostics/ActivityEvent.cs`
- E-07: `src/libraries/System.Diagnostics.DiagnosticSource/src/System/Diagnostics/ActivityLink.cs`
- E-08: `src/libraries/System.Diagnostics.DiagnosticSource/src/System/Diagnostics/DiagnosticSource.cs`
- E-09: `src/libraries/System.Diagnostics.DiagnosticSource/src/System/Diagnostics/DiagnosticListener.cs`
- E-10: `src/libraries/System.Diagnostics.DiagnosticSource/src/System/Diagnostics/DistributedContextPropagator.cs`
- E-11: `src/libraries/System.Diagnostics.DiagnosticSource/src/System/Diagnostics/W3CPropagator.cs`
- E-12: `src/libraries/System.Diagnostics.DiagnosticSource/src/System/Diagnostics/Metrics/Meter.cs`
- E-13: `src/libraries/System.Diagnostics.DiagnosticSource/src/System/Diagnostics/Metrics/Instrument.cs`
- E-14: `src/libraries/System.Diagnostics.DiagnosticSource/src/System/Diagnostics/Metrics/Counter.cs`
- E-15: `src/libraries/System.Diagnostics.DiagnosticSource/src/System/Diagnostics/Metrics/Histogram.cs`
- E-16: `src/libraries/System.Diagnostics.DiagnosticSource/src/System/Diagnostics/Metrics/MeterListener.cs`

## 3) Claims と根拠の対応（レビューの主戦場）

### Activity クラス（UT-DDS-001〜019）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Activity.Start()でActivityが開始される | E-01 | ○ |
| C-02 | Activity.Stop()でActivityが停止される | E-01 | ○ |
| C-03 | SetTag()でタグが設定される | E-01 | ○ |
| C-04 | nullキーでSetTag時に例外がスローされる | E-01 | ○ |
| C-05 | AddBaggage()でBaggageが追加される | E-01 | ○ |
| C-06 | GetBaggageItem()で値が取得できる | E-01 | ○ |
| C-07 | 存在しないキーでGetBaggageItem時にnullが返る | E-01 | ○ |
| C-08 | SetIdFormat()でIdFormatが設定される | E-01 | ○ |
| C-09 | SetParentId()でParentIdが設定される | E-01 | ○ |
| C-10 | SetStatus()でStatusが設定される | E-01 | ○ |
| C-11 | AddEvent()でイベントが追加される | E-01 | ○ |
| C-12 | Activity.Currentで現在のActivityが取得できる | E-01 | ○ |
| C-13 | Activityがない場合Activity.Currentはnull | E-01 | ○ |
| C-14 | Activity.Idで非nullのIDが返る | E-01 | ○ |
| C-15 | Activity.TraceIdで有効なTraceIdが返る | E-01 | ○ |
| C-16 | Activity.SpanIdで有効なSpanIdが返る | E-01 | ○ |
| C-17 | Activity.Durationで正の値が返る | E-01 | ○ |
| C-18 | Activity.ParentSpanIdで親のSpanIdが返る | E-01 | ○ |
| C-19 | Activity.Dispose()でリソースが解放される | E-01 | ○ |

### ActivitySource クラス（UT-DDS-020〜030）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-20 | ActivitySourceコンストラクタで正常に作成される | E-02 | ○ |
| C-21 | null名でActivitySource作成時に例外がスローされる | E-02 | ○ |
| C-22 | CreateActivity()でActivityが作成される | E-02 | ○ |
| C-23 | リスナーがない場合CreateActivity()はnullを返す | E-02 | ○ |
| C-24 | StartActivity()でActivityが作成・開始される | E-02 | ○ |
| C-25 | 親コンテキスト付きでStartActivity()が動作する | E-02 | ○ |
| C-26 | HasListeners()がtrueを返す | E-02 | ○ |
| C-27 | リスナーがない場合HasListeners()がfalseを返す | E-02 | ○ |
| C-28 | AddActivityListener()でリスナーが追加される | E-02 | ○ |
| C-29 | nullリスナーでAddActivityListener時に例外 | E-02 | ○ |
| C-30 | Dispose()でリソースが解放される | E-02 | ○ |

### ActivityListener クラス（UT-DDS-031〜036）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-31 | ActivityListenerコンストラクタで正常に作成される | E-03 | ○ |
| C-32 | ShouldListenToフィルターが機能する | E-03 | ○ |
| C-33 | Sampleコールバックが機能する | E-03 | ○ |
| C-34 | ActivityStartedコールバックが呼び出される | E-03 | ○ |
| C-35 | ActivityStoppedコールバックが呼び出される | E-03 | ○ |
| C-36 | Dispose()でリスナーが削除される | E-03 | ○ |

### ActivityContext 構造体（UT-DDS-037〜044）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-37 | ActivityContextコンストラクタで正常に作成される | E-04 | ○ |
| C-38 | TryParse()でW3C形式がパースされる | E-04 | ○ |
| C-39 | 不正なtraceParentでTryParse()がfalseを返す | E-04 | ○ |
| C-40 | nullのtraceParentでTryParse()がfalseを返す | E-04 | ○ |
| C-41 | Parse()でW3C形式がパースされる | E-04 | ○ |
| C-42 | 不正なtraceParentでParse()が例外をスローする | E-04 | ○ |
| C-43 | Equals()で同一コンテキストがtrueを返す | E-04 | ○ |
| C-44 | Equals()で異なるコンテキストがfalseを返す | E-04 | ○ |

### ActivityTagsCollection クラス（UT-DDS-045〜054）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-45 | 空のコレクションが作成される | E-05 | ○ |
| C-46 | 初期値付きでコレクションが作成される | E-05 | ○ |
| C-47 | Add()でタグが追加される | E-05 | ○ |
| C-48 | 重複キーでAdd()時に例外がスローされる | E-05 | ○ |
| C-49 | インデクサで値が設定される | E-05 | ○ |
| C-50 | インデクサでnullを設定すると削除される | E-05 | ○ |
| C-51 | Remove()でタグが削除される | E-05 | ○ |
| C-52 | 存在しないキーでRemove()がfalseを返す | E-05 | ○ |
| C-53 | ContainsKey()でキー存在確認ができる | E-05 | ○ |
| C-54 | TryGetValue()で値が取得できる | E-05 | ○ |

### ActivityEvent/ActivityLink 構造体（UT-DDS-055〜058）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-55 | ActivityEventコンストラクタで正常に作成される | E-06 | ○ |
| C-56 | タイムスタンプ付きActivityEventが作成される | E-06 | ○ |
| C-57 | ActivityLinkコンストラクタで正常に作成される | E-07 | ○ |
| C-58 | ActivityLink.Equals()が正しく動作する | E-07 | ○ |

### DiagnosticSource/DiagnosticListener クラス（UT-DDS-059〜069）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-59 | Write()でイベントが書き込まれる | E-08, E-09 | ○ |
| C-60 | IsEnabled()でイベント有効確認ができる | E-08, E-09 | ○ |
| C-61 | DiagnosticListenerコンストラクタで正常に作成される | E-09 | ○ |
| C-62 | AllListenersで全リスナーが取得できる | E-09 | ○ |
| C-63 | Subscribe()でサブスクリプションが作成される | E-09 | ○ |
| C-64 | フィルター付きSubscribe()が動作する | E-09 | ○ |
| C-65 | サブスクライバがいる場合IsEnabled()がtrueを返す | E-09 | ○ |
| C-66 | サブスクライバがいない場合IsEnabled()がfalseを返す | E-09 | ○ |
| C-67 | Write()でサブスクライバに通知される | E-09 | ○ |
| C-68 | Dispose()でリスナーがDisposeされる | E-09 | ○ |
| C-69 | 複数回Dispose()呼び出しで例外がスローされない | E-09 | ○ |

### DistributedContextPropagator/W3CPropagator クラス（UT-DDS-070〜082）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-70 | Currentで現在のプロパゲーターが取得できる | E-10 | ○ |
| C-71 | Currentでプロパゲーターが設定できる | E-10 | ○ |
| C-72 | Currentにnull設定で例外がスローされる | E-10 | ○ |
| C-73 | CreateDefaultPropagator()でW3CPropagatorが返る | E-10 | ○ |
| C-74 | CreatePassThroughPropagator()が正常に動作する | E-10 | ○ |
| C-75 | CreateNoOutputPropagator()が正常に動作する | E-10 | ○ |
| C-76 | Inject()でトレース情報がインジェクトされる | E-11 | ○ |
| C-77 | nullActivityでInject()が何もしない | E-11 | ○ |
| C-78 | ExtractTraceIdAndState()でトレース情報が抽出される | E-11 | ○ |
| C-79 | 不正なtraceparentでExtract時にtraceIdがnull | E-11 | ○ |
| C-80 | ExtractBaggage()でBaggageが抽出される | E-11 | ○ |
| C-81 | ValidateTraceState()で有効なtraceStateが検証される | E-11 | ○ |
| C-82 | 不正なtraceStateでValidateTraceState()がnullを返す | E-11 | ○ |

### Meter クラス（UT-DDS-083〜094）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-83 | Meterコンストラクタで正常に作成される | E-12 | ○ |
| C-84 | バージョン付きMeterが作成される | E-12 | ○ |
| C-85 | null名でMeter作成時に例外がスローされる | E-12 | ○ |
| C-86 | CreateCounter()でCounterが作成される | E-12 | ○ |
| C-87 | 同名Counterは再利用される | E-12 | ○ |
| C-88 | CreateHistogram()でHistogramが作成される | E-12 | ○ |
| C-89 | CreateGauge()でGaugeが作成される | E-12 | ○ |
| C-90 | CreateUpDownCounter()でUpDownCounterが作成される | E-12 | ○ |
| C-91 | CreateObservableCounter()でObservableCounterが作成される | E-12 | ○ |
| C-92 | CreateObservableGauge()でObservableGaugeが作成される | E-12 | ○ |
| C-93 | CreateObservableUpDownCounter()が正常に動作する | E-12 | ○ |
| C-94 | Dispose()でMeterがDisposeされる | E-12 | ○ |

### Instrument/Counter/Histogram 関連（UT-DDS-095〜105）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-95 | Counter.Add()で値が加算される | E-14 | ○ |
| C-96 | Counter.Add()でタグ付き値が加算される | E-14 | ○ |
| C-97 | Histogram.Record()で値が記録される | E-15 | ○ |
| C-98 | Histogram.Record()でタグ付き値が記録される | E-15 | ○ |
| C-99 | Gauge.Record()で値が記録される | E-12 | ○ |
| C-100 | UpDownCounter.Add()で正の値が加算される | E-12 | ○ |
| C-101 | UpDownCounter.Add()で負の値が加算される | E-12 | ○ |
| C-102 | Instrument.Meterで作成元Meterが取得できる | E-13 | ○ |
| C-103 | Instrument.Nameで名前が取得できる | E-13 | ○ |
| C-104 | Instrument.Enabledがtrueを返す | E-13 | ○ |
| C-105 | リスナーなし時Instrument.Enabledがfalseを返す | E-13 | ○ |

### MeterListener クラス（UT-DDS-106〜118）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-106 | MeterListenerコンストラクタで正常に作成される | E-16 | ○ |
| C-107 | EnableMeasurementEvents()で測定が有効化される | E-16 | ○ |
| C-108 | DisableMeasurementEvents()で測定が無効化される | E-16 | ○ |
| C-109 | SetMeasurementEventCallback()でコールバックが設定される | E-16 | ○ |
| C-110 | サポートされない型でSetMeasurementEventCallback時に例外 | E-16 | ○ |
| C-111 | Start()でリスナーが開始される | E-16 | ○ |
| C-112 | RecordObservableInstruments()で観測される | E-16 | ○ |
| C-113 | Dispose()でリスナーがDisposeされる | E-16 | ○ |
| C-114 | InstrumentPublishedで新規Instrument通知を受ける | E-16 | ○ |
| C-115 | MeasurementsCompletedで測定完了通知を受ける | E-16 | ○ |

### その他（UT-DDS-116〜132）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-116 | Measurementコンストラクタで正常に作成される | E-12 | ○ |
| C-117 | Measurement.Valueで値が取得できる | E-12 | ○ |
| C-118 | Measurement.Tagsでタグが取得できる | E-12 | ○ |
| C-119 | ActivityTraceId.CreateRandom()でランダム生成される | E-01 | ○ |
| C-120 | ActivityTraceId.CreateFromString()で文字列から作成される | E-01 | ○ |
| C-121 | ActivityTraceId.ToHexString()で16進変換される | E-01 | ○ |
| C-122 | ActivitySpanId.CreateRandom()でランダム生成される | E-01 | ○ |
| C-123 | ActivitySpanId.CreateFromString()で文字列から作成される | E-01 | ○ |
| C-124 | ActivitySpanId.ToHexString()で16進変換される | E-01 | ○ |
| C-125 | TagList.Add()でタグが追加される | E-01 | ○ |
| C-126 | TagList.Countでタグ数が取得できる | E-01 | ○ |
| C-127 | SynchronizedList.Add()でスレッドセーフに追加される | E-02 | ○ |
| C-128 | SynchronizedList.Remove()でスレッドセーフに削除される | E-02 | ○ |
| C-129 | SynchronizedList.Countでアイテム数が取得できる | E-02 | ○ |
| C-130 | DiagLinkedList.Add()でノードが追加される | E-13 | ○ |
| C-131 | DiagLinkedList.Remove()でノードが削除される | E-13 | ○ |
| C-132 | DiagLinkedList.Clear()でリストがクリアされる | E-13 | ○ |

## 4) 不足情報（Unknown / Missing）
- 本テストケース一覧は、ソースコードから抽出した公開APIに基づいて作成されています
- 内部実装の詳細（privateメソッド等）は対象外としています
- 実際のテスト実装時には、追加の境界値テストケースが必要になる可能性があります

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**：全テストケースがソースコードの根拠に基づいて作成されています
- Activity関連のテストケースはスレッドセーフティを考慮した実装確認が必要
- Metrics関連のテストケースは、コールバック呼び出しのタイミングを確認する必要があります

## 6) レビュアーチェックリスト（最小）
- [ ] Activity.Start/Stop の動作が正しくテストされているか
- [ ] ActivitySource.CreateActivity のリスナー有無による分岐がテストされているか
- [ ] DiagnosticListener.Subscribe のフィルター機能がテストされているか
- [ ] W3CPropagator の Inject/Extract が正しくテストされているか
- [ ] Meter.CreateCounter 等の Instrument 作成がテストされているか
- [ ] MeterListener のコールバック呼び出しがテストされているか
- [ ] スレッドセーフなコレクション（SynchronizedList, DiagLinkedList）の動作がテストされているか
- [ ] 各異常系テストケースが適切に例外をスローすることを確認しているか
