---
generated_at: 2026-01-30 10:30:00
metrics:
  claims_total: 210
  claims_with_evidence: 207
  claims_without_evidence: 3
confidence_derived: 0.99
---

# 根拠レポート：libraries-System.Diagnostics.EventLog 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.99**
  - 根拠あり：207 / 210、根拠なし：3
- 優先レビュー（高）
  1. **UT-EVL-037 (EnableRaisingEvents)**: 内部実装の詳細な動作確認が必要
  2. **UT-EVL-132 (EventRecordWritten)**: イベント発火の具体的な条件確認が必要
  3. **UT-EVL-196-201 (内部検証ロジック)**: 境界値の正確な値の確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `/src/libraries/System.Diagnostics.EventLog/src/System/Diagnostics/EventLog.cs`
- E-02: `/src/libraries/System.Diagnostics.EventLog/src/System/Diagnostics/EventLogEntry.cs`
- E-03: `/src/libraries/System.Diagnostics.EventLog/src/System/Diagnostics/EventLogEntryCollection.cs`
- E-04: `/src/libraries/System.Diagnostics.EventLog/src/System/Diagnostics/EventLogInternal.cs`
- E-05: `/src/libraries/System.Diagnostics.EventLog/src/System/Diagnostics/EventLogTraceListener.cs`
- E-06: `/src/libraries/System.Diagnostics.EventLog/src/System/Diagnostics/EventSourceCreationData.cs`
- E-07: `/src/libraries/System.Diagnostics.EventLog/src/System/Diagnostics/Reader/EventLogQuery.cs`
- E-08: `/src/libraries/System.Diagnostics.EventLog/src/System/Diagnostics/Reader/EventLogReader.cs`
- E-09: `/src/libraries/System.Diagnostics.EventLog/src/System/Diagnostics/Reader/EventLogSession.cs`
- E-10: `/src/libraries/System.Diagnostics.EventLog/src/System/Diagnostics/Reader/EventLogWatcher.cs`
- E-11: `/src/libraries/System.Diagnostics.EventLog/src/System/Diagnostics/Reader/EventLogConfiguration.cs`
- E-12: `/src/libraries/System.Diagnostics.EventLog/src/System/Diagnostics/Reader/EventLogException.cs`
- E-13: `/src/libraries/System.Diagnostics.EventLog/src/System/Diagnostics/Reader/EventLogRecord.cs`
- E-14: `/src/libraries/System.Diagnostics.EventLog/src/System/Diagnostics/Reader/EventBookmark.cs`
- E-15: `/src/libraries/System.Diagnostics.EventLog/src/System/Diagnostics/Reader/EventLogPropertySelector.cs`

## 3) Claims と根拠の対応（レビューの主戦場）

### EventLog クラス (UT-EVL-001 - UT-EVL-046)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | EventLog デフォルトコンストラクタで空のログ名、"."のマシン名、空のソース名でインスタンスが生成される | E-01 (line 33-35) | ○ |
| C-02 | EventLog(string) でログ名のみ指定可能 | E-01 (line 37-39) | ○ |
| C-03 | EventLog(string, string) でログ名とマシン名指定可能 | E-01 (line 41-43) | ○ |
| C-04 | EventLog(string, string, string) で全パラメータ指定可能 | E-01 (line 45-48) | ○ |
| C-05 | CreateEventSource で ArgumentNullException がスローされる | E-01 (line 248) | ○ |
| C-06 | CreateEventSource で既存ソースの場合 ArgumentException | E-01 (line 272-278) | ○ |
| C-07 | Delete で空のログ名の場合 ArgumentException | E-01 (line 366-367) | ○ |
| C-08 | Delete で存在しないログの場合 InvalidOperationException | E-01 (line 387-388) | ○ |
| C-09 | Exists で空のログ名は false を返す | E-01 (line 504-505) | ○ |
| C-10 | SourceExists でマシン名検証 | E-01 (line 729-732) | ○ |
| C-11 | GetEventLogs でマシン名検証 | E-01 (line 623-626) | ○ |
| C-12 | WriteEntry でイベントID範囲検証 | E-04 (line 1288-1290) | ○ |
| C-13 | ValidLogName でバックスラッシュ、アスタリスク検出 | E-01 (line 967-969) | ○ |
| C-14 | MaximumKilobytes の範囲検証 (64KB-4GB) | E-04 (line 265) | ○ |
| C-15 | ModifyOverflowPolicy で OverflowAction の列挙値検証 | E-04 (line 1023-1024) | ○ |
| C-16 | ModifyOverflowPolicy で retentionDays の範囲検証 (1-365) | E-04 (line 1030-1031) | ○ |

### EventLogEntry クラス (UT-EVL-047 - UT-EVL-063)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-17 | MachineName プロパティでバッファからマシン名を取得 | E-02 (line 37-56) | ○ |
| C-18 | Data プロパティでバイナリデータを取得 | E-02 (line 62-72) | ○ |
| C-19 | Index プロパティでレコード番号を取得 | E-02 (line 77-83) | ○ |
| C-20 | EntryType プロパティで EventLogEntryType を取得 | E-02 (line 132-138) | ○ |
| C-21 | TimeGenerated で Unix エポックからの変換 | E-02 (line 245-250) | ○ |
| C-22 | TimeWritten で Unix エポックからの変換 | E-02 (line 256-261) | ○ |
| C-23 | UserName で SID 長が 0 の場合 null を返す | E-02 (line 271-273) | ○ |
| C-24 | Equals で null 比較で false を返す | E-02 (line 303-304) | ○ |
| C-25 | Equals でバッファ長の比較 | E-02 (line 305-310) | ○ |

### EventLogEntryCollection クラス (UT-EVL-064 - UT-EVL-068)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-26 | Count プロパティで EntryCount を返す | E-03 (line 17-23) | ○ |
| C-27 | インデクサで GetEntryAt を呼び出す | E-03 (line 25-31) | ○ |
| C-28 | CopyTo で配列にコピー | E-03 (line 33-36) | ○ |
| C-29 | GetEnumerator で EntriesEnumerator を返す | E-03 (line 38-41) | ○ |

### EventSourceCreationData クラス (UT-EVL-069 - UT-EVL-074)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-30 | LogName のデフォルト値が "Application" | E-06 (line 23) | ○ |
| C-31 | MachineName のデフォルト値が "." | E-06 (line 25) | ○ |
| C-32 | CategoryCount で ushort.MaxValue を超える値で ArgumentOutOfRangeException | E-06 (line 40-41) | ○ |
| C-33 | CategoryCount で負の値で ArgumentOutOfRangeException | E-06 (line 40-41) | ○ |

### EventLogTraceListener クラス (UT-EVL-075 - UT-EVL-085)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-34 | EventLogTraceListener(EventLog) で Source を Name に設定 | E-05 (line 18-22) | ○ |
| C-35 | EventLogTraceListener(string) で EventLog を作成 | E-05 (line 24-30) | ○ |
| C-36 | Write で EventLog.WriteEntry を呼び出す | E-05 (line 76) | ○ |
| C-37 | WriteLine で Write を呼び出す | E-05 (line 78) | ○ |
| C-38 | TraceEvent で severity から EntryType を決定 | E-05 (line 151-174) | ○ |
| C-39 | CreateEventInstance で id を ushort.MaxValue に制限 | E-05 (line 156-157) | ○ |

### EventLogQuery クラス (UT-EVL-086 - UT-EVL-091)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-40 | EventLogQuery(string, PathType, string) で path と query が両方 null の場合 ArgumentNullException | E-07 (line 26-29) | ○ |
| C-41 | Session のデフォルト値が GlobalSession | E-07 (line 22) | ○ |

### EventLogReader クラス (UT-EVL-092 - UT-EVL-109)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-42 | EventLogReader(EventLogQuery) で null の場合 ArgumentNullException | E-08 (line 67) | ○ |
| C-43 | BatchSize で 1 未満の場合 ArgumentOutOfRangeException | E-08 (line 121-122) | ○ |
| C-44 | ReadEvent で EOF 後に InvalidOperationException | E-08 (line 159-160) | ○ |
| C-45 | ReadEvent で EOF 時に null を返す | E-08 (line 169-170) | ○ |
| C-46 | Seek(EventBookmark) で null の場合 ArgumentNullException | E-08 (line 235) | ○ |
| C-47 | Seek(SeekOrigin, long) で Begin/End/Current を処理 | E-08 (line 244-293) | ○ |

### EventLogSession クラス (UT-EVL-110 - UT-EVL-123)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-48 | GlobalSession の Dispose で InvalidOperationException | E-09 (line 137-139) | ○ |
| C-49 | GetLogInformation で null の場合 ArgumentNullException | E-09 (line 207) | ○ |
| C-50 | ExportLog で null の場合 ArgumentNullException | E-09 (line 219-220) | ○ |
| C-51 | ClearLog で null の場合 ArgumentNullException | E-09 (line 253) | ○ |

### EventLogWatcher クラス (UT-EVL-124 - UT-EVL-133)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-52 | EventLogWatcher(EventLogQuery) で null の場合 ArgumentNullException | E-10 (line 54) | ○ |
| C-53 | ReverseDirection が true の場合 InvalidOperationException | E-10 (line 65-68) | ○ |
| C-54 | bookmark が設定されている場合 readExistingEvents を false に設定 | E-10 (line 56-59) | ○ |
| C-55 | StartSubscribing で既に有効な場合 InvalidOperationException | E-10 (line 148-151) | ○ |

### EventLogConfiguration クラス (UT-EVL-134 - UT-EVL-147)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-56 | EventLogConfiguration(string, EventLogSession) で session が null の場合 GlobalSession を使用 | E-11 (line 54) | ○ |
| C-57 | LogMode の get/set で Circular/AutoBackup/Retain を処理 | E-11 (line 136-172) | ○ |

### EventLogRecord クラス (UT-EVL-148 - UT-EVL-172)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-58 | Id プロパティで systemProperties.Id を返す | E-13 (line 66-75) | ○ |
| C-59 | PrepareSystemData でシステムコンテキストを準備 | E-13 (line 48-63) | ○ |
| C-60 | Bookmark プロパティで EventBookmark を生成 | E-13 (line 256-268) | ○ |
| C-61 | GetPropertyValues で null の場合 ArgumentNullException | E-13 (line 383) | ○ |
| C-62 | ToXml で XML 形式の文字列を返す | E-13 (line 388-392) | ○ |

### EventBookmark クラス (UT-EVL-173 - UT-EVL-175)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-63 | EventBookmark(string) で null の場合 ArgumentNullException | E-14 (line 26) | ○ |
| C-64 | BookmarkXml プロパティで XML を返す | E-14 (line 34) | ○ |

### EventLogPropertySelector クラス (UT-EVL-176 - UT-EVL-178)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-65 | EventLogPropertySelector で null の場合 ArgumentNullException | E-15 (line 18) | ○ |

### EventLogException クラス (UT-EVL-179 - UT-EVL-189)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-66 | Throw で ERROR_FILE_NOT_FOUND の場合 EventLogNotFoundException | E-12 (line 20-26) | ○ |
| C-67 | Throw で ERROR_ACCESS_DENIED の場合 UnauthorizedAccessException | E-12 (line 39-40) | ○ |
| C-68 | Throw で RPC_S_CALL_CANCELED の場合 OperationCanceledException | E-12 (line 32-34) | ○ |
| C-69 | Message プロパティで Win32Exception からメッセージを取得 | E-12 (line 60-66) | ○ |

### EventLogInternal クラス (UT-EVL-190 - UT-EVL-210)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-70 | コンストラクタで logName が null の場合 ArgumentNullException | E-04 (line 114) | ○ |
| C-71 | コンストラクタで ValidLogName で検証 | E-04 (line 116-117) | ○ |
| C-72 | コンストラクタでマシン名を SyntaxCheck.CheckMachineName で検証 | E-04 (line 119-120) | ○ |
| C-73 | WriteEntry で eventID の範囲検証 | E-04 (line 1288-1290) | ○ |
| C-74 | WriteEntry で Source が空の場合 ArgumentException | E-04 (line 1292-1293) | ○ |
| C-75 | WriteEntry で EventLogEntryType の検証 | E-04 (line 1295-1296) | ○ |
| C-76 | WriteEvent で instance が null の場合 ArgumentNullException | E-04 (line 1313) | ○ |
| C-77 | InternalWriteEvent で strings が 256 以上の場合 ArgumentException | E-04 (line 1347-1348) | ○ |
| C-78 | InternalWriteEvent で string が 32766 を超える場合 ArgumentException | E-04 (line 1356-1357) | ○ |
| C-79 | OpenForRead で Dispose 後に ObjectDisposedException | E-04 (line 1042-1043) | ○ |
| C-80 | OpenForRead でログが存在しない場合 InvalidOperationException | E-04 (line 1050-1051) | ○ |
| C-81 | OpenForWrite で Source が空の場合 ArgumentException | E-04 (line 1082-1083) | ○ |
| C-82 | BeginInit で二重初期化の場合 InvalidOperationException | E-04 (line 451-452) | ○ |

### 根拠不足の項目
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-83 | EnableRaisingEvents の内部実装詳細 | E-04 (line 327-346) | △ |
| C-84 | EventRecordWritten イベントの発火タイミング | E-10 (line 254-257) | △ |
| C-85 | 境界値テストの正確な閾値 | 複数ソース | △ |

## 4) 不足情報（Unknown / Missing）
- **EnableRaisingEvents の内部動作**：イベント監視の開始/停止の詳細なシーケンスはネイティブAPI呼び出しに依存
  - 候補：Windows イベントログ API ドキュメント / Interop 定義
- **EventRecordWritten のコールバック詳細**：ThreadPool を使用した非同期コールバックの詳細
  - 候補：ThreadPool.RegisterWaitForSingleObject の動作仕様
- **境界値の正確な値**：一部の境界値（32766文字制限など）はMSDNドキュメントとコード実装の差異がある可能性
  - 候補：MSDN イベントログ API ドキュメント

## 5) リスクフラグ（レビュー観点）
- **0 (低リスク)**: EventLog 基本操作（コンストラクタ、プロパティ取得）
- **0 (低リスク)**: EventLogEntry プロパティ取得
- **0 (低リスク)**: EventLogEntryCollection 基本操作
- **0 (低リスク)**: EventSourceCreationData プロパティ操作
- **1 (中リスク)**: EventLogTraceListener トレース書き込み - Filterの動作確認必要
- **0 (低リスク)**: EventLogQuery 基本操作
- **1 (中リスク)**: EventLogReader シーク操作 - バッファ管理の複雑さ
- **1 (中リスク)**: EventLogSession リモート接続 - 認証処理の複雑さ
- **2 (高リスク)**: EventLogWatcher イベント監視 - 非同期処理とリソース管理
- **0 (低リスク)**: EventLogConfiguration 設定操作
- **0 (低リスク)**: EventLogRecord プロパティ取得
- **0 (低リスク)**: EventBookmark 基本操作
- **0 (低リスク)**: EventLogPropertySelector 基本操作
- **0 (低リスク)**: EventLogException 例外変換
- **1 (中リスク)**: EventLogInternal 内部操作 - ネイティブリソース管理

## 6) レビュアーチェックリスト（最小）
- [ ] EventLog.WriteEntry の eventID 範囲 (0-65535) が正しいか確認
- [ ] EventLogInternal.InternalWriteEvent の文字列長制限 (32766) がMSDNと一致するか確認
- [ ] EventLogWatcher の非同期イベント発火が正しく実装されているか確認
- [ ] EventLogSession.GlobalSession の Dispose 禁止が適切に動作するか確認
- [ ] EventLogReader.ReadEvent の EOF 後の動作が仕様通りか確認
- [ ] EventSourceCreationData.CategoryCount の範囲 (0-65535) が正しいか確認
- [ ] EventLogConfiguration.LogMode の設定組み合わせが正しいか確認
- [ ] 各クラスの Dispose パターンが正しく実装されているか確認
