---
generated_at: 2026-01-30 12:30:00
metrics:
  claims_total: 70
  claims_with_evidence: 68
  claims_without_evidence: 2
confidence_derived: 0.97
---

# 根拠レポート：libraries-System.Diagnostics.FileVersionInfo 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存テストコードなどの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：68 / 70、根拠なし：2
- 優先レビュー（高）
  1. **UT-FVI-045（ushort オーバーフロー動作）**：実際のオーバーフロー挙動の検証が必要
  2. **UT-FVI-050（破損ファイルの例外捕捉）**：例外捕捉の網羅性の確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Diagnostics.FileVersionInfo/src/System/Diagnostics/FileVersionInfo.cs` - 共通実装（プロパティ定義、GetVersionInfo、ToString）
- E-02: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Diagnostics.FileVersionInfo/src/System/Diagnostics/FileVersionInfo.Windows.cs` - Windows固有実装（Win32 API呼び出し、バージョン情報パース）
- E-03: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Diagnostics.FileVersionInfo/src/System/Diagnostics/FileVersionInfo.Unix.cs` - Unix固有実装（メタデータ読み込み、ParseVersion）
- E-04: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Diagnostics.FileVersionInfo/ref/System.Diagnostics.FileVersionInfo.cs` - API リファレンス定義
- E-05: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Diagnostics.FileVersionInfo/tests/System.Diagnostics.FileVersionInfo.Tests/FileVersionInfoTest.cs` - 共通テスト
- E-06: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Diagnostics.FileVersionInfo/tests/System.Diagnostics.FileVersionInfo.Tests/FileVersionInfoTest.Unix.cs` - Unix固有テスト
- E-07: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Diagnostics.FileVersionInfo/tests/System.Diagnostics.FileVersionInfo.Tests/FileVersionInfoTest.Windows.cs` - Windows固有テスト

## 3) Claims と根拠の対応（レビューの主戦場）

### GetVersionInfo メソッド関連
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 (UT-FVI-001) | マネージドアセンブリのバージョン情報取得 | E-01 (L265-280), E-05 (L21-54) | ○ |
| C-02 (UT-FVI-002) | 相対パスから絶対パスへの変換 | E-01 (L269-272), E-05 (L107-125) | ○ |
| C-03 (UT-FVI-003) | 存在しないファイルで FileNotFoundException | E-01 (L274-276), E-05 (L99-104) | ○ |
| C-04 (UT-FVI-004) | ディレクトリパスで FileNotFoundException | E-01 (L274-276), E-05 (L93-97) | ○ |
| C-05 (UT-FVI-005) | Unix: シンボリックリンク経由での取得 | E-03 (L19-23), E-06 (L24-63) | ○ |
| C-06 (UT-FVI-006) | Unix: 無効なシンボリックリンクで FileNotFoundException | E-03 (L19-23), E-06 (L65-76) | ○ |
| C-07 (UT-FVI-007) | Unix: 名前付きパイプで FileNotFoundException | E-03 (L19-23), E-06 (L12-20) | ○ |
| C-08 (UT-FVI-008) | Windows: ネイティブPEファイルのバージョン情報取得 | E-02 (L11-42), E-07 (L17-52) | ○ |
| C-09 (UT-FVI-009) | Windows: 中国語ローカライズDLLの取得 | E-02 (L54-62), E-07 (L54-90) | ○ |
| C-10 (UT-FVI-010) | Windows: 異なるFileVersionとProductVersion | E-02 (L110-128), E-07 (L92-127) | ○ |

### ToString メソッド関連
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-11 (UT-FVI-011) | 全プロパティの文字列化 | E-01 (L286-306), E-05 (L163-178) | ○ |
| C-12 (UT-FVI-012) | nullプロパティの空文字出力 | E-01 (L286-306), E-05 (L57-89) | ○ |

### プロパティ getter 関連
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-13 (UT-FVI-013) | Comments getter | E-01 (L46-49), E-05 (L26, L135) | ○ |
| C-14 (UT-FVI-014) | CompanyName getter | E-01 (L54-57), E-05 (L27, L136) | ○ |
| C-15 (UT-FVI-015) | FileDescription getter | E-01 (L69-73), E-05 (L29, L138) | ○ |
| C-16 (UT-FVI-016) | FileVersion getter | E-01 (L110-113), E-05 (L34, L143) | ○ |
| C-17 (UT-FVI-017) | FileMajorPart getter | E-01 (L78-81), E-05 (L30, L139) | ○ |
| C-18 (UT-FVI-018) | FileMinorPart getter | E-01 (L86-89), E-05 (L31, L140) | ○ |
| C-19 (UT-FVI-019) | FileBuildPart getter | E-01 (L62-65), E-05 (L28, L137) | ○ |
| C-20 (UT-FVI-020) | FilePrivatePart getter | E-01 (L102-105), E-05 (L33, L142) | ○ |
| C-21 (UT-FVI-021) | FileName getter | E-01 (L94-97), E-05 (L32, L141) | ○ |
| C-22 (UT-FVI-022) | InternalName getter | E-01 (L118-121), E-05 (L35, L144) | ○ |
| C-23 (UT-FVI-023) | OriginalFilename getter | E-01 (L193-196), E-05 (L44, L153) | ○ |
| C-24 (UT-FVI-024) | ProductName getter | E-01 (L233-236), E-05 (L49, L158) | ○ |
| C-25 (UT-FVI-025) | ProductVersion getter | E-01 (L249-252), E-05 (L51, L160) | ○ |
| C-26 (UT-FVI-026) | ProductMajorPart getter | E-01 (L217-220), E-05 (L47, L156) | ○ |
| C-27 (UT-FVI-027) | ProductMinorPart getter | E-01 (L225-228), E-05 (L48, L157) | ○ |
| C-28 (UT-FVI-028) | ProductBuildPart getter | E-01 (L209-212), E-05 (L45, L155) | ○ |
| C-29 (UT-FVI-029) | ProductPrivatePart getter | E-01 (L241-244), E-05 (L50, L159) | ○ |
| C-30 (UT-FVI-030) | LegalCopyright getter | E-01 (L177-180), E-05 (L42, L151) | ○ |
| C-31 (UT-FVI-031) | LegalTrademarks getter | E-01 (L185-188), E-05 (L43, L152) | ○ |
| C-32 (UT-FVI-032) | Language getter | E-01 (L169-172), E-05 (L41, L150) | ○ |
| C-33 (UT-FVI-033) | Unix: Language "Language Neutral" | E-03 (L101), E-06 (L78) | ○ |
| C-34 (UT-FVI-034) | IsDebug getter | E-01 (L127-130), E-05 (L36, L145) | ○ |
| C-35 (UT-FVI-035) | IsPatched getter | E-01 (L136-139), E-05 (L37, L146) | ○ |
| C-36 (UT-FVI-036) | IsPrivateBuild getter | E-01 (L144-147), E-05 (L38, L147) | ○ |
| C-37 (UT-FVI-037) | IsPreRelease getter | E-01 (L153-156), E-05 (L39, L148) | ○ |
| C-38 (UT-FVI-038) | IsSpecialBuild getter | E-01 (L161-164), E-05 (L40, L149) | ○ |
| C-39 (UT-FVI-039) | PrivateBuild getter | E-01 (L201-204), E-05 (L45, L154) | ○ |
| C-40 (UT-FVI-040) | SpecialBuild getter | E-01 (L257-260), E-05 (L52, L161) | ○ |

### 境界値テスト関連
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-41 (UT-FVI-041) | バージョン情報なしファイルで null/0 | E-05 (L56-89) | ○ |
| C-42 (UT-FVI-042) | 4パート以上のバージョンで全て0 | E-03 (L204-206) | ○ |
| C-43 (UT-FVI-043) | 非数字文字で途中終了 | E-03 (L195-197, L237-241) | ○ |
| C-44 (UT-FVI-044) | 空文字列で全て0 | E-03 (L200, L207) | ○ |
| C-45 (UT-FVI-045) | ushortオーバーフロー時のラップアラウンド | E-03 (L242) コメントに記載あるが実際の検証なし | △ |
| C-46 (UT-FVI-046) | 先頭が非数字で0返却 | E-03 (L237-241) | ○ |
| C-47 (UT-FVI-047) | 空白が非数字として扱われる | E-03 (L197, L237) | ○ |

### Unix 内部メソッド関連
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-48 (UT-FVI-048) | TryLoadManagedAssemblyMetadata true 返却 | E-03 (L44-72) | ○ |
| C-49 (UT-FVI-049) | 非マネージドで false 返却 | E-03 (L52-53, L63-69) | ○ |
| C-50 (UT-FVI-050) | 破損ファイルで例外捕捉 | E-03 (L63-69) catch ブロックはあるが網羅性不明 | △ |
| C-51 (UT-FVI-051) | exe で .exe 拡張子 | E-03 (L84-88) | ○ |
| C-52 (UT-FVI-052) | dll で .dll 拡張子 | E-03 (L84-88) | ○ |
| C-53 (UT-FVI-053) | AssemblyInformationalVersionAttribute なしでフォールバック | E-03 (L93-98) | ○ |
| C-54 (UT-FVI-054) | AssemblyVersion 0.0.0.0 でフォールバック | E-03 (L180-187) | ○ |

### Windows 内部メソッド関連
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-55 (UT-FVI-055) | GetVersionInfoForCodePage 正常取得 | E-02 (L91-128) | ○ |
| C-56 (UT-FVI-056) | コードページフォールバック | E-02 (L31-34) | ○ |
| C-57 (UT-FVI-057) | GetFixedFileInfo 正常取得 | E-02 (L44-52) | ○ |
| C-58 (UT-FVI-058) | GetFixedFileInfo default 返却 | E-02 (L51) | ○ |
| C-59 (UT-FVI-059) | GetFileVersionLanguage 言語名取得 | E-02 (L54-62) | ○ |
| C-60 (UT-FVI-060) | GetFileVersionString 文字列取得 | E-02 (L64-73) | ○ |
| C-61 (UT-FVI-061) | GetFileVersionString 空文字返却 | E-02 (L72) | ○ |
| C-62 (UT-FVI-062) | GetLanguageAndCodePage 取得 | E-02 (L75-85) | ○ |
| C-63 (UT-FVI-063) | GetLanguageAndCodePage デフォルト | E-02 (L84) | ○ |
| C-64 (UT-FVI-064) | HIWORD 正常動作 | E-02 (L130) | ○ |
| C-65 (UT-FVI-065) | LOWORD 正常動作 | E-02 (L132) | ○ |

### メタデータパース関連
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-66 (UT-FVI-066) | TryGetAttributeName MemberReference | E-03 (L259-268) | ○ |
| C-67 (UT-FVI-067) | TryGetAttributeName MethodDefinition | E-03 (L270-275) | ○ |
| C-68 (UT-FVI-068) | TryGetAttributeName 不正ハンドル | E-03 (L278-281) | ○ |
| C-69 (UT-FVI-069) | GetStringAttributeArgumentValue 正常 | E-03 (L288-321) | ○ |
| C-70 (UT-FVI-070) | GetStringAttributeArgumentValue 不正Prolog | E-03 (L309) | ○ |

## 4) 不足情報（Unknown / Missing）
- **UT-FVI-045（オーバーフロー動作）**：コード中にコメント（L242: "explicitly allow for overflow"）はあるが、実際にオーバーフローをテストする既存テストがない
  - 候補：オーバーフロー専用のテストケース追加 / Windows との挙動比較テスト
- **UT-FVI-050（破損ファイルの例外捕捉）**：catch ブロックは存在するが、どの例外が捕捉されるかの網羅的なドキュメントがない
  - 候補：BadImageFormatException / UnauthorizedAccessException / IOException などの明示的なテスト

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - GetVersionInfo の基本動作（UT-FVI-001〜004）：既存テストで十分にカバー
- **0: 低リスク** - プロパティ getter（UT-FVI-013〜040）：単純なフィールド返却のみ
- **1: 中リスク** - バージョンパース（UT-FVI-042〜047）：境界値の挙動確認が必要
- **1: 中リスク** - プラットフォーム固有実装（UT-FVI-005〜010）：プラットフォーム間の差異に注意
- **1: 中リスク** - 内部メソッド（UT-FVI-048〜070）：internal メソッドの直接テストは困難、統合テストで検証推奨

## 6) レビュアーチェックリスト（最小）
- [ ] Windows / Unix 両プラットフォームでのテスト実行を確認
- [ ] バージョン文字列のパースロジック（特にセマンティックバージョン対応）の妥当性を確認
- [ ] UT-FVI-045（オーバーフロー）の実際の挙動を手動または追加テストで確認
- [ ] UT-FVI-050（破損ファイル）の例外ハンドリングの網羅性を確認
- [ ] 多言語（中国語等）のバージョン情報取得テストの結果を確認
- [ ] シンボリックリンク関連テストが CI 環境で実行可能か確認
