---
generated_at: 2026-01-30 17:30:00
metrics:
  claims_total: 158
  claims_with_evidence: 156
  claims_without_evidence: 2
confidence_derived: 0.99
---

# 根拠レポート：libraries-System.Diagnostics.PerformanceCounter 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各テストケースに対して、ソースコード・既存テストコードなどの根拠（Evidence）が存在するか
2. **根拠との整合性**：テストケースの内容が実装コードと矛盾していないか
3. **網羅性**：主要なクラス・メソッド・観点をカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数 = 156 / 158 = 0.99

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で根拠なしの項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.99**
  - 根拠あり：156 / 158、根拠なし：2
- 優先レビュー（高）
  1. **UT-SDPC-067/068/069/070/071**：CheckValidIdメソッドはinternalであり、直接テスト困難な可能性
  2. **UT-SDPC-142/144/151**：Disposeの内部動作検証は実装依存

## 2) 参照した情報（Evidence一覧）

### ソースコード
- E-01: `src/libraries/System.Diagnostics.PerformanceCounter/src/System/Diagnostics/PerformanceCounter.cs`
- E-02: `src/libraries/System.Diagnostics.PerformanceCounter/src/System/Diagnostics/PerformanceCounterCategory.cs`
- E-03: `src/libraries/System.Diagnostics.PerformanceCounter/src/System/Diagnostics/CounterSample.cs`
- E-04: `src/libraries/System.Diagnostics.PerformanceCounter/src/System/Diagnostics/CounterSampleCalculator.cs`
- E-05: `src/libraries/System.Diagnostics.PerformanceCounter/src/System/Diagnostics/CounterCreationData.cs`
- E-06: `src/libraries/System.Diagnostics.PerformanceCounter/src/System/Diagnostics/CounterCreationDataCollection.cs`
- E-07: `src/libraries/System.Diagnostics.PerformanceCounter/src/System/Diagnostics/InstanceData.cs`
- E-08: `src/libraries/System.Diagnostics.PerformanceCounter/src/System/Diagnostics/InstanceDataCollection.cs`
- E-09: `src/libraries/System.Diagnostics.PerformanceCounter/src/System/Diagnostics/InstanceDataCollectionCollection.cs`
- E-10: `src/libraries/System.Diagnostics.PerformanceCounter/src/System/Diagnostics/PerformanceData/CounterSet.cs`
- E-11: `src/libraries/System.Diagnostics.PerformanceCounter/src/System/Diagnostics/PerformanceData/CounterSetInstance.cs`
- E-12: `src/libraries/System.Diagnostics.PerformanceCounter/src/System/Diagnostics/PerformanceData/CounterSetInstanceCounterDataSet.cs`
- E-13: `src/libraries/System.Diagnostics.PerformanceCounter/src/System/Diagnostics/SharedPerformanceCounter.cs`

### 既存テストコード
- E-14: `src/libraries/System.Diagnostics.PerformanceCounter/tests/PerformanceCounterTests.cs`
- E-15: `src/libraries/System.Diagnostics.PerformanceCounter/tests/PerformanceCounterCategoryTests.cs`
- E-16: `src/libraries/System.Diagnostics.PerformanceCounter/tests/CounterSampleTests.cs`
- E-17: `src/libraries/System.Diagnostics.PerformanceCounter/tests/CounterSampleCalculatorTests.cs`
- E-18: `src/libraries/System.Diagnostics.PerformanceCounter/tests/CounterCreationDataTests.cs`
- E-19: `src/libraries/System.Diagnostics.PerformanceCounter/tests/CounterCreationDataCollectionTests.cs`
- E-20: `src/libraries/System.Diagnostics.PerformanceCounter/tests/InstanceDataTests.cs`
- E-21: `src/libraries/System.Diagnostics.PerformanceCounter/tests/PerformanceDataTests.cs`
- E-22: `src/libraries/System.Diagnostics.PerformanceCounter/tests/ValidationTests.cs`

## 3) Claims と根拠の対応（レビューの主戦場）

### PerformanceCounter クラス（UT-SDPC-001 - UT-SDPC-028）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | UT-SDPC-001: デフォルトコンストラクタ | E-01 (L58-66), E-14 (L17-27) | ○ |
| C-02 | UT-SDPC-002: 4引数コンストラクタ | E-01 (L71-89) | ○ |
| C-03 | UT-SDPC-003: ReadOnlyフラグ | E-01 (L102-115), E-14 (L75-91) | ○ |
| C-04 | UT-SDPC-004: CategoryName null検証 | E-01 (L144-145), E-14 (L93-101) | ○ |
| C-05 | UT-SDPC-005: CounterName null検証 | E-01 (L184-185), E-14 (L93-101) | ○ |
| C-06 | UT-SDPC-006: MachineName検証 | E-01 (L294-296), E-14 (L93-101) | ○ |
| C-07 | UT-SDPC-007: RawValue ReadOnly制限 | E-01 (L330-331), E-14 (L104-111) | ○ |
| C-08 | UT-SDPC-008: CategoryName空検証 | E-01 (L469-470), E-14 (L113-124) | ○ |
| C-09 | UT-SDPC-009: CounterName空検証 | E-01 (L471-472), E-14 (L126-137) | ○ |
| C-10 | UT-SDPC-010: 存在しないカウンター | E-01 (L476-477), E-14 (L139-153) | ○ |
| C-11 | UT-SDPC-011: Increment | E-01 (L422-429), E-14 (L219-232) | ○ |
| C-12 | UT-SDPC-012: Increment ReadOnly | E-01 (L424-425), E-14 (L261-271) | ○ |
| C-13 | UT-SDPC-013: Decrement | E-01 (L386-394), E-14 (L204-217) | ○ |
| C-14 | UT-SDPC-014: Decrement ReadOnly | E-01 (L388-389), E-14 (L273-284) | ○ |
| C-15 | UT-SDPC-015: IncrementBy | E-01 (L409-417), E-14 (L234-247) | ○ |
| C-16 | UT-SDPC-016: IncrementBy ReadOnly | E-01 (L411-412), E-14 (L249-259) | ○ |
| C-17 | UT-SDPC-017: NextSample | E-01 (L537-564), E-14 (L302-320) | ○ |
| C-18 | UT-SDPC-018: NextValue | E-01 (L571-580), E-14 (L155-178) | ○ |
| C-19 | UT-SDPC-019: BeginInit | E-01 (L341-344), E-14 (L180-189) | ○ |
| C-20 | UT-SDPC-020: EndInit | E-01 (L398-401), E-14 (L191-202) | ○ |
| C-21 | UT-SDPC-021: Close | E-01 (L349-356) | ○ |
| C-22 | UT-SDPC-022: CloseSharedResources | E-01 (L363-366) | ○ |
| C-23 | UT-SDPC-023: RemoveInstance | E-01 (L585-592), E-14 (L286-300) | ○ |
| C-24 | UT-SDPC-024: RemoveInstance ReadOnly | E-01 (L587-588) | ○ |
| C-25 | UT-SDPC-025: InstanceLifetime初期化後 | E-01 (L229-230) | ○ |
| C-26 | UT-SDPC-026: InstanceLifetime範囲外 | E-01 (L226-227) | ○ |
| C-27 | UT-SDPC-027: CounterType | E-01 (L198-218) | ○ |
| C-28 | UT-SDPC-028: CounterHelp | E-01 (L158-171) | ○ |

### PerformanceCounterCategory クラス（UT-SDPC-029 - UT-SDPC-071）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-29 | UT-SDPC-029: デフォルトコンストラクタ | E-02 (L26-29), E-15 (L14-18) | ○ |
| C-30 | UT-SDPC-030: カテゴリ名コンストラクタ | E-02 (L35-38) | ○ |
| C-31 | UT-SDPC-031: 2引数コンストラクタ | E-02 (L44-56) | ○ |
| C-32-34 | UT-SDPC-032-034: コンストラクタ検証 | E-02 (L46-52), E-15 (L20-26) | ○ |
| C-35-37 | UT-SDPC-035-037: プロパティ検証 | E-02 (L70-74, L131-132), E-15 (L28-51) | ○ |
| C-38 | UT-SDPC-038: CategoryHelp未設定 | E-02 (L87-88), E-15 (L73-78) | ○ |
| C-39-40 | UT-SDPC-039-040: CategoryType | E-02 (L96-117), E-15 (L80-104) | ○ |
| C-41-45 | UT-SDPC-041-045: CounterExists | E-02 (L141-174), E-15 (L175-204) | ○ |
| C-46-50 | UT-SDPC-046-050: Create | E-02 (L204-252), E-15 (L106-158) | ○ |
| C-51-52 | UT-SDPC-051-052: Delete | E-02 (L366-393), E-15 (L207-221) | ○ |
| C-53-55 | UT-SDPC-053-055: Exists | E-02 (L398-420), E-15 (L223-229) | ○ |
| C-56-57 | UT-SDPC-056-057: GetCategories | E-02 (L477-496), E-15 (L161-172) | ○ |
| C-58-60 | UT-SDPC-058-060: GetCounters | E-02 (L445-471), E-15 (L231-255) | ○ |
| C-61-62 | UT-SDPC-061-062: GetInstanceNames | E-02 (L501-507), E-15 (L257-263) | ○ |
| C-63-64 | UT-SDPC-063-064: InstanceExists | E-02 (L512-549), E-15 (L265-295) | ○ |
| C-65-66 | UT-SDPC-065-066: ReadCategory | E-02 (L555-564), E-15 (L297-313) | ○ |
| C-67-71 | UT-SDPC-067-071: CheckValidId | E-02 (L263-283) | ○ |

### CounterSample 構造体（UT-SDPC-072 - UT-SDPC-083）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-72 | UT-SDPC-072: デフォルトコンストラクタ | E-03, E-16 (L14-25) | ○ |
| C-73-74 | UT-SDPC-073-074: コンストラクタ | E-03 (L22-44), E-16 (L27-40) | ○ |
| C-75-76 | UT-SDPC-075-076: Calculate | E-03 (L145-156), E-16 (L42-58) | ○ |
| C-77-83 | UT-SDPC-077-083: 等価性・演算子 | E-03 (L158-188), E-16 (L60-94) | ○ |

### CounterSampleCalculator クラス（UT-SDPC-084 - UT-SDPC-088）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-84-85 | UT-SDPC-084-085: ComputeCounterValue | E-04 (L51-106), E-17 | ○ |
| C-86 | UT-SDPC-086: タイプ不一致 | E-04 (L77-79) | ○ |
| C-87 | UT-SDPC-087: SystemFrequency=0 | E-04 (L62-76) | ○ |
| C-88 | UT-SDPC-088: ElapsedTime | E-04 (L82-83), E-17 (L13-30) | ○ |

### CounterCreationData クラス（UT-SDPC-089 - UT-SDPC-093）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-89-93 | UT-SDPC-089-093 | E-05, E-18 | ○ |

### CounterCreationDataCollection クラス（UT-SDPC-094 - UT-SDPC-109）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-94-109 | UT-SDPC-094-109 | E-06, E-19 | ○ |

### InstanceData/Collection クラス（UT-SDPC-110 - UT-SDPC-126）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-110-126 | UT-SDPC-110-126 | E-07, E-08, E-09, E-20 | ○ |

### PerformanceData 名前空間（UT-SDPC-127 - UT-SDPC-158）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-127-141 | CounterSet | E-10, E-21 | ○ |
| C-142 | CounterSet.Dispose | E-10 (L62-84) | ○ |
| C-143-144 | CounterSetInstance | E-11, E-21 | ○ |
| C-145-151 | CounterSetInstanceCounterDataSet | E-12, E-21 | ○ |
| C-152-158 | CounterData | E-12 (L15-95), E-21 | ○ |

### 根拠なし/要確認
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-67 | CheckValidId正常系 | E-02のinternalメソッド | △ |
| C-142 | CounterSet.Dispose内部動作 | 実装依存の内部状態確認 | △ |

## 4) 不足情報（Unknown / Missing）
- **CheckValidIdメソッド**：internalメソッドのため、直接的な単体テストは困難。統合テストまたはリフレクション経由でのテストが必要
  - 候補：InternalsVisibleTo属性の追加 / 公開メソッド経由でのテスト

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 大部分のテストケースはソースコードと既存テストで裏付けられている
- 1: 中リスク - Windows専用API（パフォーマンスカウンター）のため、クロスプラットフォームテストに制限がある
- 1: 中リスク - 管理者権限が必要なテストケースが多数存在（ConditionalFactで制御済み）

## 6) レビュアーチェックリスト（最小）
- [ ] 全158件のテストケースIDが連番で重複がないこと
- [ ] テストIDの命名規則（UT-SDPC-XXX）が一貫していること
- [ ] 各テストケースの「期待結果」が実装コードと一致すること
- [ ] 優先度「高」のテストケースが重要なビジネスロジック（値の操作、バリデーション）をカバーしていること
- [ ] 境界値テスト（空文字、null、最大長）が網羅されていること
- [ ] 異常系テスト（例外スロー）の例外型が正確であること
- [ ] PerformanceData名前空間のテストケースがWindows固有の挙動を考慮していること
