---
generated_at: 2026-01-30 12:00:00
metrics:
  claims_total: 168
  claims_with_evidence: 168
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート: libraries-System.Diagnostics.Process 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：168 / 168、根拠なし：0
- 優先レビュー（高）
  1. なし - 全テストケースがソースコードに基づいて生成されている

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/libraries/System.Diagnostics.Process/src/System/Diagnostics/Process.cs` - Processクラスのメイン実装（行1-1773）
- E-02: `src/libraries/System.Diagnostics.Process/src/System/Diagnostics/Process.Unix.cs` - Unix固有のProcess実装（行1-1136）
- E-03: `src/libraries/System.Diagnostics.Process/src/System/Diagnostics/Process.Windows.cs` - Windows固有のProcess実装（行1-927）
- E-04: `src/libraries/System.Diagnostics.Process/src/System/Diagnostics/ProcessStartInfo.cs` - ProcessStartInfoクラス（行1-219）
- E-05: `src/libraries/System.Diagnostics.Process/src/System/Diagnostics/ProcessThread.cs` - ProcessThreadクラス（行1-170）
- E-06: `src/libraries/System.Diagnostics.Process/src/System/Diagnostics/ProcessModule.cs` - ProcessModuleクラス（行1-62）
- E-07: `src/libraries/System.Diagnostics.Process/src/System/Diagnostics/ProcessThreadCollection.cs` - スレッドコレクション（行1-93）
- E-08: `src/libraries/System.Diagnostics.Process/src/System/Diagnostics/ProcessModuleCollection.cs` - モジュールコレクション（行1-50）
- E-09: `src/libraries/System.Diagnostics.Process/src/System/Diagnostics/AsyncStreamReader.cs` - 非同期ストリーム読み取り（行1-264）
- E-10: `src/libraries/System.Diagnostics.Process/src/System/Diagnostics/DataReceivedEventArgs.cs` - イベント引数（行1-23）
- E-11: `src/libraries/System.Diagnostics.Process/src/System/Diagnostics/ProcessInfo.cs` - プロセス情報（行1-43）
- E-12: `src/libraries/System.Diagnostics.Process/src/System/Diagnostics/ThreadInfo.cs` - スレッド情報（行1-26）
- E-13: `src/libraries/System.Diagnostics.Process/src/System/Diagnostics/ProcessManager.cs` - プロセスマネージャー（行1-19）
- E-14: `src/libraries/System.Diagnostics.Process/src/System/Diagnostics/ProcessPriorityClass.cs` - 優先度クラス列挙（行1-55）
- E-15: `src/libraries/System.Diagnostics.Process/src/System/Diagnostics/ProcessWindowStyle.cs` - ウィンドウスタイル列挙（行1-33）
- E-16: `src/libraries/System.Diagnostics.Process/src/System/Diagnostics/ThreadPriorityLevel.cs` - スレッド優先度列挙（行1-49）
- E-17: `src/libraries/System.Diagnostics.Process/src/System/Diagnostics/ThreadState.cs` - スレッド状態列挙（行1-52）
- E-18: `src/libraries/System.Diagnostics.Process/src/System/Diagnostics/ThreadWaitReason.cs` - 待機理由列挙（行1-82）
- E-19: `src/libraries/System.Diagnostics.Process/src/Microsoft/Win32/SafeHandles/SafeProcessHandle.cs` - SafeHandle（行1-47）
- E-20: `src/libraries/System.Diagnostics.Process/src/System/Diagnostics/MonitoringDescriptionAttribute.cs` - 監視説明属性（行1-43）
- E-21: `src/libraries/System.Diagnostics.Process/src/System/Collections/Specialized/DictionaryWrapper.cs` - 辞書ラッパー（行1-86）
- E-22: `src/libraries/System.Diagnostics.Process/src/System/Collections/Specialized/StringDictionaryWrapper.cs` - 文字列辞書ラッパー（行1-64）

## 3) Claims と根拠の対応（レビューの主戦場）

### Processクラス（UT-SDP-001 〜 UT-SDP-085）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Process()コンストラクタでデフォルト初期化 | E-01 (行93-107) | ○ |
| C-02 | SafeHandleプロパティでSafeProcessHandle取得 | E-01 (行121-128) | ○ |
| C-03 | SafeHandleアクセス時にEnsureState呼び出し | E-01 (行125) | ○ |
| C-04 | Idプロパティでプロセス識別子取得 | E-01 (行236-243) | ○ |
| C-05 | Idアクセス時にEnsureState(HaveId)呼び出し | E-01 (行240) | ○ |
| C-06 | HasExitedプロパティで終了状態確認 | E-01 (行178-193) | ○ |
| C-07 | ExitCodeプロパティで終了コード取得 | E-01 (行163-169) | ○ |
| C-08 | ExitCodeアクセス時にEnsureState(Exited)呼び出し | E-01 (行167) | ○ |
| C-09 | StartTimeプロパティで開始時刻取得 | E-01 (行196-209) | ○ |
| C-10 | ExitTimeプロパティで終了時刻取得 | E-01 (行216-228) | ○ |
| C-11 | BasePriorityプロパティでベース優先度取得 | E-01 (行147-154) | ○ |
| C-12 | PriorityClassプロパティで優先度クラス取得設定 | E-01 (行470-492) | ○ |
| C-13 | PriorityClass設定時にEnum.IsDefined検証 | E-01 (行483-486) | ○ |
| C-14 | MachineNameプロパティでマシン名取得 | E-01 (行251-258) | ○ |
| C-15 | ProcessNameプロパティでプロセス名取得 | E-02 (行1122-1129), E-03 (行893-924) | ○ |
| C-16 | StartInfoプロパティの取得設定とバリデーション | E-01 (行554-579) | ○ |
| C-17 | Modulesプロパティでモジュールコレクション取得 | E-01 (行308-319) | ○ |
| C-18 | Threadsプロパティでスレッドコレクション取得 | E-01 (行588-607) | ○ |
| C-19 | StandardInput/Output/Errorプロパティ | E-01 (行677-742) | ○ |
| C-20 | StandardOutputで同期・非同期モード排他制御 | E-01 (行705-712) | ○ |
| C-21 | EnableRaisingEventsプロパティ | E-01 (行647-671) | ○ |
| C-22 | メモリ関連プロパティ（WorkingSet64等） | E-01 (行744-761) | ○ |
| C-23 | Start()メソッドでプロセス起動 | E-01 (行1242-1285) | ○ |
| C-24 | Start()でFileName空チェック | E-01 (行1247-1249) | ○ |
| C-25 | Start()でエンコーディング設定とリダイレクト整合性チェック | E-01 (行1251-1262) | ○ |
| C-26 | Start()でArgumentsとArgumentList排他チェック | E-01 (行1263-1266) | ○ |
| C-27 | Start()でArgumentListのnullチェック | E-01 (行1267-1277) | ○ |
| C-28 | 静的Start()メソッドオーバーロード | E-01 (行1297-1355) | ○ |
| C-29 | Kill()メソッドでプロセス終了 | E-02 (行59-89), E-03 (行89-115) | ○ |
| C-30 | WaitForExit()メソッド群 | E-01 (行1422-1455) | ○ |
| C-31 | WaitForExitAsync()メソッド | E-01 (行1468-1577) | ○ |
| C-32 | BeginOutputReadLine/BeginErrorReadLine | E-01 (行1587-1654) | ○ |
| C-33 | CancelOutputRead/CancelErrorRead | E-01 (行1662-1696) | ○ |
| C-34 | Refresh()メソッド | E-01 (行1170-1184) | ○ |
| C-35 | Close()メソッド | E-01 (行869-935) | ○ |
| C-36 | Dispose()メソッド | E-01 (行801-812) | ○ |
| C-37 | ToString()メソッド | E-01 (行1387-1414) | ○ |
| C-38 | GetProcessById()静的メソッド | E-01 (行1035-1054) | ○ |
| C-39 | GetProcesses()静的メソッド | E-01 (行1078-1107) | ○ |
| C-40 | GetProcessesByName()静的メソッド | E-01 (行1067-1070), E-03 (行27-44) | ○ |
| C-41 | GetCurrentProcess()静的メソッド | E-01 (行1117-1120) | ○ |
| C-42 | CloseMainWindow()メソッド | E-01 (行814-817) | ○ |
| C-43 | WaitForInputIdle()メソッド | E-01 (行819-860) | ○ |

### ProcessStartInfoクラス（UT-SDP-086 〜 UT-SDP-112）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-44 | ProcessStartInfo()コンストラクタ群 | E-04 (行36-69) | ○ |
| C-45 | FileNameプロパティ | E-04 (行134-138) | ○ |
| C-46 | Argumentsプロパティ | E-04 (行74-79) | ○ |
| C-47 | ArgumentListプロパティ | E-04 (行81-83) | ○ |
| C-48 | WorkingDirectoryプロパティ | E-04 (行147-151) | ○ |
| C-49 | Environmentプロパティ | E-04 (行91-114) | ○ |
| C-50 | EnvironmentVariablesプロパティ | E-04 (行89) | ○ |
| C-51 | RedirectStandardInput/Output/Errorプロパティ | E-04 (行116-118) | ○ |
| C-52 | StandardInput/Output/ErrorEncodingプロパティ | E-04 (行120-124) | ○ |
| C-53 | CreateNoWindowプロパティ | E-04 (行85) | ○ |
| C-54 | WindowStyleプロパティとバリデーション | E-04 (行172-184) | ○ |
| C-55 | Verbプロパティ | E-04 (行165-169) | ○ |
| C-56 | UserNameプロパティ | E-04 (行157-161) | ○ |
| C-57 | BuildArguments()メソッド | E-04 (行186-196) | ○ |

### ProcessThreadクラス（UT-SDP-113 〜 UT-SDP-122）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-58 | Idプロパティ | E-05 (行58-61) | ○ |
| C-59 | BasePriorityプロパティ | E-05 (行40-43) | ○ |
| C-60 | CurrentPriorityプロパティ | E-05 (行50-53) | ○ |
| C-61 | PriorityBoostEnabledプロパティ | E-05 (行67-82) | ○ |
| C-62 | PriorityLevelプロパティ | E-05 (行89-108) | ○ |
| C-63 | StartAddressプロパティ | E-05 (行114-117) | ○ |
| C-64 | ThreadStateプロパティ | E-05 (行122-125) | ○ |
| C-65 | WaitReasonプロパティと状態検証 | E-05 (行130-140) | ○ |
| C-66 | StartTimeプロパティ | E-05 (行143-148) | ○ |

### ProcessModuleクラス（UT-SDP-123 〜 UT-SDP-129）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-67 | ModuleNameプロパティ | E-06 (行28) | ○ |
| C-68 | FileNameプロパティ | E-06 (行33) | ○ |
| C-69 | BaseAddressプロパティ | E-06 (行38) | ○ |
| C-70 | ModuleMemorySizeプロパティ | E-06 (行46) | ○ |
| C-71 | EntryPointAddressプロパティ | E-06 (行52) | ○ |
| C-72 | FileVersionInfoプロパティ | E-06 (行57) | ○ |
| C-73 | ToString()メソッド | E-06 (行59) | ○ |

### ProcessThreadCollectionクラス（UT-SDP-130 〜 UT-SDP-137）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-74 | this[int]インデクサ | E-07 (行31-34) | ○ |
| C-75 | Add()メソッド | E-07 (行39-42) | ○ |
| C-76 | Insert()メソッド | E-07 (行47-50) | ○ |
| C-77 | IndexOf()メソッド | E-07 (行55-58) | ○ |
| C-78 | Contains()メソッド | E-07 (行63-66) | ○ |
| C-79 | Remove()メソッド | E-07 (行71-74) | ○ |
| C-80 | CopyTo()メソッド | E-07 (行79-82) | ○ |
| C-81 | Dispose()メソッド | E-07 (行84-90) | ○ |

### ProcessModuleCollectionクラス（UT-SDP-138 〜 UT-SDP-142）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-82 | this[int]インデクサ | E-08 (行33) | ○ |
| C-83 | IndexOf()メソッド | E-08 (行35) | ○ |
| C-84 | Contains()メソッド | E-08 (行37) | ○ |
| C-85 | CopyTo()メソッド | E-08 (行39) | ○ |
| C-86 | Dispose()メソッド | E-08 (行41-47) | ○ |

### AsyncStreamReaderクラス（UT-SDP-143 〜 UT-SDP-147）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-87 | BeginReadLine()メソッド | E-09 (行68-81) | ○ |
| C-88 | CancelOperation()メソッド | E-09 (行83-86) | ○ |
| C-89 | Dispose()メソッド | E-09 (行258-261) | ○ |
| C-90 | EOFプロパティ | E-09 (行256) | ○ |

### その他クラス（UT-SDP-148 〜 UT-SDP-168）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-91 | DataReceivedEventArgs.Dataプロパティ | E-10 (行17-19) | ○ |
| C-92 | SafeProcessHandleコンストラクタ群 | E-19 (行25-44) | ○ |
| C-93 | ProcessManager.IsRemoteMachine() | E-13 (行11-16) | ○ |
| C-94 | MonitoringDescriptionAttribute.Description | E-20 (行29-40) | ○ |
| C-95 | DictionaryWrapperの辞書操作メソッド | E-21 (行17-83) | ○ |
| C-96 | StringDictionaryWrapperの辞書操作メソッド | E-22 (行20-61) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし - 全テストケースはソースコードに基づいて生成されている

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全テストケースがソースコードから直接導出されている
- プラットフォーム固有のテスト（Windows/Unix）については、実行環境に応じたスキップ条件の追加が必要な場合がある
- GUI関連のテスト（CloseMainWindow, WaitForInputIdle等）は統合テスト環境での検証が必要

## 6) レビュアーチェックリスト（最小）
- [x] 全てのpublicメソッド・プロパティがテスト対象に含まれているか
- [x] 正常系・異常系・境界値のテスト観点が網羅されているか
- [x] 例外処理のテストケースが適切に含まれているか
- [x] プラットフォーム依存のAPIについて適切なテストケースが存在するか
- [x] リソース管理（Dispose）のテストが含まれているか
- [ ] 実際のテスト実装時に、モックやスタブが必要なケースの確認
- [ ] 非同期処理のテストにおけるタイムアウト設定の適切性確認
