---
generated_at: 2026-01-30 10:30:00
metrics:
  claims_total: 120
  claims_with_evidence: 118
  claims_without_evidence: 2
confidence_derived: 0.98
---

# 根拠レポート：libraries-System.Diagnostics.StackTrace 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存テストコード・API定義などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.98**
  - 根拠あり：118 / 120、根拠なし：2
- 優先レビュー（高）
  1. **UT-STK-115〜116**：StackTraceSymbolsは内部クラスのため直接テスト不可能な可能性
  2. **UT-STK-117〜120**：StackTraceSymbols.GetSourceLineInfo/TryGetReaderは内部メソッドのため外部テスト困難

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Diagnostics.StackTrace/src/System/Diagnostics/StackTraceSymbols.cs`
- E-02: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Diagnostics.StackTrace/src/System/Diagnostics/SymbolStore/SymbolToken.cs`
- E-03: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Diagnostics.StackTrace/src/System/Diagnostics/SymbolStore/SymLanguageType.cs`
- E-04: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Diagnostics.StackTrace/src/System/Diagnostics/SymbolStore/SymLanguageVendor.cs`
- E-05: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Diagnostics.StackTrace/src/System/Diagnostics/SymbolStore/SymDocumentType.cs`
- E-06: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Diagnostics.StackTrace/src/System/Diagnostics/SymbolStore/SymAddressKind.cs`
- E-07: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Diagnostics.StackTrace/ref/System.Diagnostics.StackTrace.cs`（API参照定義）
- E-08: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Diagnostics.StackTrace/tests/StackTraceTests.cs`
- E-09: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Diagnostics.StackTrace/tests/StackFrameTests.cs`
- E-10: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Diagnostics.StackTrace/tests/SymbolTokenTests.cs`
- E-11: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Diagnostics.StackTrace/tests/StackFrameExtensionsTests.cs`
- E-12: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Diagnostics.StackTrace/tests/DiagnosticMethodInfoTests.cs`
- E-13: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Diagnostics.StackTrace/tests/SymLanguageTypeTests.cs`
- E-14: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Diagnostics.StackTrace/tests/SymLanguageVendorTests.cs`
- E-15: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Diagnostics.StackTrace/tests/SymDocumentTypeTests.cs`
- E-16: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Diagnostics.StackTrace/tests/StackTraceSymbolsTests.cs`
- E-17: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Diagnostics.StackTrace/src/System/Diagnostics/SymbolStore/ISymbolWriter.cs`
- E-18: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Diagnostics.StackTrace/src/System/Diagnostics/SymbolStore/ISymbolReader.cs`
- E-19: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Diagnostics.StackTrace/src/System/Diagnostics/SymbolStore/ISymbolMethod.cs`
- E-20: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Diagnostics.StackTrace/src/System/Diagnostics/SymbolStore/ISymbolDocument.cs`
- E-21: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Diagnostics.StackTrace/src/System/Diagnostics/SymbolStore/ISymbolBinder.cs`
- E-22: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Diagnostics.StackTrace/src/System/Diagnostics/SymbolStore/ISymbolScope.cs`
- E-23: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Diagnostics.StackTrace/src/System/Diagnostics/SymbolStore/ISymbolVariable.cs`
- E-24: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Diagnostics.StackTrace/src/System/Diagnostics/SymbolStore/ISymbolNamespace.cs`

## 3) Claims と根拠の対応（レビューの主戦場）

### StackTrace クラス（UT-STK-001〜027）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | UT-STK-001: デフォルトコンストラクタでStackTraceが生成されること | E-07, E-08 (Ctor_Default) | ○ |
| C-02 | UT-STK-002: fNeedFileInfo=trueでファイル情報が取得されること | E-07, E-08 (Ctor_FNeedFileInfo) | ○ |
| C-03 | UT-STK-003: fNeedFileInfo=falseでファイル情報が取得されないこと | E-07, E-08 (Ctor_FNeedFileInfo) | ○ |
| C-04 | UT-STK-004: skipFrames指定でフレームがスキップされること | E-07, E-08 (Ctor_SkipFrames) | ○ |
| C-05 | UT-STK-005: skipFrames=0でスキップなしのStackTraceが生成されること | E-07, E-08 (Ctor_SkipFrames) | ○ |
| C-06 | UT-STK-006: skipFrames=int.MaxValueで空のStackTraceが生成されること | E-08 (Ctor_LargeSkipFrames_GetFramesReturnsEmpty) | ○ |
| C-07 | UT-STK-007: skipFramesとfNeedFileInfoの組み合わせ | E-08 (Ctor_SkipFrames_FNeedFileInfo) | ○ |
| C-08 | UT-STK-008: 例外からStackTraceが生成されること | E-07, E-08 (Ctor_ThrownException_GetFramesReturnsExpected) | ○ |
| C-09 | UT-STK-009: 空の例外から空のStackTraceが生成されること | E-08 (Ctor_EmptyException_GetFramesReturnsEmpty) | ○ |
| C-10 | UT-STK-010: null例外でArgumentNullExceptionがスローされること | E-08 (Ctor_NullException_ThrowsArgumentNullException) | ○ |
| C-11 | UT-STK-011〜013: Exception+フラグ組み合わせコンストラクタ | E-07, E-08 | ○ |
| C-12 | UT-STK-014: 単一StackFrameからStackTraceが生成されること | E-08 (Ctor_Frame) | ○ |
| C-13 | UT-STK-015: nullフレームでStackTraceが生成されること | E-08 (Ctor_Frame_TestData) | ○ |
| C-14 | UT-STK-016: 複数StackFrameからStackTraceが生成されること | E-08 (Ctor_MultiFrame) | ○ |
| C-15 | UT-STK-017: nullコレクションでArgumentNullExceptionがスローされること | E-08 (Ctor_NullMultiFrame_ThrowsArgumentNullException) | ○ |
| C-16 | UT-STK-018: FrameCountプロパティ | E-07, E-08 | ○ |
| C-17 | UT-STK-019〜021: GetFrame境界値テスト | E-08 (GetFrame_InvalidIndex_ReturnsNull) | ○ |
| C-18 | UT-STK-022〜023: GetFrames()テスト | E-07, E-08 | ○ |
| C-19 | UT-STK-024〜026: ToString()テスト | E-08 (ToString_TestData, ToString_NullFrame_ThrowsNullReferenceException) | ○ |
| C-20 | UT-STK-027: METHODS_TO_SKIP定数 | E-07, E-08 (MethodsToSkip_Get_ReturnsZero) | ○ |

### StackFrame クラス（UT-STK-028〜051）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-21 | UT-STK-028〜034: コンストラクタ各種 | E-07, E-09 | ○ |
| C-22 | UT-STK-035〜037: ファイル名・行番号指定コンストラクタ | E-09 (Ctor_Filename_LineNumber, Ctor_Filename_LineNumber_ColNumber) | ○ |
| C-23 | UT-STK-038〜043: GetFileName/LineNumber/ColumnNumber | E-07, E-09 | ○ |
| C-24 | UT-STK-044〜047: GetILOffset/GetNativeOffset | E-07, E-09 (VerifyStackFrameSkipFrames) | ○ |
| C-25 | UT-STK-048〜049: GetMethod() | E-07, E-09 | ○ |
| C-26 | UT-STK-050: ToString() | E-09 (ToString_TestData) | ○ |
| C-27 | UT-STK-051: OFFSET_UNKNOWN定数 | E-07, E-09 (OffsetUnknown_Get_ReturnsNegativeOne) | ○ |

### StackFrameExtensions クラス（UT-STK-052〜066）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-28 | UT-STK-052〜057: HasNativeImage/GetNativeIP/GetNativeImageBase | E-07, E-11 | ○ |
| C-29 | UT-STK-058〜060: HasILOffset | E-11 (HasILOffset_Invoke_ReturnsExpected, HasILOffset_NullStackFrame_ThrowsNullReferenceException) | ○ |
| C-30 | UT-STK-061〜063: HasMethod | E-11 (HasMethod_Invoke_ReturnsExpected, HasMethod_NullStackFrame_ThrowsNullReferenceException) | ○ |
| C-31 | UT-STK-064〜066: HasSource | E-11 (HasSource_Invoke_ReturnsExpected, HasSource_NullStackFrame_ThrowsNullReferenceException) | ○ |

### DiagnosticMethodInfo クラス（UT-STK-067〜075）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-32 | UT-STK-067〜068: Create(Delegate) | E-07, E-12 (Create_Null, Create_OpenDelegate, Create_ClosedDelegate) | ○ |
| C-33 | UT-STK-069〜070: Create(StackFrame) | E-07, E-12 (Create_Null, Create_StackFrame) | ○ |
| C-34 | UT-STK-071〜073: Name/DeclaringTypeName/DeclaringAssemblyName | E-07, E-12 | ○ |
| C-35 | UT-STK-074: マルチキャストデリゲート | E-12 (Create_MulticastDelegate) | ○ |
| C-36 | UT-STK-075: ジェネリックメソッドデリゲート | E-12 (Create_OpenDelegate_TestData) | ○ |

### SymbolToken 構造体（UT-STK-076〜088）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-37 | UT-STK-076〜080: コンストラクタとGetToken | E-02, E-10 (Ctor_Default, Ctor_Value) | ○ |
| C-38 | UT-STK-081: GetHashCode | E-02, E-10 (Ctor_Value) | ○ |
| C-39 | UT-STK-082〜088: Equals/operator==/operator!= | E-02, E-10 (Equals_TestData, Equals_Other_ReturnsExpected) | ○ |

### SymLanguageType/SymLanguageVendor/SymDocumentType クラス（UT-STK-089〜104）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-40 | UT-STK-089〜100: SymLanguageType各GUID | E-03, E-13 (LanguageTypes_TestData) | ○ |
| C-41 | UT-STK-101〜102: SymLanguageVendor | E-04, E-14 (Microsoft_Get_ReturnsExpected, Ctor_Default) | ○ |
| C-42 | UT-STK-103〜104: SymDocumentType | E-05, E-15 (Text_Get_ReturnsExpected, Ctor_Default) | ○ |

### SymAddressKind 列挙型（UT-STK-105〜114）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-43 | UT-STK-105〜114: 列挙値検証 | E-06 | ○ |

### StackTraceSymbols 内部クラス（UT-STK-115〜120）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-44 | UT-STK-115: Constructor初期化 | E-01 | ○ |
| C-45 | UT-STK-116: Dispose | E-01 | ○ |
| C-46 | UT-STK-117: GetSourceLineInfo正常系 | E-01, E-16 | ○ |
| C-47 | UT-STK-118〜119: GetSourceLineInfo境界値 | E-01 | ○ |
| C-48 | UT-STK-120: TryGetReaderキャッシュ動作 | **根拠なし** | △ |
| C-49 | インターフェース（ISymbol*）のテストケース | **スコープ外** | △ |

## 4) 不足情報（Unknown / Missing）
- UT-STK-120（TryGetReaderキャッシュ動作）：内部privateメソッドのため、直接テスト不可。統合テストまたはリフレクション経由での検証が必要
  - 候補：E-16（StackTraceSymbolsTests.cs）で間接的に検証される可能性あり / InternalsVisibleToによる公開 / 統合テストによる検証
- ISymbol*インターフェース群：これらはインターフェース定義のみで実装がないため、単体テスト対象外
  - 候補：モック実装によるインターフェース契約テスト / 実装クラス（存在する場合）でのテスト

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**：SymLanguageType/SymLanguageVendor/SymDocumentType/SymAddressKind - 静的定数値の検証のみ
- **1（中リスク）**：StackTraceSymbols内部クラス - 内部実装のため外部テスト困難、ただしE-16で間接検証可能
- **0（低リスク）**：その他の公開API - 既存テストコードで十分にカバー

## 6) レビュアーチェックリスト（最小）
- [ ] StackTraceクラスの各コンストラクタパターンが網羅されているか
- [ ] StackFrameのファイル情報取得（PDB依存）のテスト条件が適切か
- [ ] StackFrameExtensionsのnull入力に対する例外動作が仕様通りか
- [ ] DiagnosticMethodInfoのジェネリック対応テストが十分か
- [ ] SymbolToken構造体の等価性比較が正しくテストされているか
- [ ] StackTraceSymbols内部クラスのテスト可能性を確認（InternalsVisibleTo等）
- [ ] プラットフォーム依存テスト（NativeAOT、Mono等）の考慮が必要か
