---
generated_at: 2026-01-30 17:15:00
metrics:
  claims_total: 129
  claims_with_evidence: 129
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：libraries-System.Diagnostics.TextWriterTraceListener 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：129 / 129、根拠なし：0
- 優先レビュー（高）
  1. **なし**：全テストケースに根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/libraries/System.Diagnostics.TextWriterTraceListener/src/System/Diagnostics/TextWriterTraceListener.cs`
- E-02: `src/libraries/System.Diagnostics.TextWriterTraceListener/src/System/Diagnostics/ConsoleTraceListener.cs`
- E-03: `src/libraries/System.Diagnostics.TextWriterTraceListener/src/System/Diagnostics/DelimitedListTraceListener.cs`
- E-04: `src/libraries/System.Diagnostics.TextWriterTraceListener/src/System/Diagnostics/XmlWriterTraceListener.cs`

## 3) Claims と根拠の対応（レビューの主戦場）

### TextWriterTraceListener クラス（UT-TWT-001 〜 UT-TWT-034）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | デフォルトコンストラクタでインスタンスが生成されること | E-01 (行24-26) | ○ |
| C-02 | Streamを指定してインスタンスが生成されること | E-01 (行32-35, 41-47) | ○ |
| C-03 | nullのStreamを渡すとArgumentNullExceptionがスローされること | E-01 (行44: ArgumentNullException.ThrowIfNull) | ○ |
| C-04 | Streamと名前を指定してインスタンスが生成されること | E-01 (行41-47) | ○ |
| C-05 | TextWriterを指定してインスタンスが生成されること | E-01 (行53-56, 64-70) | ○ |
| C-06 | nullのTextWriterを渡すとArgumentNullExceptionがスローされること | E-01 (行67: ArgumentNullException.ThrowIfNull) | ○ |
| C-07 | TextWriterと名前を指定してインスタンスが生成されること | E-01 (行64-70) | ○ |
| C-08 | ファイル名を指定してインスタンスが生成されること | E-01 (行76-79) | ○ |
| C-09 | nullのファイル名を渡してもインスタンスが生成されること | E-01 (行76-79: null許容) | ○ |
| C-10 | ファイル名と名前を指定してインスタンスが生成されること | E-01 (行85-89) | ○ |
| C-11 | Writerプロパティが_writerを返却すること | E-01 (行95-107) | ○ |
| C-12 | _writerがnullでファイル名が設定されている場合にEnsureWriterが呼ばれること | E-01 (行99: EnsureWriter()) | ○ |
| C-13 | Writerプロパティに値を設定できること | E-01 (行103-106) | ○ |
| C-14 | Closeメソッドで_writerが閉じられnullになること | E-01 (行113-128) | ○ |
| C-15 | Closeメソッドで_fileNameがnullになること | E-01 (行127) | ○ |
| C-16 | 既にDisposeされた_writerでもObjectDisposedExceptionを握りつぶすこと | E-01 (行121: catch (ObjectDisposedException)) | ○ |
| C-17 | Dispose(true)で_writerがDisposeされること | E-01 (行133-146) | ○ |
| C-18 | Dispose(false)では_writerがDisposeされないこと | E-01 (行137: if (disposing && _writer != null)) | ○ |
| C-19 | FlushメソッドでWriterがフラッシュされること | E-01 (行151-159) | ○ |
| C-20 | Flushで既にDisposeされた_writerでもObjectDisposedExceptionを握りつぶすこと | E-01 (行158: catch (ObjectDisposedException)) | ○ |
| C-21 | Writeメソッドでメッセージが出力されること | E-01 (行165-177) | ○ |
| C-22 | Write時にNeedIndentがtrueの場合にインデントが出力されること | E-01 (行170: if (NeedIndent) WriteIndent()) | ○ |
| C-23 | Writeでnullメッセージを渡しても例外が発生しないこと | E-01 (行173: _writer.Write(message)) | ○ |
| C-24 | Writeで既にDisposeされた_writerでもObjectDisposedExceptionを握りつぶすこと | E-01 (行175: catch (ObjectDisposedException)) | ○ |
| C-25 | WriteLineメソッドでメッセージと改行が出力されること | E-01 (行184-197) | ○ |
| C-26 | WriteLine時にNeedIndentがtrueの場合にインデントが出力されること | E-01 (行189: if (NeedIndent) WriteIndent()) | ○ |
| C-27 | WriteLine後にNeedIndentがtrueに設定されること | E-01 (行193: NeedIndent = true) | ○ |
| C-28 | EnsureWriterで_fileNameが設定されている場合にStreamWriterが生成されること | E-01 (行199-265) | ○ |
| C-29 | UTF-8 BOMなしでReplacementFallbackエンコーディングが使用されること | E-01 (行219-221) | ○ |
| C-30 | IOExceptionが発生した場合にGUID付きファイル名でリトライすること | E-01 (行239-244) | ○ |
| C-31 | UnauthorizedAccessExceptionで_fileNameがnullに設定されること | E-01 (行245-249, 256-262) | ○ |
| C-32 | リトライでも失敗した場合に_fileNameがnullに設定されること | E-01 (行256-262) | ○ |
| C-33 | IsEnabledで指定されたTraceOptionsが有効な場合にtrueを返すこと | E-01 (行267) | ○ |
| C-34 | IsEnabledで指定されたTraceOptionsが無効な場合にfalseを返すこと | E-01 (行267) | ○ |

### ConsoleTraceListener クラス（UT-CTL-001 〜 UT-CTL-004）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-35 | デフォルトコンストラクタでConsole.Outに出力されること | E-02 (行8-11) | ○ |
| C-36 | useErrorStream=trueでConsole.Errorに出力されること | E-02 (行13-16) | ○ |
| C-37 | useErrorStream=falseでConsole.Outに出力されること | E-02 (行13-16) | ○ |
| C-38 | Closeメソッドが何もしないこと | E-02 (行19: public override void Close() { }) | ○ |

### DelimitedListTraceListener クラス（UT-DLT-001 〜 UT-DLT-037）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-39 | Streamを指定してインスタンスが生成されること | E-03 (行20-22) | ○ |
| C-40 | Streamと名前を指定してインスタンスが生成されること | E-03 (行24-26) | ○ |
| C-41 | TextWriterを指定してインスタンスが生成されること | E-03 (行28-30) | ○ |
| C-42 | TextWriterと名前を指定してインスタンスが生成されること | E-03 (行32-34) | ○ |
| C-43 | ファイル名を指定してインスタンスが生成されること | E-03 (行36-38) | ○ |
| C-44 | ファイル名と名前を指定してインスタンスが生成されること | E-03 (行40-42) | ○ |
| C-45 | デフォルトのデリミタがセミコロンであること | E-03 (行16: _delimiter = ";") | ○ |
| C-46 | Attributes[delimiter]が設定されている場合にその値が使用されること | E-03 (行52-58) | ○ |
| C-47 | Delimiterプロパティに値を設定できること | E-03 (行65-79) | ○ |
| C-48 | Delimiterがカンマの場合に_secondaryDelimがセミコロンになること | E-03 (行75-76) | ○ |
| C-49 | Delimiterがカンマ以外の場合に_secondaryDelimがカンマになること | E-03 (行77-78) | ○ |
| C-50 | Delimiterにnullを設定するとArgumentExceptionがスローされること | E-03 (行67: ArgumentException.ThrowIfNullOrEmpty) | ○ |
| C-51 | Delimiterに空文字を設定するとArgumentExceptionがスローされること | E-03 (行67: ArgumentException.ThrowIfNullOrEmpty) | ○ |
| C-52 | GetSupportedAttributesでdelimiterが返却されること | E-03 (行84) | ○ |
| C-53 | TraceEvent(format, args)でフォーマット付きメッセージが出力されること | E-03 (行86-103) | ○ |
| C-54 | TraceEvent(format, args)でFilterによるフィルタリングが機能すること | E-03 (行88-89) | ○ |
| C-55 | TraceEvent(format, args)でargsがnullの場合にformatがそのまま出力されること | E-03 (行93-96) | ○ |
| C-56 | TraceEvent(message)でメッセージが出力されること | E-03 (行105-119) | ○ |
| C-57 | TraceEvent(message)でFilterによるフィルタリングが機能すること | E-03 (行107-108) | ○ |
| C-58 | TraceData(object)で単一データが出力されること | E-03 (行121-135) | ○ |
| C-59 | TraceData(object)でdataがnullの場合の挙動 | E-03 (行131) | ○ |
| C-60 | TraceData(object)でFilterによるフィルタリングが機能すること | E-03 (行123-124) | ○ |
| C-61 | TraceData(object[])で複数データが出力されること | E-03 (行137-159) | ○ |
| C-62 | TraceData(object[])でdataがnullの場合の挙動 | E-03 (行147) | ○ |
| C-63 | TraceData(object[])でdata配列内の要素がnullの場合の挙動 | E-03 (行153) | ○ |
| C-64 | WriteHeaderでsource、eventType、idが出力されること | E-03 (行161-171) | ○ |
| C-65 | WriteFooterでeventCacheがnullの場合に5つの区切り文字と改行が出力されること | E-03 (行200-204) | ○ |
| C-66 | WriteFooterでProcessIdオプションが有効な場合にProcessIdが出力されること | E-03 (行177-179) | ○ |
| C-67 | WriteFooterでLogicalOperationStackオプションが有効な場合に出力されること | E-03 (行181-183) | ○ |
| C-68 | WriteFooterでThreadIdオプションが有効な場合に出力されること | E-03 (行185-187) | ○ |
| C-69 | WriteFooterでDateTimeオプションが有効な場合に出力されること | E-03 (行189-191) | ○ |
| C-70 | WriteFooterでTimestampオプションが有効な場合に出力されること | E-03 (行193-195) | ○ |
| C-71 | WriteFooterでCallstackオプションが有効な場合に出力されること | E-03 (行197-198) | ○ |
| C-72 | WriteEscapedでメッセージがダブルクォートで囲まれること | E-03 (行209-218) | ○ |
| C-73 | WriteEscapedでダブルクォートがエスケープされること | E-03 (行214, 243-258) | ○ |
| C-74 | WriteEscapedでnullまたは空のメッセージで何も出力されないこと | E-03 (行211) | ○ |
| C-75 | EscapeMessageで複数のダブルクォートがエスケープされること | E-03 (行243-258) | ○ |

### XmlWriterTraceListener クラス（UT-XML-001 〜 UT-XML-054）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-76 | Streamを指定してインスタンスが生成されること | E-04 (行24-27) | ○ |
| C-77 | Streamと名前を指定してインスタンスが生成されること | E-04 (行29-32) | ○ |
| C-78 | TextWriterを指定してインスタンスが生成されること | E-04 (行34-37) | ○ |
| C-79 | TextWriterと名前を指定してインスタンスが生成されること | E-04 (行39-42) | ○ |
| C-80 | ファイル名を指定してインスタンスが生成されること | E-04 (行44-49) | ○ |
| C-81 | ファイル名と名前を指定してインスタンスが生成されること | E-04 (行51-56) | ○ |
| C-82 | WriteがWriteLineを呼び出すこと | E-04 (行58-61) | ○ |
| C-83 | WriteLineがTraceEventを呼び出してXML形式で出力すること | E-04 (行63-66) | ○ |
| C-84 | FailメソッドがエラーイベントとしてXML出力されること | E-04 (行68-86) | ○ |
| C-85 | FailでmessageとdetailMessageが連結されること | E-04 (行71-72) | ○ |
| C-86 | Failでmessageがnullの場合に空文字として扱われること | E-04 (行70) | ○ |
| C-87 | FailでdetailMessageがnullの場合にmessageのみ出力されること | E-04 (行71) | ○ |
| C-88 | TraceEvent(format, args)でフォーマット付きメッセージがXML形式で出力されること | E-04 (行88-96) | ○ |
| C-89 | TraceEvent(format, args)でFilterによるフィルタリングが機能すること | E-04 (行90-91) | ○ |
| C-90 | TraceEvent(format, args)でargsがnullまたは空の場合にformatがそのまま出力されること | E-04 (行94) | ○ |
| C-91 | TraceEvent(message)でメッセージがXML形式で出力されること | E-04 (行98-106) | ○ |
| C-92 | TraceEvent(message)でFilterによるフィルタリングが機能すること | E-04 (行100-101) | ○ |
| C-93 | TraceData(object)で単一データがXML形式で出力されること | E-04 (行108-125) | ○ |
| C-94 | TraceData(object)でdataがnullの場合に空のTraceDataが出力されること | E-04 (行116-121) | ○ |
| C-95 | TraceData(object)でFilterによるフィルタリングが機能すること | E-04 (行110-111) | ○ |
| C-96 | TraceData(object[])で複数データがXML形式で出力されること | E-04 (行127-149) | ○ |
| C-97 | TraceData(object[])でdataがnullの場合に空のTraceDataが出力されること | E-04 (行134-145) | ○ |
| C-98 | TraceData(object[])でdata配列内の要素がnullの場合の挙動 | E-04 (行139-142) | ○ |
| C-99 | WriteDataで通常のオブジェクトがエスケープされて出力されること | E-04 (行152-156) | ○ |
| C-100 | WriteDataでXPathNavigatorがXMLとしてそのまま出力されること | E-04 (行154-181) | ○ |
| C-101 | WriteDataでXPathNavigatorの書き込みで例外が発生した場合のフォールバック | E-04 (行177-180) | ○ |
| C-102 | Closeで_xmlBlobWriterが閉じられnullになること | E-04 (行184-190) | ○ |
| C-103 | Closeで_strBldrがnullになること | E-04 (行189) | ○ |
| C-104 | TraceTransferでrelatedActivityIdを含むXMLが出力されること | E-04 (行192-200) | ○ |
| C-105 | TraceTransferでFilterによるフィルタリングが機能すること | E-04 (行194-195) | ○ |
| C-106 | WriteHeaderでE2ETraceEventヘッダーが出力されること | E-04 (行216-244) | ○ |
| C-107 | WriteHeaderでEventID要素が出力されること | E-04 (行220-222) | ○ |
| C-108 | WriteHeaderでLevel要素が出力されること | E-04 (行230-232) | ○ |
| C-109 | WriteHeaderでLevel要素のeventType値が0にクランプされること | E-04 (行231: Math.Clamp) | ○ |
| C-110 | WriteHeaderでLevel要素のeventType値が255にクランプされること | E-04 (行231: Math.Clamp) | ○ |
| C-111 | WriteEndHeaderでプロセス名が出力されること | E-04 (行246-284) | ○ |
| C-112 | WriteEndHeaderでプロセス名がキャッシュされること | E-04 (行263: s_processName = processName) | ○ |
| C-113 | WriteEndHeaderでマシン名が出力されること | E-04 (行278-280) | ○ |
| C-114 | WriteFooterでeventCacheがnullの場合に最小限のフッターが出力されること | E-04 (行287-326) | ○ |
| C-115 | WriteFooterでLogicalOperationStackオプションが有効な場合に出力されること | E-04 (行298-307) | ○ |
| C-116 | WriteFooterでCallstackオプションが有効な場合に出力されること | E-04 (行314-318) | ○ |
| C-117 | WriteFooterでTimestampが常に出力されること | E-04 (行310-312) | ○ |
| C-118 | WriteEscapedでXMLの特殊文字がエスケープされること | E-04 (行328-376) | ○ |
| C-119 | WriteEscapedでシングルクォートがエスケープされること | E-04 (行358-361) | ○ |
| C-120 | WriteEscapedでCR(0xD)がエスケープされること | E-04 (行363-366) | ○ |
| C-121 | WriteEscapedでLF(0xA)がエスケープされること | E-04 (行368-371) | ○ |
| C-122 | WriteEscapedでnullまたは空の文字列で何も出力されないこと | E-04 (行330-331) | ○ |
| C-123 | InternalWrite(string)でメッセージが出力されること | E-04 (行378-382) | ○ |
| C-124 | InternalWrite(string)で_writerがnullの場合に何も起きないこと | E-04 (行381) | ○ |
| C-125 | InternalWrite<T>でint型の値が出力されること | E-04 (行390-402) | ○ |
| C-126 | InternalWrite<T>でuint型の値が出力されること | E-04 (行390-402) | ○ |
| C-127 | InternalWrite(Guid)でGuidが""B""形式で出力されること | E-04 (行404-414) | ○ |
| C-128 | InternalWrite(DateTime)でDateTimeが""o""形式で出力されること | E-04 (行416-426) | ○ |
| C-129 | InternalWrite(StringBuilder)でStringBuilderの内容が出力されること | E-04 (行428-438) | ○ |

## 4) 不足情報（Unknown / Missing）
- 全てのテストケースに対して、ソースコードから根拠を確認できたため、不足情報はありません。

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 全テストケースがソースコードから直接導出されており、実装との整合性が取れています。

## 6) レビュアーチェックリスト（最小）
- [ ] TextWriterTraceListenerのコンストラクタ系テストケース（UT-TWT-001〜010）がソースコードの各コンストラクタを網羅しているか
- [ ] EnsureWriterのエラーハンドリング系テストケース（UT-TWT-028〜032）が実際の例外処理ロジックと一致しているか
- [ ] DelimitedListTraceListenerのデリミタ処理テストケース（UT-DLT-007〜013）が境界値を適切にカバーしているか
- [ ] XmlWriterTraceListenerのXMLエスケープ処理テストケース（UT-XML-043〜047）が全ての特殊文字をカバーしているか
- [ ] 各TraceEvent/TraceDataメソッドのFilter連携テストケースが網羅されているか
