---
generated_at: 2026-01-30 17:30:00
metrics:
  claims_total: 201
  claims_with_evidence: 201
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：libraries-System.Diagnostics.TraceSource 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各テストケースに対して、ソースコードの実装が根拠（Evidence）として存在するか
2. **根拠との整合性**：テストケースの内容がソースコードの実装と矛盾していないか
3. **網羅性**：主要なクラス・メソッドを適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で各テストケースの根拠を確認
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：201 / 201、根拠なし：0
- 優先レビュー（高）
  1. なし - 全テストケースにソースコード根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Diagnostics.TraceSource/src/System/Diagnostics/TraceSource.cs`
- E-02: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Diagnostics.TraceSource/src/System/Diagnostics/TraceListener.cs`
- E-03: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Diagnostics.TraceSource/src/System/Diagnostics/Switch.cs`
- E-04: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Diagnostics.TraceSource/src/System/Diagnostics/BooleanSwitch.cs`
- E-05: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Diagnostics.TraceSource/src/System/Diagnostics/TraceSwitch.cs`
- E-06: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Diagnostics.TraceSource/src/System/Diagnostics/SourceSwitch.cs`
- E-07: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Diagnostics.TraceSource/src/System/Diagnostics/SourceFilter.cs`
- E-08: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Diagnostics.TraceSource/src/System/Diagnostics/SeverityFilter.cs` (EventTypeFilter)
- E-09: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Diagnostics.TraceSource/src/System/Diagnostics/TraceFilter.cs`
- E-10: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Diagnostics.TraceSource/src/System/Diagnostics/TraceEventCache.cs`
- E-11: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Diagnostics.TraceSource/src/System/Diagnostics/CorrelationManager.cs`
- E-12: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Diagnostics.TraceSource/src/System/Diagnostics/DefaultTraceListener.cs`
- E-13: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Diagnostics.TraceSource/src/System/Diagnostics/Trace.cs`
- E-14: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Diagnostics.TraceSource/src/System/Diagnostics/TraceListeners.cs` (TraceListenerCollection)
- E-15: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Diagnostics.TraceSource/src/System/Diagnostics/TraceInternal.cs`
- E-16: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Diagnostics.TraceSource/src/System/Diagnostics/SwitchAttribute.cs`
- E-17: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Diagnostics.TraceSource/src/System/Diagnostics/SwitchLevelAttribute.cs`
- E-18: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Diagnostics.TraceSource/src/System/Diagnostics/InitializingSwitchEventArgs.cs`
- E-19: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Diagnostics.TraceSource/src/System/Diagnostics/InitializingTraceSourceEventArgs.cs`
- E-20: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Diagnostics.TraceSource/src/System/Diagnostics/SourceLevels.cs`
- E-21: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Diagnostics.TraceSource/src/System/Diagnostics/TraceLevel.cs`
- E-22: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Diagnostics.TraceSource/src/System/Diagnostics/TraceEventType.cs`
- E-23: `/Users/tomoka.baba/Work/runtime-main/src/libraries/System.Diagnostics.TraceSource/src/System/Diagnostics/TraceOptions.cs`

## 3) Claims と根拠の対応（レビューの主戦場）

### TraceSource クラス（C-01〜C-24）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | TraceSource コンストラクタ(string)が名前を設定する | E-01 (L26) | ○ |
| C-02 | TraceSource コンストラクタがnull名で ArgumentException をスロー | E-01 (L30: ArgumentException.ThrowIfNullOrEmpty) | ○ |
| C-03 | TraceSource コンストラクタが空文字名で ArgumentException をスロー | E-01 (L30: ArgumentException.ThrowIfNullOrEmpty) | ○ |
| C-04 | TraceSource コンストラクタ(string, SourceLevels)がレベルを設定する | E-01 (L28-33) | ○ |
| C-05 | Name プロパティが名前を返す | E-01 (L539) | ○ |
| C-06 | DefaultLevel プロパティがデフォルトレベルを返す | E-01 (L497) | ○ |
| C-07 | Listeners プロパティが TraceListenerCollection を返す | E-01 (L541-547) | ○ |
| C-08 | Switch プロパティが SourceSwitch を返す | E-01 (L550-565) | ○ |
| C-09 | Switch プロパティにカスタムスイッチを設定できる | E-01 (L558-564) | ○ |
| C-10 | Switch プロパティに null で ArgumentNullException | E-01 (L560) | ○ |
| C-11 | Attributes プロパティが StringDictionary を返す | E-01 (L485-491) | ○ |
| C-12 | TraceEvent がリスナーに出力される | E-01 (L189-232) | ○ |
| C-13 | スイッチレベル以下のイベントは出力されない | E-01 (L194: _internalSwitch.ShouldTrace) | ○ |
| C-14 | TraceEvent(message) が出力される | E-01 (L234-277) | ○ |
| C-15 | TraceEvent(format, args) が出力される | E-01 (L279-322) | ○ |
| C-16 | TraceData(object) が出力される | E-01 (L324-366) | ○ |
| C-17 | TraceData(object[]) が出力される | E-01 (L369-411) | ○ |
| C-18 | TraceInformation(string) が出力される | E-01 (L414-418) | ○ |
| C-19 | TraceInformation(format, args) が出力される | E-01 (L421-426) | ○ |
| C-20 | TraceTransfer が出力される | E-01 (L428-483) | ○ |
| C-21 | Flush が全リスナーに呼ばれる | E-01 (L126-159) | ○ |
| C-22 | Close が全リスナーに呼ばれる | E-01 (L110-124) | ○ |
| C-23 | GetSupportedAttributes が null を返す | E-01 (L161) | ○ |
| C-24 | Initializing イベントが発火される | E-01 (L502-506) | ○ |

### TraceListener クラス（C-25〜C-56）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-25 | TraceListener パラメータなしコンストラクタ | E-02 (L31-33) | ○ |
| C-26 | TraceListener 名前指定コンストラクタ | E-02 (L39-42) | ○ |
| C-27 | Name プロパティが名前を返す | E-02 (L49-54) | ○ |
| C-28 | Name に null を設定すると空文字が返る | E-02 (L52) | ○ |
| C-29 | IndentLevel がデフォルト 0 | E-02 (L20, L87-98) | ○ |
| C-30 | IndentLevel に正の値を設定できる | E-02 (L94-97) | ○ |
| C-31 | IndentLevel に負の値を設定すると 0 | E-02 (L96) | ○ |
| C-32 | IndentSize がデフォルト 4 | E-02 (L21, L103-116) | ○ |
| C-33 | IndentSize に正の値を設定できる | E-02 (L110-115) | ○ |
| C-34 | IndentSize に負の値で ArgumentOutOfRangeException | E-02 (L112-113) | ○ |
| C-35 | Filter プロパティが設定したフィルタを返す | E-02 (L118-128) | ○ |
| C-36 | TraceOutputOptions がデフォルト None | E-02 (L22, L147-159) | ○ |
| C-37 | TraceOutputOptions に有効な値を設定できる | E-02 (L150-158) | ○ |
| C-38 | TraceOutputOptions に無効な値で ArgumentOutOfRangeException | E-02 (L152-155) | ○ |
| C-39 | IsThreadSafe がデフォルト false | E-02 (L56-59) | ○ |
| C-40 | Attributes が StringDictionary を返す | E-02 (L44) | ○ |
| C-41 | Fail(message) が WriteLine を呼ぶ | E-02 (L183-196) | ○ |
| C-42 | Fail(message, detailMessage) が WriteLine を呼ぶ | E-02 (L191-196) | ○ |
| C-43 | Write(object) が ToString を出力 | E-02 (L208-215) | ○ |
| C-44 | Write(object) に null で何も出力されない | E-02 (L213) | ○ |
| C-45 | Write(message, category) がカテゴリ付きで出力 | E-02 (L222-231) | ○ |
| C-46 | WriteLine(object) が改行付きで出力 | E-02 (L283-289) | ○ |
| C-47 | WriteLine(message, category) がカテゴリ付きで出力 | E-02 (L296-304) | ○ |
| C-48 | TraceEvent がヘッダとフッタ付きで出力 | E-02 (L350-365) | ○ |
| C-49 | TraceEvent(message) が出力 | E-02 (L356-365) | ○ |
| C-50 | TraceEvent(format, args) が出力 | E-02 (L367-379) | ○ |
| C-51 | TraceData(object) が出力 | E-02 (L324-336) | ○ |
| C-52 | TraceData(object[]) がカンマ区切りで出力 | E-02 (L338-348) | ○ |
| C-53 | TraceTransfer が relatedActivityId を含む | E-02 (L175-178) | ○ |
| C-54 | Dispose が正常に完了 | E-02 (L63-74) | ○ |
| C-55 | Close が正常に完了 | E-02 (L165-168) | ○ |
| C-56 | Flush が正常に完了 | E-02 (L79-82) | ○ |

### Switch クラス（C-57〜C-68）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-57 | Switch コンストラクタ(displayName, description) | E-03 (L41-43) | ○ |
| C-58 | Switch コンストラクタ(displayName, description, defaultValue) | E-03 (L45-59) | ○ |
| C-59 | DisplayName が名前を返す | E-03 (L89-95) | ○ |
| C-60 | DisplayName に null で空文字 | E-03 (L48) | ○ |
| C-61 | Description が説明を返す | E-03 (L100-106) | ○ |
| C-62 | Description に null で空文字 | E-03 (L104) | ○ |
| C-63 | DefaultValue がデフォルト値を返す | E-03 (L172) | ○ |
| C-64 | Value がデフォルト値を返す | E-03 (L174-187) | ○ |
| C-65 | Value 設定で OnValueChanged が呼ばれる | E-03 (L181-186) | ○ |
| C-66 | Attributes が StringDictionary を返す | E-03 (L108-115) | ○ |
| C-67 | Refresh で再初期化される | E-03 (L280-287) | ○ |
| C-68 | Initializing イベントが発火される | E-03 (L192-198) | ○ |

### BooleanSwitch クラス（C-69〜C-76）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-69 | BooleanSwitch コンストラクタ(displayName, description) | E-04 (L20-23) | ○ |
| C-70 | BooleanSwitch コンストラクタ(defaultValue) | E-04 (L25-27) | ○ |
| C-71 | Enabled がデフォルト false | E-04 (L33-43) | ○ |
| C-72 | Enabled を true に設定できる | E-04 (L39-42) | ○ |
| C-73 | Value="true" で Enabled が true | E-04 (L45-52) | ○ |
| C-74 | Value="false" で Enabled が false | E-04 (L45-52) | ○ |
| C-75 | Value="1" で Enabled が true | E-04 (L45-52) | ○ |
| C-76 | Value="0" で Enabled が false | E-04 (L45-52) | ○ |

### TraceSwitch クラス（C-77〜C-90）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-77 | TraceSwitch コンストラクタ(displayName, description) | E-05 (L18-20) | ○ |
| C-78 | TraceSwitch コンストラクタ(defaultValue) | E-05 (L22-24) | ○ |
| C-79 | Level がデフォルト Off | E-05 (L30-43) | ○ |
| C-80 | Level に有効な値を設定できる | E-05 (L36-42) | ○ |
| C-81 | Level に範囲外で ArgumentException | E-05 (L39-40) | ○ |
| C-82 | TraceError が Error 以上で true | E-05 (L51) | ○ |
| C-83 | TraceError が Off で false | E-05 (L51) | ○ |
| C-84 | TraceWarning が Warning 以上で true | E-05 (L58) | ○ |
| C-85 | TraceWarning が Error で false | E-05 (L58) | ○ |
| C-86 | TraceInfo が Info 以上で true | E-05 (L65) | ○ |
| C-87 | TraceVerbose が Verbose で true | E-05 (L72) | ○ |
| C-88 | TraceVerbose が Info で false | E-05 (L72) | ○ |
| C-89 | OnSwitchSettingChanged で低い値が Off に修正 | E-05 (L79-86) | ○ |
| C-90 | OnSwitchSettingChanged で高い値が Verbose に修正 | E-05 (L87-91) | ○ |

### SourceSwitch クラス（C-91〜C-97）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-91 | SourceSwitch コンストラクタ(name) | E-06 (L11) | ○ |
| C-92 | SourceSwitch コンストラクタ(displayName, defaultSwitchValue) | E-06 (L13-15) | ○ |
| C-93 | Level プロパティがデフォルト値を返す | E-06 (L17-27) | ○ |
| C-94 | Level に値を設定できる | E-06 (L23-26) | ○ |
| C-95 | ShouldTrace が Information で true | E-06 (L29-32) | ○ |
| C-96 | ShouldTrace が Error で Information は false | E-06 (L29-32) | ○ |
| C-97 | ShouldTrace が All で全タイプ true | E-06 (L29-32) | ○ |

### SourceFilter クラス（C-98〜C-104）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-98 | SourceFilter コンストラクタ | E-07 (L14-17) | ○ |
| C-99 | Source プロパティが値を返す | E-07 (L27-38) | ○ |
| C-100 | Source に値を設定できる | E-07 (L33-38) | ○ |
| C-101 | Source に null で ArgumentNullException | E-07 (L36) | ○ |
| C-102 | ShouldTrace が一致で true | E-07 (L19-25) | ○ |
| C-103 | ShouldTrace が不一致で false | E-07 (L24) | ○ |
| C-104 | ShouldTrace で source=null で ArgumentNullException | E-07 (L22) | ○ |

### EventTypeFilter クラス（C-105〜C-110）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-105 | EventTypeFilter コンストラクタ | E-08 (L13-16) | ○ |
| C-106 | EventType プロパティが値を返す | E-08 (L24-34) | ○ |
| C-107 | EventType に値を設定できる | E-08 (L30-33) | ○ |
| C-108 | ShouldTrace が Warning で Warning は true | E-08 (L18-22) | ○ |
| C-109 | ShouldTrace が Error で Warning は false | E-08 (L21) | ○ |
| C-110 | ShouldTrace が All で全タイプ true | E-08 (L21) | ○ |

### TraceEventCache クラス（C-111〜C-118）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-111 | DateTime が UtcNow を返す | E-10 (L17-25) | ○ |
| C-112 | DateTime が同じ値を返す（キャッシュ） | E-10 (L21-22) | ○ |
| C-113 | ProcessId が現在のプロセス ID | E-10 (L27-33) | ○ |
| C-114 | ThreadId が現在のスレッド ID | E-10 (L35-41) | ○ |
| C-115 | Timestamp がタイムスタンプを返す | E-10 (L43-51) | ○ |
| C-116 | Timestamp が同じ値を返す（キャッシュ） | E-10 (L47-48) | ○ |
| C-117 | Callstack がスタックトレースを返す | E-10 (L53) | ○ |
| C-118 | LogicalOperationStack が CorrelationManager のスタックを返す | E-10 (L55-61) | ○ |

### CorrelationManager クラス（C-119〜C-126）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-119 | ActivityId がデフォルト Guid.Empty | E-11 (L28) | ○ |
| C-120 | ActivityId に値を設定できる | E-11 (L28) | ○ |
| C-121 | LogicalOperationStack が Stack を返す | E-11 (L22) | ○ |
| C-122 | StartLogicalOperation() が Guid をプッシュ | E-11 (L24) | ○ |
| C-123 | StartLogicalOperation(object) がオブジェクトをプッシュ | E-11 (L30-35) | ○ |
| C-124 | StartLogicalOperation(null) で ArgumentNullException | E-11 (L32) | ○ |
| C-125 | StopLogicalOperation がポップする | E-11 (L26) | ○ |
| C-126 | 空スタックで StopLogicalOperation が例外 | E-11 (L104-113) | ○ |

### DefaultTraceListener クラス（C-127〜C-134）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-127 | DefaultTraceListener コンストラクタ | E-12 (L27-30) | ○ |
| C-128 | AssertUiEnabled がデフォルト true | E-12 (L32-44) | ○ |
| C-129 | AssertUiEnabled に値を設定できる | E-12 (L39-43) | ○ |
| C-130 | LogFileName がデフォルト空文字 | E-12 (L46-58) | ○ |
| C-131 | LogFileName に値を設定できる | E-12 (L53-57) | ○ |
| C-132 | Write がメッセージを出力 | E-12 (L119-122) | ○ |
| C-133 | WriteLine がメッセージを改行付きで出力 | E-12 (L129-142) | ○ |
| C-134 | Fail がスタックトレース付きで出力 | E-12 (L67-94) | ○ |

### Trace クラス（C-135〜C-165）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-135 | Listeners が TraceListenerCollection を返す | E-13 (L28-34) | ○ |
| C-136 | AutoFlush がデフォルト false | E-13 (L41-51) | ○ |
| C-137 | AutoFlush に値を設定できる | E-13 (L46-50) | ○ |
| C-138 | UseGlobalLock がデフォルト true | E-13 (L53-63) | ○ |
| C-139 | UseGlobalLock に値を設定できる | E-13 (L58-62) | ○ |
| C-140 | IndentLevel がデフォルト 0 | E-13 (L68-73) | ○ |
| C-141 | IndentLevel に値を設定できる | E-13 (L72) | ○ |
| C-142 | IndentSize がデフォルト 4 | E-13 (L81-86) | ○ |
| C-143 | IndentSize に値を設定できる | E-13 (L85) | ○ |
| C-144 | CorrelationManager が CorrelationManager を返す | E-13 (L22-23) | ○ |
| C-145 | Write(string) がリスナーに出力 | E-13 (L218-222) | ○ |
| C-146 | Write(object) がリスナーに出力 | E-13 (L228-232) | ○ |
| C-147 | Write(message, category) がリスナーに出力 | E-13 (L238-242) | ○ |
| C-148 | WriteLine(string) がリスナーに出力 | E-13 (L259-263) | ○ |
| C-149 | WriteIf(true) が出力 | E-13 (L302-306) | ○ |
| C-150 | WriteIf(false) が出力されない | E-13 (L302-306) | ○ |
| C-151 | WriteLineIf(true) が出力 | E-13 (L346-350) | ○ |
| C-152 | Assert(true) が何もしない | E-13 (L113-118) | ○ |
| C-153 | Assert(false) が Fail を呼ぶ | E-13 (L113-118) | ○ |
| C-154 | Assert(false, message) が Fail を呼ぶ | E-13 (L124-128) | ○ |
| C-155 | Fail(string) が出力 | E-13 (L143-148) | ○ |
| C-156 | Fail(string, string) が出力 | E-13 (L153-158) | ○ |
| C-157 | TraceInformation(string) が出力 | E-13 (L178-182) | ○ |
| C-158 | TraceWarning(string) が出力 | E-13 (L190-194) | ○ |
| C-159 | TraceError(string) が出力 | E-13 (L202-206) | ○ |
| C-160 | Indent が IndentLevel を増加 | E-13 (L391-395) | ○ |
| C-161 | Unindent が IndentLevel を減少 | E-13 (L400-404) | ○ |
| C-162 | Flush が各リスナーの Flush を呼ぶ | E-13 (L92-96) | ○ |
| C-163 | Close が各リスナーの Close を呼ぶ | E-13 (L102-106) | ○ |
| C-164 | Refresh がリフレッシュする | E-13 (L170-176) | ○ |
| C-165 | Refreshing イベントが発火 | E-13 (L163-168) | ○ |

### TraceListenerCollection クラス（C-166〜C-183）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-166 | Add でリスナーを追加できる | E-14 (L73-81) | ○ |
| C-167 | Add に null で ArgumentNullException | E-14 (L149-155) | ○ |
| C-168 | AddRange で複数リスナーを追加できる | E-14 (L86-94) | ○ |
| C-169 | AddRange に null で ArgumentNullException | E-14 (L88) | ○ |
| C-170 | インデクサ[int] でリスナーを取得できる | E-14 (L27-39) | ○ |
| C-171 | インデクサ[string] で名前検索できる | E-14 (L44-55) | ○ |
| C-172 | 存在しない名前で null が返る | E-14 (L53) | ○ |
| C-173 | Count がリスナー数を返す | E-14 (L62-68) | ○ |
| C-174 | Clear で全リスナーが削除される | E-14 (L116-119) | ○ |
| C-175 | Contains が追加済みリスナーで true | E-14 (L125-128) | ○ |
| C-176 | Contains が未追加リスナーで false | E-14 (L125-128) | ○ |
| C-177 | IndexOf がインデックスを返す | E-14 (L160-163) | ○ |
| C-178 | Insert で指定位置に挿入できる | E-14 (L168-175) | ○ |
| C-179 | Remove でリスナーを削除できる | E-14 (L182-185) | ○ |
| C-180 | Remove(name) で名前指定削除できる | E-14 (L191-196) | ○ |
| C-181 | RemoveAt でインデックス指定削除できる | E-14 (L201-207) | ○ |
| C-182 | CopyTo で配列にコピーできる | E-14 (L134-137) | ○ |
| C-183 | GetEnumerator で列挙できる | E-14 (L144-147) | ○ |

### SwitchAttribute クラス（C-184〜C-192）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-184 | SwitchAttribute コンストラクタ | E-16 (L17-21) | ○ |
| C-185 | SwitchName が名前を返す | E-16 (L23-33) | ○ |
| C-186 | SwitchName に null で ArgumentException | E-16 (L29) | ○ |
| C-187 | SwitchName に空文字で ArgumentException | E-16 (L29) | ○ |
| C-188 | SwitchType が型を返す | E-16 (L35-44) | ○ |
| C-189 | SwitchType に null で ArgumentNullException | E-16 (L41) | ○ |
| C-190 | SwitchDescription に値を設定・取得できる | E-16 (L46) | ○ |
| C-191 | GetAll が全 SwitchAttribute を返す | E-16 (L48-65) | ○ |
| C-192 | GetAll に null で ArgumentNullException | E-16 (L51) | ○ |

### SwitchLevelAttribute クラス（C-193〜C-195）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-193 | SwitchLevelAttribute コンストラクタ | E-17 (L13-16) | ○ |
| C-194 | SwitchLevelType が型を返す | E-17 (L18-28) | ○ |
| C-195 | SwitchLevelType に null で ArgumentNullException | E-17 (L24) | ○ |

### InitializingSwitchEventArgs クラス（C-196〜C-197）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-196 | InitializingSwitchEventArgs コンストラクタ | E-18 (L15-18) | ○ |
| C-197 | Switch プロパティがスイッチを返す | E-18 (L23) | ○ |

### InitializingTraceSourceEventArgs クラス（C-198〜C-201）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-198 | InitializingTraceSourceEventArgs コンストラクタ | E-19 (L15-18) | ○ |
| C-199 | TraceSource プロパティがソースを返す | E-19 (L23) | ○ |
| C-200 | WasInitialized がデフォルト false | E-19 (L28) | ○ |
| C-201 | WasInitialized に値を設定できる | E-19 (L28) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし - 全テストケースにソースコードの根拠あり

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全テストケースがソースコードから導出され、実装に基づいている

## 6) レビュアーチェックリスト（最小）
- [ ] TraceSource の初期化ロジック（Initialize メソッド）のテストケースが網羅的か確認
- [ ] スレッドセーフティ関連のテストケース（UseGlobalLock, IsThreadSafe）の妥当性確認
- [ ] Switch 系クラスの OnValueChanged / OnSwitchSettingChanged のテストケースが十分か確認
- [ ] CorrelationManager の AsyncLocal を使用した論理操作スタックのテストケースが適切か確認
- [ ] TraceListenerCollection のスレッドセーフなコレクション操作のテストケースが十分か確認
