---
generated_at: 2026-01-30 12:30:00
metrics:
  claims_total: 168
  claims_with_evidence: 165
  claims_without_evidence: 3
confidence_derived: 0.98
---

# 根拠レポート：libraries-System.Diagnostics.Tracing 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.98**
  - 根拠あり：165 / 168、根拠なし：3
- 優先レビュー（高）
  1. **UT-TRC-147（ActivityTracker深度制限）**：MAX_ACTIVITY_DEPTH定数の確認が必要
  2. **UT-TRC-148（ActivityTracker.Enable）**：NotImplementedException処理の確認
  3. **UT-TRC-152-155（CounterGroupタイマー関連）**：内部クラスのため直接テスト困難

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/libraries/System.Private.CoreLib/src/System/Diagnostics/Tracing/EventSource.cs`
- E-02: `src/libraries/System.Private.CoreLib/src/System/Diagnostics/Tracing/DiagnosticCounter.cs`
- E-03: `src/libraries/System.Private.CoreLib/src/System/Diagnostics/Tracing/EventCounter.cs`
- E-04: `src/libraries/System.Private.CoreLib/src/System/Diagnostics/Tracing/PollingCounter.cs`
- E-05: `src/libraries/System.Private.CoreLib/src/System/Diagnostics/Tracing/IncrementingEventCounter.cs`
- E-06: `src/libraries/System.Private.CoreLib/src/System/Diagnostics/Tracing/IncrementingPollingCounter.cs`
- E-07: `src/libraries/System.Private.CoreLib/src/System/Diagnostics/Tracing/EventSourceException.cs`
- E-08: `src/libraries/System.Private.CoreLib/src/System/Diagnostics/Tracing/ActivityTracker.cs`
- E-09: `src/libraries/System.Private.CoreLib/src/System/Diagnostics/Tracing/CounterGroup.cs`
- E-10: `src/libraries/System.Private.CoreLib/src/System/Diagnostics/Tracing/CounterPayload.cs`
- E-11: `src/libraries/System.Private.CoreLib/src/System/Diagnostics/Tracing/TraceLogging/EventSourceOptions.cs`
- E-12: `src/libraries/System.Private.CoreLib/src/System/Diagnostics/Tracing/TraceLogging/EventDataAttribute.cs`
- E-13: `src/libraries/System.Diagnostics.Tracing/ref/System.Diagnostics.Tracing.cs`（公開API定義）
- E-14: `src/libraries/System.Diagnostics.Tracing/ref/System.Diagnostics.Tracing.Counters.cs`（カウンターAPI定義）

## 3) Claims と根拠の対応（レビューの主戦場）

### EventSource クラス (UT-TRC-001 〜 UT-TRC-047)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | EventSource.IsEnabled()がbool返却 | E-01 (line 304-307), E-13 | ○ |
| C-02 | IsEnabled(level, keywords)のフィルタリング | E-01 (line 318-321) | ○ |
| C-03 | IsEnabled(level, keywords, channel)のチャネルフィルタリング | E-01 (line 333-341) | ○ |
| C-04 | GetGuid(Type)の実装 | E-01 (line 355-378), E-13 | ○ |
| C-05 | GetGuid(Type)のnullチェック | E-01 (line 357: ArgumentNullException.ThrowIfNull) | ○ |
| C-06 | GetName(Type)の実装 | E-01 (line 384-387), E-13 | ○ |
| C-07 | GenerateManifest実装 | E-01 (line 408-446), E-13 | ○ |
| C-08 | GetSources()の実装 | E-01 (line 453-472), E-13 | ○ |
| C-09 | SendCommand実装 | E-01 (line 483-499), E-13 | ○ |
| C-10 | GetTrait(string)の実装 | E-01 (line 521-533) | ○ |
| C-11 | ToString()の実装 | E-01 (line 538-544) | ○ |
| C-12 | SetCurrentThreadActivityId実装 | E-01 (line 595-618), E-13 | ○ |
| C-13 | CurrentThreadActivityIdプロパティ | E-01 (line 623-646), E-13 | ○ |
| C-14 | WriteEventオーバーロード各種 | E-01 (line 817-994) | ○ |
| C-15 | Write<T>メソッド | E-01, E-13 | ○ |
| C-16 | Dispose()実装 | E-01, E-13 | ○ |
| C-17 | OnEventCommand仮想メソッド | E-01 (line 811), E-13 | ○ |
| C-18 | EventCommandExecutedイベント | E-01 (line 549-574), E-13 | ○ |
| C-19 | ConstructionExceptionプロパティ | E-01 (line 511), E-13 | ○ |
| C-20 | Name, Guid, Settingsプロパティ | E-01 (line 294-347), E-13 | ○ |

### EventListener クラス (UT-TRC-048 〜 UT-TRC-058)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-21 | EventListenerコンストラクタ | E-01, E-13 | ○ |
| C-22 | EnableEvents各オーバーロード | E-01, E-13 | ○ |
| C-23 | DisableEvents実装 | E-01, E-13 | ○ |
| C-24 | OnEventSourceCreated仮想メソッド | E-01, E-13 | ○ |
| C-25 | OnEventWritten仮想メソッド | E-01, E-13 | ○ |
| C-26 | EventSourceCreatedイベント | E-01, E-13 | ○ |
| C-27 | EventWrittenイベント | E-01, E-13 | ○ |
| C-28 | Dispose()実装 | E-01, E-13 | ○ |
| C-29 | EventSourceIndex静的メソッド | E-01, E-13 | ○ |

### DiagnosticCounter クラス (UT-TRC-059 〜 UT-TRC-066)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-30 | コンストラクタのnullチェック | E-02 (line 28-29) | ○ |
| C-31 | Name, EventSourceプロパティ | E-02 (line 99-101), E-14 | ○ |
| C-32 | DisplayName, DisplayUnitsプロパティ | E-02 (line 77-97), E-14 | ○ |
| C-33 | AddMetadata実装 | E-02 (line 68-75), E-14 | ○ |
| C-34 | Dispose()実装 | E-02 (line 56-63), E-14 | ○ |

### EventCounter クラス (UT-TRC-067 〜 UT-TRC-078)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-35 | EventCounterコンストラクタ | E-03 (line 31-44), E-14 | ○ |
| C-36 | WriteMetric(float/double)実装 | E-03 (line 51-59), E-14 | ○ |
| C-37 | 統計計算（Mean, Min, Max, StdDev） | E-03 (line 78-136) | ○ |
| C-38 | ToString()実装 | E-03 (line 61-67) | ○ |

### PollingCounter クラス (UT-TRC-079 〜 UT-TRC-083)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-39 | PollingCounterコンストラクタ | E-04 (line 29-35), E-14 | ○ |
| C-40 | metricProviderのnullチェック | E-04 (line 31) | ○ |
| C-41 | WritePayloadでのmetricProvider呼び出し | E-04 (line 45-75) | ○ |
| C-42 | 例外時のReportOutOfBandMessage | E-04 (line 54-57) | ○ |
| C-43 | ToString()実装 | E-04 (line 37) | ○ |

### IncrementingEventCounter クラス (UT-TRC-084 〜 UT-TRC-089)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-44 | IncrementingEventCounterコンストラクタ | E-05 (line 27-30), E-14 | ○ |
| C-45 | Increment(double)実装 | E-05 (line 37-43), E-14 | ○ |
| C-46 | DisplayRateTimeScaleプロパティ | E-05 (line 45), E-14 | ○ |
| C-47 | ToString()実装 | E-05 (line 49) | ○ |

### IncrementingPollingCounter クラス (UT-TRC-090 〜 UT-TRC-095)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-48 | IncrementingPollingCounterコンストラクタ | E-06 (line 30-36), E-14 | ○ |
| C-49 | totalValueProviderのnullチェック | E-06 (line 32) | ○ |
| C-50 | UpdateMetric実装 | E-06 (line 48-62) | ○ |
| C-51 | 例外時のReportOutOfBandMessage | E-06 (line 58-61) | ○ |
| C-52 | ToString()実装 | E-06 (line 38) | ○ |

### EventSourceException クラス (UT-TRC-096 〜 UT-TRC-099)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-53 | 各コンストラクタの実装 | E-07 (line 19-41), E-13 | ○ |

### EventCommandEventArgs クラス (UT-TRC-100 〜 UT-TRC-105)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-54 | Command, Argumentsプロパティ | E-01 (line 4708-4713), E-13 | ○ |
| C-55 | EnableEvent/DisableEvent実装 | E-01 (line 4720-4737), E-13 | ○ |
| C-56 | InvalidOperationException on invalid command | E-01 (line 4722-4723, 4734-4735) | ○ |

### EventWrittenEventArgs クラス (UT-TRC-106 〜 UT-TRC-122)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-57 | EventId, EventName, EventSourceプロパティ | E-01 (line 4796-4847), E-13 | ○ |
| C-58 | Payload, PayloadNamesプロパティ | E-01 (line 4832-4841), E-13 | ○ |
| C-59 | Level, Keywords, Opcode, Task, Tagsプロパティ | E-01 (line 4852-4878), E-13 | ○ |
| C-60 | Message, Channel, Versionプロパティ | E-01 (line 4884-4898), E-13 | ○ |
| C-61 | ActivityId, RelatedActivityIdプロパティ | E-01 (line 4812-4828), E-13 | ○ |
| C-62 | TimeStamp, OSThreadIdプロパティ | E-01 (line 4910-4930), E-13 | ○ |

### EventSourceOptions 構造体 (UT-TRC-123 〜 UT-TRC-127)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-63 | Level, Opcode, Keywords, Tags, ActivityOptionsプロパティ | E-11 (line 30-96), E-13 | ○ |

### 属性クラス (UT-TRC-128 〜 UT-TRC-144)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-64 | EventAttributeの各プロパティ | E-01 (line 5019-5078), E-13 | ○ |
| C-65 | EventSourceAttributeの各プロパティ | E-01 (line 4974-5008), E-13 | ○ |
| C-66 | EventDataAttributeの各プロパティ | E-12 (line 17-138), E-13 | ○ |
| C-67 | EventFieldAttributeの各プロパティ | E-13 | ○ |

### ActivityTracker クラス (UT-TRC-145 〜 UT-TRC-148)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-68 | OnStart実装 | E-08 (line 45-119) | ○ |
| C-69 | OnStop実装 | E-08 (line 127-204) | ○ |
| C-70 | MAX_ACTIVITY_DEPTH定数による深度制限 | E-08 (line 77-84, 609) | ○ |
| C-71 | Enable実装 | E-08 (line 209-224) | △ |

### CounterGroup クラス (UT-TRC-149 〜 UT-TRC-157)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-72 | Add/Remove実装 | E-09 (line 26-36) | ○ |
| C-73 | GetCounterGroup実装 | E-09 (line 124-139) | ○ |
| C-74 | EnableTimer/DisableTimer実装 | E-09 (line 149-200) | △ |
| C-75 | OnEventSourceCommand実装 | E-09 (line 45-98) | ○ |

### その他 (UT-TRC-158 〜 UT-TRC-168)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-76 | EventSourcePrimitiveの暗黙変換 | E-13 (line 224-254) | ○ |
| C-77 | EventDataのDataPointer, Size | E-13 (line 257-262) | ○ |
| C-78 | EventSourceCreatedEventArgsのEventSource | E-01 (line 4773-4783), E-13 | ○ |
| C-79 | CounterPayloadのIEnumerable実装 | E-10 (line 38-66) | ○ |
| C-80 | IncrementingCounterPayloadのIEnumerable実装 | E-10 (line 91-118) | △ |

## 4) 不足情報（Unknown / Missing）
- **UT-TRC-071-072（ActivityTracker内部ロジック）**: ActivityTrackerは内部クラスであり、直接テストには特殊なテストインフラが必要
  - 候補：リフレクションを使用したテスト / InternalsVisibleTo属性の活用 / 統合テストでの検証
- **CounterGroupのタイマースレッド動作**: ポーリングスレッドの動作検証は単体テストでは困難
  - 候補：モックを使用したタイマー検証 / 統合テストでの動作確認

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: プロパティのget/set、基本的なコンストラクタ検証（大部分のテストケース）
- **1（中リスク）**: 統計計算ロジック、マルチスレッド関連、例外処理
  - UT-TRC-074〜077（EventCounter統計計算）
  - UT-TRC-081〜082, 092〜093（PollingCounter/IncrementingPollingCounterの例外処理）
  - UT-TRC-152〜155（CounterGroupタイマー管理）
- **2（高リスク）**: 該当なし

## 6) レビュアーチェックリスト（最小）
- [ ] EventSourceの主要API（IsEnabled, WriteEvent, GetGuid, GetName）のテストケースが網羅されているか
- [ ] EventListenerのライフサイクル（Enable/Disable/Dispose）が適切にテストされているか
- [ ] DiagnosticCounter派生クラス（EventCounter, PollingCounter, IncrementingEventCounter, IncrementingPollingCounter）のコア機能がカバーされているか
- [ ] null引数に対するArgumentNullExceptionのテストケースが含まれているか
- [ ] 統計計算（Mean, Min, Max, StandardDeviation）の正常系・境界値テストが含まれているか
- [ ] アクティビティトラッキング（ActivityTracker）の開始/停止/深度制限がテストされているか
- [ ] 内部クラス（CounterGroup, ActivityTracker）のテスト方針が明確か
