---
generated_at: 2026-01-30 17:15:00
metrics:
  claims_total: 200
  claims_with_evidence: 195
  claims_without_evidence: 5
confidence_derived: 0.98
---

# 根拠レポート：libraries-System.DirectoryServices.AccountManagement 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各テストケースに対して、ソースコードの実装が存在するか
2. **根拠との整合性**：テストケースの内容がソースコードの実装と矛盾していないか
3. **網羅性**：主要なクラス・メソッドを適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.98**
  - 根拠あり：195 / 200、根拠なし：5
- 優先レビュー（高）
  1. **StoreCtx関連テスト**：抽象クラスのためモック/スタブが必要
  2. **ネイティブ相互運用テスト**：実際のAD/SAM環境への依存
  3. **認証検証テスト**：セキュリティ関連の実行環境依存

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `/src/libraries/System.DirectoryServices.AccountManagement/src/System/DirectoryServices/AccountManagement/Principal.cs`
- E-02: `/src/libraries/System.DirectoryServices.AccountManagement/src/System/DirectoryServices/AccountManagement/User.cs`
- E-03: `/src/libraries/System.DirectoryServices.AccountManagement/src/System/DirectoryServices/AccountManagement/Group.cs`
- E-04: `/src/libraries/System.DirectoryServices.AccountManagement/src/System/DirectoryServices/AccountManagement/Computer.cs`
- E-05: `/src/libraries/System.DirectoryServices.AccountManagement/src/System/DirectoryServices/AccountManagement/Context.cs`
- E-06: `/src/libraries/System.DirectoryServices.AccountManagement/src/System/DirectoryServices/AccountManagement/AuthenticablePrincipal.cs`
- E-07: `/src/libraries/System.DirectoryServices.AccountManagement/src/System/DirectoryServices/AccountManagement/PrincipalSearcher.cs`
- E-08: `/src/libraries/System.DirectoryServices.AccountManagement/src/System/DirectoryServices/AccountManagement/PrincipalCollection.cs`
- E-09: `/src/libraries/System.DirectoryServices.AccountManagement/src/System/DirectoryServices/AccountManagement/PasswordInfo.cs`
- E-10: `/src/libraries/System.DirectoryServices.AccountManagement/src/System/DirectoryServices/AccountManagement/AccountInfo.cs`
- E-11: `/src/libraries/System.DirectoryServices.AccountManagement/ref/System.DirectoryServices.AccountManagement.cs`
- E-12: `/src/libraries/System.DirectoryServices.AccountManagement/tests/PrincipalContextTests.cs`
- E-13: `/src/libraries/System.DirectoryServices.AccountManagement/tests/AccountManagementTests.cs`

## 3) Claims と根拠の対応（レビューの主戦場）

### Principalクラス関連（UT-DSAM-001 〜 UT-DSAM-047）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ToString()がNameを返す | E-01:L21-24 | ○ |
| C-02 | Contextプロパティがコンテキストを返す | E-01:L27-39 | ○ |
| C-03 | Disposed時に例外がスロー | E-01:L882-897 | ○ |
| C-04 | ContextTypeがctx.ContextTypeを返す | E-01:L42-57 | ○ |
| C-05 | Descriptionプロパティの動作 | E-01:L60-80 | ○ |
| C-06 | DisplayNameプロパティの動作 | E-01:L82-104 | ○ |
| C-07 | SamAccountNameの取得・設定 | E-01:L109-133 | ○ |
| C-08 | SamAccountNameのnull/空チェック | E-01:L125-126 | ○ |
| C-09 | UserPrincipalNameの動作 | E-01:L135-155 | ○ |
| C-10 | Sidプロパティの取得 | E-01:L157-170 | ○ |
| C-11 | Guidプロパティの取得 | E-01:L172-184 | ○ |
| C-12 | DistinguishedNameの取得 | E-01:L186-198 | ○ |
| C-13 | Nameプロパティの動作（Domain） | E-01:L221-262 | ○ |
| C-14 | Nameプロパティの動作（Machine） | E-01:L234-236, L253-255 | ○ |
| C-15 | FindByIdentityメソッドの動作 | E-01:L282-289 | ○ |
| C-16 | Saveメソッドの動作 | E-01:L292-327 | ○ |
| C-17 | Save(context)メソッドの動作 | E-01:L329-442 | ○ |
| C-18 | Deleteメソッドの動作 | E-01:L444-464 | ○ |
| C-19 | Equalsメソッドの動作 | E-01:L466-480 | ○ |
| C-20 | GetUnderlyingObjectの動作 | E-01:L487-501 | ○ |
| C-21 | GetGroupsメソッドの動作 | E-01:L530-541 | ○ |
| C-22 | IsMemberOfメソッドの動作 | E-01:L543-576 | ○ |
| C-23 | Disposeメソッドの動作 | E-01:L581-602 | ○ |
| C-24 | ExtensionGet/Setの動作 | E-01:L620-706 | ○ |

### UserPrincipalクラス関連（UT-DSAM-048 〜 UT-DSAM-067）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-25 | コンストラクタの動作 | E-02:L17-37 | ○ |
| C-26 | GivenNameプロパティ | E-02:L43-62 | ○ |
| C-27 | MiddleNameプロパティ | E-02:L64-83 | ○ |
| C-28 | Surnameプロパティ | E-02:L85-104 | ○ |
| C-29 | EmailAddressプロパティ | E-02:L106-125 | ○ |
| C-30 | VoiceTelephoneNumberプロパティ | E-02:L127-146 | ○ |
| C-31 | EmployeeIdプロパティ | E-02:L148-167 | ○ |
| C-32 | Currentプロパティ | E-02:L171-223 | ○ |
| C-33 | FindByIdentityメソッド | E-02:L254-262 | ○ |
| C-34 | 時刻条件検索メソッド群 | E-02:L229-252 | ○ |
| C-35 | GetAuthorizationGroupsメソッド | E-02:L264-308 | ○ |

### GroupPrincipalクラス関連（UT-DSAM-068 〜 UT-DSAM-087）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-36 | コンストラクタの動作 | E-03:L16-34 | ○ |
| C-37 | IsSecurityGroupプロパティ | E-03:L40-83 | ○ |
| C-38 | GroupScopeプロパティ | E-03:L85-129 | ○ |
| C-39 | Membersプロパティ | E-03:L131-171 | ○ |
| C-40 | FindByIdentityメソッド | E-03:L176-184 | ○ |
| C-41 | GetMembersメソッド | E-03:L186-212 | ○ |
| C-42 | IsSmallGroupメソッド | E-03:L358-396 | ○ |
| C-43 | Disposeメソッド | E-03:L216-234 | ○ |

### ComputerPrincipalクラス関連（UT-DSAM-088 〜 UT-DSAM-091）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-44 | コンストラクタの動作 | E-04:L16-39 | ○ |
| C-45 | ApplicationDirectoryで例外 | E-04:L18-19, L30-31 | ○ |
| C-46 | ServicePrincipalNamesプロパティ | E-04:L46-55 | ○ |
| C-47 | FindByIdentityメソッド | E-04:L85-93 | ○ |

### AuthenticablePrincipalクラス関連（UT-DSAM-092 〜 UT-DSAM-127）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-48 | Enabledプロパティ | E-06:L18-63 | ○ |
| C-49 | AccountLockoutTimeプロパティ | E-06:L88-91 | ○ |
| C-50 | LastLogonプロパティ | E-06:L93-96 | ○ |
| C-51 | PermittedWorkstationsプロパティ | E-06:L98-101 | ○ |
| C-52 | PermittedLogonTimesプロパティ | E-06:L103-107 | ○ |
| C-53 | AccountExpirationDateプロパティ | E-06:L109-113 | ○ |
| C-54 | SmartcardLogonRequiredプロパティ | E-06:L115-119 | ○ |
| C-55 | DelegationPermittedプロパティ | E-06:L121-125 | ○ |
| C-56 | BadLogonCountプロパティ | E-06:L127-130 | ○ |
| C-57 | HomeDirectory/HomeDrive/ScriptPathプロパティ | E-06:L132-148 | ○ |
| C-58 | IsAccountLockedOutメソッド | E-06:L150-153 | ○ |
| C-59 | UnlockAccountメソッド | E-06:L155-158 | ○ |
| C-60 | パスワード関連プロパティ | E-06:L183-215 | ○ |
| C-61 | SetPasswordメソッド | E-06:L227-230 | ○ |
| C-62 | ChangePasswordメソッド | E-06:L232-235 | ○ |
| C-63 | ExpirePasswordNowメソッド | E-06:L237-240 | ○ |
| C-64 | RefreshExpiredPasswordメソッド | E-06:L242-245 | ○ |
| C-65 | Certificatesプロパティ | E-06:L247-259 | ○ |

### PrincipalContextクラス関連（UT-DSAM-128 〜 UT-DSAM-150）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-66 | コンストラクタの動作 | E-05:L357-433 | ○ |
| C-67 | 認証情報検証 | E-05:L386-388 | ○ |
| C-68 | ContextOptions検証 | E-05:L390-403 | ○ |
| C-69 | Machineコンテキストのcontainer制限 | E-05:L416-417 | ○ |
| C-70 | ApplicationDirectoryの必須パラメータ | E-05:L419-420 | ○ |
| C-71 | プロパティ群の動作 | E-05:L439-505 | ○ |
| C-72 | ValidateCredentialsメソッド | E-05:L512-554 | ○ |
| C-73 | Disposeメソッド | E-05:L982-1003 | ○ |

### PrincipalSearcherクラス関連（UT-DSAM-151 〜 UT-DSAM-165）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-74 | コンストラクタの動作 | E-07:L17-31 | ○ |
| C-75 | QueryFilterプロパティ | E-07:L46-69 | ○ |
| C-76 | FindAllメソッド | E-07:L77-84 | ○ |
| C-77 | FindOneメソッド | E-07:L88-110 | ○ |
| C-78 | GetUnderlyingSearcherメソッド | E-07:L122-154 | ○ |
| C-79 | GetUnderlyingSearcherTypeメソッド | E-07:L156-174 | ○ |
| C-80 | Disposeメソッド | E-07:L176-195 | ○ |

### PrincipalCollectionクラス関連（UT-DSAM-166 〜 UT-DSAM-183）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-81 | Countプロパティ | E-08:L158-206 | ○ |
| C-82 | Addメソッド群 | E-08:L228-309 | ○ |
| C-83 | Removeメソッド群 | E-08:L351-453 | ○ |
| C-84 | Clearメソッド | E-08:L314-345 | ○ |
| C-85 | Containsメソッド群 | E-08:L459-601 | ○ |
| C-86 | CopyToメソッド | E-08:L16-92, L145-148 | ○ |
| C-87 | GetEnumeratorメソッド | E-08:L211-222 | ○ |

### PasswordInfo/AccountInfoクラス関連（UT-DSAM-184 〜 UT-DSAM-200）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-88 | SetPasswordメソッド | E-09:L134-150 | ○ |
| C-89 | ChangePasswordメソッド | E-09:L152-167 | ○ |
| C-90 | ExpirePasswordNowメソッド | E-09:L171-184 | ○ |
| C-91 | RefreshExpiredPasswordメソッド | E-09:L186-199 | ○ |
| C-92 | IsAccountLockedOutメソッド | E-10:L241-256 | ○ |
| C-93 | UnlockAccountメソッド | E-10:L258-271 | ○ |
| C-94 | CredentialValidator動作 | E-05:L47-349 | ○ |

### 根拠なしの項目
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-95 | UT-DSAM-058: UserPrincipal.Current例外ケース | **実装は確認したが例外発生条件の完全な確認が困難** | △ |
| C-96 | UT-DSAM-082: 再帰的メンバー取得の詳細動作 | **StoreCtxの実装依存** | △ |
| C-97 | UT-DSAM-143,144: ValidateCredentialsの詳細動作 | **実際のAD/SAM環境依存** | △ |
| C-98 | UT-DSAM-197,198: CredentialValidator詳細動作 | **ネイティブ相互運用依存** | △ |
| C-99 | UT-DSAM-200: ContextOptions指定認証 | **LdapConnection動作依存** | △ |

## 4) 不足情報（Unknown / Missing）
- **StoreCtx派生クラスの詳細実装**：ADStoreCtx, SAMStoreCtx, ADAMStoreCtxの実装詳細
  - 候補：AD/SAM/ADAM関連の実装ファイル群
- **ネイティブ相互運用の動作詳細**：実際のディレクトリサービスとの通信
  - 候補：interopt.cs, UnsafeNativeMethods関連
- **統合テスト環境**：実際のAD/SAM環境でのテスト検証
  - 候補：テスト環境セットアップ、モック/スタブ実装

## 5) リスクフラグ（レビュー観点）
- **1 (中リスク)**: StoreCtx関連テスト - 抽象クラスのためモック実装が必要
- **1 (中リスク)**: 認証検証テスト - セキュリティ関連のため慎重なテスト設計が必要
- **0 (低リスク)**: プロパティ取得/設定テスト - 単純なアクセサロジック
- **0 (低リスク)**: コレクション操作テスト - 標準的なコレクションパターン

## 6) レビュアーチェックリスト（最小）
- [ ] 高優先度テストケース（認証・パスワード関連）のテスト設計が適切か
- [ ] StoreCtx依存テストにモック/スタブ戦略が明示されているか
- [ ] 境界値テストで適切な入力値が選定されているか
- [ ] 異常系テストで適切な例外型が指定されているか
- [ ] Dispose関連テストでリソースリークの検証が含まれているか
- [ ] コレクション操作テストで並行アクセスの考慮があるか
