---
generated_at: 2026-01-30 12:00:00
metrics:
  claims_total: 193
  claims_with_evidence: 193
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：libraries-System.DirectoryServices.Protocols 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各テストケースに対して、ソースコードの実装が存在するか
2. **根拠との整合性**：テストケースの内容がソースコードの実装と矛盾していないか
3. **網羅性**：主要なクラス・メソッドを適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：193 / 193、根拠なし：0
- 優先レビュー（高）
  1. **LdapConnection接続テスト**：実際のLDAPサーバーが必要なケース
  2. **BerConverter変換テスト**：プラットフォーム依存の可能性
  3. **TLS関連テスト**：環境依存の設定が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/libraries/System.DirectoryServices.Protocols/src/System/DirectoryServices/Protocols/common/DirectoryAttribute.cs`
- E-02: `src/libraries/System.DirectoryServices.Protocols/src/System/DirectoryServices/Protocols/common/DirectoryControl.cs`
- E-03: `src/libraries/System.DirectoryServices.Protocols/src/System/DirectoryServices/Protocols/common/DirectoryRequest.cs`
- E-04: `src/libraries/System.DirectoryServices.Protocols/src/System/DirectoryServices/Protocols/common/DirectoryResponse.cs`
- E-05: `src/libraries/System.DirectoryServices.Protocols/src/System/DirectoryServices/Protocols/common/BerConverter.cs`
- E-06: `src/libraries/System.DirectoryServices.Protocols/src/System/DirectoryServices/Protocols/common/DirectoryException.cs`
- E-07: `src/libraries/System.DirectoryServices.Protocols/src/System/DirectoryServices/Protocols/common/DirectoryConnection.cs`
- E-08: `src/libraries/System.DirectoryServices.Protocols/src/System/DirectoryServices/Protocols/common/SearchResults.cs`
- E-09: `src/libraries/System.DirectoryServices.Protocols/src/System/DirectoryServices/Protocols/ldap/LdapConnection.cs`
- E-10: `src/libraries/System.DirectoryServices.Protocols/src/System/DirectoryServices/Protocols/ldap/LdapDirectoryIdentifier.cs`
- E-11: `src/libraries/System.DirectoryServices.Protocols/src/System/DirectoryServices/Protocols/ldap/LdapSessionOptions.cs`
- E-12: `src/libraries/System.DirectoryServices.Protocols/src/System/DirectoryServices/Protocols/ldap/LdapException.cs`

## 3) Claims と根拠の対応（レビューの主戦場）

### DirectoryAttribute クラス (UT-DSP-001 - UT-DSP-027)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | DirectoryAttributeのコンストラクタでnull検証 | E-01 (Line 38-39) | ○ |
| C-02 | Nameプロパティのnull検証 | E-01 (Line 61) | ○ |
| C-03 | GetValues(Type)の型変換 | E-01 (Line 64-116) | ○ |
| C-04 | インデクサの型検証 | E-01 (Line 144-148) | ○ |
| C-05 | AddRangeの配列検証 | E-01 (Line 172-190) | ○ |
| C-06 | OnValidateのバリデーション | E-01 (Line 213-221) | ○ |

### DirectoryAttributeModification クラス (UT-DSP-028 - UT-DSP-030)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-07 | Operationプロパティのデフォルト値 | E-01 (Line 226) | ○ |
| C-08 | Operation列挙値検証 | E-01 (Line 237-240) | ○ |

### DirectoryAttributeCollection クラス (UT-DSP-031 - UT-DSP-034)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-09 | Addのnull検証 | E-01 (Line 296-299) | ○ |
| C-10 | OnValidateのバリデーション | E-01 (Line 348-358) | ○ |

### BerConverter クラス (UT-DSP-040 - UT-DSP-052)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-11 | Encodeのnullフォーマット検証 | E-05 (Line 15) | ○ |
| C-12 | Encodeのフォーマット文字処理 | E-05 (Line 48-241) | ○ |
| C-13 | Decodeのエラー処理 | E-05 (Line 292-300) | ○ |

### DirectoryControl クラス (UT-DSP-053 - UT-DSP-061)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-14 | コンストラクタのnull検証 | E-02 (Line 121) | ○ |
| C-15 | GetValueの値コピー | E-02 (Line 133-141) | ○ |
| C-16 | TransformControlsの変換処理 | E-02 (Line 149-312) | ○ |

### 各種Control派生クラス (UT-DSP-062 - UT-DSP-084)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-17 | SortKeyのnull検証 | E-02 (Line 76) | ○ |
| C-18 | ExtendedDNControlの列挙値検証 | E-02 (Line 424-427) | ○ |
| C-19 | SearchOptionsControlの列挙値検証 | E-02 (Line 513-516) | ○ |
| C-20 | DirSyncRequestControlの範囲検証 | E-02 (Line 642-645) | ○ |
| C-21 | PageResultRequestControlの範囲検証 | E-02 (Line 725-728) | ○ |
| C-22 | VlvRequestControlの範囲検証 | E-02 (Line 962-966, 975-980, 990-996, 1004-1010) | ○ |

### DirectoryRequest派生クラス (UT-DSP-085 - UT-DSP-104)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-23 | AddRequestのnull検証 | E-03 (Line 55) | ○ |
| C-24 | CompareRequestのassertion検証 | E-03 (Line 129-134) | ○ |
| C-25 | SearchRequestのFilter型検証 | E-03 (Line 241-244) | ○ |
| C-26 | SearchRequestのScope列挙値検証 | E-03 (Line 255-258) | ○ |
| C-27 | SearchRequestのSizeLimit範囲検証 | E-03 (Line 283-286) | ○ |
| C-28 | SearchRequestのTimeLimit範囲検証 | E-03 (Line 297-306) | ○ |

### LdapDirectoryIdentifier クラス (UT-DSP-108 - UT-DSP-113)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-29 | サーバー名のスペース検証 | E-10 (Line 37-41) | ○ |
| C-30 | PortNumberのデフォルト値 | E-10 (Line 63) | ○ |

### LdapConnection クラス (UT-DSP-114 - UT-DSP-143)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-31 | AuthTypeの列挙値検証 | E-09 (Line 73-76, 127-130) | ○ |
| C-32 | Anonymous認証の資格情報検証 | E-09 (Line 79-82, 996-999) | ○ |
| C-33 | Timeoutの範囲検証 | E-09 (Line 107-116) | ○ |
| C-34 | SendRequestのnull検証 | E-09 (Line 200) | ○ |
| C-35 | SendRequestのDsmlAuthRequest検証 | E-09 (Line 202-205) | ○ |
| C-36 | BeginSendRequestの列挙値検証 | E-09 (Line 272-275) | ○ |
| C-37 | BeginSendRequestのPartialResults検証 | E-09 (Line 277-285) | ○ |
| C-38 | EndSendRequestのasyncResult検証 | E-09 (Line 453-466) | ○ |
| C-39 | Disposeの後処理 | E-09 (Line 1146-1168) | ○ |

### LdapSessionOptions クラス (UT-DSP-144 - UT-DSP-161)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-40 | ReferralHopLimitの範囲検証 | E-11 (Line 165-169) | ○ |
| C-41 | PingKeepAliveTimeoutの範囲検証 | E-11 (Line 220-229) | ○ |
| C-42 | PingLimitの範囲検証 | E-11 (Line 240-244) | ○ |
| C-43 | SendTimeoutの範囲検証 | E-11 (Line 401-410) | ○ |
| C-44 | FastConcurrentBindのDispose検証 | E-11 (Line 538-541) | ○ |
| C-45 | StartTransportLayerSecurityのDispose検証 | E-11 (Line 565-568) | ○ |
| C-46 | StopTransportLayerSecurityのDispose検証 | E-11 (Line 745-748) | ○ |

### 例外クラス (UT-DSP-162 - UT-DSP-171)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-47 | LdapExceptionのエラーコード正規化 | E-12 (Line 64-68, 135) | ○ |
| C-48 | LdapErrorMappingsのマッピング | E-12 (Line 71-76) | ○ |
| C-49 | DirectoryOperationExceptionのメッセージ生成 | E-06 (Line 71-79) | ○ |
| C-50 | BerConversionExceptionのデフォルトメッセージ | E-06 (Line 92-94) | ○ |

### SearchResult関連クラス (UT-DSP-172 - UT-DSP-177)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-51 | SearchResultEntryのプロパティ | E-08 (Line 52-66) | ○ |
| C-52 | SearchResultReferenceのコピー返却 | E-08 (Line 14-30) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし
  - 全テストケースがソースコード内の実装に基づいて生成されています

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 大部分のテストケースはユニットテストレベルで検証可能
- 1: 中リスク - LdapConnection関連のテストは実際のLDAPサーバーへの接続が必要な場合がある
- 1: 中リスク - BerConverter関連のテストはプラットフォーム固有の実装（Windows/Linux）に依存する可能性
- 1: 中リスク - TLS関連のテストは適切な証明書と環境設定が必要

## 6) レビュアーチェックリスト（最小）
- [ ] DirectoryAttribute関連のテストケース（UT-DSP-001〜027）が値の型検証を網羅しているか確認
- [ ] BerConverter関連のテストケース（UT-DSP-040〜052）がエンコード/デコードの全フォーマット文字を網羅しているか確認
- [ ] LdapConnection関連のテストケース（UT-DSP-114〜143）が接続・認証・非同期処理を網羅しているか確認
- [ ] 各Controlクラスの境界値テストが適切に設定されているか確認
- [ ] 例外テストケースが適切な例外型をスローすることを確認
- [ ] プラットフォーム固有の実装（Windows/Linux）に対するテストの考慮が必要かレビュー
