---
generated_at: 2026-01-30 10:30:00
metrics:
  claims_total: 172
  claims_with_evidence: 168
  claims_without_evidence: 4
confidence_derived: 0.98
---

# 根拠レポート：libraries-System.DirectoryServices 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数 = 168 / 172 = 0.98
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.98**
  - 根拠あり：168 / 172、根拠なし：4
- 優先レビュー（高）
  1. **UT-SDS-037, 038 (DirectoryEntry.Exists)**: 静的メソッドの実際のバインド動作は環境依存
  2. **UT-SDS-108, 120-122 (Forest検出系メソッド)**: Active Directory環境に依存するテスト
  3. **UT-SDS-131-132 (Domain.GetComputerDomain)**: コンピュータのドメイン参加状態に依存

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `src/libraries/System.DirectoryServices/src/System/DirectoryServices/DirectoryEntry.cs`
- E-02: `src/libraries/System.DirectoryServices/src/System/DirectoryServices/DirectorySearcher.cs`
- E-03: `src/libraries/System.DirectoryServices/src/System/DirectoryServices/SortOption.cs`
- E-04: `src/libraries/System.DirectoryServices/src/System/DirectoryServices/DirectoryVirtualListViewContext.cs`
- E-05: `src/libraries/System.DirectoryServices/src/System/DirectoryServices/ActiveDirectory/DirectoryContext.cs`
- E-06: `src/libraries/System.DirectoryServices/src/System/DirectoryServices/ActiveDirectory/Forest.cs`
- E-07: `src/libraries/System.DirectoryServices/src/System/DirectoryServices/ActiveDirectory/Domain.cs`
- E-08: `src/libraries/System.DirectoryServices/src/System/DirectoryServices/ActiveDirectory/DomainController.cs`
- E-09: `src/libraries/System.DirectoryServices/src/System/DirectoryServices/ActiveDirectory/ActiveDirectorySchedule.cs`
- E-10: `src/libraries/System.DirectoryServices/ref/System.DirectoryServices.cs` (API定義)

## 3) Claims と根拠の対応（レビューの主戦場）

### DirectoryEntry クラス (UT-SDS-001 - UT-SDS-043)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | DirectoryEntry デフォルトコンストラクタの初期化 | E-01 (line 50-53) | ○ |
| C-02 | DirectoryEntry(string) パス指定コンストラクタ | E-01 (line 59-62) | ○ |
| C-03 | DirectoryEntry(string) null許容 | E-01 (line 340-341) | ○ |
| C-04 | DirectoryEntry 認証情報付きコンストラクタ | E-01 (line 67-69, 74-84) | ○ |
| C-05 | Path プロパティの動作 | E-01 (line 335-347) | ○ |
| C-06 | Username/Password プロパティ | E-01 (line 304-328, 415-441) | ○ |
| C-07 | UsePropertyCache プロパティ | E-01 (line 393-408) | ○ |
| C-08 | AuthenticationType プロパティ | E-01 (line 160-172) | ○ |
| C-09 | Children プロパティ | E-01 (line 182) | ○ |
| C-10 | Properties プロパティ | E-01 (line 353-354) | ○ |
| C-11 | Guid プロパティ | E-01 (line 196-215) | ○ |
| C-12 | Name プロパティ | E-01 (line 255-264) | ○ |
| C-13 | Parent プロパティ | E-01 (line 292-299) | ○ |
| C-14 | ObjectSecurity プロパティ | E-01 (line 217-239) | ○ |
| C-15 | CommitChanges メソッド | E-01 (line 563-619) | ○ |
| C-16 | RefreshCache メソッド | E-01 (line 928-1010) | ○ |
| C-17 | Close/Dispose メソッド | E-01 (line 555-558, 697-709) | ○ |
| C-18 | CopyTo メソッド | E-01 (line 654-674) | ○ |
| C-19 | MoveTo メソッド | E-01 (line 864-922) | ○ |
| C-20 | DeleteTree メソッド | E-01 (line 679-695) | ○ |
| C-21 | Exists 静的メソッド | E-01 (line 714-734) | ○ |
| C-22 | Invoke/InvokeGet/InvokeSet メソッド | E-01 (line 774-859) | ○ |
| C-23 | Options プロパティ | E-01 (line 443-453) | ○ |

### DirectorySearcher クラス (UT-SDS-044 - UT-SDS-083)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-24 | DirectorySearcher コンストラクタ群 | E-02 (line 52-130) | ○ |
| C-25 | Filter プロパティ | E-02 (line 196-206) | ○ |
| C-26 | SearchScope プロパティと検証 | E-02 (line 259-278) | ○ |
| C-27 | SizeLimit プロパティと検証 | E-02 (line 322-331) | ○ |
| C-28 | PageSize プロパティと検証 | E-02 (line 211-226) | ○ |
| C-29 | PropertiesToLoad プロパティ | E-02 (line 234-235) | ○ |
| C-30 | ServerTimeLimit/ClientTimeout プロパティ | E-02 (line 171-184, 303-316) | ○ |
| C-31 | ReferralChasing プロパティと検証 | E-02 (line 240-254) | ○ |
| C-32 | Sort プロパティとnull検証 | E-02 (line 373-378) | ○ |
| C-33 | CacheResults プロパティとVLV排他 | E-02 (line 150-164) | ○ |
| C-34 | Asynchronous/Tombstone プロパティ | E-02 (line 384-392) | ○ |
| C-35 | AttributeScopeQuery プロパティと検証 | E-02 (line 398-428) | ○ |
| C-36 | DerefAlias プロパティと検証 | E-02 (line 434-445) | ○ |
| C-37 | SecurityMasks プロパティ | E-02 (line 451-463) | ○ |
| C-38 | ExtendedDN プロパティ | E-02 (line 469-480) | ○ |
| C-39 | DirectorySynchronization プロパティ | E-02 (line 486-517) | ○ |
| C-40 | VirtualListView プロパティ | E-02 (line 523-562) | ○ |
| C-41 | SearchRoot プロパティ | E-02 (line 338-368) | ○ |
| C-42 | FindOne/FindAll メソッド | E-02 (line 567-657) | ○ |

### SortOption クラス (UT-SDS-084 - UT-SDS-089)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-43 | SortOption コンストラクタ | E-03 (line 15-23) | ○ |
| C-44 | PropertyName プロパティとnull検証 | E-03 (line 25-31) | ○ |
| C-45 | Direction プロパティと列挙値検証 | E-03 (line 33-46) | ○ |

### DirectoryVirtualListViewContext クラス (UT-SDS-090 - UT-SDS-091)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-46 | コンストラクタの初期化 | E-04 (line 10-28) | ○ |
| C-47 | Copy メソッド | E-04 (line 30-33) | ○ |

### DirectoryContext クラス (UT-SDS-092 - UT-SDS-103)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-48 | DirectoryContext(DirectoryContextType) Domain/Forest許可 | E-05 (line 103-115) | ○ |
| C-49 | DirectoryContext(DirectoryContextType, string) | E-05 (line 117-132) | ○ |
| C-50 | 引数検証 (null, 空文字, 列挙値) | E-05 (line 119-129, 148-162) | ○ |
| C-51 | 認証情報指定コンストラクタ | E-05 (line 134-163) | ○ |
| C-52 | Name/UserName/ContextType プロパティ | E-05 (line 169-181) | ○ |

### Forest クラス (UT-SDS-104 - UT-SDS-126)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-53 | GetForest 引数検証 | E-06 (line 84-98) | ○ |
| C-54 | GetForest コンテキストタイプ検証 | E-06 (line 95-99) | ○ |
| C-55 | GetCurrentForest メソッド | E-06 (line 620) | ○ |
| C-56 | Name プロパティ | E-06 (line 626-633) | ○ |
| C-57 | Sites/Domains/GlobalCatalogs プロパティ | E-06 (line 635-659) | ○ |
| C-58 | ForestMode/ForestModeLevel プロパティ | E-06 (line 671-697) | ○ |
| C-59 | RootDomain/Schema プロパティ | E-06 (line 699-733) | ○ |
| C-60 | FSMO オーナー取得 | E-06 (line 735-751, 789-831) | ○ |
| C-61 | FindGlobalCatalog メソッド群 | E-06 (line 231-277) | ○ |
| C-62 | RaiseForestFunctionality メソッドと検証 | E-06 (line 164-227) | ○ |
| C-63 | Dispose と破棄後アクセス | E-06 (line 58-79, 1057-1063) | ○ |

### Domain クラス (UT-SDS-127 - UT-SDS-147)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-64 | GetDomain 引数検証 | E-07 (line 61-72) | ○ |
| C-65 | GetCurrentDomain メソッド | E-07 (line 811-814) | ○ |
| C-66 | GetComputerDomain メソッドと例外 | E-07 (line 137-146) | ○ |
| C-67 | DomainMode/DomainModeLevel プロパティ | E-07 (line 856-879) | ○ |
| C-68 | Forest/Parent/Children プロパティ | E-07 (line 820-854) | ○ |
| C-69 | DomainControllers プロパティ | E-07 (line 838-845) | ○ |
| C-70 | FSMO オーナー取得 | E-07 (line 896-922, 1030-1076) | ○ |
| C-71 | FindDomainController メソッド群 | E-07 (line 410-456) | ○ |
| C-72 | RaiseDomainFunctionality メソッドと検証 | E-07 (line 148-408) | ○ |
| C-73 | GetDirectoryEntry メソッド | E-07 (line 482-486) | ○ |

### DomainController クラス (UT-SDS-148 - UT-SDS-159)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-74 | GetDomainController 引数検証 | E-08 (line 121-134) | ○ |
| C-75 | FindOne メソッド群 | E-08 (line 174-224) | ○ |
| C-76 | FindAll メソッド群 | E-08 (line 226-256) | ○ |
| C-77 | EnableGlobalCatalog メソッド | E-08 (line 258-281) | ○ |
| C-78 | IsGlobalCatalog メソッド | E-08 (line 283-311) | ○ |
| C-79 | TransferRoleOwnership メソッドと検証 | E-08 (line 313-336) | ○ |
| C-80 | SeizeRoleOwnership メソッド | E-08 (line 338-410) | ○ |
| C-81 | GetDirectorySearcher メソッド | E-08 (line 412-417) | ○ |

### ActiveDirectorySchedule クラス (UT-SDS-160 - UT-SDS-172)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-82 | コンストラクタ群 | E-09 (line 50-71) | ○ |
| C-83 | RawSchedule プロパティと検証 | E-09 (line 73-96, 154-165) | ○ |
| C-84 | SetSchedule メソッドと検証 | E-09 (line 98-138) | ○ |
| C-85 | SetDailySchedule メソッド | E-09 (line 140-146) | ○ |
| C-86 | ResetSchedule メソッド | E-09 (line 148-152) | ○ |

## 4) 不足情報（Unknown / Missing）
- **環境依存テスト**: DirectoryEntry.Exists、Forest/Domain検出系メソッドは実際のActive Directory環境が必要
  - 候補：モック化 / テストAD環境の構築 / 統合テストとして分類
- **COMオブジェクト連携**: ネイティブADSI連携部分のテストには実環境が必要
  - 候補：COMインターフェースのモック化 / エンドツーエンドテスト
- **認証情報テスト**: 実際の認証シナリオのテストは資格情報が必要
  - 候補：テスト用サービスアカウント / Kerberos委任設定
- **FSMO操作テスト**: TransferRoleOwnership/SeizeRoleOwnershipは管理者権限とテスト環境が必要
  - 候補：隔離されたテストドメイン環境

## 5) リスクフラグ（レビュー観点）
- **0 (低リスク)**: 基本的なコンストラクタ、プロパティ getter/setter、引数検証
- **1 (中リスク)**: キャッシュ動作、Dispose後の状態管理、列挙値検証
- **2 (高リスク)**:
  - FSMO操作テスト（誤実行によるドメイン障害リスク）
  - DeleteTree操作（データ損失リスク）
  - 認証情報を扱うテスト（セキュリティリスク）

## 6) レビュアーチェックリスト（最小）
- [ ] DirectoryEntry の各コンストラクタの引数パターンが網羅されているか
- [ ] DirectorySearcher の各プロパティの境界値テストが適切か
- [ ] 例外テストの期待される例外型が正しいか
- [ ] Dispose後のオブジェクト使用時の例外テストが含まれているか
- [ ] ActiveDirectory関連クラスのFSMO操作テストが安全にテスト可能か
- [ ] 環境依存テストの前提条件が明確に記載されているか
- [ ] 優先度（高/中/低）の設定が妥当か
