---
generated_at: 2026-01-30 17:30:00
metrics:
  claims_total: 218
  claims_with_evidence: 218
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：libraries-System.Drawing.Primitives 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各テストケースに対して、ソースコード内のメソッド・プロパティ定義が存在するか
2. **根拠との整合性**：テストケースの入力値・期待結果がソースコードの実装と矛盾していないか
3. **網羅性**：対象モジュール内のpublicメソッド・プロパティを適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：218 / 218、根拠なし：0
- 優先レビュー（高）
  1. **Color.FromArgb各種オーバーロード**：境界値テストの網羅性確認
  2. **Rectangle/RectangleF交差・包含判定**：境界条件の確認
  3. **ColorTranslator変換メソッド**：HTMLシステム色マッピングの完全性確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `src/libraries/System.Drawing.Primitives/src/System/Drawing/Color.cs`
- E-02: `src/libraries/System.Drawing.Primitives/src/System/Drawing/Point.cs`
- E-03: `src/libraries/System.Drawing.Primitives/src/System/Drawing/PointF.cs`
- E-04: `src/libraries/System.Drawing.Primitives/src/System/Drawing/Size.cs`
- E-05: `src/libraries/System.Drawing.Primitives/src/System/Drawing/SizeF.cs`
- E-06: `src/libraries/System.Drawing.Primitives/src/System/Drawing/Rectangle.cs`
- E-07: `src/libraries/System.Drawing.Primitives/src/System/Drawing/RectangleF.cs`
- E-08: `src/libraries/System.Drawing.Primitives/src/System/Drawing/ColorTranslator.cs`
- E-09: `src/libraries/System.Drawing.Primitives/src/System/Drawing/KnownColor.cs`
- E-10: `src/libraries/System.Drawing.Primitives/src/System/Drawing/KnownColorTable.cs`
- E-11: `src/libraries/System.Drawing.Primitives/src/System/Drawing/KnownColorNames.cs`
- E-12: `src/libraries/System.Drawing.Primitives/src/System/Drawing/SystemColors.cs`

## 3) Claims と根拠の対応（レビューの主戦場）

### Color構造体（UT-SDP-001 ~ UT-SDP-045）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | FromArgb(int argb)は有効なARGB値からColorを生成する | E-01 L443 | ○ |
| C-02 | FromArgb(int,int,int,int)は範囲チェックを行う | E-01 L445-458, CheckByte L432-439 | ○ |
| C-03 | FromArgb(int,int,int,int)で範囲外の値はArgumentException | E-01 L434-438 | ○ |
| C-04 | FromArgb(int,Color)はアルファ値を変更したColorを返す | E-01 L460-468 | ○ |
| C-05 | FromKnownColorは有効なKnownColorからColorを生成 | E-01 L472-473 | ○ |
| C-06 | FromNameは色名からColorを生成、未知の名前は名前付きColorとして処理 | E-01 L475-483 | ○ |
| C-07 | R/G/B/Aプロパティは正しいビットシフトで各成分を返す | E-01 L364-370 | ○ |
| C-08 | IsKnownColor/IsEmpty/IsNamedColor/IsSystemColorは正しい状態を返す | E-01 L372-378 | ○ |
| C-09 | Nameプロパティは状態に応じた名前を返す | E-01 L389-411 | ○ |
| C-10 | GetBrightness/GetHue/GetSaturationはHSL計算を行う | E-01 L517-566 | ○ |
| C-11 | ToArgb/ToKnownColorは適切な変換を行う | E-01 L568-570 | ○ |
| C-12 | 等価演算子とEquals/GetHashCodeは正しく動作する | E-01 L577-602 | ○ |

### Point構造体（UT-SDP-046 ~ UT-SDP-067）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-13 | コンストラクタ(int,int)/(Size)/(int dw)は正しく初期化する | E-02 L28-50 | ○ |
| C-14 | IsEmptyはx==0 && y==0で判定する | E-02 L56 | ○ |
| C-15 | X/Yプロパティはget/setが正しく動作する | E-02 L61-74 | ○ |
| C-16 | 暗黙/明示変換演算子は型変換を行う | E-02 L79, L84 | ○ |
| C-17 | +/-演算子はPoint+Sizeの加減算を行う | E-02 L89, L94 | ○ |
| C-18 | Add/Subtract静的メソッドは演算子と同等の処理を行う | E-02 L113, L118 | ○ |
| C-19 | Ceiling/Truncate/RoundはPointFからPointへの変換を行う | E-02 L123, L128, L133 | ○ |
| C-20 | Offset(int,int)/(Point)は座標を移動する | E-02 L151-163 | ○ |

### PointF構造体（UT-SDP-068 ~ UT-SDP-078）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-21 | コンストラクタ(float,float)/(Vector2)は正しく初期化する | E-03 L28-42 | ○ |
| C-22 | ToVector2はVector2への変換を行う | E-03 L47 | ○ |
| C-23 | +/-演算子はPointF+Size/SizeFの加減算を行う | E-03 L86-101 | ○ |
| C-24 | Add/Subtract静的メソッドはSize/SizeFとの演算を行う | E-03 L120-135 | ○ |

### Size構造体（UT-SDP-079 ~ UT-SDP-101）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-25 | コンストラクタ(int,int)/(Point)は正しく初期化する | E-04 L29-42 | ○ |
| C-26 | IsEmptyはwidth==0 && height==0で判定する | E-04 L127 | ○ |
| C-27 | 暗黙変換演算子SizeFへの変換を行う | E-04 L47 | ○ |
| C-28 | +/-/*// 演算子は算術演算を行う | E-04 L52-106 | ○ |
| C-29 | Ceiling/Truncate/RoundはSizeFからSizeへの変換を行う | E-04 L156-174 | ○ |

### SizeF構造体（UT-SDP-102 ~ UT-SDP-120）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-30 | 各種コンストラクタは正しく初期化する | E-05 L29-67 | ○ |
| C-31 | ToVector2/ToPointF/ToSizeは型変換を行う | E-05 L58, L173, L175 | ○ |
| C-32 | +/-/*// 演算子は算術演算を行う | E-05 L82-112 | ○ |

### Rectangle構造体（UT-SDP-121 ~ UT-SDP-156）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-33 | コンストラクタとFromLTRBは正しく初期化する | E-06 L28-51 | ○ |
| C-34 | Location/Sizeプロパティはget/setが正しく動作する | E-06 L58-80 | ○ |
| C-35 | Left/Top/Right/Bottomは計算された座標を返す | E-06 L125-146 | ○ |
| C-36 | IsEmptyはすべてのフィールドが0で判定する | E-06 L153 | ○ |
| C-37 | Contains(int,int)/(Point)/(Rectangle)は包含判定を行う | E-06 L223-237 | ○ |
| C-38 | Inflate(int,int)/(Size)/静的メソッドは膨張処理を行う | E-06 L244-269 | ○ |
| C-39 | Intersect/IntersectsWith/Unionは交差・結合処理を行う | E-06 L274-321 | ○ |
| C-40 | Offset(int,int)/(Point)は座標を移動する | E-06 L326-338 | ○ |
| C-41 | Ceiling/Truncate/Roundは変換処理を行う | E-06 L177-217 | ○ |

### RectangleF構造体（UT-SDP-157 ~ UT-SDP-188）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-42 | 各種コンストラクタとFromLTRBは正しく初期化する | E-07 L31-82 | ○ |
| C-43 | ToVector4はVector4への変換を行う | E-07 L66 | ○ |
| C-44 | IsEmptyはWidth<=0またはHeight<=0で判定する | E-07 L183 | ○ |
| C-45 | Contains/Inflate/Intersect/Union等の幾何演算を行う | E-07 L208-303 | ○ |
| C-46 | RectangleからRectangleFへの暗黙変換を行う | E-07 L323 | ○ |

### ColorTranslator（UT-SDP-189 ~ UT-SDP-207）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-47 | ToWin32はCOLORREF形式(BGR)への変換を行う | E-08 L33-40 | ○ |
| C-48 | ToOle/FromOleはOLE色形式との相互変換を行う | E-08 L45-209 | ○ |
| C-49 | FromWin32はFromOleを呼び出す | E-08 L214-217 | ○ |
| C-50 | FromHtmlは#RRGGBB/#RGB/名前/システム色を解析する | E-08 L222-283 | ○ |
| C-51 | ToHtmlはシステム色/名前付き色/ARGB色を文字列化する | E-08 L288-398 | ○ |
| C-52 | LightGray/LightGreyの特殊ケースを処理する | E-08 L253-256, L381-385 | ○ |

### KnownColor/SystemColors（UT-SDP-208 ~ UT-SDP-218）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-53 | KnownColor列挙体は1から始まりRebeccaPurpleで終わる | E-09 L20, L203 | ○ |
| C-54 | SystemColorsの各プロパティはFromKnownColorを呼び出す | E-12 L12-53 | ○ |
| C-55 | UseAlternativeColorSetはs_useAlternativeColorSetを制御する | E-12 L73-77 | ○ |
| C-56 | 静的色プロパティ(Red/Green/Blue等)は正しいKnownColorを返す | E-01 L24-310 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（すべてのテストケースにソースコードの根拠あり）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべてのテストケースがソースコードに基づいて生成されている
- 境界値テスト（Contains, Intersect等）については実装詳細の確認を推奨

## 6) レビュアーチェックリスト（最小）
- [ ] Color.FromArgbの境界値テスト（0, 255, -1, 256）が十分か確認
- [ ] Rectangle/RectangleFの包含判定の境界条件（x < X + Width vs x <= X + Width）を確認
- [ ] ColorTranslator.FromHtmlの不正入力（無効な16進数等）のテストケース追加を検討
- [ ] GetHue/GetSaturation/GetBrightnessの計算精度テストの追加を検討
- [ ] オーバーフロー時の挙動（uncheckedブロック内の演算）のテストケース追加を検討
