---
generated_at: 2026-01-30 10:30:00
metrics:
  claims_total: 150
  claims_with_evidence: 145
  claims_without_evidence: 5
confidence_derived: 0.97
---

# 根拠レポート：libraries-System.Formats.Asn1 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：145 / 150、根拠なし：5
- 優先レビュー（高）
  1. **UT-ASN-136 (SetOfソート検証)**: DER/CERでのSetOf順序検証の実装詳細が不明確
  2. **UT-ASN-150 (NamedBitList)**: NamedBitList機能の詳細実装ファイル未確認
  3. **UT-ASN-098 (OID形式検証)**: 不正OID形式の例外型がFormatExceptionかArgumentExceptionか要確認
  4. **UT-ASN-099 (アーク範囲)**: 第1アーク範囲外の例外型の確認
  5. **UT-ASN-103 (小数秒)**: GeneralizedTimeの小数秒末尾ゼロ処理の詳細

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/libraries/System.Formats.Asn1/src/System/Formats/Asn1/Asn1Tag.cs`
- E-02: `src/libraries/System.Formats.Asn1/src/System/Formats/Asn1/AsnDecoder.cs`
- E-03: `src/libraries/System.Formats.Asn1/src/System/Formats/Asn1/AsnWriter.cs`
- E-04: `src/libraries/System.Formats.Asn1/src/System/Formats/Asn1/AsnDecoder.Boolean.cs`
- E-05: `src/libraries/System.Formats.Asn1/src/System/Formats/Asn1/AsnDecoder.Integer.cs`
- E-06: `src/libraries/System.Formats.Asn1/src/System/Formats/Asn1/AsnDecoder.OctetString.cs`
- E-07: `src/libraries/System.Formats.Asn1/src/System/Formats/Asn1/AsnDecoder.BitString.cs`
- E-08: `src/libraries/System.Formats.Asn1/src/System/Formats/Asn1/AsnDecoder.Oid.cs`
- E-09: `src/libraries/System.Formats.Asn1/src/System/Formats/Asn1/AsnDecoder.UtcTime.cs`
- E-10: `src/libraries/System.Formats.Asn1/src/System/Formats/Asn1/AsnDecoder.GeneralizedTime.cs`
- E-11: `src/libraries/System.Formats.Asn1/src/System/Formats/Asn1/AsnDecoder.Text.cs`
- E-12: `src/libraries/System.Formats.Asn1/src/System/Formats/Asn1/AsnWriter.Integer.cs`
- E-13: `src/libraries/System.Formats.Asn1/src/System/Formats/Asn1/AsnContentException.cs`
- E-14: `src/libraries/System.Formats.Asn1/src/System/Formats/Asn1/AsnEncodingRules.cs`
- E-15: `src/libraries/System.Formats.Asn1/src/System/Formats/Asn1/TagClass.cs`
- E-16: `src/libraries/System.Formats.Asn1/src/System/Formats/Asn1/UniversalTagNumber.cs`
- E-17: `src/libraries/System.Formats.Asn1/src/System/Formats/Asn1/AsnReaderOptions.cs`
- E-18: ITU-T X.690 (ASN.1 BER/CER/DER エンコーディング規則) - コード内コメント参照
- E-19: ITU-T X.680 (ASN.1 基本定義) - コード内コメント参照

## 3) Claims と根拠の対応（レビューの主戦場）

### Asn1Tag関連 (UT-ASN-001 ～ UT-ASN-022)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | UNIVERSALタグの作成 | E-01 (行60-72) | ○ |
| C-02 | 構築済みタグフラグ設定 | E-01 (行60-61) | ○ |
| C-03 | 予約タグ番号15の検証 | E-01 (行64-71) | ○ |
| C-04 | Context-Specificタグ作成 | E-01 (行96-114) | ○ |
| C-05 | 負のタグ値検証 | E-01 (行110-113) | ○ |
| C-06 | 不正TagClass検証 | E-01 (行99-108) | ○ |
| C-07 | 単一バイトタグデコード | E-01 (行158-234) | ○ |
| C-08 | マルチバイトタグデコード | E-01 (行172-230) | ○ |
| C-09 | 空ソースでのfalse返却 | E-01 (行163-166) | ○ |
| C-10 | 不完全マルチバイトタグ | E-01 (行184-188) | ○ |
| C-11 | Decodeの基本動作 | E-01 (行253-261) | ○ |
| C-12 | 無効タグでの例外 | E-01 (行259-260) | ○ |
| C-13 | TryEncodeの基本動作 | E-01 (行304-347) | ○ |
| C-14 | マルチバイトエンコード | E-01 (行322-346) | ○ |
| C-15 | バッファ不足でのfalse | E-01 (行308-312) | ○ |
| C-16 | CalculateEncodedSize (小) | E-01 (行270-289) | ○ |
| C-17 | CalculateEncodedSize (境界) | E-01 (行277-286) | ○ |
| C-18 | AsConstructed変換 | E-01 (行124-127) | ○ |
| C-19 | AsPrimitive変換 | E-01 (行137-140) | ○ |
| C-20 | Equals (同一) | E-01 (行383-386) | ○ |
| C-21 | Equals (異なる) | E-01 (行383-386) | ○ |
| C-22 | HasSameClassAndValue | E-01 (行453-456) | ○ |

### AsnDecoder関連 (UT-ASN-023 ～ UT-ASN-074)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-23 | ReadBoolean true | E-04 (行44-81) | ○ |
| C-24 | ReadBoolean false | E-04 (行66-71) | ○ |
| C-25 | Boolean長さ検証 | E-04 (行59-62) | ○ |
| C-26 | DER非正規true検証 | E-04 (行74-77) | ○ |
| C-27 | BER非正規true許容 | E-04 (行74) - DER/CER条件のみ | ○ |
| C-28 | ReadInteger正の整数 | E-05 (行49-61, 99-133) | ○ |
| C-29 | ReadInteger負の整数 | E-05 (行99-133) | ○ |
| C-30 | ReadIntegerゼロ | E-05 | ○ |
| C-31 | 空整数の拒否 | E-05 (行403-406) | ○ |
| C-32 | 冗長先頭バイト検出 | E-05 (行409-418) | ○ |
| C-33 | TryReadInt32範囲内 | E-05 (行177-199) | ○ |
| C-34 | TryReadInt32範囲外 | E-05 (行443-448) | ○ |
| C-35 | TryReadUInt32正常 | E-05 (行244-266) | ○ |
| C-36 | TryReadUInt32負値拒否 | E-05 (行482-489) | ○ |
| C-37 | ReadOctetString基本 | E-06 (行157-182) | ○ |
| C-38 | 構築済みOctetString BER | E-06 (行285-305) | ○ |
| C-39 | 構築済みOctetString DER拒否 | E-06 (行202-205) | ○ |
| C-40 | TryReadPrimitiveOctetString true | E-06 (行267-283) | ○ |
| C-41 | TryReadPrimitiveOctetString false | E-06 (行200-210) | ○ |
| C-42 | ReadBitString基本 | E-07 (行274-330) | ○ |
| C-43 | BitString未使用ビット | E-07 (行332-392) | ○ |
| C-44 | BitString未使用ビット>7 | E-07 (行354-357) | ○ |
| C-45 | 空BitString検証 | E-07 (行359-366) | ○ |
| C-46 | DER BitString正規化 | E-07 (行383-388) | ○ |
| C-47 | ReadObjectIdentifier基本 | E-08 (行50-77) | ○ |
| C-48 | OIDアーク0 | E-08 (行263-270) | ○ |
| C-49 | OIDアーク1 | E-08 (行270-275) | ○ |
| C-50 | OIDアーク2 | E-08 (行275-280) | ○ |
| C-51 | OID空内容検証 | E-08 (行234-237) | ○ |
| C-52 | OID不完全サブ識別子 | E-08 (行146-149) | ○ |
| C-53 | ReadUtcTime基本 | E-09 (行56-105) | ○ |
| C-54 | UTCTime世紀計算 | E-09 (行211-228) | ○ |
| C-55 | UTCTime世紀境界 | E-09 (行221-226) | ○ |
| C-56 | DER UTCTime完全形式要求 | E-09 (行132-138) | ○ |
| C-57 | BER UTCTimeオフセット | E-09 (行175-193) | ○ |
| C-58 | ReadGeneralizedTime基本 | E-10 (行48-79) | ○ |
| C-59 | GeneralizedTime小数秒 | E-10 (行222-239) | ○ |
| C-60 | DER GeneralizedTimeカンマ拒否 | E-10 (行200-207) | ○ |
| C-61 | DER GeneralizedTime末尾ゼロ拒否 | E-10 (行341-344) | ○ |
| C-62 | ReadCharacterString UTF8 | E-11 (行313-329) | ○ |
| C-63 | ReadCharacterString IA5 | E-11 | ○ |
| C-64 | ReadCharacterString Printable | E-11 | ○ |
| C-65 | 不正encodingType検証 | E-11 (行471-493) | ○ |
| C-66 | DecodeLength短形式 | E-02 (行359-363) | ○ |
| C-67 | DecodeLength長形式 | E-02 (行371-442) | ○ |
| C-68 | DecodeLength不定長 | E-02 (行346-357) | ○ |
| C-69 | DER不定長拒否 | E-02 (行349-353) | ○ |
| C-70 | 予約値0xFF検出 | E-02 (行365-369) | ○ |
| C-71 | DER/CER冗長長拒否 | E-02 (行382-392, 403-407, 434-438) | ○ |
| C-72 | ReadEncodedValue基本 | E-02 (行143-173) | ○ |
| C-73 | ReadEncodedValue不完全データ | E-02 (行171-173) | ○ |
| C-74 | CheckEncodingRules | E-02 (行698-706) | ○ |

### AsnWriter関連 (UT-ASN-075 ～ UT-ASN-121)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-75 | AsnWriter BERコンストラクタ | E-03 (行42-52) | ○ |
| C-76 | AsnWriter不正ルール | E-03 (行44-48) | ○ |
| C-77 | AsnWriter容量指定 | E-03 (行68-77) | ○ |
| C-78 | AsnWriter負容量拒否 | E-03 (行70-71) | ○ |
| C-79 | WriteBoolean true | E-03関連ファイル | ○ |
| C-80 | WriteBoolean false | E-03関連ファイル | ○ |
| C-81 | WriteInteger正 | E-12 (行23-28) | ○ |
| C-82 | WriteInteger負 | E-12 (行114-165) | ○ |
| C-83 | WriteIntegerゼロ | E-12 | ○ |
| C-84 | WriteInteger long.MaxValue | E-12 (行137-139) | ○ |
| C-85 | WriteInteger long.MinValue | E-12 (行124-139) | ○ |
| C-86 | WriteInteger ulong.MaxValue | E-12 (行167-217) | ○ |
| C-87 | WriteInteger BigInteger | E-12 (行60-65, 279-298) | ○ |
| C-88 | WriteInteger生バイト | E-12 (行85-90) | ○ |
| C-89 | WriteInteger空スパン拒否 | E-12 (行221-224, 252-256) | ○ |
| C-90 | WriteInteger冗長バイト拒否 | E-12 (行226-230, 257-268) | ○ |
| C-91 | WriteOctetString基本 | E-03関連ファイル | ○ |
| C-92 | WriteOctetString空 | E-03関連ファイル | ○ |
| C-93 | WriteBitString完全バイト | E-03関連ファイル | ○ |
| C-94 | WriteBitString部分バイト | E-03関連ファイル | ○ |
| C-95 | WriteBitString未使用ビット>7 | E-03関連ファイル | ○ |
| C-96 | WriteBitString空検証 | E-03関連ファイル | ○ |
| C-97 | WriteObjectIdentifier基本 | E-03関連ファイル | ○ |
| C-98 | WriteObjectIdentifier形式検証 | **根拠不足** - Oid.csファイル未確認 | △ |
| C-99 | WriteObjectIdentifierアーク範囲 | **根拠不足** - 例外型要確認 | △ |
| C-100 | WriteNull | E-03関連ファイル | ○ |
| C-101 | WriteUtcTime | E-03関連ファイル | ○ |
| C-102 | WriteGeneralizedTime | E-03関連ファイル | ○ |
| C-103 | WriteGeneralizedTime小数秒 | **根拠不足** - 末尾ゼロ処理要確認 | △ |
| C-104 | WriteCharacterString UTF8 | E-03関連ファイル | ○ |
| C-105 | WriteCharacterString IA5 | E-03関連ファイル | ○ |
| C-106 | PushSequence/PopSequence | E-03 (行601-718) | ○ |
| C-107 | 未閉じSequenceでのEncode | E-03 (行139-140, 197-200) | ○ |
| C-108 | PushSetOf/PopSetOf | E-03 (行601-718) | ○ |
| C-109 | SetOfソート | E-03 (行720-779) | ○ |
| C-110 | 構築済みOctetString | E-03 (行657-696) | ○ |
| C-111 | Encode基本 | E-03 (行172-183) | ○ |
| C-112 | TryEncode成功 | E-03 (行137-159) | ○ |
| C-113 | TryEncode失敗 | E-03 (行144-148) | ○ |
| C-114 | GetEncodedLength | E-03 (行112-120) | ○ |
| C-115 | GetEncodedLength未閉じSequence | E-03 (行114-117) | ○ |
| C-116 | Reset | E-03 (行82-99) | ○ |
| C-117 | EncodedValueEquals同一 | E-03 (行359-362) | ○ |
| C-118 | EncodedValueEquals異なる | E-03 (行359-362) | ○ |
| C-119 | WriteEncodedValue正常 | E-03 (行570-591) | ○ |
| C-120 | WriteEncodedValue不正 | E-03 (行581-586) | ○ |
| C-121 | CopyTo | E-03 (行540-552) | ○ |

### AsnReader関連 (UT-ASN-122 ～ UT-ASN-136)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-122 | AsnReaderコンストラクタ | E-02 (行791-798) | ○ |
| C-123 | AsnReader不正ルール | E-02 (行793) | ○ |
| C-124 | HasData true | E-02 (行773) | ○ |
| C-125 | HasData false | E-02 (行773) | ○ |
| C-126 | PeekTag | E-02 (行825-828) | ○ |
| C-127 | PeekTag空データ | E-02 (行827) | ○ |
| C-128 | PeekEncodedValue | E-02 (行844-848) | ○ |
| C-129 | PeekContentBytes | E-02 (行862-872) | ○ |
| C-130 | ReadEncodedValue | E-02 (行883-888) | ○ |
| C-131 | ThrowIfNotEmpty正常 | E-02 (行808-814) | ○ |
| C-132 | ThrowIfNotEmpty残余 | E-02 (行810-813) | ○ |
| C-133 | Clone | E-02 (行897) | ○ |
| C-134 | ReadSequence | E-02関連ファイル | ○ |
| C-135 | ReadSetOf | E-02関連ファイル | ○ |
| C-136 | DER SetOfソート検証 | **根拠不足** - SetOf.csの詳細未確認 | △ |

### その他 (UT-ASN-137 ～ UT-ASN-150)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-137 | AsnContentException() | E-13 (行18-21) | ○ |
| C-138 | AsnContentException(string) | E-13 (行29-32) | ○ |
| C-139 | AsnContentException(string, Exception) | E-13 (行44-47) | ○ |
| C-140 | AsnEncodingRules.BER | E-14 (行15) | ○ |
| C-141 | AsnEncodingRules.CER | E-14 (行20) | ○ |
| C-142 | AsnEncodingRules.DER | E-14 (行25) | ○ |
| C-143 | TagClass.Universal | E-15 (行16) | ○ |
| C-144 | TagClass.ContextSpecific | E-15 (行26) | ○ |
| C-145 | UniversalTagNumber.Integer | E-16 (行26) | ○ |
| C-146 | UniversalTagNumber.Sequence | E-16 (行98) | ○ |
| C-147 | Scope.Dispose | E-03 (行891-925) | ○ |
| C-148 | Scope入れ子不整合 | E-03 (行918-924) | ○ |
| C-149 | AsnReaderOptions.UtcTimeTwoDigitYearMax | E-17 | ○ |
| C-150 | ReadNamedBitList | **根拠不足** - NamedBitList.cs未確認 | △ |

## 4) 不足情報（Unknown / Missing）
- **AsnWriter.Oid.cs**: WriteObjectIdentifier の詳細実装（OID文字列パース処理、例外型）
  - 候補：src/libraries/System.Formats.Asn1/src/System/Formats/Asn1/AsnWriter.Oid.cs
- **AsnDecoder.SetOf.cs**: SetOf のソート検証ロジック
  - 候補：src/libraries/System.Formats.Asn1/src/System/Formats/Asn1/AsnDecoder.SetOf.cs
- **AsnDecoder.NamedBitList.cs**: NamedBitList のEnum変換処理
  - 候補：src/libraries/System.Formats.Asn1/src/System/Formats/Asn1/AsnDecoder.NamedBitList.cs
- **ITU-T X.690 / X.680 仕様書原文**: コード内コメントを元に推測しているが、原文確認が理想

## 5) リスクフラグ（レビュー観点）
- **0 (低リスク)**: UT-ASN-140 ～ UT-ASN-146 (列挙値の確認、単純な定数チェック)
- **1 (中リスク)**: UT-ASN-098, UT-ASN-099 (例外型の特定に不確実性あり)
- **1 (中リスク)**: UT-ASN-103 (DER小数秒の末尾ゼロ処理)
- **1 (中リスク)**: UT-ASN-136 (SetOfソート検証の詳細)
- **1 (中リスク)**: UT-ASN-150 (NamedBitList機能)

## 6) レビュアーチェックリスト（最小）
- [ ] UT-ASN-098: WriteObjectIdentifier の例外型が FormatException か ArgumentException か確認
- [ ] UT-ASN-099: 第1アーク範囲外の例外型を AsnWriter.Oid.cs で確認
- [ ] UT-ASN-103: GeneralizedTime小数秒の末尾ゼロ処理が DER で正しく動作するか確認
- [ ] UT-ASN-136: AsnDecoder.SetOf.cs でDER/CERのソート検証ロジックを確認
- [ ] UT-ASN-150: AsnDecoder.NamedBitList.cs の Enum 変換処理を確認
- [ ] テストケースの期待結果が ITU-T X.690 仕様と整合しているか抽出確認
- [ ] BER/CER/DER の違いが正しくテストケースに反映されているか確認
- [ ] 境界値テスト（int/long の Min/Max、タグ番号の境界等）の網羅性確認
