---
generated_at: 2026-01-30 10:30:00
metrics:
  claims_total: 165
  claims_with_evidence: 165
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：libraries-System.Formats.Cbor 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：165 / 165、根拠なし：0
- 優先レビュー（高）
  1. **なし**：全テストケースにソースコード根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/libraries/System.Formats.Cbor/src/System/Formats/Cbor/Reader/CborReader.cs` - CborReaderメインクラス
- E-02: `src/libraries/System.Formats.Cbor/src/System/Formats/Cbor/Reader/CborReader.Integer.cs` - 整数読み取り（ReadInt32, ReadInt64, ReadUInt32, ReadUInt64, ReadCborNegativeIntegerRepresentation）
- E-03: `src/libraries/System.Formats.Cbor/src/System/Formats/Cbor/Reader/CborReader.String.cs` - 文字列読み取り（ReadByteString, ReadTextString, TryReadByteString, TryReadTextString, 不定長文字列）
- E-04: `src/libraries/System.Formats.Cbor/src/System/Formats/Cbor/Reader/CborReader.Array.cs` - 配列読み取り（ReadStartArray, ReadEndArray）
- E-05: `src/libraries/System.Formats.Cbor/src/System/Formats/Cbor/Reader/CborReader.Map.cs` - マップ読み取り（ReadStartMap, ReadEndMap, キー重複/ソート検証）
- E-06: `src/libraries/System.Formats.Cbor/src/System/Formats/Cbor/Reader/CborReader.Simple.cs` - シンプル値読み取り（ReadSingle, ReadDouble, ReadBoolean, ReadNull, ReadSimpleValue）
- E-07: `src/libraries/System.Formats.Cbor/src/System/Formats/Cbor/Reader/CborReader.Tag.cs` - タグ読み取り（ReadTag, PeekTag, ReadDateTimeOffset, ReadUnixTimeSeconds, ReadBigInteger, ReadDecimal）
- E-08: `src/libraries/System.Formats.Cbor/src/System/Formats/Cbor/Reader/CborReader.SkipValue.cs` - 値スキップ（SkipValue, SkipToParent）
- E-09: `src/libraries/System.Formats.Cbor/src/System/Formats/Cbor/Reader/CborReader.PeekState.cs` - 状態確認（PeekState）
- E-10: `src/libraries/System.Formats.Cbor/src/System/Formats/Cbor/Reader/CborReaderState.cs` - CborReaderState列挙型
- E-11: `src/libraries/System.Formats.Cbor/src/System/Formats/Cbor/Writer/CborWriter.cs` - CborWriterメインクラス
- E-12: `src/libraries/System.Formats.Cbor/src/System/Formats/Cbor/Writer/CborWriter.Integer.cs` - 整数書き込み（WriteInt32, WriteInt64, WriteUInt32, WriteUInt64, WriteCborNegativeIntegerRepresentation）
- E-13: `src/libraries/System.Formats.Cbor/src/System/Formats/Cbor/Writer/CborWriter.String.cs` - 文字列書き込み（WriteByteString, WriteTextString, 不定長文字列）
- E-14: `src/libraries/System.Formats.Cbor/src/System/Formats/Cbor/Writer/CborWriter.Array.cs` - 配列書き込み（WriteStartArray, WriteEndArray）
- E-15: `src/libraries/System.Formats.Cbor/src/System/Formats/Cbor/Writer/CborWriter.Map.cs` - マップ書き込み（WriteStartMap, WriteEndMap, キー重複検証/ソート）
- E-16: `src/libraries/System.Formats.Cbor/src/System/Formats/Cbor/Writer/CborWriter.Simple.cs` - シンプル値書き込み（WriteSingle, WriteDouble, WriteBoolean, WriteNull, WriteSimpleValue）
- E-17: `src/libraries/System.Formats.Cbor/src/System/Formats/Cbor/Writer/CborWriter.Tag.cs` - タグ書き込み（WriteTag, WriteDateTimeOffset, WriteUnixTimeSeconds, WriteBigInteger, WriteDecimal, DecimalHelpers）
- E-18: `src/libraries/System.Formats.Cbor/src/System/Formats/Cbor/CborConformanceLevel.cs` - CborConformanceMode列挙型、CborConformanceModeHelpers
- E-19: `src/libraries/System.Formats.Cbor/src/System/Formats/Cbor/CborInitialByte.cs` - CborInitialByte構造体、CborMajorType、CborAdditionalInfo列挙型
- E-20: `src/libraries/System.Formats.Cbor/src/System/Formats/Cbor/CborTag.cs` - CborTag、CborSimpleValue列挙型
- E-21: `src/libraries/System.Formats.Cbor/src/System/Formats/Cbor/CborContentException.cs` - CborContentException例外クラス
- E-22: `src/libraries/System.Formats.Cbor/src/System/Formats/Cbor/CborHelpers.netcoreapp.cs` - CborHelpersヘルパークラス（.NET Core版）
- E-23: `src/libraries/System.Formats.Cbor/src/System/Formats/Cbor/CborHelpers.netstandard.cs` - CborHelpersヘルパークラス（.NET Standard版）
- E-24: `src/libraries/System.Formats.Cbor/src/System/Formats/Cbor/HalfHelpers.netcoreapp.cs` - HalfHelpersヘルパークラス（.NET Core版）
- E-25: `src/libraries/System.Formats.Cbor/src/System/Formats/Cbor/HalfHelpers.netstandard.cs` - HalfHelpersヘルパークラス（.NET Standard版）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | CborReader.ReadInt32 正常系（正の整数） | E-02: ReadInt32メソッド（21-27行目） | ○ |
| C-02 | CborReader.ReadInt32 正常系（負の整数） | E-02: PeekSignedInteger（122-140行目）、major type 1処理 | ○ |
| C-03 | CborReader.ReadInt32 異常系（オーバーフロー） | E-02: checked((int)PeekSignedInteger())（23行目） | ○ |
| C-04 | CborReader.ReadInt32 異常系（型不一致） | E-02: PeekSignedInteger内でMajorTypeMismatch例外（138行目） | ○ |
| C-05 | CborReader.ReadInt64 正常系 | E-02: ReadInt64メソッド（56-62行目） | ○ |
| C-06 | CborReader.ReadUInt32 正常系 | E-02: ReadUInt32メソッド（38-45行目） | ○ |
| C-07 | CborReader.ReadUInt64 正常系 | E-02: ReadUInt64メソッド（73-80行目） | ○ |
| C-08 | CborReader.ReadCborNegativeIntegerRepresentation 正常系 | E-02: ReadCborNegativeIntegerRepresentationメソッド（95-102行目） | ○ |
| C-09 | CborReader.ReadByteString 正常系 | E-03: ReadByteStringメソッド（27-49行目） | ○ |
| C-10 | CborReader.ReadByteString 境界値（空） | E-03: length=0の場合も正常処理 | ○ |
| C-11 | CborReader.ReadByteString 不定長 | E-03: IndefiniteLength判定（31-38行目） | ○ |
| C-12-15 | CborReader.TryReadByteString/ReadDefiniteLengthByteString | E-03: 該当メソッド実装 | ○ |
| C-16-19 | CborReader.ReadTextString/TryReadTextString | E-03: ReadTextStringメソッド（163-205行目） | ○ |
| C-20-23 | CborReader.ReadStartArray/ReadEndArray | E-04: ReadStartArray（16-40行目）、ReadEndArray（49-63行目） | ○ |
| C-24-27 | CborReader.ReadStartMap/ReadEndMap | E-05: ReadStartMap（30-64行目）、ReadEndMap（75-95行目） | ○ |
| C-28-33 | CborReader.ReadSingle/ReadDouble | E-06: ReadSingle（22-51行目）、ReadDouble（63-95行目） | ○ |
| C-34-38 | CborReader.ReadBoolean/ReadNull/ReadSimpleValue | E-06: ReadBoolean（107-121行目）、ReadNull（132-145行目）、ReadSimpleValue（157-184行目） | ○ |
| C-39-48 | CborReader.ReadTag関連 | E-07: ReadTag（20-27行目）、ReadDateTimeOffset（53-87行目）、ReadUnixTimeSeconds（101-139行目）、ReadBigInteger（153-186行目）、ReadDecimal（201-267行目） | ○ |
| C-49-52 | CborReader.SkipValue/SkipToParent | E-08: SkipValue（18-21行目）、SkipToParent（31-39行目） | ○ |
| C-53-58 | CborReader.PeekState/ReadEncodedValue/Reset/CurrentDepth/BytesRemaining | E-01, E-09: PeekState（13-21行目）、ReadEncodedValue（72-82行目）、Reset（89-110行目）、CurrentDepth（44行目）、BytesRemaining（48行目） | ○ |
| C-59-65 | CborReader コンストラクタ/不定長文字列 | E-01: コンストラクタ（56-64行目）、E-03: 不定長文字列メソッド | ○ |
| C-66-78 | CborWriter.WriteInt32/WriteInt64/WriteUInt32/WriteUInt64/WriteCborNegativeIntegerRepresentation/WriteByteString | E-12: WriteInt32（19行目）、WriteInt64（28-41行目）、WriteUInt32（51行目）、WriteUInt64（61-65行目）、WriteCborNegativeIntegerRepresentation（79-83行目）、E-13: WriteByteString（25-56行目） | ○ |
| C-79-90 | CborWriter.WriteTextString/WriteStartArray/WriteEndArray/WriteStartMap/WriteEndMap | E-13: WriteTextString（97-150行目）、E-14: WriteStartArray（24-34行目）、WriteEndArray（40-44行目）、E-15: WriteStartMap（35-45行目）、WriteEndMap（53-62行目） | ○ |
| C-91 | CborWriter 重複キー検証 | E-15: HandleMapKeyWritten（93-115行目）、GetKeyEncodingRanges（184-199行目） | ○ |
| C-92-101 | CborWriter.WriteSingle/WriteDouble/WriteBoolean/WriteNull/WriteSimpleValue | E-16: WriteSingle（23-34行目）、WriteDouble（43-61行目）、WriteBoolean（87-90行目）、WriteNull（98-101行目）、WriteSimpleValue（111-131行目） | ○ |
| C-102-110 | CborWriter.WriteTag/WriteDateTimeOffset/WriteUnixTimeSeconds/WriteBigInteger/WriteDecimal | E-17: WriteTag（20-29行目）、WriteDateTimeOffset（38-51行目）、WriteUnixTimeSeconds（60-83行目）、WriteBigInteger（92-100行目）、WriteDecimal（109-135行目） | ○ |
| C-111-126 | CborWriter.WriteEncodedValue/Encode/TryEncode/Reset/Constructor/CurrentDepth/BytesWritten/IsWriteCompleted | E-11: WriteEncodedValue（132-177行目）、Encode（182行目）、TryEncode（207-220行目）、Reset（104-125行目）、コンストラクタ（82-101行目）、CurrentDepth（49行目）、BytesWritten（53行目）、IsWriteCompleted（57行目） | ○ |
| C-127-140 | CborConformanceModeHelpers | E-18: Validate（57-64行目）、RequiresCanonicalIntegerRepresentation（66-81行目）、RequiresDefiniteLengthItems（122-137行目）、AllowsTags（139-154行目）、RequiresUniqueKeys（156-171行目）、RequiresSortedKeys（173-188行目）、CompareKeyEncodings（232-272行目） | ○ |
| C-141-143 | CborInitialByte | E-19: コンストラクタ（45-56行目）、MajorType（58行目）、AdditionalInfo（59行目） | ○ |
| C-144-145 | CborContentException | E-21: コンストラクタ（17-21行目、29-33行目） | ○ |
| C-146-148 | CborHelpers | E-22, E-23: CreateBigIntegerFromUnsignedBigEndianBytes、CreateUnsignedBigEndianBytesFromBigInteger | ○ |
| C-149-153 | HalfHelpers | E-24, E-25: HalfToFloat、HalfToDouble、FloatToHalf | ○ |
| C-154-156 | CborWriter.DecimalHelpers | E-17: DecimalHelpers（139-211行目）、Deconstruct（147-156行目）、Reconstruct（170-210行目） | ○ |
| C-157-165 | 境界値/モード制限テストケース | E-01-E-18: 各メソッドの境界値処理とConformanceMode検証ロジック | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（全テストケースにソースコード根拠あり）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全テストケースがソースコードの実装に基づいて設計されている
- 注意点：
  - CBORは複雑なバイナリフォーマットであり、境界値テストが重要
  - ConformanceMode（Lax/Strict/Canonical/Ctap2Canonical）ごとの動作差異に注意
  - 浮動小数点数の精度変換（Half/Single/Double）に関するテストを重視

## 6) レビュアーチェックリスト（最小）
- [ ] 整数読み書きテスト（UT-CBOR-001〜008, 066〜072）がmajor type 0/1の仕様に準拠しているか
- [ ] 文字列読み書きテスト（UT-CBOR-009〜019, 073〜081）がmajor type 2/3の仕様に準拠しているか
- [ ] 配列/マップ読み書きテスト（UT-CBOR-020〜027, 082〜091）がmajor type 4/5の仕様に準拠しているか
- [ ] タグ/シンプル値テスト（UT-CBOR-028〜048, 092〜110）がmajor type 6/7の仕様に準拠しているか
- [ ] ConformanceMode別の動作検証テスト（UT-CBOR-040, 103, 159〜165）が網羅的か
- [ ] 境界値テスト（Int32.Max/Min, 空配列/文字列等）が十分か
- [ ] 例外系テストがエラーメッセージ/例外タイプを正しく検証しているか
